/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.metadata.support.SAML2MetadataSupport;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.RoleDescriptorImpl;

public abstract class SSODescriptorImpl
extends RoleDescriptorImpl
implements SSODescriptor {
    @Nonnull
    private final XMLObjectChildrenList<ArtifactResolutionService> artifactResolutionServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<SingleLogoutService> singleLogoutServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<ManageNameIDService> manageNameIDServices = new XMLObjectChildrenList(this);
    @Nonnull
    private final XMLObjectChildrenList<NameIDFormat> nameIDFormats = new XMLObjectChildrenList(this);

    protected SSODescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nonnull
    @Live
    public List<ArtifactResolutionService> getArtifactResolutionServices() {
        return this.artifactResolutionServices;
    }

    @Override
    @Nullable
    public ArtifactResolutionService getDefaultArtifactResolutionService() {
        return SAML2MetadataSupport.getDefaultIndexedEndpoint(this.artifactResolutionServices);
    }

    @Override
    @Nonnull
    @Live
    public List<SingleLogoutService> getSingleLogoutServices() {
        return this.singleLogoutServices;
    }

    @Override
    @Nonnull
    @Live
    public List<ManageNameIDService> getManageNameIDServices() {
        return this.manageNameIDServices;
    }

    @Override
    @Nonnull
    @Live
    public List<NameIDFormat> getNameIDFormats() {
        return this.nameIDFormats;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.addAll(this.artifactResolutionServices);
        endpoints.addAll(this.singleLogoutServices);
        endpoints.addAll(this.manageNameIDServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(ArtifactResolutionService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.artifactResolutionServices);
        }
        if (type.equals(SingleLogoutService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.singleLogoutServices);
        }
        if (type.equals(ManageNameIDService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.manageNameIDServices);
        }
        return CollectionSupport.emptyList();
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll(this.artifactResolutionServices);
        children.addAll(this.singleLogoutServices);
        children.addAll(this.manageNameIDServices);
        children.addAll(this.nameIDFormats);
        return CollectionSupport.copyToList(children);
    }
}

