/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.RepositoryPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.s3.GenericStatsMetricPublisher;
import org.opensearch.repositories.s3.S3AsyncService;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Repository;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.async.AsyncExecutorContainer;
import org.opensearch.repositories.s3.async.AsyncTransferEventLoopGroup;
import org.opensearch.repositories.s3.async.AsyncTransferManager;
import org.opensearch.repositories.s3.async.SizeBasedBlockingQ;
import org.opensearch.repositories.s3.async.TransferSemaphoresHolder;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private static final String URGENT_FUTURE_COMPLETION = "urgent_future_completion";
    private static final String URGENT_STREAM_READER = "urgent_stream_reader";
    private static final String PRIORITY_FUTURE_COMPLETION = "priority_future_completion";
    private static final String PRIORITY_STREAM_READER = "priority_stream_reader";
    private static final String FUTURE_COMPLETION = "future_completion";
    private static final String STREAM_READER = "stream_reader";
    private static final String LOW_TRANSFER_QUEUE_CONSUMER = "low_transfer_queue_consumer";
    private static final String NORMAL_TRANSFER_QUEUE_CONSUMER = "normal_transfer_queue_consumer";
    protected final S3Service service;
    protected final S3AsyncService s3AsyncService;
    private final Path configPath;
    protected AsyncExecutorContainer urgentExecutorBuilder;
    protected AsyncExecutorContainer priorityExecutorBuilder;
    protected AsyncExecutorContainer normalExecutorBuilder;
    private ExecutorService lowTransferQConsumerService;
    private ExecutorService normalTransferQConsumerService;
    protected SizeBasedBlockingQ normalPrioritySizeBasedBlockingQ;
    protected SizeBasedBlockingQ lowPrioritySizeBasedBlockingQ;
    protected TransferSemaphoresHolder transferSemaphoresHolder;
    protected GenericStatsMetricPublisher genericStatsMetricPublisher;

    public S3RepositoryPlugin(Settings settings, Path configPath) {
        this(settings, configPath, new S3Service(configPath), new S3AsyncService(configPath));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList executorBuilders = new ArrayList();
        int halfProc = S3RepositoryPlugin.halfNumberOfProcessors(S3RepositoryPlugin.allocatedProcessors(settings));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, URGENT_FUTURE_COMPLETION, S3RepositoryPlugin.urgentPoolCount(settings), 10000, URGENT_FUTURE_COMPLETION));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(URGENT_STREAM_READER, 1, halfProc, TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(PRIORITY_FUTURE_COMPLETION, 1, S3RepositoryPlugin.allocatedProcessors(settings), TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(PRIORITY_STREAM_READER, 1, halfProc, TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(FUTURE_COMPLETION, 1, S3RepositoryPlugin.allocatedProcessors(settings), TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new ScalingExecutorBuilder(STREAM_READER, S3RepositoryPlugin.allocatedProcessors(settings), 4 * S3RepositoryPlugin.allocatedProcessors(settings), TimeValue.timeValueMinutes((long)5L)));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, LOW_TRANSFER_QUEUE_CONSUMER, this.lowPriorityTransferQConsumers(settings), 10, "thread_pool.low_transfer_queue_consumer"));
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, NORMAL_TRANSFER_QUEUE_CONSUMER, this.normalPriorityTransferQConsumers(settings), 10, "thread_pool.normal_transfer_queue_consumer"));
        return executorBuilders;
    }

    private int lowPriorityTransferQConsumers(Settings settings) {
        double lowPriorityAllocation = (double)(100 - (Integer)S3Repository.S3_PRIORITY_PERMIT_ALLOCATION_PERCENT.get(settings)) / 100.0;
        return Math.max(2, (int)(lowPriorityAllocation * (double)((Integer)S3Repository.S3_TRANSFER_QUEUE_CONSUMERS.get(settings)).intValue()));
    }

    private int normalPriorityTransferQConsumers(Settings settings) {
        return (Integer)S3Repository.S3_TRANSFER_QUEUE_CONSUMERS.get(settings);
    }

    static int halfNumberOfProcessors(int numberOfProcessors) {
        return (numberOfProcessors + 1) / 2;
    }

    S3RepositoryPlugin(Settings settings, Path configPath, S3Service service, S3AsyncService s3AsyncService) {
        this.service = Objects.requireNonNull(service, "S3 service must not be null");
        this.configPath = configPath;
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, configPath);
        this.s3AsyncService = Objects.requireNonNull(s3AsyncService, "S3AsyncService must not be null");
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    private static int boundedBy(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    private static int allocatedProcessors(Settings settings) {
        return OpenSearchExecutors.allocatedProcessors((Settings)settings);
    }

    private static int urgentPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 1) / 2, 1, 2);
    }

    private static int priorityPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 1) / 2, 2, 4);
    }

    private static int normalPoolCount(Settings settings) {
        return S3RepositoryPlugin.boundedBy((S3RepositoryPlugin.allocatedProcessors(settings) + 7) / 8, 1, 2);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        int urgentEventLoopThreads = S3RepositoryPlugin.urgentPoolCount(clusterService.getSettings());
        int priorityEventLoopThreads = S3RepositoryPlugin.priorityPoolCount(clusterService.getSettings());
        int normalEventLoopThreads = S3RepositoryPlugin.normalPoolCount(clusterService.getSettings());
        this.urgentExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(URGENT_FUTURE_COMPLETION), threadPool.executor(URGENT_STREAM_READER), new AsyncTransferEventLoopGroup(urgentEventLoopThreads));
        this.priorityExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(PRIORITY_FUTURE_COMPLETION), threadPool.executor(PRIORITY_STREAM_READER), new AsyncTransferEventLoopGroup(priorityEventLoopThreads));
        this.normalExecutorBuilder = new AsyncExecutorContainer(threadPool.executor(FUTURE_COMPLETION), threadPool.executor(STREAM_READER), new AsyncTransferEventLoopGroup(normalEventLoopThreads));
        this.lowTransferQConsumerService = threadPool.executor(LOW_TRANSFER_QUEUE_CONSUMER);
        this.normalTransferQConsumerService = threadPool.executor(NORMAL_TRANSFER_QUEUE_CONSUMER);
        int availablePermits = Math.max(S3RepositoryPlugin.allocatedProcessors(clusterService.getSettings()) * 4, 10);
        double priorityPermitAllocation = (double)((Integer)S3Repository.S3_PRIORITY_PERMIT_ALLOCATION_PERCENT.get(clusterService.getSettings())).intValue() / 100.0;
        int normalPriorityPermits = (int)(priorityPermitAllocation * (double)availablePermits);
        int lowPriorityPermits = availablePermits - normalPriorityPermits;
        int normalPriorityConsumers = this.normalPriorityTransferQConsumers(clusterService.getSettings());
        int lowPriorityConsumers = this.lowPriorityTransferQConsumers(clusterService.getSettings());
        ByteSizeValue normalPriorityQCapacity = new ByteSizeValue((long)normalPriorityConsumers * 10L, ByteSizeUnit.GB);
        ByteSizeValue lowPriorityQCapacity = new ByteSizeValue((long)lowPriorityConsumers * 20L, ByteSizeUnit.GB);
        this.genericStatsMetricPublisher = new GenericStatsMetricPublisher(normalPriorityQCapacity.getBytes(), normalPriorityPermits, lowPriorityQCapacity.getBytes(), lowPriorityPermits);
        this.normalPrioritySizeBasedBlockingQ = new SizeBasedBlockingQ(normalPriorityQCapacity, this.normalTransferQConsumerService, normalPriorityConsumers, this.genericStatsMetricPublisher, SizeBasedBlockingQ.QueueEventType.NORMAL);
        LowPrioritySizeBasedBlockingQ lowPrioritySizeBasedBlockingQ = new LowPrioritySizeBasedBlockingQ(lowPriorityQCapacity, this.lowTransferQConsumerService, lowPriorityConsumers, this.genericStatsMetricPublisher);
        this.lowPrioritySizeBasedBlockingQ = lowPrioritySizeBasedBlockingQ;
        this.transferSemaphoresHolder = new TransferSemaphoresHolder(normalPriorityPermits, lowPriorityPermits, (Integer)S3Repository.S3_PERMIT_WAIT_DURATION_MIN.get(clusterService.getSettings()), TimeUnit.MINUTES, this.genericStatsMetricPublisher);
        return CollectionUtils.arrayAsArrayList((Object[])new Object[]{this.normalPrioritySizeBasedBlockingQ, lowPrioritySizeBasedBlockingQ});
    }

    protected S3Repository createRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        AsyncTransferManager asyncUploadUtils = new AsyncTransferManager(((ByteSizeValue)S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING.get(clusterService.getSettings())).getBytes(), this.normalExecutorBuilder.getStreamReader(), this.priorityExecutorBuilder.getStreamReader(), this.urgentExecutorBuilder.getStreamReader(), this.transferSemaphoresHolder);
        return new S3Repository(metadata, registry, this.service, clusterService, recoverySettings, asyncUploadUtils, this.urgentExecutorBuilder, this.priorityExecutorBuilder, this.normalExecutorBuilder, this.s3AsyncService, (Boolean)S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING.get(clusterService.getSettings()), this.configPath, this.normalPrioritySizeBasedBlockingQ, this.lowPrioritySizeBasedBlockingQ, this.genericStatsMetricPublisher);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_TYPE_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3Repository.ACCESS_KEY_SETTING, S3Repository.SECRET_KEY_SETTING, S3ClientSettings.SIGNER_OVERRIDE, S3ClientSettings.REGION, S3ClientSettings.ROLE_ARN_SETTING, S3ClientSettings.IDENTITY_TOKEN_FILE_SETTING, S3ClientSettings.ROLE_SESSION_NAME_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING, S3Repository.PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING, S3Repository.REDIRECT_LARGE_S3_UPLOAD, S3Repository.UPLOAD_RETRY_ENABLED, S3Repository.S3_PRIORITY_PERMIT_ALLOCATION_PERCENT, S3Repository.PERMIT_BACKED_TRANSFER_ENABLED, S3Repository.S3_ASYNC_HTTP_CLIENT_TYPE);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings, this.configPath);
        this.service.refreshAndClearCache(clientsSettings);
        this.s3AsyncService.refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.service.close();
        this.s3AsyncService.close();
        if (this.urgentExecutorBuilder.getAsyncTransferEventLoopGroup() != null) {
            this.urgentExecutorBuilder.getAsyncTransferEventLoopGroup().close();
        }
        if (this.priorityExecutorBuilder.getAsyncTransferEventLoopGroup() != null) {
            this.priorityExecutorBuilder.getAsyncTransferEventLoopGroup().close();
        }
        if (this.normalExecutorBuilder.getAsyncTransferEventLoopGroup() != null) {
            this.normalExecutorBuilder.getAsyncTransferEventLoopGroup().close();
        }
    }

    private static final class LowPrioritySizeBasedBlockingQ
    extends SizeBasedBlockingQ {
        public LowPrioritySizeBasedBlockingQ(ByteSizeValue capacity, ExecutorService executorService, int consumers, GenericStatsMetricPublisher genericStatsMetricPublisher) {
            super(capacity, executorService, consumers, genericStatsMetricPublisher, SizeBasedBlockingQ.QueueEventType.LOW);
        }
    }
}

