/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import org.opensearch.geospatial.h3.BaseCells;
import org.opensearch.geospatial.h3.Constants;
import org.opensearch.geospatial.h3.CoordIJK;
import org.opensearch.geospatial.h3.H3Index;

final class HexRing {
    private static final int INVALID_BASE_CELL = 127;
    private static final int[][] baseCellNeighbors = new int[][]{{0, 1, 5, 2, 4, 3, 8}, {1, 7, 6, 9, 0, 3, 2}, {2, 6, 10, 11, 0, 1, 5}, {3, 13, 1, 7, 4, 12, 0}, {4, 127, 15, 8, 3, 0, 12}, {5, 2, 18, 10, 8, 0, 16}, {6, 14, 11, 17, 1, 9, 2}, {7, 21, 9, 19, 3, 13, 1}, {8, 5, 22, 16, 4, 0, 15}, {9, 19, 14, 20, 1, 7, 6}, {10, 11, 24, 23, 5, 2, 18}, {11, 17, 23, 25, 2, 6, 10}, {12, 28, 13, 26, 4, 15, 3}, {13, 26, 21, 29, 3, 12, 7}, {14, 127, 17, 27, 9, 20, 6}, {15, 22, 28, 31, 4, 8, 12}, {16, 18, 33, 30, 8, 5, 22}, {17, 11, 14, 6, 35, 25, 27}, {18, 24, 30, 32, 5, 10, 16}, {19, 34, 20, 36, 7, 21, 9}, {20, 14, 19, 9, 40, 27, 36}, {21, 38, 19, 34, 13, 29, 7}, {22, 16, 41, 33, 15, 8, 31}, {23, 24, 11, 10, 39, 37, 25}, {24, 127, 32, 37, 10, 23, 18}, {25, 23, 17, 11, 45, 39, 35}, {26, 42, 29, 43, 12, 28, 13}, {27, 40, 35, 46, 14, 20, 17}, {28, 31, 42, 44, 12, 15, 26}, {29, 43, 38, 47, 13, 26, 21}, {30, 32, 48, 50, 16, 18, 33}, {31, 41, 44, 53, 15, 22, 28}, {32, 30, 24, 18, 52, 50, 37}, {33, 30, 49, 48, 22, 16, 41}, {34, 19, 38, 21, 54, 36, 51}, {35, 46, 45, 56, 17, 27, 25}, {36, 20, 34, 19, 55, 40, 54}, {37, 39, 52, 57, 24, 23, 32}, {38, 127, 34, 51, 29, 47, 21}, {39, 37, 25, 23, 59, 57, 45}, {40, 27, 36, 20, 60, 46, 55}, {41, 49, 53, 61, 22, 33, 31}, {42, 58, 43, 62, 28, 44, 26}, {43, 62, 47, 64, 26, 42, 29}, {44, 53, 58, 65, 28, 31, 42}, {45, 39, 35, 25, 63, 59, 56}, {46, 60, 56, 68, 27, 40, 35}, {47, 38, 43, 29, 69, 51, 64}, {48, 49, 30, 33, 67, 66, 50}, {49, 127, 61, 66, 33, 48, 41}, {50, 48, 32, 30, 70, 67, 52}, {51, 69, 54, 71, 38, 47, 34}, {52, 57, 70, 74, 32, 37, 50}, {53, 61, 65, 75, 31, 41, 44}, {54, 71, 55, 73, 34, 51, 36}, {55, 40, 54, 36, 72, 60, 73}, {56, 68, 63, 77, 35, 46, 45}, {57, 59, 74, 78, 37, 39, 52}, {58, 127, 62, 76, 44, 65, 42}, {59, 63, 78, 79, 39, 45, 57}, {60, 72, 68, 80, 40, 55, 46}, {61, 53, 49, 41, 81, 75, 66}, {62, 43, 58, 42, 82, 64, 76}, {63, 127, 56, 45, 79, 59, 77}, {64, 47, 62, 43, 84, 69, 82}, {65, 58, 53, 44, 86, 76, 75}, {66, 67, 81, 85, 49, 48, 61}, {67, 66, 50, 48, 87, 85, 70}, {68, 56, 60, 46, 90, 77, 80}, {69, 51, 64, 47, 89, 71, 84}, {70, 67, 52, 50, 83, 87, 74}, {71, 89, 73, 91, 51, 69, 54}, {72, 127, 73, 55, 80, 60, 88}, {73, 91, 72, 88, 54, 71, 55}, {74, 78, 83, 92, 52, 57, 70}, {75, 65, 61, 53, 94, 86, 81}, {76, 86, 82, 96, 58, 65, 62}, {77, 63, 68, 56, 93, 79, 90}, {78, 74, 59, 57, 95, 92, 79}, {79, 78, 63, 59, 93, 95, 77}, {80, 68, 72, 60, 99, 90, 88}, {81, 85, 94, 101, 61, 66, 75}, {82, 96, 84, 98, 62, 76, 64}, {83, 127, 74, 70, 100, 87, 92}, {84, 69, 82, 64, 97, 89, 98}, {85, 87, 101, 102, 66, 67, 81}, {86, 76, 75, 65, 104, 96, 94}, {87, 83, 102, 100, 67, 70, 85}, {88, 72, 91, 73, 99, 80, 105}, {89, 97, 91, 103, 69, 84, 71}, {90, 77, 80, 68, 106, 93, 99}, {91, 73, 89, 71, 105, 88, 103}, {92, 83, 78, 74, 108, 100, 95}, {93, 79, 90, 77, 109, 95, 106}, {94, 86, 81, 75, 107, 104, 101}, {95, 92, 79, 78, 109, 108, 93}, {96, 104, 98, 110, 76, 86, 82}, {97, 127, 98, 84, 103, 89, 111}, {98, 110, 97, 111, 82, 96, 84}, {99, 80, 105, 88, 106, 90, 113}, {100, 102, 83, 87, 108, 114, 92}, {101, 102, 107, 112, 81, 85, 94}, {102, 101, 87, 85, 114, 112, 100}, {103, 91, 97, 89, 116, 105, 111}, {104, 107, 110, 115, 86, 94, 96}, {105, 88, 103, 91, 113, 99, 116}, {106, 93, 99, 90, 117, 109, 113}, {107, 127, 101, 94, 115, 104, 112}, {108, 100, 95, 92, 118, 114, 109}, {109, 108, 93, 95, 117, 118, 106}, {110, 98, 104, 96, 119, 111, 115}, {111, 97, 110, 98, 116, 103, 119}, {112, 107, 102, 101, 120, 115, 114}, {113, 99, 116, 105, 117, 106, 121}, {114, 112, 100, 102, 118, 120, 108}, {115, 110, 107, 104, 120, 119, 112}, {116, 103, 119, 111, 113, 105, 121}, {117, 127, 109, 118, 113, 121, 106}, {118, 120, 108, 114, 117, 121, 109}, {119, 111, 115, 110, 121, 116, 120}, {120, 115, 114, 112, 121, 119, 118}, {121, 116, 120, 119, 117, 113, 118}};
    private static final int[][] baseCellNeighbor60CCWRots = new int[][]{{0, 5, 0, 0, 1, 5, 1}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 5, 0}, {0, 5, 0, 0, 2, 5, 1}, {0, -1, 1, 0, 3, 4, 2}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 3, 5, 5, 0}, {0, 0, 0, 0, 0, 5, 0}, {0, 5, 0, 0, 0, 5, 1}, {0, 0, 1, 3, 0, 0, 1}, {0, 0, 1, 3, 0, 0, 1}, {0, 3, 3, 3, 0, 0, 0}, {0, 5, 0, 0, 3, 5, 1}, {0, 0, 1, 0, 1, 0, 1}, {0, -1, 3, 0, 5, 2, 0}, {0, 5, 0, 0, 4, 5, 1}, {0, 0, 0, 0, 0, 5, 0}, {0, 3, 3, 3, 3, 0, 3}, {0, 0, 0, 3, 5, 5, 0}, {0, 3, 3, 3, 0, 0, 0}, {0, 3, 3, 3, 0, 3, 0}, {0, 0, 0, 3, 5, 5, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 3, 3, 3, 0, 3, 0}, {0, -1, 3, 0, 5, 2, 0}, {0, 0, 0, 3, 0, 0, 3}, {0, 0, 0, 0, 0, 5, 0}, {0, 3, 0, 0, 0, 3, 3}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 1, 3, 0, 0, 1}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 0, 0, 0, 5, 0}, {0, 3, 3, 3, 3, 0, 3}, {0, 0, 1, 3, 0, 0, 1}, {0, 3, 3, 3, 3, 0, 3}, {0, 0, 3, 0, 3, 0, 3}, {0, 0, 0, 3, 0, 0, 3}, {0, 3, 0, 0, 0, 3, 3}, {0, -1, 3, 0, 5, 2, 0}, {0, 3, 0, 0, 3, 3, 0}, {0, 3, 0, 0, 3, 3, 0}, {0, 0, 0, 3, 5, 5, 0}, {0, 0, 0, 3, 5, 5, 0}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 1, 3, 0, 0, 1}, {0, 0, 3, 0, 0, 3, 3}, {0, 0, 0, 3, 0, 3, 0}, {0, 3, 3, 3, 0, 3, 0}, {0, 3, 3, 3, 0, 3, 0}, {0, -1, 3, 0, 5, 2, 0}, {0, 0, 0, 3, 0, 0, 3}, {0, 3, 0, 0, 0, 3, 3}, {0, 0, 3, 0, 3, 0, 3}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 3, 0, 3, 0, 3}, {0, 0, 3, 0, 0, 3, 3}, {0, 3, 3, 3, 0, 0, 3}, {0, 0, 0, 3, 0, 3, 0}, {0, -1, 3, 0, 5, 2, 0}, {0, 3, 3, 3, 3, 3, 0}, {0, 3, 3, 3, 3, 3, 0}, {0, 3, 3, 3, 3, 0, 3}, {0, 3, 3, 3, 3, 0, 3}, {0, -1, 3, 0, 5, 2, 0}, {0, 0, 0, 3, 0, 0, 3}, {0, 3, 3, 3, 0, 3, 0}, {0, 3, 0, 0, 0, 3, 3}, {0, 3, 0, 0, 3, 3, 0}, {0, 3, 3, 3, 0, 0, 0}, {0, 3, 0, 0, 3, 3, 0}, {0, 0, 3, 0, 0, 3, 3}, {0, 0, 0, 3, 0, 3, 0}, {0, -1, 3, 0, 5, 2, 0}, {0, 3, 3, 3, 0, 0, 3}, {0, 3, 3, 3, 0, 0, 3}, {0, 0, 0, 3, 0, 0, 3}, {0, 3, 0, 0, 0, 3, 3}, {0, 0, 0, 3, 0, 5, 0}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 1, 3, 1, 0, 1}, {0, 0, 1, 3, 1, 0, 1}, {0, 0, 3, 0, 3, 0, 3}, {0, 0, 3, 0, 3, 0, 3}, {0, -1, 3, 0, 5, 2, 0}, {0, 0, 3, 0, 0, 3, 3}, {0, 0, 0, 3, 0, 3, 0}, {0, 3, 0, 0, 3, 3, 0}, {0, 3, 3, 3, 3, 3, 0}, {0, 0, 0, 3, 0, 5, 0}, {0, 3, 3, 3, 3, 3, 0}, {0, 0, 0, 0, 0, 0, 1}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 0, 3, 0, 5, 0}, {0, 5, 0, 0, 5, 5, 0}, {0, 0, 3, 0, 0, 3, 3}, {0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 3, 0, 3, 0}, {0, -1, 3, 0, 5, 2, 0}, {0, 3, 3, 3, 0, 0, 3}, {0, 5, 0, 0, 5, 5, 0}, {0, 0, 1, 3, 1, 0, 1}, {0, 3, 3, 3, 0, 0, 3}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 1, 3, 1, 0, 1}, {0, 3, 3, 3, 3, 3, 0}, {0, 0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 3, 5, 1}, {0, -1, 3, 0, 5, 2, 0}, {0, 5, 0, 0, 5, 5, 0}, {0, 0, 1, 0, 4, 5, 1}, {0, 3, 3, 3, 0, 0, 0}, {0, 0, 0, 3, 0, 5, 0}, {0, 0, 0, 3, 0, 5, 0}, {0, 0, 1, 0, 2, 5, 1}, {0, 0, 0, 0, 0, 0, 1}, {0, 0, 1, 3, 1, 0, 1}, {0, 5, 0, 0, 5, 5, 0}, {0, -1, 1, 0, 3, 4, 2}, {0, 0, 1, 0, 0, 5, 1}, {0, 0, 0, 0, 0, 0, 1}, {0, 5, 0, 0, 5, 5, 0}, {0, 0, 1, 0, 1, 5, 1}};
    private static final int E_SUCCESS = 0;
    private static final int E_PENTAGON = 9;
    private static final int E_CELL_INVALID = 5;
    private static final int E_FAILED = 1;
    private static final CoordIJK.Direction[] DIRECTIONS = new CoordIJK.Direction[]{CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT};
    private static final CoordIJK.Direction[][] NEW_DIGIT_II = new CoordIJK.Direction[][]{{CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}, {CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT}, {CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT}, {CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.K_AXES_DIGIT}, {CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT}, {CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT}};
    private static final CoordIJK.Direction[][] NEW_ADJUSTMENT_II = new CoordIJK.Direction[][]{{CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.J_AXES_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}};
    private static final CoordIJK.Direction[][] NEW_DIGIT_III = new CoordIJK.Direction[][]{{CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}, {CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT}, {CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT}, {CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT}, {CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT}, {CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT}};
    private static final CoordIJK.Direction[][] NEW_ADJUSTMENT_III = new CoordIJK.Direction[][]{{CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.J_AXES_DIGIT, CoordIJK.Direction.JK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.I_AXES_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.K_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.IK_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT}, {CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.I_AXES_DIGIT, CoordIJK.Direction.CENTER_DIGIT, CoordIJK.Direction.IJ_AXES_DIGIT}};

    HexRing() {
    }

    public static long[] hexRing(long origin) {
        long[] out = H3Index.H3_is_pentagon(origin) ? new long[5] : new long[6];
        int idx = 0;
        long previous = -1L;
        for (int i = 0; i < 6; ++i) {
            int[] rotations = new int[]{0};
            long[] nextNeighbor = new long[]{0L};
            int neighborResult = HexRing.h3NeighborRotations(origin, DIRECTIONS[i].digit(), rotations, nextNeighbor);
            if (neighborResult == 9) continue;
            if (neighborResult != 0) {
                throw new IllegalArgumentException();
            }
            if (previous == nextNeighbor[0]) continue;
            out[idx++] = nextNeighbor[0];
            previous = nextNeighbor[0];
        }
        assert (idx == out.length);
        return out;
    }

    private static int h3NeighborRotations(long origin, int dir, int[] rotations, long[] out) {
        int newRotations;
        long current;
        block19: {
            block18: {
                boolean alreadyAdjustedKSubsequence;
                block20: {
                    int newBaseCell;
                    current = origin;
                    for (int i = 0; i < rotations[0]; ++i) {
                        dir = CoordIJK.rotate60ccw(dir);
                    }
                    newRotations = 0;
                    int oldBaseCell = H3Index.H3_get_base_cell(current);
                    if (oldBaseCell < 0 || oldBaseCell >= Constants.NUM_BASE_CELLS) {
                        return 5;
                    }
                    int oldLeadingDigit = H3Index.h3LeadingNonZeroDigit(current);
                    int r = H3Index.H3_get_resolution(current) - 1;
                    while (true) {
                        int nextDir;
                        if (r == -1) {
                            current = H3Index.H3_set_base_cell(current, baseCellNeighbors[oldBaseCell][dir]);
                            newRotations = baseCellNeighbor60CCWRots[oldBaseCell][dir];
                            if (H3Index.H3_get_base_cell(current) != 127) break;
                            current = H3Index.H3_set_base_cell(current, baseCellNeighbors[oldBaseCell][CoordIJK.Direction.IK_AXES_DIGIT.digit()]);
                            newRotations = baseCellNeighbor60CCWRots[oldBaseCell][CoordIJK.Direction.IK_AXES_DIGIT.digit()];
                            current = H3Index.h3Rotate60ccw(current);
                            rotations[0] = rotations[0] + 1;
                            break;
                        }
                        int oldDigit = H3Index.H3_get_index_digit(current, r + 1);
                        if (oldDigit == CoordIJK.Direction.INVALID_DIGIT.digit()) {
                            return 5;
                        }
                        if (H3Index.isResolutionClassIII(r + 1)) {
                            current = H3Index.H3_set_index_digit(current, r + 1, NEW_DIGIT_II[oldDigit][dir].digit());
                            nextDir = NEW_ADJUSTMENT_II[oldDigit][dir].digit();
                        } else {
                            current = H3Index.H3_set_index_digit(current, r + 1, NEW_DIGIT_III[oldDigit][dir].digit());
                            nextDir = NEW_ADJUSTMENT_III[oldDigit][dir].digit();
                        }
                        if (nextDir == CoordIJK.Direction.CENTER_DIGIT.digit()) break;
                        dir = nextDir;
                        --r;
                    }
                    if (!BaseCells.isBaseCellPentagon(newBaseCell = H3Index.H3_get_base_cell(current))) break block18;
                    alreadyAdjustedKSubsequence = false;
                    if (H3Index.h3LeadingNonZeroDigit(current) == CoordIJK.Direction.K_AXES_DIGIT.digit()) {
                        if (oldBaseCell != newBaseCell) {
                            current = BaseCells.baseCellIsCwOffset(newBaseCell, BaseCells.getBaseFaceIJK((int)oldBaseCell).face) ? H3Index.h3Rotate60cw(current) : H3Index.h3Rotate60ccw(current);
                            alreadyAdjustedKSubsequence = true;
                        } else {
                            if (oldLeadingDigit == CoordIJK.Direction.CENTER_DIGIT.digit()) {
                                return 9;
                            }
                            if (oldLeadingDigit == CoordIJK.Direction.JK_AXES_DIGIT.digit()) {
                                current = H3Index.h3Rotate60ccw(current);
                                rotations[0] = rotations[0] + 1;
                            } else if (oldLeadingDigit == CoordIJK.Direction.IK_AXES_DIGIT.digit()) {
                                current = H3Index.h3Rotate60cw(current);
                                rotations[0] = rotations[0] + 5;
                            } else {
                                return 1;
                            }
                        }
                    }
                    for (int i = 0; i < newRotations; ++i) {
                        current = H3Index.h3RotatePent60ccw(current);
                    }
                    if (oldBaseCell == newBaseCell) break block19;
                    if (!BaseCells.isBaseCellPolarPentagon(newBaseCell)) break block20;
                    if (oldBaseCell != 118 && oldBaseCell != 8 && H3Index.h3LeadingNonZeroDigit(current) != CoordIJK.Direction.JK_AXES_DIGIT.digit()) {
                        rotations[0] = rotations[0] + 1;
                    }
                    break block19;
                }
                if (H3Index.h3LeadingNonZeroDigit(current) != CoordIJK.Direction.IK_AXES_DIGIT.digit() || alreadyAdjustedKSubsequence) break block19;
                rotations[0] = rotations[0] + 1;
                break block19;
            }
            for (int i = 0; i < newRotations; ++i) {
                current = H3Index.h3Rotate60ccw(current);
            }
        }
        rotations[0] = (rotations[0] + newRotations) % 6;
        out[0] = current;
        return 0;
    }
}

