/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.tool.FilmSize;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVFilmTable
extends MVTable {
    private static final Logger logger = LogManager.getLogger();
    private MyRowSorter<TableModel> sorter;

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int viewColumn = this.columnAtPoint(p);
        int modelColumnIndex = this.convertColumnIndexToModel(viewColumn);
        if (modelColumnIndex != 3) {
            return super.getToolTipText(e);
        }
        String toolTipText = null;
        int viewRow = this.rowAtPoint(p);
        Component comp = this.prepareRenderer(this.getCellRenderer(viewRow, viewColumn), viewRow, viewColumn);
        Rectangle bounds = this.getCellRect(viewRow, viewColumn, false);
        try {
            if (comp.getPreferredSize().width > bounds.width) {
                int modelRowIndex = this.convertRowIndexToModel(viewRow);
                DatenFilm datenFilm = (DatenFilm)this.getModel().getValueAt(modelRowIndex, 16);
                toolTipText = datenFilm.getTitle();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return toolTipText;
    }

    public MVFilmTable() {
        super(17, GuiFilme.VISIBLE_COLUMNS, Optional.of(MVConfig.Configs.SYSTEM_TAB_FILME_ICON_ANZEIGEN), Optional.of(MVConfig.Configs.SYSTEM_TAB_FILME_ICON_KLEIN), Optional.of(MVConfig.Configs.SYSTEM_EIGENSCHAFTEN_TABELLE_FILME));
        this.setAutoCreateRowSorter(false);
        this.addPropertyChangeListener("model", evt -> {
            TableModel model = (TableModel)evt.getNewValue();
            if (this.sorter == null) {
                this.sorter = new MyRowSorter<TableModel>(model);
                this.sorter.setModel(model);
                this.setRowSorter(this.sorter);
            } else {
                this.sorter.setModel(model);
            }
        });
    }

    private void resetFilmeTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        switch (i) {
            case 0: {
                this.breite[i] = 75;
                break;
            }
            case 3: {
                this.breite[i] = 300;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                this.breite[i] = 100;
                break;
            }
            case 14: {
                this.breite[i] = 500;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.breite[i] = 20;
                break;
            }
            case 11: 
            case 12: {
                this.breite[i] = 50;
            }
        }
    }

    @Override
    public void resetTabelle() {
        for (int i = 0; i < this.maxSpalten; ++i) {
            this.resetFilmeTab(i);
        }
        this.getRowSorter().setSortKeys(null);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite);
        this.setSpalten();
        this.calculateRowHeight();
    }

    @Override
    protected void spaltenAusschalten() {
    }

    @Override
    public void getSpalten() {
        int i;
        this.saveSelectedTableRows();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        this.listeSortKeys = rowSorter != null ? rowSorter.getSortKeys() : null;
    }

    private void reorderColumns() {
        TableColumnModel model = this.getColumnModel();
        int numCols = this.getColumnCount();
        for (int i = 0; i < this.reihe.length && i < numCols; ++i) {
            if (this.reihe[i] == i) continue;
            model.moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
        }
    }

    private void restoreSortKeys() {
        RowSorter<? extends TableModel> rowSorter;
        List<RowSorter.SortKey> tblSortKeys;
        if (this.listeSortKeys != null && this.listeSortKeys != (tblSortKeys = (rowSorter = this.getRowSorter()).getSortKeys()) && !this.listeSortKeys.isEmpty()) {
            rowSorter.setSortKeys(this.listeSortKeys);
        }
    }

    @Override
    public void setSpalten() {
        try {
            this.changeInternalColumnWidths();
            this.changeTableModelColumnWidths();
            this.reorderColumns();
            this.restoreSortKeys();
            this.restoreSelectedTableRows();
            this.validate();
        }
        catch (Exception ex) {
            logger.error("setSpalten", (Throwable)ex);
        }
    }

    static class MyRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public MyRowSorter(M model) {
            super(model);
        }

        @Override
        public void setModel(M model) {
            super.setModel(model);
            this.setSortable(4, false);
            this.setSortable(5, false);
            this.setSortable(13, false);
            this.setSortable(6, false);
            this.setComparator(10, FilmSize::compareTo);
            this.setComparator(1, String::compareTo);
            this.setComparator(8, String::compareTo);
            this.setComparator(14, String::compareTo);
            this.setComparator(9, Comparator.naturalOrder());
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
            if (sortKeys != null) {
                while (sortKeys.size() > 1) {
                    sortKeys.remove(1);
                }
            }
            super.setSortKeys(sortKeys);
        }
    }
}

