/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0010"}, d2={"Lmediathek/tool/FileSpecifier;", "", "path", "", "fileName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getFileName", "setFileName", "checkLength", "", "Companion", "MediathekView"})
public final class FileSpecifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String path;
    @NotNull
    private String fileName;
    private static final int WIN_MAX_PATH_LENGTH = 250;
    private static final int X_MAX_NAME_LENGTH = 255;
    private static final Logger logger = LogManager.getLogger();

    public FileSpecifier(@NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.path = path;
        this.fileName = fileName;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    public final void checkLength() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (this.path.length() + 10 > 250) {
                logger.error("Path too long: {}", (Object)this.path);
                String string = SystemUtils.USER_HOME;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
                this.path = string;
            }
            if (this.path.length() + this.fileName.length() > 250) {
                logger.error("FileSpecifier too long: {}", (Object)this.path);
                int maxNameL = 250 - this.path.length();
                String string = GuiFunktionen.cutName(this.fileName, maxNameL);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cutName(...)");
                this.fileName = string;
            }
        } else if (this.fileName.length() > 255) {
            logger.error("Name too long: {}", (Object)this.fileName);
            String string = GuiFunktionen.cutName(this.fileName, 255);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cutName(...)");
            this.fileName = string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmediathek/tool/FileSpecifier$Companion;", "", "<init>", "()V", "WIN_MAX_PATH_LENGTH", "", "X_MAX_NAME_LENGTH", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

