/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Color;

public class ColorUtils {
    public static Color blend(Color c1, Color c2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int i1 = c1.getRGB();
        int i2 = c2.getRGB();
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return new Color(a << 24 | r << 16 | g << 8 | b);
    }

    public static Color blend(Color ... c) {
        if (c == null || c.length == 0) {
            return null;
        }
        float ratio = 1.0f / (float)c.length;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (Color color : c) {
            int rgb = color.getRGB();
            int a1 = rgb >> 24 & 0xFF;
            int r1 = (rgb & 0xFF0000) >> 16;
            int g1 = (rgb & 0xFF00) >> 8;
            int b1 = rgb & 0xFF;
            a += (int)((float)a1 * ratio);
            r += (int)((float)r1 * ratio);
            g += (int)((float)g1 * ratio);
            b += (int)((float)b1 * ratio);
        }
        return new Color(a << 24 | r << 16 | g << 8 | b);
    }
}

