/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot.registry;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.boot.registry.MirroringIntegratorService;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusManagedBeanRegistryInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusJndiServiceInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusJtaPlatformInitiator;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusRuntimeProxyFactoryFactory;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusRuntimeProxyFactoryFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.orm.runtime.service.CfgXmlAccessServiceInitiatorQuarkus;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.service.QuarkusConnectionProviderInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusImportSqlCommandExtractorInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusMutationExecutorServiceInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRegionFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRuntimeInitDialectFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRuntimeInitDialectResolverInitiator;
import io.quarkus.hibernate.orm.runtime.service.bytecodeprovider.QuarkusRuntimeBytecodeProviderInitiator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderInitiator;
import org.hibernate.engine.jdbc.connections.internal.MultiTenantConnectionProviderInitiator;
import org.hibernate.engine.jdbc.cursor.internal.RefCursorSupportInitiator;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentInitiator;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jdbc.internal.SqlStatementLoggerInitiator;
import org.hibernate.event.internal.EntityCopyObserverFactoryInitiator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.loader.ast.internal.BatchLoaderFactoryInitiator;
import org.hibernate.persister.internal.PersisterClassResolverInitiator;
import org.hibernate.persister.internal.PersisterFactoryInitiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyResolverInitiator;
import org.hibernate.query.sqm.mutation.internal.SqmMultiTableMutationStrategyProviderInitiator;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.SessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyInitiator;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesMappingProducerProviderInitiator;
import org.hibernate.tool.schema.internal.SchemaManagementToolInitiator;

public class PreconfiguredServiceRegistryBuilder {
    private final Map<String, Object> configurationValues = new HashMap<String, Object>();
    private final List<StandardServiceInitiator<?>> initiators;
    private final List<ProvidedService<?>> providedServices = new ArrayList();
    private final Collection<Integrator> integrators;
    private final StandardServiceRegistryImpl destroyedRegistry;

    private void checkIsNotReactive(RecordedState rs) {
        if (rs.isReactive()) {
            throw new IllegalStateException("Booting a blocking Hibernate ORM serviceregistry on a Reactive RecordedState!");
        }
    }

    public PreconfiguredServiceRegistryBuilder(String puName, RecordedState rs, HibernateOrmRuntimeConfigPersistenceUnit puConfig) {
        this.checkIsNotReactive(rs);
        this.initiators = PreconfiguredServiceRegistryBuilder.buildQuarkusServiceInitiatorList(puName, rs, puConfig);
        this.integrators = rs.getIntegrators();
        this.destroyedRegistry = (StandardServiceRegistryImpl)rs.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    public PreconfiguredServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.configurationValues.put(settingName, value);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder addInitiator(StandardServiceInitiator<?> initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder addIntegrator(Integrator integrator) {
        this.integrators.add(integrator);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder addService(ProvidedService<?> providedService) {
        this.providedServices.add(providedService);
        return this;
    }

    public StandardServiceRegistryImpl buildNewServiceRegistry() {
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildEmptyBootstrapServiceRegistry();
        HashMap<String, Object> settingsCopy = new HashMap<String, Object>();
        settingsCopy.putAll(this.configurationValues);
        this.destroyedRegistry.resetAndReactivate(bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
        return this.destroyedRegistry;
    }

    private BootstrapServiceRegistry buildEmptyBootstrapServiceRegistry() {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(FlatClassLoaderService.INSTANCE);
        return new BootstrapServiceRegistryImpl(true, FlatClassLoaderService.INSTANCE, (StrategySelector)strategySelector, (IntegratorService)new MirroringIntegratorService(this.integrators));
    }

    private static List<StandardServiceInitiator<?>> buildQuarkusServiceInitiatorList(String puName, RecordedState rs, HibernateOrmRuntimeConfigPersistenceUnit puConfig) {
        ArrayList serviceInitiators = new ArrayList();
        QuarkusRuntimeProxyFactoryFactory statefulProxyFactory = new QuarkusRuntimeProxyFactoryFactory(rs.getProxyClassDefinitions());
        serviceInitiators.add(new QuarkusRuntimeBytecodeProviderInitiator(statefulProxyFactory));
        serviceInitiators.add(QuarkusMutationExecutorServiceInitiator.INSTANCE);
        serviceInitiators.add(new QuarkusRuntimeProxyFactoryFactoryInitiator(statefulProxyFactory));
        serviceInitiators.add(CfgXmlAccessServiceInitiatorQuarkus.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ConfigurationServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)PropertyAccessStrategyResolverInitiator.INSTANCE);
        serviceInitiators.add(QuarkusImportSqlCommandExtractorInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)JdbcEnvironmentInitiator.INSTANCE);
        serviceInitiators.add(QuarkusJndiServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)PersisterClassResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)PersisterFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)MultiTenantConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add(new QuarkusRuntimeInitDialectResolverInitiator(rs.getDialect()));
        RecordedConfig recordedConfig = rs.getBuildTimeSettings().getSource();
        serviceInitiators.add(new QuarkusRuntimeInitDialectFactoryInitiator(puName, rs.isFromPersistenceXml(), rs.getDialect(), rs.getBuildTimeSettings().getSource(), puConfig));
        serviceInitiators.add((StandardServiceInitiator<?>)BatchBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)JdbcServicesInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)RefCursorSupportInitiator.INSTANCE);
        serviceInitiators.add(QuarkusJtaPlatformInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusRegionFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)TransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceInitiators.add(QuarkusManagedBeanRegistryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)EntityCopyObserverFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)JdbcValuesMappingProducerProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SqmMultiTableMutationStrategyProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)ParameterMarkerStrategyInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)BatchLoaderFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator<?>)SqlStatementLoggerInitiator.INSTANCE);
        serviceInitiators.trimToSize();
        return serviceInitiators;
    }
}

