/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gs2;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.codec.Base32Alphabet;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;

public final class Gs2 {
    public static final String GS2_PREFIX = "GS2-";
    public static final String PLUS_SUFFIX = "-PLUS";
    public static final String GS2_KRB5 = "GS2-KRB5";
    public static final String GS2_KRB5_PLUS = "GS2-KRB5-PLUS";
    public static final String SPNEGO = "SPNEGO";
    public static final String SPNEGO_PLUS = "SPNEGO-PLUS";

    public static String getSaslNameForMechanism(Oid mechanismOid, boolean plus) throws GSSException {
        MessageDigest messageDigest;
        if (mechanismOid == null) {
            throw new GSSException(2);
        }
        if (mechanismOid.equals(GSSCredentialSecurityFactory.KERBEROS_V5)) {
            if (plus) {
                return GS2_KRB5_PLUS;
            }
            return GS2_KRB5;
        }
        if (mechanismOid.equals(GSSCredentialSecurityFactory.SPNEGO)) {
            if (plus) {
                return SPNEGO_PLUS;
            }
            return SPNEGO;
        }
        ByteStringBuilder name = new ByteStringBuilder();
        name.append(GS2_PREFIX);
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new GSSException(11);
        }
        messageDigest.update(mechanismOid.getDER());
        byte[] digest = messageDigest.digest();
        digest[6] = (byte)(digest[6] & 0xFE);
        String encoded = ByteIterator.ofBytes((byte[])digest, (int)0, (int)7).base32Encode(Base32Alphabet.STANDARD, false).drainToString();
        name.append(encoded.substring(0, encoded.length() - 1));
        if (plus) {
            name.append(PLUS_SUFFIX);
        }
        return new String(name.toArray(), StandardCharsets.UTF_8);
    }

    public static String getSaslNameForMechanism(Oid mechanismOid) throws GSSException {
        return Gs2.getSaslNameForMechanism(mechanismOid, false);
    }

    public static Oid getMechanismForSaslName(GSSManager gssManager, String saslMechanismName) throws GSSException {
        int plusSuffixIndex = saslMechanismName.indexOf(PLUS_SUFFIX);
        if (plusSuffixIndex != -1) {
            saslMechanismName = saslMechanismName.substring(0, plusSuffixIndex);
        }
        if (saslMechanismName.equals(GS2_KRB5)) {
            return GSSCredentialSecurityFactory.KERBEROS_V5;
        }
        if (saslMechanismName.equals(SPNEGO)) {
            return GSSCredentialSecurityFactory.SPNEGO;
        }
        Oid[] mechanisms = gssManager.getMechs();
        if (mechanisms == null) {
            throw new GSSException(2);
        }
        for (Oid mechanism : mechanisms) {
            if (!Gs2.getSaslNameForMechanism(mechanism).equals(saslMechanismName)) continue;
            return mechanism;
        }
        throw new GSSException(2);
    }
}

