/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.tools.I18n;

public class Note {
    public static final Comparator<Note> DEFAULT_COMPARATOR = (n1, n2) -> {
        if (n1.getId() < 0L && n2.getId() > 0L) {
            return 1;
        }
        if (n1.getId() > 0L && n2.getId() < 0L) {
            return -1;
        }
        if (n1.getState() == State.CLOSED && n2.getState() == State.OPEN) {
            return 1;
        }
        if (n1.getState() == State.OPEN && n2.getState() == State.CLOSED) {
            return -1;
        }
        return Long.compare(Math.abs(n1.getId()), Math.abs(n2.getId()));
    };
    public static final Comparator<Note> DATE_COMPARATOR = Comparator.comparing(n -> n.createdAt);
    public static final Comparator<Note> USER_COMPARATOR = Comparator.comparing(Note::getUserName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DATE_COMPARATOR);
    public static final Comparator<Note> LAST_ACTION_COMPARATOR = Comparator.comparing(Note::getLastComment, NoteComment.DATE_COMPARATOR);
    private long id;
    private LatLon latLon;
    private Instant createdAt;
    private Instant closedAt;
    private State state;
    private List<NoteComment> comments = new ArrayList<NoteComment>();

    public Note(LatLon latLon) {
        this.latLon = latLon;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Instant closedAt) {
        this.closedAt = closedAt;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<NoteComment> getComments() {
        return this.comments;
    }

    @Nullable
    public NoteComment getLastComment() {
        return this.comments.isEmpty() ? null : this.comments.get(this.comments.size() - 1);
    }

    public void addComment(NoteComment comment) {
        this.comments.add(comment);
    }

    @Nullable
    public NoteComment getFirstComment() {
        return this.comments.isEmpty() ? null : this.comments.get(0);
    }

    @Nullable
    private String getUserName() {
        return this.getFirstComment() == null ? null : this.getFirstComment().getUser().getName();
    }

    public void updateWith(Note note) {
        this.comments = note.comments;
        this.createdAt = note.createdAt;
        this.id = note.id;
        this.state = note.state;
        this.latLon = note.latLon;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Note note = (Note)obj;
        return this.id == note.id;
    }

    public String toString() {
        return I18n.tr("Note", new Object[0]) + " " + this.id + ": " + String.valueOf(this.getFirstComment());
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

