/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.DimensionalEvaluator;
import io.sf.carte.doc.style.css.property.ExpressionFactory;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class ExpressionValue
extends TypedValue
implements CSSExpressionValue {
    private static final long serialVersionUID = 1L;
    private CSSExpression expression = null;
    private boolean roundResult = false;

    public ExpressionValue() {
        super(CSSValue.Type.EXPRESSION);
    }

    protected ExpressionValue(ExpressionValue expressionValue) {
        super(expressionValue);
        this.expression = expressionValue.expression.clone();
        this.roundResult = expressionValue.roundResult;
    }

    @Override
    ExpressionLexicalSetter newLexicalSetter() {
        return new ExpressionLexicalSetter();
    }

    @Override
    public CSSExpression getExpression() {
        return this.expression;
    }

    ExpressionFactory createExpressionFactory(LexicalUnit lexicalUnit) {
        return new ExpressionFactory(lexicalUnit);
    }

    @Override
    public String getStringValue() throws DOMException {
        return "";
    }

    @Override
    public float getFloatValue(short s) throws DOMException {
        throw new DOMException(15, "Please use an evaluator and compute result.");
    }

    @Override
    public String getCssText() {
        String string = this.expression.getCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('(').append(string).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2 = this.expression.getMinifiedCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 2);
        stringBuilder.append('(').append(string2).append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            this.expression.writeCssText(simpleWriter);
        } else {
            simpleWriter.write('(');
            this.expression.writeCssText(simpleWriter);
            simpleWriter.write(')');
        }
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "The value of this property cannot be modified.");
    }

    @Override
    public void setExpectInteger() {
        this.roundResult = true;
    }

    @Override
    public boolean isExpectingInteger() {
        return this.roundResult;
    }

    @Override
    public short computeUnitType() {
        short s;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            s = dimensionalEvaluator.computeUnitType(this.getExpression());
        }
        catch (DOMException dOMException) {
            s = 255;
        }
        return s;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax == null) {
            return CSSValueSyntax.Match.FALSE;
        }
        return this.dimensionalAnalysis(cSSValueSyntax, true);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        return this.dimensionalAnalysis(cSSValueSyntax, false);
    }

    private CSSValueSyntax.Match dimensionalAnalysis(CSSValueSyntax cSSValueSyntax, boolean bl) {
        CSSValueSyntax.Category category;
        DimensionalEvaluator dimensionalEvaluator = new DimensionalEvaluator();
        try {
            category = dimensionalEvaluator.dimensionalAnalysis(this.getExpression());
        }
        catch (DOMException dOMException) {
            if (dimensionalEvaluator.hasUnknownFunction() && cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            CSSValueSyntax.Category category2;
            if ((category2 = cSSValueSyntax.getCategory()) == category) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category2 == CSSValueSyntax.Category.lengthPercentage && (category == CSSValueSyntax.Category.length || category == CSSValueSyntax.Category.percentage) || category2 == CSSValueSyntax.Category.integer && category == CSSValueSyntax.Category.number) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (category != CSSValueSyntax.Category.lengthPercentage) continue;
            if (category2 == CSSValueSyntax.Category.length) {
                if (bl3) {
                    return CSSValueSyntax.Match.TRUE;
                }
                bl2 = true;
                continue;
            }
            if (category2 != CSSValueSyntax.Category.percentage) continue;
            if (bl2) {
                return CSSValueSyntax.Match.TRUE;
            }
            bl3 = true;
        } while (bl && (cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.expression == null ? 0 : this.expression.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionValue expressionValue = (ExpressionValue)object;
        if (this.expression == null) {
            return expressionValue.expression == null;
        }
        return this.expression.equals(expressionValue.expression);
    }

    @Override
    public ExpressionValue clone() {
        return new ExpressionValue(this);
    }

    class ExpressionLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        ExpressionLexicalSetter() {
            super(ExpressionValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) throws DOMException {
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
            this.setLexicalUnitFromSubValues(lexicalUnit.getParameters());
        }

        void setLexicalUnitFromSubValues(LexicalUnit lexicalUnit) throws DOMException {
            ExpressionFactory expressionFactory = ExpressionValue.this.createExpressionFactory(this.nextLexicalUnit);
            ExpressionValue.this.expression = expressionFactory.createExpression(lexicalUnit);
            if (ExpressionValue.this.expression == null) {
                throw new DOMException(12, "Void expression");
            }
            this.nextLexicalUnit = expressionFactory.getNextLexicalUnit();
        }
    }
}

