// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { Platform } from "react-native";
/**
 * @internal
 */
export function getHeaderName() {
    return "x-ms-useragent";
}
/**
 * @internal
 */
export async function setPlatformSpecificData(map) {
    if (Platform.constants?.reactNativeVersion) {
        const { major, minor, patch } = Platform.constants.reactNativeVersion;
        map.set("react-native", `${major}.${minor}.${patch}`);
    }
    map.set("OS", `${Platform.OS}-${Platform.Version}`);
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/7d842fb85a0275a4a8e4d7e040d2625abbf7f084/node_modules/@typespec/ts-http-runtime/dist/react-native/util/userAgentPlatform-react-native.mjs.map