import { ParsingOptions } from './opts';
import { AnyPart, Paragraph } from './dom';
export interface CommandParser {
    command: string;
    parameters: number;
    escapedArguments?: boolean;
    process: (args: string[], opts: ParsingOptions, source: string | undefined) => AnyPart;
}
export declare function composeCommandMap(commands: CommandParser[]): Map<string, CommandParser>;
export declare function composeCommandRE(commands: CommandParser[]): RegExp;
export declare function parseString(input: string, commandRE: RegExp, commands: Map<string, CommandParser>, opts: ParsingOptions, where: string): Paragraph;
/**
  Parses a string or a list of strings to a list of paragraphs.
 */
export declare function parse(input: string | string[], opts?: ParsingOptions): Paragraph[];
//# sourceMappingURL=parser.d.ts.map