# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoRedundancy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'url': 'str',
        'uuid': 'str',
        'redundancies': 'VideoRedundancyRedundancies'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'url': 'url',
        'uuid': 'uuid',
        'redundancies': 'redundancies'
    }

    def __init__(self, id=None, name=None, url=None, uuid=None, redundancies=None, local_vars_configuration=None):  # noqa: E501
        """VideoRedundancy - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._url = None
        self._uuid = None
        self._redundancies = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url
        if uuid is not None:
            self.uuid = uuid
        if redundancies is not None:
            self.redundancies = redundancies

    @property
    def id(self):
        """Gets the id of this VideoRedundancy.  # noqa: E501


        :return: The id of this VideoRedundancy.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoRedundancy.


        :param id: The id of this VideoRedundancy.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this VideoRedundancy.  # noqa: E501


        :return: The name of this VideoRedundancy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VideoRedundancy.


        :param name: The name of this VideoRedundancy.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this VideoRedundancy.  # noqa: E501


        :return: The url of this VideoRedundancy.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this VideoRedundancy.


        :param url: The url of this VideoRedundancy.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def uuid(self):
        """Gets the uuid of this VideoRedundancy.  # noqa: E501


        :return: The uuid of this VideoRedundancy.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this VideoRedundancy.


        :param uuid: The uuid of this VideoRedundancy.  # noqa: E501
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def redundancies(self):
        """Gets the redundancies of this VideoRedundancy.  # noqa: E501


        :return: The redundancies of this VideoRedundancy.  # noqa: E501
        :rtype: VideoRedundancyRedundancies
        """
        return self._redundancies

    @redundancies.setter
    def redundancies(self, redundancies):
        """Sets the redundancies of this VideoRedundancy.


        :param redundancies: The redundancies of this VideoRedundancy.  # noqa: E501
        :type redundancies: VideoRedundancyRedundancies
        """

        self._redundancies = redundancies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoRedundancy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoRedundancy):
            return True

        return self.to_dict() != other.to_dict()
