# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Plugin(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'type': 'int',
        'latest_version': 'str',
        'version': 'str',
        'enabled': 'bool',
        'uninstalled': 'bool',
        'peertube_engine': 'str',
        'description': 'str',
        'homepage': 'str',
        'settings': 'dict(str, object)',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'latest_version': 'latestVersion',
        'version': 'version',
        'enabled': 'enabled',
        'uninstalled': 'uninstalled',
        'peertube_engine': 'peertubeEngine',
        'description': 'description',
        'homepage': 'homepage',
        'settings': 'settings',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, name=None, type=None, latest_version=None, version=None, enabled=None, uninstalled=None, peertube_engine=None, description=None, homepage=None, settings=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Plugin - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._type = None
        self._latest_version = None
        self._version = None
        self._enabled = None
        self._uninstalled = None
        self._peertube_engine = None
        self._description = None
        self._homepage = None
        self._settings = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if latest_version is not None:
            self.latest_version = latest_version
        if version is not None:
            self.version = version
        if enabled is not None:
            self.enabled = enabled
        if uninstalled is not None:
            self.uninstalled = uninstalled
        if peertube_engine is not None:
            self.peertube_engine = peertube_engine
        if description is not None:
            self.description = description
        if homepage is not None:
            self.homepage = homepage
        if settings is not None:
            self.settings = settings
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def name(self):
        """Gets the name of this Plugin.  # noqa: E501


        :return: The name of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Plugin.


        :param name: The name of this Plugin.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this Plugin.  # noqa: E501

        - `1`: PLUGIN - `2`: THEME   # noqa: E501

        :return: The type of this Plugin.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Plugin.

        - `1`: PLUGIN - `2`: THEME   # noqa: E501

        :param type: The type of this Plugin.  # noqa: E501
        :type type: int
        """
        allowed_values = [1, 2]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def latest_version(self):
        """Gets the latest_version of this Plugin.  # noqa: E501


        :return: The latest_version of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """Sets the latest_version of this Plugin.


        :param latest_version: The latest_version of this Plugin.  # noqa: E501
        :type latest_version: str
        """

        self._latest_version = latest_version

    @property
    def version(self):
        """Gets the version of this Plugin.  # noqa: E501


        :return: The version of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Plugin.


        :param version: The version of this Plugin.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def enabled(self):
        """Gets the enabled of this Plugin.  # noqa: E501


        :return: The enabled of this Plugin.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this Plugin.


        :param enabled: The enabled of this Plugin.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def uninstalled(self):
        """Gets the uninstalled of this Plugin.  # noqa: E501


        :return: The uninstalled of this Plugin.  # noqa: E501
        :rtype: bool
        """
        return self._uninstalled

    @uninstalled.setter
    def uninstalled(self, uninstalled):
        """Sets the uninstalled of this Plugin.


        :param uninstalled: The uninstalled of this Plugin.  # noqa: E501
        :type uninstalled: bool
        """

        self._uninstalled = uninstalled

    @property
    def peertube_engine(self):
        """Gets the peertube_engine of this Plugin.  # noqa: E501


        :return: The peertube_engine of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._peertube_engine

    @peertube_engine.setter
    def peertube_engine(self, peertube_engine):
        """Sets the peertube_engine of this Plugin.


        :param peertube_engine: The peertube_engine of this Plugin.  # noqa: E501
        :type peertube_engine: str
        """

        self._peertube_engine = peertube_engine

    @property
    def description(self):
        """Gets the description of this Plugin.  # noqa: E501


        :return: The description of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Plugin.


        :param description: The description of this Plugin.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def homepage(self):
        """Gets the homepage of this Plugin.  # noqa: E501


        :return: The homepage of this Plugin.  # noqa: E501
        :rtype: str
        """
        return self._homepage

    @homepage.setter
    def homepage(self, homepage):
        """Sets the homepage of this Plugin.


        :param homepage: The homepage of this Plugin.  # noqa: E501
        :type homepage: str
        """

        self._homepage = homepage

    @property
    def settings(self):
        """Gets the settings of this Plugin.  # noqa: E501


        :return: The settings of this Plugin.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this Plugin.


        :param settings: The settings of this Plugin.  # noqa: E501
        :type settings: dict(str, object)
        """

        self._settings = settings

    @property
    def created_at(self):
        """Gets the created_at of this Plugin.  # noqa: E501


        :return: The created_at of this Plugin.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Plugin.


        :param created_at: The created_at of this Plugin.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Plugin.  # noqa: E501


        :return: The updated_at of this Plugin.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Plugin.


        :param updated_at: The updated_at of this Plugin.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Plugin):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Plugin):
            return True

        return self.to_dict() != other.to_dict()
