/****************************************************************************
** Created: Sat Feb 24 23:35:01 2001
****************************************************************************/
#include "SearchResults.h"
#include <stdio.h>
#include <qstrlist.h>

#include "gutenbrowser.h"
#include "LibraryDialog.h"
#include  <qclipboard.h>

#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/*
 *  Constructs a SearchResultsDlg which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SearchResultsDlg::SearchResultsDlg( QWidget* parent,  const char* name, bool modal, WFlags fl, QStringList  stringList )
        : QDialog( parent, name, modal, fl )
{

    if ( !name )
        setName( "SearchResultsDlg" );
    resize( 515, 286 );
    setCaption( tr( "Search Results"  ) );
    setSizeGripEnabled( TRUE );
//    resultsList = stringList;
//resultsList =
    QWidget* Layout1 = new QWidget( this, "Layout1" );
    Layout1->setGeometry( QRect( 20, 240, 476, 33 ) );
    hbox = new QHBoxLayout( Layout1 );
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Fixed );
    hbox->addItem( spacer );

    buttonOk = new QPushButton( Layout1, "buttonOk" );
    buttonOk->setText( tr( "&Download"  ) );
    buttonOk->setAutoDefault( TRUE );
    hbox->addWidget( buttonOk );

    buttonCancel = new QPushButton( Layout1, "buttonCancel" );
    buttonCancel->setText( tr( "&Cancel"  ) );
    buttonCancel->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    hbox->addWidget( buttonCancel );

    ListBox1 = new QListBox( this, "ListBox1" );
    ListBox1->setGeometry( QRect( 60, 10, 431, 221 ) );
    ListBox1->setSelectionMode( QListBox::Single );
    ListBox1->setMultiSelection(true);

    statusLabel = new QLabel( this, "Status_Bar" );
    statusLabel->setText( "Double click a title to begin downloading." );
    statusLabel->setGeometry( 10, 238 , 240, 20);

    QLabel * outPutLabel;
    outPutLabel = new QLabel( this, "outPutLabel" );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( dwnLd() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( ListBox1, SIGNAL( doubleClicked(QListBoxItem *)),  SLOT( slotListClicked(QListBoxItem * )) );

//        for( QStringList::Iterator it = stringList.begin(); it != stringList.end(); it++)
//        {
//            printf("%s\n", (*it).latin1() );
//      }
    ListBox1->insertStringList( stringList);
    numListItems= ListBox1->numRows();
    QString strOut;

    outPutLabel->setText( "Number of results: "+ strOut.sprintf("%d", numListItems) );
    outPutLabel->setGeometry( 10, 260 , 240, 20);
//     hbox->addWidget( outPutLabel);

//    printf( "Sucessfully entered SearchResults Dialog\n");
// selText = resultStr;
}

/*
 *  Destroys the object and frees any allocated resources
 */
SearchResultsDlg::~SearchResultsDlg()
{
      // no need to delete child widgets, Qt does it all for us
}

void SearchResultsDlg::slotListClicked(QListBoxItem *) {
    
    resultsList.append(ListBox1->text( 0));
//    selText = ListBox1->currentText();
    accept();
}

void SearchResultsDlg::dwnLd() {

    for(unsigned int ji=0; ji< ListBox1->count() ; ji++ ) {
        if( ListBox1->isSelected( ji) )
            resultsList.append(ListBox1->text( ji));
    }
    accept();
}

void SearchResultsDlg::downloadButtonSlot() {

}
