Homerun Model Specification {#homerunmodel}
===========================

Homerun models make heavy use of Qt introspection and duck-typing. This
document describes the mandatory and optional roles, properties and signals of a
Homerun model.

## Roles
### string display
- mandatory: yes

The item text.

### string|QIcon decoration
- mandatory: yes

The item icon, as a string or as a QIcon.

### string favoriteId
- mandatory: no

Unique Id used to favorite this item. Its value depends on the item type:

- item cannot be favorited: ""
- item is an application: "app:" + $desktopName.
  Examples: "app:inkscape.desktop" or "app:kde4-dolphin.desktop" for KDE applications.
- item is a place: "place:" + $url.
  Examples: "place:file:///home/jdoe/Documents" or "place:sftp://host.com/dir".

### bool hasActionList
- mandatory: no

Set to true if the item has additional actions, defined by the actionList
role.

### QVariantList actionList
- mandatory: no

A list of QVariantMap describing extra actions. Each map should contain the
following elements:

- string type
    - mandatory: no, default to "action"
    - Can be one of "action", "title" or "separator"
- string text
    - mandatory: yes
    - The visible text shown in the item context menu
- QIcon icon
    - mandatory: no
    - The icon associated with the action
- string actionId
    - mandatory: yes
    - An id passed to trigger() to distinguish between actions
- variant actionArgument
    - mandatory: no
    - An optional argument, passed to trigger() as well

Functions from the Homerun::ActionList namespace simplifies the creation of
actions.

Important: This role is ignored if hasActionList is not defined or returns
false.

## Properties
### string name
- access: read-only
- mandatory: yes

Returns a translated name for the model. This name is used as a title for the
view associated with the model.

### int count
- access: read-only
- mandatory: yes

Returns current number of rows. Most often it will simply return
rowCount(QModelIndex()).

### Homerun::PathModel pathModel
- access: read-only
- mandatory: no

Used for models which can be navigated through. Returns a Homerun::PathModel instance
representing the position inside the model.

### bool running
- access: read-only
- mandatory: no

Set to true to indicate the model is busy filling itself. Homerun will show a
busy indicator as long as this property is true.

### string query
- access: read-write
- mandatory: no

A model can implement this property to implement searching/filtering itself. If
it is not defined, Homerun will apply a generic filter to the item names when
the user type a search criteria.

## Methods
### bool trigger(int row, string actionId = "", QVariant actionArgument = QVariant())
- mandatory: yes

Triggers the action identified by `actionId` on the item at row `row`.
`actionId` and `actionArgument` are defined in the `actionList` role.

Returns true if you want Homerun to close, false otherwise.

Note: When the user clicks on an item, `actionId` is an empty string.

## Signals
### openSourceRequested(QString sourceId, const QVariantMap &arguments)
- mandatory: no

Emitted by a model when it wants another source to be opened by the view. This
is used for example to open a browsable model in a subdir.

Note: If you want to be able to access your model this way, you need to
implement Homerun::AbstractSource::createModelFromArguments().
