/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2009-04-19
 * Description : Qt item view for images - the delegate
 *
 * Copyright (C) 2009 by Marcel Wiesweg <marcel dot wiesweg at gmx dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ITEMVIEWIMAGEDELEGATE_H
#define ITEMVIEWIMAGEDELEGATE_H

// Qt includes

// Local includes

#include "ditemdelegate.h"
#include "thumbnailsize.h"
#include "digikam_export.h"

namespace Digikam
{

class ImageCategoryDrawer;
class ImageCategorizedView;
class ImageDelegateOverlay;
class ImageFilterModel;
class ImageModel;
class ItemViewImageDelegatePrivate;

class DIGIKAM_EXPORT ItemViewImageDelegate : public DItemDelegate
{
    Q_OBJECT

public:

    ItemViewImageDelegate(DCategorizedView* parent);
    ~ItemViewImageDelegate();

    virtual QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const;
    virtual QSize gridSize() const;

    ThumbnailSize thumbnailSize() const;

    // reimplemented from DItemDelegate
    virtual void setThumbnailSize(const ThumbnailSize& thumbSize);
    virtual void setSpacing(int spacing);
    virtual void setDefaultViewOptions(const QStyleOptionViewItem& option);
    virtual bool acceptsToolTip(const QPoint& pos, const QRect& visualRect,
                                const QModelIndex& index, QRect* tooltipRect = 0) const;
    virtual bool acceptsActivation(const QPoint& pos, const QRect& visualRect,
                                   const QModelIndex& index, QRect* activationRect = 0) const;

    QRect rect() const;

    /** Can be used to temporarily disable drawing of the rating.
     *  Call with QModelIndex() afterwards. */
    void setRatingEdited(const QModelIndex& index);
    /** Returns the rectangle where the rating is drawn,
     *  or a null rectangle if not supported. */
    virtual QRect ratingRect() const;

    /** Support for overlays. To be called by the item view only. */
    void installOverlay(ImageDelegateOverlay* overlay);
    void removeOverlay(ImageDelegateOverlay* overlay);
    void setAllOverlaysActive(bool active);
    void removeAllOverlays();
    void mouseMoved(QMouseEvent* e, const QRect& visualRect, const QModelIndex& index);

protected Q_SLOTS:

    void slotThemeChanged();
    void slotSetupChanged();

protected:

    /// Use the tool methods for painting in subclasses
    QRect drawThumbnail(QPainter* p, const QRect& thumbRect, const QPixmap& background, const QPixmap& thumbnail) const;
    void drawRating(QPainter* p, const QModelIndex& index, const QRect& ratingRect, int rating, bool isSelected) const;
    void drawName(QPainter* p,const QRect& nameRect, const QString& name) const;
    void drawComments(QPainter* p, const QRect& commentsRect, const QString& comments) const;
    void drawCreationDate(QPainter* p, const QRect& dateRect, const QDateTime& date) const;
    void drawModificationDate(QPainter* p, const QRect& dateRect, const QDateTime& date) const;
    void drawImageSize(QPainter* p, const QRect& dimsRect, const QSize& dims) const;
    void drawFileSize(QPainter* p, const QRect& r, int bytes) const;
    void drawTags(QPainter* p, const QRect& r, const QString& tagsString, bool isSelected) const;
    void drawFocusRect(QPainter* p, const QStyleOptionViewItem& option, bool isSelected) const;
    void drawMouseOverRect(QPainter* p, const QStyleOptionViewItem& option) const;
    void drawDelegates(QPainter* p, const QStyleOptionViewItem& option, const QModelIndex& index) const;
    void prepareFonts();
    void prepareMetrics(int maxWidth);
    void prepareBackground();
    void prepareRatingPixmaps(bool composeOverBackground = true);

    // reimplement these in subclasses
    virtual void invalidatePaintingCache();
    virtual void updateSizeRectsAndPixmaps() = 0;

    /// Returns the relevant pixmap from the cached rating pixmaps
    QPixmap ratingPixmap(int rating, bool selected) const;

    ItemViewImageDelegatePrivate* const d_ptr;
    ItemViewImageDelegate(ItemViewImageDelegatePrivate& dd, DCategorizedView* parent);

private:

    Q_DECLARE_PRIVATE(ItemViewImageDelegate)
};

} // namespace Digikam

#endif /* ITEMVIEWIMAGEDELEGATE_H */
