# find speech-dispatcher library and header if available
# Copyright (c) 2009, Jeremy Whiting <jeremy@scitools.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

FIND_PATH(SPEECHD_INCLUDE_DIR libspeechd.h /usr/include /usr/local/include)

FIND_LIBRARY(SPEECHD_LIBRARY NAMES speechd PATH /usr/lib /usr/local/lib)

IF (SPEECHD_INCLUDE_DIR AND SPEECHD_LIBRARY)
    SET(SPEECHD_FOUND TRUE)
ENDIF (SPEECHD_INCLUDE_DIR AND SPEECHD_LIBRARY)

IF (SPEECHD_FOUND)
  IF (NOT Speechd_FIND_QUIETLY)
    MESSAGE(STATUS "Found Speech Dispatcher: ${SPEECHD_LIBRARY}")
  ENDIF (NOT Speechd_FIND_QUIETLY)
ELSE (SPEECHD_FOUND)
  IF (Speechd_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find Required package: Speech Dispatcher")
  ENDIF (Speechd_FIND_REQUIRED)
ENDIF (SPEECHD_FOUND)

