/* -*- c++ -*-
 *
 * mlconfig.cpp
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2004,2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <qcheckbox.h>
#include <QVBoxLayout>
#include <QList>

#include <kdebug.h>
#include <klocale.h>

#include "donkeyprotocol.h"
#include "network.h"
#include "mlconfig.h"
#include "kmldonkey.h"

NetworkPage::NetworkPage(QWidget* parent, const char* name)
    : QWidget(parent, name)
{
    QVBoxLayout* layout = new QVBoxLayout(this);
    setLayout(layout);
    Q3IntDictIterator<Network> nwit( KMLDonkey::App->donkey->availableNetworks() );
    for ( ; nwit.current(); ++nwit ) {
        Network* net = nwit.current();
        QCheckBox* c = new QCheckBox(net->networkName(), this);
        c->setChecked(net->networkEnabled());
        layout->addWidget(c);
        connect(c, SIGNAL(toggled(bool)), SLOT(becomeDirty(bool)));
        nwBox.insert(net->networkNo(), c);
    }
    layout->addStretch(1);
}

void NetworkPage::becomeDirty(bool)
{
    emit pageDirty();
}

void NetworkPage::applyOptions(DonkeyProtocol* target)
{
    Q3IntDictIterator<QCheckBox> it(nwBox);
    for (; it.current(); ++it) {
        Network* net = target->findNetworkNo(it.currentKey());
        if (!net || net->networkEnabled() == it.current()->isChecked())
            continue;
        target->enableNetwork(it.currentKey(), it.current()->isChecked());
    }
}

MLDonkeyConfigDialog::MLDonkeyConfigDialog(QWidget* parent, const char* name)
    : KPageDialog(parent)
{
    setCaption(i18n("MLDonkey Configuration"));
    setObjectName(name ? name : "MLDonkeyConfigDialog");
    setFaceType(KPageDialog::Tree);
    setButtons(KDialog::Ok|KDialog::Apply|KDialog::Cancel);
    enableButton(Apply, false);

    // Add regular option sections
    OptionEditorWidget* page;
    const QList<DonkeyOption>& list = KMLDonkey::App->donkey->sectionOptions();
    QList<DonkeyOption>::ConstIterator it;
    for (it = list.begin(); it != list.end(); ++it) {
        if (!KMLDonkey::App->advancedConfig && (*it).optionAdvanced())
            continue;
        page = pages[(*it).optionSection()];
        if (!page) {
            QWidget* p = new QWidget(this);
            p->setLayout(new QVBoxLayout(p));
            addPage(p, (*it).optionSection());
            page = new OptionEditorWidget(p);
            connect(page, SIGNAL(listIsDirty()), SLOT(setDirtyDialog()));
            pages.insert((*it).optionSection(), page);
        }
        page->addOption(*it);
    }

    // Add the root network page
    QString networksName = i18nc("mldonkey config: network options page", "Networks");

    QWidget* w = new QWidget(this);
    QVBoxLayout* l = new QVBoxLayout(w);
    l->setSpacing(0);
    l->setMargin(0);
    w->setLayout(l);
    KPageWidgetItem* networkItem = addPage(w, networksName);
    m_networkPage = new NetworkPage(w);
    l->addWidget(m_networkPage);
    connect(m_networkPage, SIGNAL(pageDirty()), SLOT(setDirtyDialog()));

    // Add the network sub-pages
    const QList<DonkeyOption>& plist = KMLDonkey::App->donkey->pluginOptions();
    for (it = plist.begin(); it != plist.end(); ++it) {
        if (!KMLDonkey::App->advancedConfig && (*it).optionAdvanced())
            continue;
        QStringList section;
        section << networksName << (*it).optionSection();
        page = pages[(*it).optionSection()];
        if (!page) {
            QWidget* p = new QWidget(this);
            p->setLayout(new QVBoxLayout(w));
            addSubPage(networkItem, p, /*section,*/ (*it).optionSection());
            page = new OptionEditorWidget(p);
            connect(page, SIGNAL(listIsDirty()), SLOT(setDirtyDialog()));
            pages.insert((*it).optionSection(), page);
        }
        page->addOption(*it);
    }

    resize(QSize(580, 420).expandedTo( minimumSizeHint() ));
    //setInitialSize(configDialogSize("MLConfigDialog"));

    connect(this, SIGNAL(applyClicked()), this, SLOT(applyOptions()));
    connect(this, SIGNAL(accepted()), this, SLOT(applyOptions()));
    connect(this, SIGNAL(finished()), this, SLOT(closeDialog()));
}

void MLDonkeyConfigDialog::setDirtyDialog()
{
    enableButton(Apply, true);
}

void MLDonkeyConfigDialog::applyOptions()
{
    Q3DictIterator<OptionEditorWidget> it(pages);
    for (; it.current(); ++it)
        it.current()->applyChangedOptions(KMLDonkey::App->donkey);
    m_networkPage->applyOptions(KMLDonkey::App->donkey);
    enableButton(Apply, false);
}

void MLDonkeyConfigDialog::closeDialog()
{
    //saveDialogSize("MLConfigDialog");
    delayedDestruct();
}

#include "mlconfig.moc"
