/* -*- c++ -*-
 *
 * sharepage.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2004,2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_sharepage_h__
#define __kmldonkey_sharepage_h__

#include <qobject.h>
#include <q3intdict.h>
#include <qsplitter.h>
#include <QShowEvent>
#include <Q3PtrList>

#include "clipboard.h"
#include "page.h"

class QTimer;
class KActionCollection;

class KMLDonkeyPreferences;
class InfoList;

class SharedFile : public InfoItem
{
public:
    SharedFile( K3ListView *parent, int share ) : InfoItem(parent,share) { refresh(); }
    ~SharedFile() {}

    QString xtext(int col) const;
    double numeric(int col ) const;
    bool isNumeric(int col) const;

};

class UploadersFile : public InfoItem
{
public:
    UploadersFile(K3ListView *parent, int uploaderid) : InfoItem(parent,uploaderid) {}
    ~UploadersFile() {}

    QString xtext(int col) const;
    double numeric(int col) const;
    bool isNumeric(int col) const;
};

class SharePage : public QWidget, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    SharePage(QWidget* parent);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void configurePrefsDialog(KMLDonkeyPreferences* prefs);
    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KSharedConfigPtr);
    virtual void restoreState(KSharedConfigPtr);

    virtual void clear();

    //void clearUploadersView();
    //void addUploadersViewItem(QMap<QString, QString> items);

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void shareUpdated(int share);
    void shareRemoved(int share);

protected slots:
    void contextUpload(K3ListView*,Q3ListViewItem*,const QPoint&);
    void actionRefreshShared();
    void actionSharedDirs();

    void contextUploaders(K3ListView*,Q3ListViewItem*,const QPoint&);
    void actionRefreshUploaders();

    void actionUpdateUploader(int clientnum);
    void actionRemoveUploader(int clientnum);

    void actionActivatePage();

    void clearUploadSelection();
    void clearUploadersSelection();

    void refreshLists();
    void updateTimer();

protected:
    void showEvent(QShowEvent* event);

private:
    void copyFileToClipboard(ClipFormat format);

    QSplitter *uploadSplitter;
    InfoList *uploadView, *uploadersView;

    Q3IntDict<SharedFile> shareList;
    Q3IntDict<UploadersFile> uploadList;

    Q3PtrList<KAction> uploadActions, uploadersActions;
    KAction * refreshShared, * refreshUploaders;

    QTimer* refreshTimer;
    bool autoUpdate;
    int updateFrequency, activeFrequency;
};

#endif
