/***************************************************************************
                            ReadWritePart.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Base class for an "editor" part.

 This class handles network transparency for you.
 Anything that can open a URL, allow modifications, and save
 (to the same URL or a different one).

 A read-write part can be set to read-only mode, using {@link #setReadWrite}.

 Part writers :
 Any part inheriting ReadWritePart should check {@link isReadWrite}
 before allowing any action that modifies the part.
 The part probably wants to reimplement {@link setReadWrite}, disable those
 actions. Don't forget to call the parent {@link setReadWrite}.
 
 @short 
 Base class for an "editor" part.
*/
public class ReadWritePart extends ReadOnlyPart  {
	protected ReadWritePart(Class dummy){super((Class) null);}


/** 
 Constructor
 See parent constructor for instructions.
   
*/

/** 
 Destructor
 Applications using a ReadWritePart should make sure, before
 destroying it, to call {@link #closeURL}.
 In {@link KMainWindow#queryClose}, for instance, they should allow
 closing only if the return value of {@link #closeURL} was true.
 This allows to cancel.
   
*/
	protected native void finalize() throws InternalError;

/** 

*/
	public native boolean isReadWrite();

/** 
 Changes the behaviour of this part to readonly or readwrite.

*/
	public native void setReadWrite( boolean readwrite);
	public native void setReadWrite();

/** 

*/
	public native boolean isModified();

/** 
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that {@link #openURL} calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Reimplemented from ReadOnlyPart, to handle modified parts
 (and suggest saving in this case, with yes/no/cancel).

*/
	public native boolean closeURL();

/** 
 Save the file to a new location.

 Calls {@link #save}, no need to reimplement
   
*/
	public native boolean saveAs( KURL url);

/** 
  Sets the modified flag of the part.
   
*/
	public native void setModified( boolean modified);

/** 
 Call {@link #setModified} whenever the contents get modified.
 This is a slot for convenience, so that you can connect it
 to a signal, like textChanged().
   
*/
	public native void setModified();

/** 
 Save the file in the location from which it was opened.
 You can connect this to the "save" action.
 Calls {@link #saveFile} and {@link #saveToURL}, no need to reimplement.
   
*/
	public native boolean save();
}
