/***************************************************************************
                            KTMainWindow.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 Compatibility top level widget class

 This class is intended to make porting of KDE-1.x applications
 easier. For new applications, use its base class KMainWindow.

 
 See {@link KTMainWindowSignals} for signals emitted by KTMainWindow.

 See {@link KTMainWindowEventHandling} for event handlers to override in subclasses of KTMainWindow.

 @author Reginald Stadlbauer (reggie@kde.org) Stephan Kulow (coolo@kde.org), Matthias Ettrich (ettrich@kde.org), Chris Schlaeger (cs@kde.org), Sven Radej (radej@kde.org). Maintained by Sven Radej (radej@kde.org)

 @short KDE top level main window.
*/
public class KTMainWindow extends KMainWindow  {
	protected KTMainWindow(Class dummy){super((Class) null);}


/** 
 Construct a main window.

 KTMainWindows must be created on the heap with 'new', like:
  <pre> KTMainWindow ktmw = new KTMainWindow (...</pre>

*/
	private native void newKTMainWindow( String name, int f);
	public KTMainWindow( String name, int f) {
		super((Class) null);
		newKTMainWindow( name, f);
	}
	private native void newKTMainWindow();
	public KTMainWindow() {
		super((Class) null);
		newKTMainWindow();
	}

/** 
 Destructor.

 Will also destroy the toolbars, and menubar if
 needed.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Set the main client widget.

 This is the main widget for your application; it's geometry
 will be automatically managed by KTMainWindow to fit the
 client area, constrained by the positions of the menu, toolbars
 and status bar. It can be fixed-width or Y-fixed.

 Only one client widget can be handled at a time.  Multiple calls
 of {@link #setView} will cause only the last widget to be added to be
 properly handled. The layout management will not start before this
 function has been called. It increases the application start
 speed to call this function after all bars have been registered. The
 presence of the view widget is mandatory for the class to operate.

 The widget must have been created with this instance of
 KTMainWindow as its parent.
     
*/
	public native void setView( QWidget w, boolean arg1);
	public native void setView( QWidget w);

/** 
 Retrieve the view widget.

*/
	public native QWidget view();

/** 
 Enable or disable the status bar.
     
*/
	public native void enableStatusBar( int stat);
	public native void enableStatusBar();

/** 
 Enable or disable the toolbar with the specified @id.

 If no id is specified, the default id of 0 is used.
     
*/
	public native void enableToolBar( int stat, int identifier);
	public native void enableToolBar();

/** 
 Enable or disable the toolbar with the specified name (as
 determined by the XML UI framework).
     
*/
	public native void setEnableToolBar( int stat, String name);
	public native void setEnableToolBar();

/** 
 Add a toolbar to the widget.

 A toolbar added to this widget will be automatically laid out
 by it.

 The toolbar must have been created with this instance of
 KTMainWindow as its parent.

 Usually you do not need this function. Just refer to a toolbar
 with {@link #toolBar} instead and the KTMainWindow will
 create it for you. Anyway {@link #addToolBar} is useful if you want
 to pass additional arguments to the toolbar's constructor.
     
*/
	public native int addToolBar( KToolBar toolbar, int index);
	public native int addToolBar( KToolBar toolbar);

/** 
 Retrieve a pointer to the toolbar with the specified id.

 If there is no such tool bar yet, it will be generated.

*/
	public native KToolBar toolBar( int identifier);
	public native KToolBar toolBar();

/** 

     
*/
	public native void setMenu( KMenuBar arg1);

/** 

     
*/
	public native void setStatusBar( KStatusBar arg1);

/** 

*/
	public native boolean hasMenuBar();

/** 

*/
	public native boolean hasStatusBar();

/** 

*/
	public native boolean hasToolBar( int identifier);
	public native boolean hasToolBar();

/** 

     
*/
	protected native void updateRects();
}
