/***************************************************************************
                            KShared.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Reference counting for shared objects.  If you derive your object
 from this class, then you may use it in conjunction with
 {@link KSharedPtr} to control the lifetime of your object.

 Specifically, all classes that derive from KShared have an internal
 counter keeping track of how many other objects have a reference to
 their object.  If used with {@link KSharedPtr}, then your object will
 not be deleted until all references to the object have been
 released.

 You should probably not ever use any of the methods in this class
 directly -- let the {@link KSharedPtr} take care of that.  Just derive
 your class from KShared and forget about it.

 @author Waldo Bastian <bastian@kde.org>

 @version $Id: KShared.java,v 1.2.2.1 2001/08/29 23:14:10 rdale Exp $
 
 @short 
 Reference counting for shared objects.
*/
public class  KShared implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KShared(Class dummy){}


/** 
 Standard constructor.  This will initialize the reference count
 on this object to 0
    
*/
	private native void newKShared();
	public KShared() {
		newKShared();
	}

/** 
 Copy constructor.  This will <em>not</em> actually copy the objects
 but it will initialize the reference count on this object to 0
    
*/
	private native void newKShared( KShared arg1);
	public KShared( KShared arg1) {
		newKShared( arg1);
	}

/** 
 Increases the reference count by one
    
*/
	public native void _KShared_ref();

/** 
 Releases a reference (decreases the reference count by one).  If
 the count goes to 0, this object will delete itself
    
*/
	public native void _KShared_unref();

/** 
 Return the current number of references held

*/
	public native int _KShared_count();
	protected native void finalize() throws InternalError;
}
