/***************************************************************************
                            KPixmapIO.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 KPixmapIO implements a fast path for QPixmap to/from QImage conversions.
 It uses the MIT-SHM shared memory extension for this. If this extension is 
 not available, it will fall back to standard Qt methods. 

 You can use KPixmapIO for load/saving pixmaps.

 <pre>
 KPixmapIO io;
 pixmap = io.convertToPixmap(image);
 image = io.convertToImage(pixmap);
 </pre>

 It also has functionality for partially updating/saving pixmaps, see 
 {@link #putImage} and {@link #getImage.}

 Speed measurements were taken. These show that usage of KPixmapIO for 
 images up to a certain threshold size, offers no speed advantage over 
 the Qt routines. Below you can see a plot of these measurements.

 The threshold size, amongst other causes, is determined by the shared 
 memory allocation policy. If the policy is <code>ShmDontKeep</code>, the 
 shared memory segment is discarded right after usage, and thus needs to 
 be allocated before each transfer. This introduces a a setup penalty not 
 present when the policy is <code>ShmKeepAndGrow.</code> In this case the 
 shared memory segment is kept and resized when necessary, until the 
 KPixmapIO object is destroyed.

 The default policy is <code>ShmDontKeep.</code> This policy makes sense when
 loading pixmaps once. The corresponding threshold is taken at 5.000 
 pixels as suggested by experiments. Below this threshold, KPixmapIO 
 will not use shared memory and fall back on the Qt routines.

 When the policy is <code>ShmKeepAndGrow</code>, the threshold is taken at
 2.000 pixels. Using this policy, you might want to use {@link #preAllocShm}
 to pre-allocate a certain amount of shared memory, in order to avoid
 resizes. This allocation policy makes sense in a multimedia type
 application where you are constantly updating the screen.

 Above a couple times the threshold size, KPixmapIO's and Qt's speed become 
 linear in the number of pixels, KPixmapIO being at least 2, and mostly around 
 4 times faster than Qt, depending on the screen and image depth.

 Speed difference seems to be the most at 16 bpp, followed by 32 and 24
 bpp respectively. This can be explained by the relatively poor
 implementation of 16 bit RGB packing in Qt, while at 32 bpp we need to
 transfer more data, and thus gain more, than at 24 bpp.

 For large pixmaps, there's a definite speed improvement when using 
 KPixmapIO. On the other hand, there's no speed improvement for small 
 pixmaps. When you know you're only transferring small pixmaps, there's no
 point in using it.
 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: KPixmapIO.java,v 1.2.2.1 2001/08/29 23:14:10 rdale Exp $

 @short Fast QImage to/from QPixmap conversion.

*/
public class  KPixmapIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPixmapIO(Class dummy){}

	private native void newKPixmapIO();
	public KPixmapIO() {
		newKPixmapIO();
	}
	protected native void finalize() throws InternalError;

/** 
 Convert an image to a pixmap.

*/
	public native QPixmap convertToPixmap( QImage image);

/** 
 Convert a pixmap to an image.

*/
	public native QImage convertToImage( QPixmap pixmap);

/** 
 Bitblt an image onto a pixmap.

*/
	public native void putImage( QPixmap dst, int dx, int dy, QImage src);

/** 
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
	public native void putImage( QPixmap dst, QPoint offset, QImage src);

/** 
 Transfer (a part of) a pixmap to an image.

*/
	public native QImage getImage( QPixmap src, int sx, int sy, int sw, int sh);

/** 
 This function is identical to the one above. It only differs in the
 arguments it accepts.
     
*/
	public native QImage getImage( QPixmap src, QRect rect);

/** 
 Set the shared memory allocation policy. See the introduction for
 KPixmapIO for a discussion.

*/
	public native void setShmPolicy( int policy);

/** 
 Pre-allocate shared memory. KPixmapIO will be able to transfer images
 up to this size without resizing.

*/
	public native void preAllocShm( int size);
	public static final int ShmDontKeep = 0;
	public static final int ShmKeepAndGrow = 1;
}
