package org.kde.koala;
import org.kde.qt.*;


/** {@link KEdit} emits these signals */
public interface KEditSignals {
	void destroyed();
	void returnPressed();
	void undoAvailable( boolean arg1 );

/**  This signal is emitted if the user dropped a URL over the text editor
 {@link QMultiLineEdit} widget.

  Note that the user can drop also Text on it, but
 this is already handled internally by QMultiLineEdit.
      
*/
	void gotUrlDrop( QDropEvent e );
	void copyAvailable( boolean arg1 );

/**  This signal is emitted whenever the cursor position changes.

 Use this in conjunction with {@link KEdit#currentLine}, {@link KEdit#currentColumn}
 if you need to know the cursor position.
     
*/
	void CursorPositionChanged();

/** 
 This signal is emitted if the user toggles from insert to overwrite mode
 or vice versa.

 The user can do so by pressing the "Insert" button on a PC keyboard.

 This feature must be activated by calling {@link KEdit#setOverwriteEnabled}
 first.
     
*/
	void toggle_overwrite_signal();
	void redoAvailable( boolean arg1 );
	void textChanged();
}

