package org.kde.koala;
import org.kde.qt.*;


/** {@link KDirWatch} emits these signals */
public interface KDirWatchSignals {
	void destroyed();

/** 
 Emitted when {@link KDirWatch} learns that the file
 <code>_file</code> has changed.

 This happens for instance when a .desktop file 
 gets a new icon - but this isn't automatic, one has to call 
 {@link KDirWatch#setFileDirty} for this signal to be emitted.

 Note that KDirNotify is network transparent and
 broadcasts to all processes, so it sort of supersedes this.
    
*/
	void fileDirty( String _file );

/** 
 Emitted when directory is deleted.

 When you receive this signal, the directory is not yet
 deleted from the list. However, it will be removed from the
 notification list afterwards automatically. 
    
*/
	void deleted( String dir );

/** 
 Emitted when a directory is changed.

 The new ctime is set
 before the signal is emited.
    
*/
	void dirty( String dir );
}

