/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CCODE_COMPILER (vala_ccode_compiler_get_type ())
#define VALA_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler))
#define VALA_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))
#define VALA_IS_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMPILER))
#define VALA_IS_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMPILER))
#define VALA_CCODE_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))

typedef struct _ValaCCodeCompiler ValaCCodeCompiler;
typedef struct _ValaCCodeCompilerClass ValaCCodeCompilerClass;
typedef struct _ValaCCodeCompilerPrivate ValaCCodeCompilerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaCCodeCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeCompilerPrivate * priv;
};

struct _ValaCCodeCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeCompiler *self);
};

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

gpointer vala_ccode_compiler_ref (gpointer instance);
void vala_ccode_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_compiler (GValue* value, gpointer v_object);
void vala_value_take_ccode_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_compiler (const GValue* value);
GType vala_ccode_compiler_get_type (void) G_GNUC_CONST;
enum  {
	VALA_CCODE_COMPILER_DUMMY_PROPERTY
};
ValaCCodeCompiler* vala_ccode_compiler_new (void);
ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type);
static gboolean vala_ccode_compiler_package_exists (const gchar* package_name);
void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1);
static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj);


ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type) {
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler* vala_ccode_compiler_new (void) {
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


static gboolean vala_ccode_compiler_package_exists (const gchar* package_name) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* pc;
	gint exit_status = 0;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = g_strconcat ("pkg-config --exists ", package_name, NULL);
	pc = _tmp0_;
	g_spawn_command_line_sync (pc, NULL, NULL, &_tmp1_, &_inner_error_);
	exit_status = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch1_g_spawn_error;
		}
		_g_free0 (pc);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = 0 == exit_status;
	_g_free0 (pc);
	return result;
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		vala_report_error (NULL, e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally1:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1) {
	gboolean use_pkgconfig;
	gchar* _tmp0_;
	gchar* pc;
	gboolean _tmp1_;
	ValaProfile _tmp3_;
	gchar* _tmp14_;
	gchar* pkgflags;
	gchar* _tmp19_;
	gchar* cmdline;
	gboolean _tmp20_;
	gboolean _tmp22_;
	ValaList* _tmp41_ = NULL;
	ValaList* source_files;
	ValaList* _tmp53_ = NULL;
	ValaList* c_source_files;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gboolean _tmp73_;
	gint exit_status = 0;
	gint _tmp74_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	use_pkgconfig = FALSE;
	_tmp0_ = g_strdup ("pkg-config --cflags");
	pc = _tmp0_;
	_tmp1_ = vala_code_context_get_compile_only (context);
	if (!_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat (pc, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp2_;
	}
	_tmp3_ = vala_code_context_get_profile (context);
	if (_tmp3_ == VALA_PROFILE_GOBJECT) {
		gchar* _tmp4_;
		gboolean _tmp5_;
		use_pkgconfig = TRUE;
		_tmp4_ = g_strconcat (pc, " gobject-2.0", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
		_tmp5_ = vala_code_context_get_thread (context);
		if (_tmp5_) {
			gchar* _tmp6_;
			_tmp6_ = g_strconcat (pc, " gthread-2.0", NULL);
			_g_free0 (pc);
			pc = _tmp6_;
		}
	}
	{
		ValaList* _tmp7_ = NULL;
		ValaList* _pkg_list;
		gint _tmp8_;
		gint _pkg_size;
		gint _pkg_index;
		_tmp7_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _pkg_list);
		_pkg_size = _tmp8_;
		_pkg_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			gchar* pkg;
			gboolean _tmp10_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_pkg_list, _pkg_index);
			pkg = (gchar*) _tmp9_;
			_tmp10_ = vala_ccode_compiler_package_exists (pkg);
			if (_tmp10_) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				use_pkgconfig = TRUE;
				_tmp11_ = g_strconcat (" ", pkg, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (pc, _tmp12_, NULL);
				_g_free0 (pc);
				pc = _tmp13_;
				_g_free0 (_tmp12_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp14_ = g_strdup ("");
	pkgflags = _tmp14_;
	if (use_pkgconfig) {
		gint exit_status = 0;
		gchar* _tmp15_ = NULL;
		gint _tmp16_;
		g_spawn_command_line_sync (pc, &_tmp15_, NULL, &_tmp16_, &_inner_error_);
		_g_free0 (pkgflags);
		pkgflags = _tmp15_;
		exit_status = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch2_g_spawn_error;
			}
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (exit_status != 0) {
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = g_strdup_printf ("pkg-config exited with status %d", exit_status);
			_tmp18_ = _tmp17_;
			vala_report_error (NULL, _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		goto __finally2;
		__catch2_g_spawn_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			vala_report_error (NULL, e->message);
			_g_error_free0 (e);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp19_ = g_strdup (cc_command);
	cmdline = _tmp19_;
	_tmp20_ = vala_code_context_get_debug (context);
	if (_tmp20_) {
		gchar* _tmp21_;
		_tmp21_ = g_strconcat (cmdline, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp21_;
	}
	_tmp22_ = vala_code_context_get_compile_only (context);
	if (_tmp22_) {
		gchar* _tmp23_;
		_tmp23_ = g_strconcat (cmdline, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp23_;
	} else {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = vala_code_context_get_output (context);
		if (_tmp24_ != NULL) {
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* output;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp25_ = vala_code_context_get_output (context);
			_tmp26_ = g_strdup (_tmp25_);
			output = _tmp26_;
			_tmp29_ = vala_code_context_get_directory (context);
			if (_tmp29_ != NULL) {
				const gchar* _tmp30_ = NULL;
				_tmp30_ = vala_code_context_get_directory (context);
				_tmp28_ = g_strcmp0 (_tmp30_, "") != 0;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				const gchar* _tmp31_ = NULL;
				gboolean _tmp32_;
				_tmp31_ = vala_code_context_get_output (context);
				_tmp32_ = g_path_is_absolute (_tmp31_);
				_tmp27_ = !_tmp32_;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				_tmp33_ = vala_code_context_get_directory (context);
				_tmp34_ = vala_code_context_get_output (context);
				_tmp35_ = g_strdup_printf ("%s%c%s", _tmp33_, (gint) G_DIR_SEPARATOR, _tmp34_);
				_g_free0 (output);
				output = _tmp35_;
			}
			_tmp36_ = g_shell_quote (output);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (" -o ", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (cmdline, _tmp39_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp40_;
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (output);
		}
	}
	_tmp41_ = vala_code_context_get_source_files (context);
	source_files = _tmp41_;
	{
		ValaList* _tmp42_;
		ValaList* _file_list;
		gint _tmp43_;
		gint _file_size;
		gint _file_index;
		_tmp42_ = _vala_iterable_ref0 (source_files);
		_file_list = _tmp42_;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp43_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp44_ = NULL;
			ValaSourceFile* file;
			ValaSourceFileType _tmp45_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp44_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp44_;
			_tmp45_ = vala_source_file_get_file_type (file);
			if (_tmp45_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp46_ = vala_source_file_get_csource_filename (file);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_shell_quote (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (" ", _tmp49_, NULL);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (cmdline, _tmp51_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp52_;
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp53_ = vala_code_context_get_c_source_files (context);
	c_source_files = _tmp53_;
	{
		ValaList* _tmp54_;
		ValaList* _file_list;
		gint _tmp55_;
		gint _file_size;
		gint _file_index;
		_tmp54_ = _vala_iterable_ref0 (c_source_files);
		_file_list = _tmp54_;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp55_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp56_ = NULL;
			gchar* file;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp56_ = vala_list_get (_file_list, _file_index);
			file = (gchar*) _tmp56_;
			_tmp57_ = g_shell_quote (file);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (" ", _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_strconcat (cmdline, _tmp60_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp61_;
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp62_ = string_strip (pkgflags);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_strconcat (" ", _tmp63_, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_strconcat (cmdline, _tmp65_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp66_;
	_g_free0 (_tmp65_);
	_g_free0 (_tmp63_);
	{
		gchar** cc_option_collection;
		int cc_option_collection_length1;
		int cc_option_it;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_options_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp67_;
			gchar* cc_option;
			_tmp67_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp67_;
			{
				gchar* _tmp68_ = NULL;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				_tmp68_ = g_shell_quote (cc_option);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_strconcat (" ", _tmp69_, NULL);
				_tmp71_ = _tmp70_;
				_tmp72_ = g_strconcat (cmdline, _tmp71_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp72_;
				_g_free0 (_tmp71_);
				_g_free0 (_tmp69_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp73_ = vala_code_context_get_verbose_mode (context);
	if (_tmp73_) {
		fprintf (stdout, "%s\n", cmdline);
	}
	g_spawn_command_line_sync (cmdline, NULL, NULL, &_tmp74_, &_inner_error_);
	exit_status = _tmp74_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch3_g_spawn_error;
		}
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (exit_status != 0) {
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		_tmp75_ = g_strdup_printf ("cc exited with status %d", exit_status);
		_tmp76_ = _tmp75_;
		vala_report_error (NULL, _tmp76_);
		_g_free0 (_tmp76_);
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		vala_report_error (NULL, e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _tmp77_;
		ValaList* _file_list;
		gint _tmp78_;
		gint _file_size;
		gint _file_index;
		_tmp77_ = _vala_iterable_ref0 (source_files);
		_file_list = _tmp77_;
		_tmp78_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp78_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp79_ = NULL;
			ValaSourceFile* file;
			ValaSourceFileType _tmp80_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp79_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp79_;
			_tmp80_ = vala_source_file_get_file_type (file);
			if (_tmp80_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gboolean _tmp81_;
				_tmp81_ = vala_code_context_get_save_csources (context);
				if (!_tmp81_) {
					gchar* _tmp82_ = NULL;
					gchar* _tmp83_;
					_tmp82_ = vala_source_file_get_csource_filename (file);
					_tmp83_ = _tmp82_;
					g_unlink (_tmp83_);
					_g_free0 (_tmp83_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void vala_value_ccode_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void vala_value_take_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass) {
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_COMPILER_CLASS (klass)->finalize = vala_ccode_compiler_finalize;
}


static void vala_ccode_compiler_instance_init (ValaCCodeCompiler * self) {
	self->ref_count = 1;
}


static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj) {
	ValaCCodeCompiler * self;
	self = VALA_CCODE_COMPILER (obj);
}


/**
 * Interface to the C compiler.
 */
GType vala_ccode_compiler_get_type (void) {
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer vala_ccode_compiler_ref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_compiler_unref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



