/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2009 Richard Hughes <richard@hughsie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <glib.h>

#include "dkp-native.h"

/**
 * dkp_native_get_native_path:
 * @object: the native tracking object
 *
 * This converts a GObject used as the device data into a native path.
 * This would be implemented on a Linux system using:
 *  g_udev_device_get_sysfs_path (G_UDEV_DEVICE (object))
 *
 * Return value: The native path for the device which is unique, e.g. "/sys/class/power/BAT1"
 **/
const gchar *
dkp_native_get_native_path (GObject *object)
{
	return "/sys/dummy";
}

/***************************************************************************
 ***                          MAKE CHECK TESTS                           ***
 ***************************************************************************/
#ifdef EGG_TEST
#include "egg-test.h"

void
dkp_native_test (gpointer user_data)
{
	EggTest *test = (EggTest *) user_data;
	const gchar *path;

	if (!egg_test_start (test, "DkpNative"))
		return;

	/************************************************************/
	egg_test_title (test, "get instance");
	path = dkp_native_get_native_path (NULL);
	egg_test_assert (test, (g_strcmp0 (path, "/sys/dummy") == 0));

	egg_test_end (test);
}
#endif

