/* testreadonlylist.c generated by valac, the Vala compiler
 * generated from testreadonlylist.vala, do not modify */

/* testreadonlylist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Tomaž Vajngerl <quikee@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_READ_ONLY_COLLECTION_TESTS (read_only_collection_tests_get_type ())
#define READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTests))
#define READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))
#define IS_READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READ_ONLY_COLLECTION_TESTS))
#define IS_READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READ_ONLY_COLLECTION_TESTS))
#define READ_ONLY_COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))

typedef struct _ReadOnlyCollectionTests ReadOnlyCollectionTests;
typedef struct _ReadOnlyCollectionTestsClass ReadOnlyCollectionTestsClass;
typedef struct _ReadOnlyCollectionTestsPrivate ReadOnlyCollectionTestsPrivate;

#define TYPE_READ_ONLY_LIST_TESTS (read_only_list_tests_get_type ())
#define READ_ONLY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READ_ONLY_LIST_TESTS, ReadOnlyListTests))
#define READ_ONLY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READ_ONLY_LIST_TESTS, ReadOnlyListTestsClass))
#define IS_READ_ONLY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READ_ONLY_LIST_TESTS))
#define IS_READ_ONLY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READ_ONLY_LIST_TESTS))
#define READ_ONLY_LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READ_ONLY_LIST_TESTS, ReadOnlyListTestsClass))

typedef struct _ReadOnlyListTests ReadOnlyListTests;
typedef struct _ReadOnlyListTestsClass ReadOnlyListTestsClass;
typedef struct _ReadOnlyListTestsPrivate ReadOnlyListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _ReadOnlyCollectionTests {
	GeeTestCase parent_instance;
	ReadOnlyCollectionTestsPrivate * priv;
	GeeCollection* test_collection;
	GeeCollection* ro_collection;
};

struct _ReadOnlyCollectionTestsClass {
	GeeTestCaseClass parent_class;
	GeeCollection* (*get_ro_view) (ReadOnlyCollectionTests* self, GeeCollection* collection);
};

struct _ReadOnlyListTests {
	ReadOnlyCollectionTests parent_instance;
	ReadOnlyListTestsPrivate * priv;
};

struct _ReadOnlyListTestsClass {
	ReadOnlyCollectionTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer read_only_list_tests_parent_class = NULL;

GType gee_test_case_get_type (void);
GType read_only_collection_tests_get_type (void);
GType read_only_list_tests_get_type (void);
enum  {
	READ_ONLY_LIST_TESTS_DUMMY_PROPERTY
};
ReadOnlyCollectionTests* read_only_collection_tests_new_with_name (const char* name);
ReadOnlyCollectionTests* read_only_collection_tests_construct_with_name (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void read_only_list_tests_test_immutable_iterator (ReadOnlyListTests* self);
static void _read_only_list_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self);
void read_only_list_tests_test_immutable (ReadOnlyListTests* self);
static void _read_only_list_tests_test_immutable_gee_test_case_test_method (gpointer self);
void read_only_list_tests_test_accurate_view (ReadOnlyListTests* self);
static void _read_only_list_tests_test_accurate_view_gee_test_case_test_method (gpointer self);
ReadOnlyListTests* read_only_list_tests_new (void);
ReadOnlyListTests* read_only_list_tests_construct (GType object_type);
GeeCollection* read_only_collection_tests_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection);
static void read_only_list_tests_real_set_up (GeeTestCase* base);
static void read_only_list_tests_real_tear_down (GeeTestCase* base);
static GeeCollection* read_only_list_tests_real_get_ro_view (ReadOnlyCollectionTests* base, GeeCollection* collection);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _read_only_list_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self) {
	read_only_list_tests_test_immutable_iterator (self);
}


static void _read_only_list_tests_test_immutable_gee_test_case_test_method (gpointer self) {
	read_only_list_tests_test_immutable (self);
}


static void _read_only_list_tests_test_accurate_view_gee_test_case_test_method (gpointer self) {
	read_only_list_tests_test_accurate_view (self);
}


ReadOnlyListTests* read_only_list_tests_construct (GType object_type) {
	ReadOnlyListTests * self;
	self = (ReadOnlyListTests*) read_only_collection_tests_construct_with_name (object_type, "ReadOnlyList");
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyList] immutable iterator", _read_only_list_tests_test_immutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyList] immutable", _read_only_list_tests_test_immutable_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyList] accurate view", _read_only_list_tests_test_accurate_view_gee_test_case_test_method, self);
	return self;
}


ReadOnlyListTests* read_only_list_tests_new (void) {
	return read_only_list_tests_construct (TYPE_READ_ONLY_LIST_TESTS);
}


static void read_only_list_tests_real_set_up (GeeTestCase* base) {
	ReadOnlyListTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (ReadOnlyListTests*) base;
	((ReadOnlyCollectionTests*) self)->test_collection = (_tmp0_ = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (((ReadOnlyCollectionTests*) self)->test_collection), _tmp0_);
	((ReadOnlyCollectionTests*) self)->ro_collection = (_tmp1_ = read_only_collection_tests_get_ro_view ((ReadOnlyCollectionTests*) self, ((ReadOnlyCollectionTests*) self)->test_collection), _g_object_unref0 (((ReadOnlyCollectionTests*) self)->ro_collection), _tmp1_);
}


static void read_only_list_tests_real_tear_down (GeeTestCase* base) {
	ReadOnlyListTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (ReadOnlyListTests*) base;
	((ReadOnlyCollectionTests*) self)->test_collection = (_tmp0_ = NULL, _g_object_unref0 (((ReadOnlyCollectionTests*) self)->test_collection), _tmp0_);
	((ReadOnlyCollectionTests*) self)->ro_collection = (_tmp1_ = NULL, _g_object_unref0 (((ReadOnlyCollectionTests*) self)->ro_collection), _tmp1_);
}


static GeeCollection* read_only_list_tests_real_get_ro_view (ReadOnlyCollectionTests* base, GeeCollection* collection) {
	ReadOnlyListTests * self;
	GeeCollection* result = NULL;
	self = (ReadOnlyListTests*) base;
	g_return_val_if_fail (collection != NULL, NULL);
	result = (GeeCollection*) gee_list_get_read_only_view (GEE_LIST (collection));
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void read_only_list_tests_test_immutable_iterator (ReadOnlyListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeCollection* _tmp1_;
	GeeList* ro_list;
	char* _tmp2_;
	char* _tmp3_;
	GeeListIterator* iterator;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((ReadOnlyCollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	ro_list = _g_object_ref0 ((_tmp1_ = ((ReadOnlyCollectionTests*) self)->ro_collection, GEE_IS_LIST (_tmp1_) ? ((GeeList*) _tmp1_) : NULL));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp3_);
	iterator = gee_list_list_iterator (ro_list);
	g_assert (gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	g_assert (gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "two") == 0);
	_g_free0 (_tmp5_);
	g_assert (gee_list_iterator_index (iterator) == 1);
	g_assert (!gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (!gee_iterator_next ((GeeIterator*) iterator));
	g_assert (gee_bidir_iterator_has_previous ((GeeBidirIterator*) iterator));
	g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	g_assert (gee_bidir_iterator_last ((GeeBidirIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "two") == 0);
	_g_free0 (_tmp7_);
	g_assert (gee_list_iterator_index (iterator) == 1);
	g_assert (gee_iterator_first ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_iterator_remove ((GeeIterator*) iterator);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp10_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_iterator_set (iterator, "three");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp11_);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp12_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_iterator_insert (iterator, "three");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp13_);
	g_assert (_vala_strcmp0 (_tmp14_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp14_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_iterator_add (iterator, "three");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (_vala_strcmp0 (_tmp15_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp15_);
	g_assert (_vala_strcmp0 (_tmp16_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp16_);
	g_assert (gee_list_iterator_index (iterator) == 0);
	_g_object_unref0 (test_list);
	_g_object_unref0 (ro_list);
	_g_object_unref0 (iterator);
}


void read_only_list_tests_test_immutable (ReadOnlyListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeCollection* _tmp1_;
	GeeList* ro_list;
	GeeCollection* dummy;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((ReadOnlyCollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	ro_list = _g_object_ref0 ((_tmp1_ = ((ReadOnlyCollectionTests*) self)->ro_collection, GEE_IS_LIST (_tmp1_) ? ((GeeList*) _tmp1_) : NULL));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	dummy = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_collection_add (dummy, "one"));
	g_assert (gee_collection_add (dummy, "two"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_set (ro_list, 0, "two");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (ro_list, 1, "two");
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp2_;
		_tmp2_ = (char*) gee_list_remove_at (ro_list, 1);
		_g_free0 (_tmp2_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert_all (ro_list, 1, dummy);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_sort (ro_list, NULL);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "one"));
	_g_object_unref0 (test_list);
	_g_object_unref0 (ro_list);
	_g_object_unref0 (dummy);
}


void read_only_list_tests_test_accurate_view (ReadOnlyListTests* self) {
	GeeCollection* _tmp0_;
	GeeList* test_list;
	GeeCollection* _tmp1_;
	GeeList* ro_list;
	GeeCollection* dummy;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((ReadOnlyCollectionTests*) self)->test_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL));
	ro_list = _g_object_ref0 ((_tmp1_ = ((ReadOnlyCollectionTests*) self)->ro_collection, GEE_IS_LIST (_tmp1_) ? ((GeeList*) _tmp1_) : NULL));
	dummy = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_collection_add (dummy, "one"));
	g_assert (gee_collection_add (dummy, "two"));
	g_assert (gee_iterable_get_element_type ((GeeIterable*) ro_list) == G_TYPE_STRING);
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) ro_list));
	g_assert (!gee_collection_contains ((GeeCollection*) ro_list, "one"));
	g_assert (gee_list_index_of (ro_list, "one") == (-1));
	g_assert (gee_collection_add ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (!gee_collection_get_is_empty ((GeeCollection*) ro_list));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_list_index_of (ro_list, "one") == 0);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_first (ro_list), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_last (ro_list), "one") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_collection_add ((GeeCollection*) test_list, "two"));
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 2);
	g_assert (!gee_collection_get_is_empty ((GeeCollection*) ro_list));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (ro_list, 0), "one") == 0);
	_g_free0 (_tmp5_);
	g_assert (gee_list_index_of (ro_list, "one") == 0);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (ro_list, 1), "two") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_list_index_of (ro_list, "two") == 1);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_first (ro_list), "one") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_last (ro_list), "two") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_collection_remove ((GeeCollection*) test_list, "one"));
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 1);
	g_assert (!gee_collection_get_is_empty ((GeeCollection*) ro_list));
	g_assert (!gee_collection_contains ((GeeCollection*) ro_list, "one"));
	g_assert (gee_list_index_of (ro_list, "one") == (-1));
	g_assert (gee_collection_contains ((GeeCollection*) ro_list, "two"));
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (ro_list, 0), "two") == 0);
	_g_free0 (_tmp9_);
	g_assert (gee_list_index_of (ro_list, "two") == 0);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_first (ro_list), "two") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_list_last (ro_list), "two") == 0);
	_g_free0 (_tmp11_);
	gee_collection_clear ((GeeCollection*) test_list);
	g_assert (gee_collection_get_size ((GeeCollection*) ro_list) == 0);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) ro_list));
	g_assert (gee_list_index_of (ro_list, "one") == (-1));
	g_assert (gee_list_index_of (ro_list, "two") == (-1));
	_g_object_unref0 (test_list);
	_g_object_unref0 (ro_list);
	_g_object_unref0 (dummy);
}


static void read_only_list_tests_class_init (ReadOnlyListTestsClass * klass) {
	read_only_list_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = read_only_list_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = read_only_list_tests_real_tear_down;
	READ_ONLY_COLLECTION_TESTS_CLASS (klass)->get_ro_view = read_only_list_tests_real_get_ro_view;
}


static void read_only_list_tests_instance_init (ReadOnlyListTests * self) {
}


GType read_only_list_tests_get_type (void) {
	static volatile gsize read_only_list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&read_only_list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReadOnlyListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) read_only_list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReadOnlyListTests), 0, (GInstanceInitFunc) read_only_list_tests_instance_init, NULL };
		GType read_only_list_tests_type_id;
		read_only_list_tests_type_id = g_type_register_static (TYPE_READ_ONLY_COLLECTION_TESTS, "ReadOnlyListTests", &g_define_type_info, 0);
		g_once_init_leave (&read_only_list_tests_type_id__volatile, read_only_list_tests_type_id);
	}
	return read_only_list_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




