/* treeset.c generated by valac, the Vala compiler
 * generated from treeset.vala, do not modify */

/* treeset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_SORTED_SET (gee_sorted_set_get_type ())
#define GEE_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SORTED_SET, GeeSortedSet))
#define GEE_IS_SORTED_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SORTED_SET))
#define GEE_SORTED_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SORTED_SET, GeeSortedSetIface))

typedef struct _GeeSortedSet GeeSortedSet;
typedef struct _GeeSortedSetIface GeeSortedSetIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_TREE_SET (gee_tree_set_get_type ())
#define GEE_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TREE_SET, GeeTreeSet))
#define GEE_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TREE_SET, GeeTreeSetClass))
#define GEE_IS_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TREE_SET))
#define GEE_IS_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TREE_SET))
#define GEE_TREE_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TREE_SET, GeeTreeSetClass))

typedef struct _GeeTreeSet GeeTreeSet;
typedef struct _GeeTreeSetClass GeeTreeSetClass;
typedef struct _GeeTreeSetPrivate GeeTreeSetPrivate;
typedef struct _GeeTreeSetNode GeeTreeSetNode;

#define GEE_TREE_SET_TYPE_RANGE_TYPE (gee_tree_set_range_type_get_type ())
#define _gee_tree_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_tree_set_node_free (var), NULL)))

#define GEE_TREE_SET_NODE_TYPE_COLOR (gee_tree_set_node_color_get_type ())

#define GEE_TREE_SET_TYPE_ITERATOR (gee_tree_set_iterator_get_type ())
#define GEE_TREE_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIterator))
#define GEE_TREE_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))
#define GEE_TREE_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))

typedef struct _GeeTreeSetIterator GeeTreeSetIterator;
typedef struct _GeeTreeSetIteratorClass GeeTreeSetIteratorClass;

#define GEE_TREE_SET_TYPE_SUB_SET (gee_tree_set_sub_set_get_type ())
#define GEE_TREE_SET_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSet))
#define GEE_TREE_SET_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))
#define GEE_TREE_SET_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_SET))
#define GEE_TREE_SET_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetClass))

typedef struct _GeeTreeSetSubSet GeeTreeSetSubSet;
typedef struct _GeeTreeSetSubSetClass GeeTreeSetSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeTreeSetIteratorPrivate GeeTreeSetIteratorPrivate;
typedef struct _GeeTreeSetSubSetPrivate GeeTreeSetSubSetPrivate;

#define GEE_TREE_SET_TYPE_RANGE (gee_tree_set_range_get_type ())
typedef struct _GeeTreeSetRange GeeTreeSetRange;

#define GEE_TREE_SET_TYPE_SUB_ITERATOR (gee_tree_set_sub_iterator_get_type ())
#define GEE_TREE_SET_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIterator))
#define GEE_TREE_SET_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))
#define GEE_TREE_SET_IS_SUB_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_IS_SUB_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_SUB_ITERATOR))
#define GEE_TREE_SET_SUB_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorClass))

typedef struct _GeeTreeSetSubIterator GeeTreeSetSubIterator;
typedef struct _GeeTreeSetSubIteratorClass GeeTreeSetSubIteratorClass;
typedef struct _GeeTreeSetSubIteratorPrivate GeeTreeSetSubIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeSortedSetIface {
	GTypeInterface parent_iface;
	gpointer (*first) (GeeSortedSet* self);
	gpointer (*last) (GeeSortedSet* self);
	GeeBidirIterator* (*bidir_iterator) (GeeSortedSet* self);
	GeeBidirIterator* (*iterator_at) (GeeSortedSet* self, gconstpointer element);
	gpointer (*lower) (GeeSortedSet* self, gconstpointer element);
	gpointer (*higher) (GeeSortedSet* self, gconstpointer element);
	gpointer (*floor) (GeeSortedSet* self, gconstpointer element);
	gpointer (*ceil) (GeeSortedSet* self, gconstpointer element);
	GeeSortedSet* (*head_set) (GeeSortedSet* self, gconstpointer before);
	GeeSortedSet* (*tail_set) (GeeSortedSet* self, gconstpointer after);
	GeeSortedSet* (*sub_set) (GeeSortedSet* self, gconstpointer from, gconstpointer to);
};

struct _GeeTreeSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetPrivate * priv;
};

struct _GeeTreeSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	GeeTreeSetNode* root;
	GeeTreeSetNode* _first;
	GeeTreeSetNode* _last;
	gint stamp;
};

typedef enum  {
	GEE_TREE_SET_RANGE_TYPE_HEAD,
	GEE_TREE_SET_RANGE_TYPE_TAIL,
	GEE_TREE_SET_RANGE_TYPE_EMPTY,
	GEE_TREE_SET_RANGE_TYPE_BOUNDED
} GeeTreeSetRangeType;

typedef enum  {
	GEE_TREE_SET_NODE_COLOR_RED,
	GEE_TREE_SET_NODE_COLOR_BLACK
} GeeTreeSetNodeColor;

struct _GeeTreeSetNode {
	gpointer key;
	GeeTreeSetNodeColor color;
	GeeTreeSetNode* left;
	GeeTreeSetNode* right;
	GeeTreeSetNode* prev;
	GeeTreeSetNode* next;
};

struct _GeeTreeSetIterator {
	GObject parent_instance;
	GeeTreeSetIteratorPrivate * priv;
};

struct _GeeTreeSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* _set;
	gint stamp;
	GeeTreeSetNode* current;
	GeeTreeSetNode* _next;
	GeeTreeSetNode* _prev;
	gboolean started;
};

struct _GeeTreeSetSubSet {
	GeeAbstractSet parent_instance;
	GeeTreeSetSubSetPrivate * priv;
};

struct _GeeTreeSetSubSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeTreeSetRange {
	GeeTreeSet* set;
	gpointer after;
	gpointer before;
	GeeTreeSetRangeType type;
};

struct _GeeTreeSetSubSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange range;
};

struct _GeeTreeSetSubIterator {
	GObject parent_instance;
	GeeTreeSetSubIteratorPrivate * priv;
};

struct _GeeTreeSetSubIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetSubIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* set;
	GeeTreeSetRange range;
	GeeTreeSetIterator* iterator;
};


static gpointer gee_tree_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_iterator_gee_bidir_iterator_parent_iface = NULL;
static gpointer gee_tree_set_sub_set_parent_class = NULL;
static GeeSortedSetIface* gee_tree_set_sub_set_gee_sorted_set_parent_iface = NULL;
static gpointer gee_tree_set_sub_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_sub_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = NULL;
static gpointer gee_tree_set_parent_class = NULL;
static GeeSortedSetIface* gee_tree_set_gee_sorted_set_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_set_get_type (void);
GType gee_abstract_set_get_type (void);
GType gee_bidir_iterator_get_type (void);
GType gee_sorted_set_get_type (void);
GType gee_tree_set_get_type (void);
static void gee_tree_set_node_free (GeeTreeSetNode* self);
#define GEE_TREE_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TREE_SET, GeeTreeSetPrivate))
enum  {
	GEE_TREE_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SIZE,
	GEE_TREE_SET_COMPARE_FUNC,
	GEE_TREE_SET_G_TYPE,
	GEE_TREE_SET_G_DUP_FUNC,
	GEE_TREE_SET_G_DESTROY_FUNC
};
static GType gee_tree_set_range_type_get_type (void) G_GNUC_UNUSED;
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value);
GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self);
GType gee_tree_set_node_color_get_type (void);
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n);
static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n);
static void gee_tree_set_node_flip (GeeTreeSetNode* self);
static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item);
static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root);
static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next);
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_tree_set_real_clear (GeeAbstractCollection* base);
static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GType gee_tree_set_iterator_get_type (void) G_GNUC_UNUSED;
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base);
static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base);
static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node);
static gpointer gee_tree_set_real_first (GeeSortedSet* base);
static gpointer gee_tree_set_real_last (GeeSortedSet* base);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before);
static GType gee_tree_set_sub_set_get_type (void) G_GNUC_UNUSED;
static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after);
static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item);
static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current);
static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item);
static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item);
static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item);
static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item);
static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b);
static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self);
static void gee_tree_set_node_instance_init (GeeTreeSetNode * self);
#define GEE_TREE_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorPrivate))
enum  {
	GEE_TREE_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_ITERATOR_G_TYPE,
	GEE_TREE_SET_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_tree_set_iterator_real_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_first (GeeIterator* base);
static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base);
static gpointer gee_tree_set_iterator_real_get (GeeIterator* base);
static void gee_tree_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val);
static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val);
static void gee_tree_set_iterator_finalize (GObject* obj);
static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static GType gee_tree_set_range_get_type (void) G_GNUC_UNUSED;
static GeeTreeSetRange* gee_tree_set_range_dup (const GeeTreeSetRange* self);
static void gee_tree_set_range_free (GeeTreeSetRange* self);
static void gee_tree_set_range_copy (const GeeTreeSetRange* self, GeeTreeSetRange* dest);
static void gee_tree_set_range_destroy (GeeTreeSetRange* self);
#define GEE_TREE_SET_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_SET, GeeTreeSetSubSetPrivate))
enum  {
	GEE_TREE_SET_SUB_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_SET_SIZE,
	GEE_TREE_SET_SUB_SET_IS_EMPTY,
	GEE_TREE_SET_SUB_SET_G_TYPE,
	GEE_TREE_SET_SUB_SET_G_DUP_FUNC,
	GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC
};
static void gee_tree_set_range_init (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after, gconstpointer before);
static void gee_tree_set_range_init_head (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer before);
static void gee_tree_set_range_init_tail (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after);
static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static gboolean gee_tree_set_range_in_range (GeeTreeSetRange *self, gconstpointer item);
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range);
static GType gee_tree_set_sub_iterator_get_type (void) G_GNUC_UNUSED;
static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base);
static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base);
static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange *self);
static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base);
static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange *self);
static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base);
static void gee_tree_set_range_cut_tail (GeeTreeSetRange *self, gconstpointer before, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before);
static void gee_tree_set_range_cut_head (GeeTreeSetRange *self, gconstpointer after, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after);
static void gee_tree_set_range_cut (GeeTreeSetRange *self, gconstpointer after, gconstpointer before, GeeTreeSetRange* result);
static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node);
static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item);
static gint gee_tree_set_range_compare_range (GeeTreeSetRange *self, gconstpointer item);
gpointer gee_sorted_set_last (GeeSortedSet* self);
gpointer gee_sorted_set_lower (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_first (GeeSortedSet* self);
gpointer gee_sorted_set_higher (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_floor (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item);
gpointer gee_sorted_set_ceil (GeeSortedSet* self, gconstpointer element);
static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item);
static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange *self);
static void gee_tree_set_sub_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
static void gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_SUB_ITERATOR, GeeTreeSetSubIteratorPrivate))
enum  {
	GEE_TREE_SET_SUB_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_SUB_ITERATOR_G_TYPE,
	GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC
};
gboolean gee_iterator_first (GeeIterator* self);
static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base);
static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base);
gboolean gee_bidir_iterator_previous (GeeBidirIterator* self);
static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base);
gpointer gee_iterator_get (GeeIterator* self);
static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base);
static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base);
static void gee_tree_set_sub_iterator_finalize (GObject* obj);
static void gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_tree_set_finalize (GObject* obj);
static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static GType gee_tree_set_range_type_get_type (void) {
	static volatile gsize gee_tree_set_range_type_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_RANGE_TYPE_HEAD, "GEE_TREE_SET_RANGE_TYPE_HEAD", "head"}, {GEE_TREE_SET_RANGE_TYPE_TAIL, "GEE_TREE_SET_RANGE_TYPE_TAIL", "tail"}, {GEE_TREE_SET_RANGE_TYPE_EMPTY, "GEE_TREE_SET_RANGE_TYPE_EMPTY", "empty"}, {GEE_TREE_SET_RANGE_TYPE_BOUNDED, "GEE_TREE_SET_RANGE_TYPE_BOUNDED", "bounded"}, {0, NULL, NULL}};
		GType gee_tree_set_range_type_type_id;
		gee_tree_set_range_type_type_id = g_enum_register_static ("GeeTreeSetRangeType", values);
		g_once_init_leave (&gee_tree_set_range_type_type_id__volatile, gee_tree_set_range_type_type_id);
	}
	return gee_tree_set_range_type_type_id__volatile;
}


GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	GeeTreeSet * self;
	self = (GeeTreeSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (compare_func == NULL) {
		compare_func = gee_functions_get_compare_func_for (g_type);
	}
	gee_tree_set_set_compare_func (self, compare_func);
	return self;
}


GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	return gee_tree_set_construct (GEE_TYPE_TREE_SET, g_type, g_dup_func, g_destroy_func, compare_func);
}


static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	GeeTreeSetNode* cur;
	self = (GeeTreeSet*) base;
	cur = self->priv->root;
	while (TRUE) {
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
		if (res == 0) {
			result = TRUE;
			return result;
		} else {
			if (res < 0) {
				cur = cur->left;
			} else {
				cur = cur->right;
			}
		}
	}
	result = FALSE;
	return result;
}


static inline void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	pivot = (_tmp0_ = (*root)->left, (*root)->left = NULL, _tmp0_);
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	(*root)->left = (_tmp2_ = (_tmp1_ = pivot->right, pivot->right = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->left), _tmp2_);
	pivot->right = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->right), _tmp4_);
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
	_gee_tree_set_node_free0 (pivot);
}


static inline void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	pivot = (_tmp0_ = (*root)->right, (*root)->right = NULL, _tmp0_);
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	(*root)->right = (_tmp2_ = (_tmp1_ = pivot->left, pivot->left = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->right), _tmp2_);
	pivot->left = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->left), _tmp4_);
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
	_gee_tree_set_node_free0 (pivot);
}


static inline gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n != NULL) {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_RED;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	result = _tmp0_;
	return result;
}


static inline void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (gee_tree_set_is_black (self, (*node)->left)) {
		_tmp0_ = gee_tree_set_is_red (self, (*node)->right);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gee_tree_set_rotate_left (self, node);
	}
	if (gee_tree_set_is_red (self, (*node)->left)) {
		_tmp1_ = gee_tree_set_is_red (self, (*node)->left->left);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gee_tree_set_rotate_right (self, node);
	}
	if (gee_tree_set_is_red (self, (*node)->left)) {
		_tmp2_ = gee_tree_set_is_red (self, (*node)->right);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gee_tree_set_node_flip (*node);
	}
}


static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	gboolean result = FALSE;
	gint cmp;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*node) == NULL) {
		GeeTreeSetNode* _tmp1_;
		gpointer _tmp0_;
		*node = (_tmp1_ = gee_tree_set_node_new ((_tmp0_ = item, item = NULL, _tmp0_), prev, next), _gee_tree_set_node_free0 (*node), _tmp1_);
		if (prev == NULL) {
			self->priv->_first = *node;
		}
		if (next == NULL) {
			self->priv->_last = *node;
		}
		self->priv->_size++;
		result = TRUE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	}
	cmp = gee_tree_set_get_compare_func (self) (item, (*node)->key);
	if (cmp == 0) {
		gee_tree_set_fix_up (self, node);
		result = FALSE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	} else {
		if (cmp < 0) {
			gconstpointer _tmp2_;
			gboolean r;
			r = gee_tree_set_add_to_node (self, &(*node)->left, (_tmp2_ = item, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_)), (*node)->prev, *node);
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		} else {
			gconstpointer _tmp3_;
			gboolean r;
			r = gee_tree_set_add_to_node (self, &(*node)->right, (_tmp3_ = item, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), *node, (*node)->next);
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		}
	}
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
}


static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean r;
	self = (GeeTreeSet*) base;
	r = gee_tree_set_add_to_node (self, &self->priv->root, (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), NULL, NULL);
	self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	self->priv->stamp++;
	result = r;
	return result;
}


static inline void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	if (gee_tree_set_is_red (self, (*root)->right->left)) {
		gee_tree_set_rotate_right (self, &(*root)->right);
		gee_tree_set_rotate_left (self, root);
		gee_tree_set_node_flip (*root);
	}
}


static inline void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	if (gee_tree_set_is_red (self, (*root)->left->left)) {
		gee_tree_set_rotate_right (self, root);
		gee_tree_set_node_flip (*root);
	}
}


static inline void gee_tree_set_fix_removal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* n;
	GeeTreeSetNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	n = (_tmp0_ = *node, *node = NULL, _tmp0_);
	if ((key) != NULL) {
		gpointer _tmp2_;
		gpointer _tmp1_;
		*key = (_tmp2_ = (_tmp1_ = n->key, n->key = NULL, _tmp1_), (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp2_);
	}
	if (n->prev != NULL) {
		n->prev->next = n->next;
	} else {
		self->priv->_first = n->next;
	}
	if (n->next != NULL) {
		n->next->prev = n->prev;
	} else {
		self->priv->_last = n->prev;
	}
	*node = (_tmp3_ = NULL, _gee_tree_set_node_free0 (*node), _tmp3_);
	self->priv->_size--;
	_gee_tree_set_node_free0 (n);
}


static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
	gboolean _tmp2_ = FALSE;
	gpointer _tmp4_;
	gpointer _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if ((*node)->left == NULL) {
		gpointer _tmp1_;
		gpointer _tmp0_ = NULL;
		gee_tree_set_fix_removal (self, node, &_tmp0_);
		*key = (_tmp1_ = _tmp0_, (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp1_);
		return;
	}
	if (gee_tree_set_is_black (self, (*node)->left)) {
		_tmp2_ = gee_tree_set_is_black (self, (*node)->left->left);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gee_tree_set_move_red_left (self, node);
	}
	gee_tree_set_remove_minimal (self, &(*node)->left, &_tmp3_);
	*key = (_tmp4_ = _tmp3_, (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp4_);
	gee_tree_set_fix_up (self, node);
}


static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item, GeeTreeSetNode** prev, GeeTreeSetNode** next) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (prev != NULL) {
		*prev = NULL;
	}
	if (next != NULL) {
		*next = NULL;
	}
	if ((*node) == NULL) {
		result = FALSE;
		return result;
	} else {
		if (gee_tree_set_get_compare_func (self) (item, (*node)->key) < 0) {
			GeeTreeSetNode* left;
			gboolean _tmp0_ = FALSE;
			gboolean r;
			left = (*node)->left;
			if (left == NULL) {
				result = FALSE;
				return result;
			}
			if (gee_tree_set_is_black (self, left)) {
				_tmp0_ = gee_tree_set_is_black (self, left->left);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gee_tree_set_move_red_left (self, node);
			}
			r = gee_tree_set_remove_from_node (self, &(*node)->left, item, prev, next);
			gee_tree_set_fix_up (self, node);
			result = r;
			return result;
		} else {
			GeeTreeSetNode* r;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			if (gee_tree_set_is_red (self, (*node)->left)) {
				gee_tree_set_rotate_right (self, node);
			}
			r = (*node)->right;
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
				_tmp1_ = r == NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				if ((prev) != NULL) {
					*prev = (*node)->prev;
				}
				if ((next) != NULL) {
					*next = (*node)->next;
				}
				gee_tree_set_fix_removal (self, node, NULL);
				result = TRUE;
				return result;
			}
			if (gee_tree_set_is_black (self, r)) {
				_tmp3_ = r != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				_tmp2_ = gee_tree_set_is_black (self, r->left);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gee_tree_set_move_red_right (self, node);
			}
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
				gpointer _tmp5_;
				gpointer _tmp4_ = NULL;
				if ((prev) != NULL) {
					*prev = (*node)->prev;
				}
				if ((next) != NULL) {
					*next = *node;
				}
				gee_tree_set_remove_minimal (self, &(*node)->right, &_tmp4_);
				(*node)->key = (_tmp5_ = _tmp4_, (((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL)), _tmp5_);
				gee_tree_set_fix_up (self, node);
				result = TRUE;
				return result;
			} else {
				gboolean re;
				re = gee_tree_set_remove_from_node (self, &(*node)->right, item, prev, next);
				gee_tree_set_fix_up (self, node);
				result = re;
				return result;
			}
		}
	}
}


static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result = FALSE;
	gboolean b;
	self = (GeeTreeSet*) base;
	b = gee_tree_set_remove_from_node (self, &self->priv->root, item, NULL, NULL);
	if (self->priv->root != NULL) {
		self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	self->priv->stamp++;
	result = b;
	return result;
}


static void gee_tree_set_real_clear (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	GeeTreeSetNode* _tmp0_;
	self = (GeeTreeSet*) base;
	self->priv->root = (_tmp0_ = NULL, _gee_tree_set_node_free0 (self->priv->root), _tmp0_);
	self->priv->_size = 0;
	self->priv->stamp++;
}


static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	GeeIterator* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeIterator*) gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static GeeBidirIterator* gee_tree_set_real_bidir_iterator (GeeSortedSet* base) {
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeBidirIterator*) gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static inline gpointer gee_tree_set_lift_null_get (GeeTreeSet* self, GeeTreeSetNode* node) {
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	if (node != NULL) {
		_tmp0_ = node->key;
	} else {
		_tmp0_ = NULL;
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	return result;
}


static gpointer gee_tree_set_real_first (GeeSortedSet* base) {
	GeeTreeSet * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSet*) base;
	g_assert (self->priv->_first != NULL);
	result = (_tmp0_ = self->priv->_first->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static gpointer gee_tree_set_real_last (GeeSortedSet* base) {
	GeeTreeSet * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSet*) base;
	g_assert (self->priv->_last != NULL);
	result = (_tmp0_ = self->priv->_last->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static GeeSortedSet* gee_tree_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new_head (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, before);
	return result;
}


static GeeSortedSet* gee_tree_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new_tail (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after);
	return result;
}


static GeeSortedSet* gee_tree_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
	GeeTreeSet * self;
	GeeSortedSet* result = NULL;
	self = (GeeTreeSet*) base;
	result = (GeeSortedSet*) gee_tree_set_sub_set_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, after, before);
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_node (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
	g_return_val_if_fail (self != NULL, NULL);
	cur = self->priv->root;
	while (TRUE) {
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
		if (res == 0) {
			result = cur;
			return result;
		} else {
			if (res < 0) {
				cur = cur->left;
			} else {
				cur = cur->right;
			}
		}
	}
	result = NULL;
	return result;
}


static GeeBidirIterator* gee_tree_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSet*) base;
	node = gee_tree_set_find_node (self, item);
	_tmp0_ = NULL;
	if (node != NULL) {
		GeeTreeSetIterator* _tmp1_;
		_tmp0_ = (_tmp1_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, node), _g_object_unref0 (_tmp0_), _tmp1_);
	} else {
		GeeTreeSetIterator* _tmp2_;
		_tmp0_ = (_tmp2_ = NULL, _g_object_unref0 (_tmp0_), _tmp2_);
	}
	result = (GeeBidirIterator*) _tmp0_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_nearest (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* cur;
	g_return_val_if_fail (self != NULL, NULL);
	cur = self->priv->root;
	while (TRUE) {
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
		if (res == 0) {
			result = cur;
			return result;
		} else {
			if (res < 0) {
				if (cur->left == NULL) {
					result = cur;
					return result;
				}
				cur = cur->left;
			} else {
				if (cur->right == NULL) {
					result = cur;
					return result;
				}
				cur = cur->right;
			}
		}
	}
	result = NULL;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_lower (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	node = gee_tree_set_find_nearest (self, item);
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (item, node->key) <= 0) {
		_tmp0_ = node->prev;
	} else {
		_tmp0_ = node;
	}
	result = _tmp0_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_higher (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	node = gee_tree_set_find_nearest (self, item);
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (item, node->key) >= 0) {
		_tmp0_ = node->next;
	} else {
		_tmp0_ = node;
	}
	result = _tmp0_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_floor (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	node = gee_tree_set_find_nearest (self, item);
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (item, node->key) < 0) {
		_tmp0_ = node->prev;
	} else {
		_tmp0_ = node;
	}
	result = _tmp0_;
	return result;
}


static inline GeeTreeSetNode* gee_tree_set_find_ceil (GeeTreeSet* self, gconstpointer item) {
	GeeTreeSetNode* result = NULL;
	GeeTreeSetNode* node;
	GeeTreeSetNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	node = gee_tree_set_find_nearest (self, item);
	if (node == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (item, node->key) > 0) {
		_tmp0_ = node->next;
	} else {
		_tmp0_ = node;
	}
	result = _tmp0_;
	return result;
}


static gpointer gee_tree_set_real_lower (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_lower (self, item));
	return result;
}


static gpointer gee_tree_set_real_higher (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_higher (self, item));
	return result;
}


static gpointer gee_tree_set_real_floor (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_floor (self, item));
	return result;
}


static gpointer gee_tree_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSet * self;
	gpointer result = NULL;
	self = (GeeTreeSet*) base;
	result = gee_tree_set_lift_null_get (self, gee_tree_set_find_ceil (self, item));
	return result;
}


static inline gpointer gee_tree_set_min (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (a, b) <= 0) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	return result;
}


static inline gpointer gee_tree_set_max (GeeTreeSet* self, gconstpointer a, gconstpointer b) {
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	if (gee_tree_set_get_compare_func (self) (a, b) > 0) {
		_tmp0_ = a;
	} else {
		_tmp0_ = b;
	}
	result = (_tmp1_ = _tmp0_, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	return result;
}


static gint gee_tree_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSet* self;
	self = (GeeTreeSet*) base;
	result = self->priv->_size;
	return result;
}


GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
	return result;
}


static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self) {
	GeeTreeSetNodeColor result = 0;
	if (self == GEE_TREE_SET_NODE_COLOR_RED) {
		result = GEE_TREE_SET_NODE_COLOR_BLACK;
		return result;
	} else {
		result = GEE_TREE_SET_NODE_COLOR_RED;
		return result;
	}
}


GType gee_tree_set_node_color_get_type (void) {
	static volatile gsize gee_tree_set_node_color_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_node_color_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_NODE_COLOR_RED, "GEE_TREE_SET_NODE_COLOR_RED", "red"}, {GEE_TREE_SET_NODE_COLOR_BLACK, "GEE_TREE_SET_NODE_COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType gee_tree_set_node_color_type_id;
		gee_tree_set_node_color_type_id = g_enum_register_static ("GeeTreeSetNodeColor", values);
		g_once_init_leave (&gee_tree_set_node_color_type_id__volatile, gee_tree_set_node_color_type_id);
	}
	return gee_tree_set_node_color_type_id__volatile;
}


static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	GeeTreeSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeTreeSetNode);
	gee_tree_set_node_instance_init (self);
	self->key = (_tmp0_ = node, node = NULL, _tmp0_);
	self->color = GEE_TREE_SET_NODE_COLOR_RED;
	self->prev = prev;
	self->next = next;
	if (prev != NULL) {
		prev->next = self;
	}
	if (next != NULL) {
		next->prev = self;
	}
	return self;
}


static void gee_tree_set_node_flip (GeeTreeSetNode* self) {
	g_return_if_fail (self != NULL);
	self->color = gee_tree_set_node_color_flip (self->color);
	if (self->left != NULL) {
		self->left->color = gee_tree_set_node_color_flip (self->left->color);
	}
	if (self->right != NULL) {
		self->right->color = gee_tree_set_node_color_flip (self->right->color);
	}
}


static void gee_tree_set_node_instance_init (GeeTreeSetNode * self) {
}


static void gee_tree_set_node_free (GeeTreeSetNode* self) {
	_gee_tree_set_node_free0 (self->left);
	_gee_tree_set_node_free0 (self->right);
	g_slice_free (GeeTreeSetNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	GeeTreeSetIterator * self;
	GeeTreeSet* _tmp0_;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
	self->priv->stamp = self->priv->_set->priv->stamp;
	return self;
}


static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	return gee_tree_set_iterator_construct (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static GeeTreeSetIterator* gee_tree_set_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
	GeeTreeSetIterator * self;
	GeeTreeSet* _tmp0_;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (current != NULL, NULL);
	self = (GeeTreeSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->_set), _tmp0_);
	self->priv->current = current;
	self->priv->stamp = set->priv->stamp;
	self->priv->started = TRUE;
	return self;
}


static GeeTreeSetIterator* gee_tree_set_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetNode* current) {
	return gee_tree_set_iterator_construct_pointing (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set, current);
}


static gboolean gee_tree_set_iterator_real_next (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current != NULL) {
		if (self->priv->current->next != NULL) {
			self->priv->current = self->priv->current->next;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		if (!self->priv->started) {
			self->priv->current = self->priv->_set->priv->_first;
			self->priv->started = TRUE;
			result = self->priv->current != NULL;
			return result;
		} else {
			self->priv->current = self->priv->_next;
			if (self->priv->current != NULL) {
				self->priv->_next = NULL;
				self->priv->_prev = NULL;
			}
			result = self->priv->current != NULL;
			return result;
		}
	}
}


static gboolean gee_tree_set_iterator_real_has_next (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (!self->priv->started) {
		_tmp2_ = self->priv->_set->priv->_first != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->current == NULL) {
			_tmp3_ = self->priv->_next != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (self->priv->current != NULL) {
			_tmp4_ = self->priv->current->next != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_iterator_real_first (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	self->priv->current = self->priv->_set->priv->_first;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = TRUE;
	result = self->priv->current != NULL;
	return result;
}


static gboolean gee_tree_set_iterator_real_previous (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current != NULL) {
		if (self->priv->current->prev != NULL) {
			self->priv->current = self->priv->current->prev;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		if (self->priv->_prev != NULL) {
			self->priv->current = self->priv->_prev;
			self->priv->_next = NULL;
			self->priv->_prev = NULL;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}


static gboolean gee_tree_set_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	if (self->priv->current == NULL) {
		_tmp1_ = self->priv->_prev != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current != NULL) {
			_tmp2_ = self->priv->current->prev != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_iterator_real_last (GeeBidirIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	self->priv->current = self->priv->_set->priv->_last;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = TRUE;
	result = self->priv->current != NULL;
	return result;
}


static gpointer gee_tree_set_iterator_real_get (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	g_assert (self->priv->current != NULL);
	result = (_tmp0_ = self->priv->current->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static void gee_tree_set_iterator_real_remove (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean success;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	g_assert (self->priv->current != NULL);
	success = gee_tree_set_remove_from_node (self->priv->_set, &self->priv->_set->priv->root, self->priv->current->key, &self->priv->_prev, &self->priv->_next);
	g_assert (success);
	if (self->priv->_set->priv->root != NULL) {
		self->priv->_set->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	self->priv->current = NULL;
	g_assert ((self->priv->stamp++) == (self->priv->_set->priv->stamp++));
}


static gboolean gee_tree_set_iterator_safe_next_get (GeeTreeSetIterator* self, gpointer* val) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		gpointer _tmp0_;
		*val = (_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->next), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp0_);
		result = self->priv->current->next != NULL;
		return result;
	} else {
		gpointer _tmp1_;
		*val = (_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_next), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp1_);
		result = self->priv->_next != NULL;
		return result;
	}
}


static gboolean gee_tree_set_iterator_safe_previous_get (GeeTreeSetIterator* self, gpointer* val) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current != NULL) {
		gpointer _tmp0_;
		*val = (_tmp0_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->current->prev), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp0_);
		result = self->priv->current->prev != NULL;
		return result;
	} else {
		gpointer _tmp1_;
		*val = (_tmp1_ = gee_tree_set_lift_null_get (self->priv->_set, self->priv->_prev), (((*val) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*val = (self->priv->g_destroy_func (*val), NULL)), _tmp1_);
		result = self->priv->_next != NULL;
		return result;
	}
}


static void gee_tree_set_iterator_class_init (GeeTreeSetIteratorClass * klass) {
	gee_tree_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_tree_set_iterator_real_next;
	iface->has_next = gee_tree_set_iterator_real_has_next;
	iface->first = gee_tree_set_iterator_real_first;
	iface->get = gee_tree_set_iterator_real_get;
	iface->remove = gee_tree_set_iterator_real_remove;
}


static void gee_tree_set_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_tree_set_iterator_real_previous;
	iface->has_previous = gee_tree_set_iterator_real_has_previous;
	iface->last = gee_tree_set_iterator_real_last;
}


static void gee_tree_set_iterator_instance_init (GeeTreeSetIterator * self) {
	self->priv = GEE_TREE_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->current = NULL;
	self->priv->_next = NULL;
	self->priv->_prev = NULL;
	self->priv->started = FALSE;
}


static void gee_tree_set_iterator_finalize (GObject* obj) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_tree_set_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_iterator_get_type (void) {
	static volatile gsize gee_tree_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetIterator), 0, (GInstanceInitFunc) gee_tree_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_iterator_type_id;
		gee_tree_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_iterator_type_id__volatile, gee_tree_set_iterator_type_id);
	}
	return gee_tree_set_iterator_type_id__volatile;
}


static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init (&_tmp1_, set, after, before), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	return gee_tree_set_sub_set_construct (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after, before);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init_head (&_tmp1_, set, before), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer before) {
	return gee_tree_set_sub_set_construct_head (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, before);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_tail (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_init_tail (&_tmp1_, set, after), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_tail (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, gconstpointer after) {
	return gee_tree_set_sub_set_construct_tail (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, after);
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_construct_from_range (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	GeeTreeSetSubSet * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	return self;
}


static GeeTreeSetSubSet* gee_tree_set_sub_set_new_from_range (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	return gee_tree_set_sub_set_construct_from_range (GEE_TREE_SET_TYPE_SUB_SET, g_type, g_dup_func, g_destroy_func, set, range);
}


static gboolean gee_tree_set_sub_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
		_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->set, item);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_sub_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
		_tmp0_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->set, item);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_sub_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (GeeTreeSetSubSet*) base;
	if (gee_tree_set_range_in_range (&self->priv->range, item)) {
		_tmp0_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->set, item);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void gee_tree_set_sub_set_real_clear (GeeAbstractCollection* base) {
	GeeTreeSetSubSet * self;
	GeeIterator* iter;
	self = (GeeTreeSetSubSet*) base;
	iter = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	while (TRUE) {
		if (!gee_iterator_next (iter)) {
			break;
		}
		gee_iterator_remove (iter);
	}
	_g_object_unref0 (iter);
}


static GeeIterator* gee_tree_set_sub_set_real_iterator (GeeAbstractCollection* base) {
	GeeTreeSetSubSet * self;
	GeeIterator* result = NULL;
	self = (GeeTreeSetSubSet*) base;
	result = (GeeIterator*) gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range);
	return result;
}


static GeeBidirIterator* gee_tree_set_sub_set_real_bidir_iterator (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	self = (GeeTreeSetSubSet*) base;
	result = (GeeBidirIterator*) gee_tree_set_sub_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range);
	return result;
}


static gpointer gee_tree_set_sub_set_real_first (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _first;
	gconstpointer _tmp0_;
	self = (GeeTreeSetSubSet*) base;
	_first = gee_tree_set_range_first (&self->priv->range);
	g_assert (_first != NULL);
	result = (_tmp0_ = _first->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static gpointer gee_tree_set_sub_set_real_last (GeeSortedSet* base) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	GeeTreeSetNode* _last;
	gconstpointer _tmp0_;
	self = (GeeTreeSetSubSet*) base;
	_last = gee_tree_set_range_last (&self->priv->range);
	g_assert (_last != NULL);
	result = (_tmp0_ = _last->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_head_set (GeeSortedSet* base, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut_tail (&self->priv->range, before, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_tail_set (GeeSortedSet* base, gconstpointer after) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut_head (&self->priv->range, after, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
	return result;
}


static GeeSortedSet* gee_tree_set_sub_set_real_sub_set (GeeSortedSet* base, gconstpointer after, gconstpointer before) {
	GeeTreeSetSubSet * self;
	GeeSortedSet* result = NULL;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_;
	GeeTreeSetRange _tmp0_ = {0};
	GeeSortedSet* _tmp3_;
	self = (GeeTreeSetSubSet*) base;
	result = (_tmp3_ = (GeeSortedSet*) gee_tree_set_sub_set_new_from_range (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, (_tmp2_ = _tmp1_ = (gee_tree_set_range_cut (&self->priv->range, after, before, &_tmp0_), _tmp0_), &_tmp2_)), gee_tree_set_range_destroy (&_tmp1_), _tmp3_);
	return result;
}


static GeeBidirIterator* gee_tree_set_sub_set_real_iterator_at (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	GeeBidirIterator* result = NULL;
	GeeTreeSetNode* n;
	self = (GeeTreeSetSubSet*) base;
	if (!gee_tree_set_range_in_range (&self->priv->range, item)) {
		result = NULL;
		return result;
	}
	n = gee_tree_set_find_node (self->priv->set, item);
	if (n == NULL) {
		result = NULL;
		return result;
	}
	result = (GeeBidirIterator*) gee_tree_set_sub_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, &self->priv->range, n);
	return result;
}


static gpointer gee_tree_set_sub_set_real_lower (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer l;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
	if (res > 0) {
		result = gee_sorted_set_last ((GeeSortedSet*) self);
		return result;
	}
	l = gee_sorted_set_lower ((GeeSortedSet*) self->priv->set, item);
	_tmp0_ = NULL;
	if (l != NULL) {
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, l);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = l;
	} else {
		_tmp0_ = NULL;
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
	return result;
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
}


static gpointer gee_tree_set_sub_set_real_higher (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer h;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
	if (res < 0) {
		result = gee_sorted_set_first ((GeeSortedSet*) self);
		return result;
	}
	h = gee_sorted_set_higher ((GeeSortedSet*) self->priv->set, item);
	_tmp0_ = NULL;
	if (h != NULL) {
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, h);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = h;
	} else {
		_tmp0_ = NULL;
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
	return result;
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
}


static gpointer gee_tree_set_sub_set_real_floor (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer l;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
	if (res > 0) {
		result = gee_sorted_set_last ((GeeSortedSet*) self);
		return result;
	}
	l = gee_sorted_set_floor ((GeeSortedSet*) self->priv->set, item);
	_tmp0_ = NULL;
	if (l != NULL) {
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, l);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = l;
	} else {
		_tmp0_ = NULL;
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
	return result;
	((l == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (l = (self->priv->g_destroy_func (l), NULL));
}


static gpointer gee_tree_set_sub_set_real_ceil (GeeSortedSet* base, gconstpointer item) {
	GeeTreeSetSubSet * self;
	gpointer result = NULL;
	gint res;
	gpointer h;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_;
	self = (GeeTreeSetSubSet*) base;
	res = gee_tree_set_range_compare_range (&self->priv->range, item);
	if (res < 0) {
		result = gee_sorted_set_first ((GeeSortedSet*) self);
		return result;
	}
	h = gee_sorted_set_ceil ((GeeSortedSet*) self->priv->set, item);
	_tmp0_ = NULL;
	if (h != NULL) {
		_tmp1_ = gee_tree_set_range_in_range (&self->priv->range, h);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = h;
	} else {
		_tmp0_ = NULL;
	}
	result = (_tmp2_ = _tmp0_, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_));
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
	return result;
	((h == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (h = (self->priv->g_destroy_func (h), NULL));
}


static gint gee_tree_set_sub_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSetSubSet* self;
	gint i;
	GeeIterator* iterator;
	self = (GeeTreeSetSubSet*) base;
	i = 0;
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	while (TRUE) {
		if (!gee_iterator_next (iterator)) {
			break;
		}
		i++;
	}
	result = i;
	_g_object_unref0 (iterator);
	return result;
}


static gboolean gee_tree_set_sub_set_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeTreeSetSubSet* self;
	self = (GeeTreeSetSubSet*) base;
	result = gee_tree_set_range_empty_subset (&self->priv->range);
	return result;
}


static void gee_tree_set_sub_set_class_init (GeeTreeSetSubSetClass * klass) {
	gee_tree_set_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_sub_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_sub_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_sub_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_sub_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_sub_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_sub_set_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_tree_set_sub_set_real_get_is_empty;
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_sub_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_sub_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_SET_IS_EMPTY, "is-empty");
}


static void gee_tree_set_sub_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_sub_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = gee_tree_set_sub_set_real_bidir_iterator;
	iface->first = gee_tree_set_sub_set_real_first;
	iface->last = gee_tree_set_sub_set_real_last;
	iface->head_set = gee_tree_set_sub_set_real_head_set;
	iface->tail_set = gee_tree_set_sub_set_real_tail_set;
	iface->sub_set = gee_tree_set_sub_set_real_sub_set;
	iface->iterator_at = gee_tree_set_sub_set_real_iterator_at;
	iface->lower = gee_tree_set_sub_set_real_lower;
	iface->higher = gee_tree_set_sub_set_real_higher;
	iface->floor = gee_tree_set_sub_set_real_floor;
	iface->ceil = gee_tree_set_sub_set_real_ceil;
}


static void gee_tree_set_sub_set_instance_init (GeeTreeSetSubSet * self) {
	self->priv = GEE_TREE_SET_SUB_SET_GET_PRIVATE (self);
}


static void gee_tree_set_sub_set_finalize (GObject* obj) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (obj);
	_g_object_unref0 (self->priv->set);
	gee_tree_set_range_destroy (&self->priv->range);
	G_OBJECT_CLASS (gee_tree_set_sub_set_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_set_get_type (void) {
	static volatile gsize gee_tree_set_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubSet), 0, (GInstanceInitFunc) gee_tree_set_sub_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_sub_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_set_type_id;
		gee_tree_set_sub_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSetSubSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_sub_set_type_id__volatile, gee_tree_set_sub_set_type_id);
	}
	return gee_tree_set_sub_set_type_id__volatile;
}


static void gee_tree_set_sub_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SUB_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_SUB_SET_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_sub_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubSet * self;
	self = GEE_TREE_SET_SUB_SET (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	GeeTreeSetSubIterator * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	return self;
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range) {
	return gee_tree_set_sub_iterator_construct (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range);
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_construct_pointing (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
	GeeTreeSetSubIterator * self;
	GeeTreeSet* _tmp0_;
	GeeTreeSetRange _tmp2_;
	GeeTreeSetRange _tmp1_ = {0};
	GeeTreeSetIterator* _tmp3_;
	g_return_val_if_fail (set != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	self = (GeeTreeSetSubIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 (self->priv->set), _tmp0_);
	self->priv->range = (_tmp2_ = (gee_tree_set_range_copy (range, &_tmp1_), _tmp1_), gee_tree_set_range_destroy (&self->priv->range), _tmp2_);
	self->priv->iterator = (_tmp3_ = gee_tree_set_iterator_new_pointing (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, set, node), _g_object_unref0 (self->priv->iterator), _tmp3_);
	return self;
}


static GeeTreeSetSubIterator* gee_tree_set_sub_iterator_new_pointing (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set, GeeTreeSetRange* range, GeeTreeSetNode* node) {
	return gee_tree_set_sub_iterator_construct_pointing (GEE_TREE_SET_TYPE_SUB_ITERATOR, g_type, g_dup_func, g_destroy_func, set, range, node);
}


static gboolean gee_tree_set_sub_iterator_real_next (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator != NULL) {
		gpointer next;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp3_;
		gboolean _tmp2_;
		gpointer _tmp1_ = NULL;
		next = NULL;
		if ((_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_), next = (_tmp3_ = _tmp1_, ((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL)), _tmp3_), _tmp2_)) {
			_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, next);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			g_assert (gee_iterator_next ((GeeIterator*) self->priv->iterator));
			result = TRUE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
			return result;
		} else {
			result = FALSE;
			((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
			return result;
		}
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
	} else {
		result = gee_iterator_first ((GeeIterator*) self);
		return result;
	}
}


static gboolean gee_tree_set_sub_iterator_real_has_next (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator != NULL) {
		gpointer next;
		gboolean _tmp0_ = FALSE;
		gpointer _tmp3_;
		gboolean _tmp2_;
		gpointer _tmp1_ = NULL;
		next = NULL;
		if ((_tmp2_ = gee_tree_set_iterator_safe_next_get (self->priv->iterator, &_tmp1_), next = (_tmp3_ = _tmp1_, ((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL)), _tmp3_), _tmp2_)) {
			_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, next);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		((next == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (next = (self->priv->g_destroy_func (next), NULL));
		return result;
	} else {
		result = gee_tree_set_range_first (&self->priv->range) != NULL;
		return result;
	}
}


static gboolean gee_tree_set_sub_iterator_real_first (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSetSubIterator*) base;
	node = gee_tree_set_range_first (&self->priv->range);
	if (node == NULL) {
		result = FALSE;
		return result;
	}
	self->priv->iterator = (_tmp0_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node), _g_object_unref0 (self->priv->iterator), _tmp0_);
	result = TRUE;
	return result;
}


static gboolean gee_tree_set_sub_iterator_real_previous (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp3_;
	gboolean _tmp2_;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator == NULL) {
		result = FALSE;
		return result;
	}
	prev = NULL;
	if ((_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_), prev = (_tmp3_ = _tmp1_, ((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL)), _tmp3_), _tmp2_)) {
		_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, prev);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_assert (gee_bidir_iterator_previous ((GeeBidirIterator*) self->priv->iterator));
		result = TRUE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
		return result;
	} else {
		result = FALSE;
		((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
		return result;
	}
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
}


static gboolean gee_tree_set_sub_iterator_real_has_previous (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	gpointer prev;
	gboolean _tmp0_ = FALSE;
	gpointer _tmp3_;
	gboolean _tmp2_;
	gpointer _tmp1_ = NULL;
	self = (GeeTreeSetSubIterator*) base;
	if (self->priv->iterator == NULL) {
		result = FALSE;
		return result;
	}
	prev = NULL;
	if ((_tmp2_ = gee_tree_set_iterator_safe_previous_get (self->priv->iterator, &_tmp1_), prev = (_tmp3_ = _tmp1_, ((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL)), _tmp3_), _tmp2_)) {
		_tmp0_ = gee_tree_set_range_in_range (&self->priv->range, prev);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	((prev == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (prev = (self->priv->g_destroy_func (prev), NULL));
	return result;
}


static gboolean gee_tree_set_sub_iterator_real_last (GeeBidirIterator* base) {
	GeeTreeSetSubIterator * self;
	gboolean result = FALSE;
	GeeTreeSetNode* node;
	GeeTreeSetIterator* _tmp0_;
	self = (GeeTreeSetSubIterator*) base;
	node = gee_tree_set_range_last (&self->priv->range);
	if (node == NULL) {
		result = FALSE;
		return result;
	}
	self->priv->iterator = (_tmp0_ = gee_tree_set_iterator_new_pointing (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self->priv->set, node), _g_object_unref0 (self->priv->iterator), _tmp0_);
	result = TRUE;
	return result;
}


static gpointer gee_tree_set_sub_iterator_real_get (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	gpointer result = NULL;
	self = (GeeTreeSetSubIterator*) base;
	g_assert (self->priv->iterator != NULL);
	result = gee_iterator_get ((GeeIterator*) self->priv->iterator);
	return result;
}


static void gee_tree_set_sub_iterator_real_remove (GeeIterator* base) {
	GeeTreeSetSubIterator * self;
	self = (GeeTreeSetSubIterator*) base;
	g_assert (self->priv->iterator != NULL);
	gee_iterator_remove ((GeeIterator*) self->priv->iterator);
}


static void gee_tree_set_sub_iterator_class_init (GeeTreeSetSubIteratorClass * klass) {
	gee_tree_set_sub_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetSubIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_sub_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_sub_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_sub_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_sub_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_tree_set_sub_iterator_real_next;
	iface->has_next = gee_tree_set_sub_iterator_real_has_next;
	iface->first = gee_tree_set_sub_iterator_real_first;
	iface->get = gee_tree_set_sub_iterator_real_get;
	iface->remove = gee_tree_set_sub_iterator_real_remove;
}


static void gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_tree_set_sub_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_tree_set_sub_iterator_real_previous;
	iface->has_previous = gee_tree_set_sub_iterator_real_has_previous;
	iface->last = gee_tree_set_sub_iterator_real_last;
}


static void gee_tree_set_sub_iterator_instance_init (GeeTreeSetSubIterator * self) {
	self->priv = GEE_TREE_SET_SUB_ITERATOR_GET_PRIVATE (self);
	self->priv->iterator = NULL;
}


static void gee_tree_set_sub_iterator_finalize (GObject* obj) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (obj);
	_g_object_unref0 (self->priv->set);
	gee_tree_set_range_destroy (&self->priv->range);
	_g_object_unref0 (self->priv->iterator);
	G_OBJECT_CLASS (gee_tree_set_sub_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_sub_iterator_get_type (void) {
	static volatile gsize gee_tree_set_sub_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_sub_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetSubIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_sub_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetSubIterator), 0, (GInstanceInitFunc) gee_tree_set_sub_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_tree_set_sub_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_sub_iterator_type_id;
		gee_tree_set_sub_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetSubIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_tree_set_sub_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&gee_tree_set_sub_iterator_type_id__volatile, gee_tree_set_sub_iterator_type_id);
	}
	return gee_tree_set_sub_iterator_type_id__volatile;
}


static void gee_tree_set_sub_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_sub_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetSubIterator * self;
	self = GEE_TREE_SET_SUB_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_SUB_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_tree_set_range_init (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after, gconstpointer before) {
	GeeTreeSet* _tmp0_;
	g_return_if_fail (set != NULL);
	memset (self, 0, sizeof (GeeTreeSetRange));
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
	if (gee_tree_set_get_compare_func (set) (after, before) < 0) {
		(*self).after = after;
		(*self).before = before;
		(*self).type = GEE_TREE_SET_RANGE_TYPE_BOUNDED;
	} else {
		(*self).type = GEE_TREE_SET_RANGE_TYPE_EMPTY;
	}
}


static void gee_tree_set_range_init_head (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer before) {
	GeeTreeSet* _tmp0_;
	g_return_if_fail (set != NULL);
	memset (self, 0, sizeof (GeeTreeSetRange));
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
	(*self).before = before;
	(*self).type = GEE_TREE_SET_RANGE_TYPE_HEAD;
}


static void gee_tree_set_range_init_tail (GeeTreeSetRange *self, GeeTreeSet* set, gconstpointer after) {
	GeeTreeSet* _tmp0_;
	g_return_if_fail (set != NULL);
	memset (self, 0, sizeof (GeeTreeSetRange));
	(*self).set = (_tmp0_ = _g_object_ref0 (set), _g_object_unref0 ((*self).set), _tmp0_);
	(*self).after = after;
	(*self).type = GEE_TREE_SET_RANGE_TYPE_TAIL;
}


static void gee_tree_set_range_cut_head (GeeTreeSetRange *self, gconstpointer after, GeeTreeSetRange* result) {
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			GeeTreeSetRange _tmp0_ = {0};
			*result = (gee_tree_set_range_init (&_tmp0_, (*self).set, after, (*self).before), _tmp0_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			GeeTreeSetRange _tmp1_ = {0};
			*result = (gee_tree_set_range_init_tail (&_tmp1_, (*self).set, gee_tree_set_max ((*self).set, after, (*self).after)), _tmp1_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange _tmp2_ = {0};
			*result = (gee_tree_set_range_copy (&(*self), &_tmp2_), _tmp2_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _after;
			GeeTreeSetRange _tmp3_ = {0};
			_after = gee_tree_set_max ((*self).set, after, (*self).after);
			*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, _after, (*self).before), _tmp3_);
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void gee_tree_set_range_cut_tail (GeeTreeSetRange *self, gconstpointer before, GeeTreeSetRange* result) {
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			GeeTreeSetRange _tmp0_ = {0};
			*result = (gee_tree_set_range_init_head (&_tmp0_, (*self).set, gee_tree_set_min ((*self).set, before, (*self).before)), _tmp0_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			GeeTreeSetRange _tmp1_ = {0};
			*result = (gee_tree_set_range_init (&_tmp1_, (*self).set, (*self).after, before), _tmp1_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			GeeTreeSetRange _tmp2_ = {0};
			*result = (gee_tree_set_range_copy (&(*self), &_tmp2_), _tmp2_);
			return;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gpointer _before;
			GeeTreeSetRange _tmp3_ = {0};
			_before = gee_tree_set_min ((*self).set, before, (*self).before);
			*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, (*self).after, _before), _tmp3_);
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void gee_tree_set_range_cut (GeeTreeSetRange *self, gconstpointer after, gconstpointer before, GeeTreeSetRange* result) {
	gpointer _tmp1_;
	gpointer _before;
	gpointer _tmp2_;
	gpointer _after;
	GeeTreeSetRange _tmp3_ = {0};
	if ((*self).type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
		GeeTreeSetRange _tmp0_ = {0};
		*result = (gee_tree_set_range_copy (&(*self), &_tmp0_), _tmp0_);
		return;
	}
	_tmp1_ = NULL;
	if ((*self).type != GEE_TREE_SET_RANGE_TYPE_TAIL) {
		_tmp1_ = gee_tree_set_min ((*self).set, before, (*self).before);
	} else {
		_tmp1_ = before;
	}
	_before = _tmp1_;
	_tmp2_ = NULL;
	if ((*self).type != GEE_TREE_SET_RANGE_TYPE_HEAD) {
		_tmp2_ = gee_tree_set_max ((*self).set, after, (*self).after);
	} else {
		_tmp2_ = after;
	}
	_after = _tmp2_;
	*result = (gee_tree_set_range_init (&_tmp3_, (*self).set, _after, _before), _tmp3_);
	return;
}


static gboolean gee_tree_set_range_in_range (GeeTreeSetRange *self, gconstpointer item) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if ((*self).type == GEE_TREE_SET_RANGE_TYPE_EMPTY) {
		_tmp0_ = FALSE;
	} else {
		_tmp0_ = gee_tree_set_range_compare_range (&(*self), item) == 0;
	}
	result = _tmp0_;
	return result;
}


static gint gee_tree_set_range_compare_range (GeeTreeSetRange *self, gconstpointer item) {
	gint result = 0;
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gint _tmp0_ = 0;
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).before) < 0) {
				_tmp0_ = 0;
			} else {
				_tmp0_ = 1;
			}
			result = _tmp0_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gint _tmp1_ = 0;
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).after) >= 0) {
				_tmp1_ = 0;
			} else {
				_tmp1_ = -1;
			}
			result = _tmp1_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = 0;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			gint _tmp2_ = 0;
			if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).after) >= 0) {
				gint _tmp3_ = 0;
				if (gee_tree_set_get_compare_func ((*self).set) (item, (*self).before) < 0) {
					_tmp3_ = 0;
				} else {
					_tmp3_ = 1;
				}
				_tmp2_ = _tmp3_;
			} else {
				_tmp2_ = -1;
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gboolean gee_tree_set_range_empty_subset (GeeTreeSetRange *self) {
	gboolean result = FALSE;
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			gboolean _tmp0_ = FALSE;
			if ((*self).set->priv->_first == NULL) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = !gee_tree_set_range_in_range (&(*self), (*self).set->priv->_first->key);
			}
			result = _tmp0_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			gboolean _tmp1_ = FALSE;
			if ((*self).set->priv->_last == NULL) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !gee_tree_set_range_in_range (&(*self), (*self).set->priv->_last->key);
			}
			result = _tmp1_;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = TRUE;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_BOUNDED:
		{
			result = gee_tree_set_range_first (&(*self)) == NULL;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GeeTreeSetNode* gee_tree_set_range_first (GeeTreeSetRange *self) {
	GeeTreeSetNode* result = NULL;
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_HEAD:
		{
			result = (*self).set->priv->_first;
			return result;
		}
		default:
		{
			result = gee_tree_set_find_floor ((*self).set, (*self).after);
			return result;
		}
	}
}


static GeeTreeSetNode* gee_tree_set_range_last (GeeTreeSetRange *self) {
	GeeTreeSetNode* result = NULL;
	switch ((*self).type) {
		case GEE_TREE_SET_RANGE_TYPE_EMPTY:
		{
			result = NULL;
			return result;
		}
		case GEE_TREE_SET_RANGE_TYPE_TAIL:
		{
			result = (*self).set->priv->_last;
			return result;
		}
		default:
		{
			result = gee_tree_set_find_lower ((*self).set, (*self).before);
			return result;
		}
	}
}


static void gee_tree_set_range_copy (const GeeTreeSetRange* self, GeeTreeSetRange* dest) {
	dest->set = _g_object_ref0 (self->set);
	dest->after = self->after;
	dest->before = self->before;
	dest->type = self->type;
}


static void gee_tree_set_range_destroy (GeeTreeSetRange* self) {
	_g_object_unref0 (self->set);
}


static GeeTreeSetRange* gee_tree_set_range_dup (const GeeTreeSetRange* self) {
	GeeTreeSetRange* dup;
	dup = g_new0 (GeeTreeSetRange, 1);
	gee_tree_set_range_copy (self, dup);
	return dup;
}


static void gee_tree_set_range_free (GeeTreeSetRange* self) {
	gee_tree_set_range_destroy (self);
	g_free (self);
}


static GType gee_tree_set_range_get_type (void) {
	static volatile gsize gee_tree_set_range_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_range_type_id__volatile)) {
		GType gee_tree_set_range_type_id;
		gee_tree_set_range_type_id = g_boxed_type_register_static ("GeeTreeSetRange", (GBoxedCopyFunc) gee_tree_set_range_dup, (GBoxedFreeFunc) gee_tree_set_range_free);
		g_once_init_leave (&gee_tree_set_range_type_id__volatile, gee_tree_set_range_type_id);
	}
	return gee_tree_set_range_type_id__volatile;
}


static void gee_tree_set_class_init (GeeTreeSetClass * klass) {
	gee_tree_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SIZE, "size");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_tree_set_gee_sorted_set_interface_init (GeeSortedSetIface * iface) {
	gee_tree_set_gee_sorted_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->bidir_iterator = gee_tree_set_real_bidir_iterator;
	iface->first = gee_tree_set_real_first;
	iface->last = gee_tree_set_real_last;
	iface->head_set = gee_tree_set_real_head_set;
	iface->tail_set = gee_tree_set_real_tail_set;
	iface->sub_set = gee_tree_set_real_sub_set;
	iface->iterator_at = gee_tree_set_real_iterator_at;
	iface->lower = gee_tree_set_real_lower;
	iface->higher = gee_tree_set_real_higher;
	iface->floor = gee_tree_set_real_floor;
	iface->ceil = gee_tree_set_real_ceil;
}


static void gee_tree_set_instance_init (GeeTreeSet * self) {
	self->priv = GEE_TREE_SET_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->root = NULL;
	self->priv->_first = NULL;
	self->priv->_last = NULL;
	self->priv->stamp = 0;
}


static void gee_tree_set_finalize (GObject* obj) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (obj);
	_gee_tree_set_node_free0 (self->priv->root);
	G_OBJECT_CLASS (gee_tree_set_parent_class)->finalize (obj);
}


GType gee_tree_set_get_type (void) {
	static volatile gsize gee_tree_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tree_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSet), 0, (GInstanceInitFunc) gee_tree_set_instance_init, NULL };
		static const GInterfaceInfo gee_sorted_set_info = { (GInterfaceInitFunc) gee_tree_set_gee_sorted_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_tree_set_type_id;
		gee_tree_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeTreeSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_type_id, GEE_TYPE_SORTED_SET, &gee_sorted_set_info);
		g_once_init_leave (&gee_tree_set_type_id__volatile, gee_tree_set_type_id);
	}
	return gee_tree_set_type_id__volatile;
}


static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_COMPARE_FUNC:
		g_value_set_pointer (value, gee_tree_set_get_compare_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_COMPARE_FUNC:
		gee_tree_set_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




