/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Signal;
import gnu.kawa.swingviews.SwingContent;
import gnu.lists.CharBuffer;

public class BufferContent
extends SwingContent {
    public BufferContent() {
        this(100);
    }

    public BufferContent(int initialSize) {
        super(initialSize);
    }

    public static int indexOf(char[] buffer, int start, int limit, char ch) {
        for (int i = start; i < limit; ++i) {
            if (buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] buffer, int start, int limit, char ch) {
        for (int i = start; i >= limit; --i) {
            if (buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public final long scan(char target, int start, int end, int count, boolean allowQuit) {
        int limit;
        CharBuffer b = this.buffer;
        int n = limit = end > b.gapStart ? end + b.gapEnd - b.gapStart : end;
        if (start > b.gapStart) {
            start += b.gapEnd - b.gapStart;
        }
        if (count > 0) {
            while (start < limit && count > 0) {
                int i;
                if (start == b.gapStart) {
                    start = b.gapEnd;
                }
                int ceil = start < b.gapStart && limit > b.gapStart ? b.gapStart : limit;
                if (allowQuit) {
                    if (ceil - start > 5000) {
                        ceil = start + 5000;
                    }
                    Signal.checkQuit();
                }
                if ((i = BufferContent.indexOf(b.getArray(), start, ceil, target)) >= 0) {
                    --count;
                    start = i + 1;
                    continue;
                }
                start = ceil;
            }
            if (start > b.gapEnd) {
                start -= b.gapEnd - b.gapStart;
            }
            return (long)count << 32 | (long)start;
        }
        while (start > limit && count < 0) {
            int i;
            if (start == b.gapEnd) {
                start = b.gapStart;
            }
            int floor = start <= b.gapStart || limit >= b.gapEnd ? limit : b.gapEnd;
            if (allowQuit) {
                if (start - floor > 5000) {
                    floor = start - 5000;
                }
                Signal.checkQuit();
            }
            if ((i = BufferContent.lastIndexOf(b.getArray(), start - 1, floor, target)) >= 0) {
                ++count;
                start = i;
                continue;
            }
            start = floor;
        }
        if (start >= b.gapEnd) {
            start -= b.gapEnd - b.gapStart;
        }
        if (count != 0) {
            return (long)(-count) << 32 | (long)start;
        }
        return start + 1;
    }
}

