/* MainWindow.c generated by valac, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <config.h>


#define MOSERIAL_TYPE_MAIN_WINDOW (moserial_main_window_get_type ())
#define MOSERIAL_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindow))
#define MOSERIAL_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))
#define MOSERIAL_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_MAIN_WINDOW))
#define MOSERIAL_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowClass))

typedef struct _moserialMainWindow moserialMainWindow;
typedef struct _moserialMainWindowClass moserialMainWindowClass;
typedef struct _moserialMainWindowPrivate moserialMainWindowPrivate;

#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;

#define TYPE_DEFAULT_PATHS (default_paths_get_type ())
#define DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_PATHS, DefaultPaths))
#define DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_PATHS, DefaultPathsClass))
#define IS_DEFAULT_PATHS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_PATHS))
#define IS_DEFAULT_PATHS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_PATHS))
#define DEFAULT_PATHS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_PATHS, DefaultPathsClass))

typedef struct _DefaultPaths DefaultPaths;
typedef struct _DefaultPathsClass DefaultPathsClass;

#define MOSERIAL_TYPE_SEND_PROGRESS_DIALOG (moserial_send_progress_dialog_get_type ())
#define MOSERIAL_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialog))
#define MOSERIAL_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_IS_SEND_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG))
#define MOSERIAL_SEND_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, moserialSendProgressDialogClass))

typedef struct _moserialSendProgressDialog moserialSendProgressDialog;
typedef struct _moserialSendProgressDialogClass moserialSendProgressDialogClass;

#define MOSERIAL_TYPE_SEND_CHOOSER_DIALOG (moserial_send_chooser_dialog_get_type ())
#define MOSERIAL_SEND_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialog))
#define MOSERIAL_SEND_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialogClass))
#define MOSERIAL_IS_SEND_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG))
#define MOSERIAL_IS_SEND_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG))
#define MOSERIAL_SEND_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SEND_CHOOSER_DIALOG, moserialSendChooserDialogClass))

typedef struct _moserialSendChooserDialog moserialSendChooserDialog;
typedef struct _moserialSendChooserDialogClass moserialSendChooserDialogClass;

#define MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG (moserial_receive_progress_dialog_get_type ())
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialog))
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialogClass))
#define MOSERIAL_IS_RECEIVE_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG))
#define MOSERIAL_IS_RECEIVE_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG))
#define MOSERIAL_RECEIVE_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, moserialReceiveProgressDialogClass))

typedef struct _moserialReceiveProgressDialog moserialReceiveProgressDialog;
typedef struct _moserialReceiveProgressDialogClass moserialReceiveProgressDialogClass;

#define MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG (moserial_receive_chooser_dialog_get_type ())
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialog))
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialogClass))
#define MOSERIAL_IS_RECEIVE_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG))
#define MOSERIAL_IS_RECEIVE_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG))
#define MOSERIAL_RECEIVE_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECEIVE_CHOOSER_DIALOG, moserialReceiveChooserDialogClass))

typedef struct _moserialReceiveChooserDialog moserialReceiveChooserDialog;
typedef struct _moserialReceiveChooserDialogClass moserialReceiveChooserDialogClass;

#define MOSERIAL_TYPE_RECORD_DIALOG (moserial_record_dialog_get_type ())
#define MOSERIAL_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialog))
#define MOSERIAL_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))
#define MOSERIAL_IS_RECORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_IS_RECORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RECORD_DIALOG))
#define MOSERIAL_RECORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RECORD_DIALOG, moserialRecordDialogClass))

typedef struct _moserialRecordDialog moserialRecordDialog;
typedef struct _moserialRecordDialogClass moserialRecordDialogClass;

#define MOSERIAL_TYPE_PREFERENCES_DIALOG (moserial_preferences_dialog_get_type ())
#define MOSERIAL_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialog))
#define MOSERIAL_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))
#define MOSERIAL_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_PREFERENCES_DIALOG))
#define MOSERIAL_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_PREFERENCES_DIALOG, moserialPreferencesDialogClass))

typedef struct _moserialPreferencesDialog moserialPreferencesDialog;
typedef struct _moserialPreferencesDialogClass moserialPreferencesDialogClass;

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;

#define MOSERIAL_TYPE_HEX_TEXT_BUFFER (moserial_hex_text_buffer_get_type ())
#define MOSERIAL_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBuffer))
#define MOSERIAL_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))
#define MOSERIAL_IS_HEX_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_IS_HEX_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_HEX_TEXT_BUFFER))
#define MOSERIAL_HEX_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_HEX_TEXT_BUFFER, moserialHexTextBufferClass))

typedef struct _moserialHexTextBuffer moserialHexTextBuffer;
typedef struct _moserialHexTextBufferClass moserialHexTextBufferClass;

#define MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG (moserial_xmodem_filename_dialog_get_type ())
#define MOSERIAL_XMODEM_FILENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialog))
#define MOSERIAL_XMODEM_FILENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialogClass))
#define MOSERIAL_IS_XMODEM_FILENAME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG))
#define MOSERIAL_IS_XMODEM_FILENAME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG))
#define MOSERIAL_XMODEM_FILENAME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_XMODEM_FILENAME_DIALOG, moserialXmodemFilenameDialogClass))

typedef struct _moserialXmodemFilenameDialog moserialXmodemFilenameDialog;
typedef struct _moserialXmodemFilenameDialogClass moserialXmodemFilenameDialogClass;

#define MOSERIAL_TYPE_SERIAL_STREAM_RECORDER (moserial_serial_stream_recorder_get_type ())
#define MOSERIAL_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorder))
#define MOSERIAL_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_IS_SERIAL_STREAM_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER))
#define MOSERIAL_SERIAL_STREAM_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_STREAM_RECORDER, moserialSerialStreamRecorderClass))

typedef struct _moserialSerialStreamRecorder moserialSerialStreamRecorder;
typedef struct _moserialSerialStreamRecorderClass moserialSerialStreamRecorderClass;

#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;

#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _moserial_serial_stream_recorder_unref0(var) ((var == NULL) ? NULL : (var = (moserial_serial_stream_recorder_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())
typedef struct _moserialSendChooserDialogPrivate moserialSendChooserDialogPrivate;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;
typedef struct _moserialReceiveChooserDialogPrivate moserialReceiveChooserDialogPrivate;
typedef struct _moserialXmodemFilenameDialogPrivate moserialXmodemFilenameDialogPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_SERIAL_STREAM_RECORDER_TYPE_DIRECTION (moserial_serial_stream_recorder_direction_get_type ())
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _moserialMainWindow {
	GtkWindow parent_instance;
	moserialMainWindowPrivate * priv;
};

struct _moserialMainWindowClass {
	GtkWindowClass parent_class;
};

struct _moserialMainWindowPrivate {
	GtkBuilder* _builder;
	GtkWindow* gtkWindow;
	moserialSettingsDialog* settingsDialog;
	GtkToolButton* settingsButton;
	GtkToggleToolButton* recordButton;
	Settings* currentSettings;
	Preferences* currentPreferences;
	DefaultPaths* currentPaths;
	GtkStatusbar* statusbar;
	GtkStatusbar* bytecountbar;
	guint statusbarContext;
	guint bytecountbarContext;
	GtkToolButton* send;
	moserialSendProgressDialog* sendProgressDialog;
	moserialSendChooserDialog* sendChooserDialog;
	GtkToolButton* receive;
	moserialReceiveProgressDialog* receiveProgressDialog;
	moserialReceiveChooserDialog* receiveChooserDialog;
	moserialRecordDialog* recordDialog;
	moserialPreferencesDialog* preferencesDialog;
	moserialSerialConnection* serialConnection;
	GtkTextView* incomingHexTextView;
	GtkTextView* incomingAsciiTextView;
	GtkTextView* outgoingHexTextView;
	GtkTextView* outgoingAsciiTextView;
	GtkComboBox* inputMode;
	GtkComboBox* terminationMode;
	GtkToggleToolButton* connectButton;
	GtkLabel* disconnectLabel;
	GtkLabel* connectLabel;
	GtkLabel* recordLabel;
	GtkLabel* stopRecordingLabel;
	GtkPaned* paned;
	GtkNotebook* incoming_notebook;
	GtkNotebook* outgoing_notebook;
	moserialHexTextBuffer* incomingHexTextBuffer;
	moserialHexTextBuffer* outgoingHexTextBuffer;
	GtkTextBuffer* incomingAsciiTextBuffer;
	GtkTextTag* echoTag;
	GtkTextBuffer* outgoingAsciiTextBuffer;
	GtkTextMark* echoStartMark;
	moserialXmodemFilenameDialog* xmodemFilenameDialog;
	GtkEntry* entry;
	GtkButton* sendButton;
	moserialSerialStreamRecorder* streamRecorder;
	gboolean recordDataReceived;
	guint recordTimeoutID;
	moserialRzwrapper* rz;
	moserialSzwrapper* sz;
	Profile* profile;
	char* _startupProfileFilename;
	char* profileFilename;
	gboolean profileChanged;
	GtkAction* cutMenuItem;
	GtkAction* copyMenuItem;
	GtkAdjustment* va1;
	GtkAdjustment* va2;
	GtkAdjustment* va3;
	GtkAdjustment* va4;
};

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	char* echoReference;
	char* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

struct _moserialSendChooserDialog {
	GObject parent_instance;
	moserialSendChooserDialogPrivate * priv;
	GtkComboBox* protocolCombo;
	char* filename;
};

struct _moserialSendChooserDialogClass {
	GObjectClass parent_class;
};

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

struct _moserialReceiveChooserDialog {
	GObject parent_instance;
	moserialReceiveChooserDialogPrivate * priv;
	GtkComboBox* protocolCombo;
	char* path;
};

struct _moserialReceiveChooserDialogClass {
	GObjectClass parent_class;
};

struct _moserialXmodemFilenameDialog {
	GObject parent_instance;
	moserialXmodemFilenameDialogPrivate * priv;
	char* filename;
};

struct _moserialXmodemFilenameDialogClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_INCOMING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_OUTGOING,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_BOTH,
	MOSERIAL_SERIAL_STREAM_RECORDER_DIRECTION_NULL
} moserialSerialStreamRecorderDirection;


static gpointer moserial_main_window_parent_class = NULL;

GType moserial_main_window_get_type (void);
GType moserial_settings_dialog_get_type (void);
GType settings_get_type (void);
GType preferences_get_type (void);
GType default_paths_get_type (void);
GType moserial_send_progress_dialog_get_type (void);
GType moserial_send_chooser_dialog_get_type (void);
GType moserial_receive_progress_dialog_get_type (void);
GType moserial_receive_chooser_dialog_get_type (void);
GType moserial_record_dialog_get_type (void);
GType moserial_preferences_dialog_get_type (void);
GType moserial_serial_connection_get_type (void);
GType moserial_hex_text_buffer_get_type (void);
GType moserial_xmodem_filename_dialog_get_type (void);
gpointer moserial_serial_stream_recorder_ref (gpointer instance);
void moserial_serial_stream_recorder_unref (gpointer instance);
GParamSpec* moserial_param_spec_serial_stream_recorder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void moserial_value_set_serial_stream_recorder (GValue* value, gpointer v_object);
gpointer moserial_value_get_serial_stream_recorder (const GValue* value);
GType moserial_serial_stream_recorder_get_type (void);
GType moserial_rzwrapper_get_type (void);
GType moserial_szwrapper_get_type (void);
GType profile_get_type (void);
#define MOSERIAL_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowPrivate))
enum  {
	MOSERIAL_MAIN_WINDOW_DUMMY_PROPERTY,
	MOSERIAL_MAIN_WINDOW_BUILDER,
	MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME
};
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_new (void);
moserialSerialStreamRecorder* moserial_serial_stream_recorder_construct (GType object_type);
#define MOSERIAL_MAIN_WINDOW_translators N_ ("translator-credits")
static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value);
static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value);
moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename);
moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename);
gboolean profile_load (Profile* self, const char* filename, GtkWindow* window);
void moserial_main_window_ensureDisconnected (moserialMainWindow* self);
Settings* settings_loadFromProfile (Profile* profile);
Preferences* preferences_loadFromProfile (Profile* profile);
DefaultPaths* default_paths_loadFromProfile (Profile* profile);
static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences);
char* settings_getStatusbarString (Settings* self, gboolean open);
static void moserial_main_window_setWindowTitle (moserialMainWindow* self, const char* recordingFilename);
static void moserial_main_window_applyProfile (moserialMainWindow* self, const char* filename);
static void moserial_main_window_recentItemOpen (moserialMainWindow* self, GtkRecentChooser* r);
static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s);
gboolean moserial_main_window_ensureConnected (moserialMainWindow* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_stream_recorder_writeOutgoing (moserialSerialStreamRecorder* self, guchar data);
void moserial_hex_text_buffer_add (moserialHexTextBuffer* self, guchar data);
char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e);
GQuark hex_parse_error_quark (void);
guchar* input_parser_parseHex (const char* s, int* result_length1, GError** error);
char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w);
void moserial_send_chooser_dialog_show (moserialSendChooserDialog* self, const char* folder);
const char* default_paths_get_sendFrom (DefaultPaths* self);
static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button);
GType moserial_szwrapper_protocol_get_type (void);
char* mo_utils_getParentFolder (const char* path);
void default_paths_set_sendFrom (DefaultPaths* self, const char* value);
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* filename);
void moserial_send_progress_dialog_show (moserialSendProgressDialog* self);
void moserial_send_progress_dialog_updateStatus (moserialSendProgressDialog* self, GObject* o, const char* newStatus);
static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self);
void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o);
static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self);
static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog);
gboolean moserial_send_progress_dialog_hide (moserialSendProgressDialog* self);
void moserial_receive_chooser_dialog_show (moserialReceiveChooserDialog* self, const char* folder);
const char* default_paths_get_receiveTo (DefaultPaths* self);
static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button);
void default_paths_set_receiveTo (DefaultPaths* self, const char* value);
void moserial_xmodem_filename_dialog_show (moserialXmodemFilenameDialog* self);
GType moserial_rzwrapper_protocol_get_type (void);
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const char* p, const char* filename);
void moserial_receive_progress_dialog_show (moserialReceiveProgressDialog* self);
void moserial_receive_progress_dialog_updateStatus (moserialReceiveProgressDialog* self, GObject* o, const char* newStatus);
static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self);
void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o);
static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self);
static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog);
gboolean moserial_receive_progress_dialog_hide (moserialReceiveProgressDialog* self);
void moserial_record_dialog_show (moserialRecordDialog* self, const char* folder);
const char* default_paths_get_recordTo (DefaultPaths* self);
void moserial_serial_stream_recorder_close (moserialSerialStreamRecorder* self, gboolean launch);
gboolean preferences_get_recordLaunch (Preferences* self);
void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button);
void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog);
GType moserial_serial_stream_recorder_direction_get_type (void);
void moserial_serial_stream_recorder_open (moserialSerialStreamRecorder* self, const char* filename, moserialSerialStreamRecorderDirection direction, GError** error);
void default_paths_set_recordTo (DefaultPaths* self, const char* value);
void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction);
gboolean moserial_main_window_recordTimeout (moserialMainWindow* self);
void moserial_main_window_showWindow (moserialMainWindow* self);
static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings);
gboolean preferences_get_useSystemMonospaceFont (Preferences* self);
char* preferences_getSystemDefaultMonospaceFont (void);
const char* preferences_get_font (Preferences* self);
void preferences_getGdkColor (const char* color, GdkColor* result);
const char* preferences_get_fontColor (Preferences* self);
const char* preferences_get_backgroundColor (Preferences* self);
const char* preferences_get_highlightColor (Preferences* self);
void moserial_hex_text_buffer_applyPreferences (moserialHexTextBuffer* self, Preferences* preferences);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o);
void moserial_preferences_dialog_show (moserialPreferencesDialog* self, Preferences* preferences, gboolean recording);
static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o);
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
const char* settings_get_device (Settings* self);
void moserial_hex_text_buffer_clear (moserialHexTextBuffer* self);
static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size);
static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self);
static gboolean moserial_main_window_startConnection (moserialMainWindow* self);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
static void moserial_main_window_connectButtonClick (moserialMainWindow* self, GtkToggleToolButton* button);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
gboolean preferences_get_enableTimeout (Preferences* self);
gint preferences_get_timeout (Preferences* self);
static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self);
void moserial_serial_stream_recorder_writeIncoming (moserialSerialStreamRecorder* self, guchar data);
static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode);
static void moserial_main_window_showHelp (moserialMainWindow* self);
static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button);
static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link);
static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void moserial_main_window_showAboutDialog (moserialMainWindow* self);
static void moserial_main_window_windowSizeSave (moserialMainWindow* self);
static void moserial_main_window_quitSave (moserialMainWindow* self);
static void moserial_main_window_quitSizeSave (moserialMainWindow* self);
static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, GdkEvent* event);
void moserial_auto_scroll_scroll (GtkAdjustment* va);
static gboolean moserial_main_window_keyPress (moserialMainWindow* self, GtkWidget* widget, GdkEventKey* key);
void profile_saveWindowSize (Profile* self, gint w, gint h);
void profile_saveWindowPanedPosition (Profile* self, gint pos);
void preferences_saveToProfile (Preferences* self, Profile* profile);
void settings_saveToProfile (Settings* self, Profile* profile);
void default_paths_saveToProfile (DefaultPaths* self, Profile* profile);
static void moserial_main_window_saveProfile (moserialMainWindow* self);
void profile_save (Profile* self, const char* filename, GtkWindow* window);
static void moserial_main_window_saveProfileAs (moserialMainWindow* self);
static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename);
static void moserial_main_window_loadProfile (moserialMainWindow* self);
static void moserial_main_window_copy (moserialMainWindow* self);
static void moserial_main_window_cut (moserialMainWindow* self);
static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_paste (moserialMainWindow* self);
static void moserial_main_window_clear (moserialMainWindow* self);
GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self);
const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self);
static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, GdkEvent* event, gpointer self);
static gboolean _moserial_main_window_keyPress_gtk_widget_key_press_event (GtkWindow* _sender, GdkEventKey* event, gpointer self);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
gint profile_getWindowWidth (Profile* self);
gint profile_getWindowHeight (Profile* self);
gint profile_getWindowPanedPosition (Profile* self);
static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self);
static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialSendProgressDialog* moserial_send_progress_dialog_new (GtkBuilder* builder);
moserialSendProgressDialog* moserial_send_progress_dialog_construct (GType object_type, GtkBuilder* builder);
moserialSendChooserDialog* moserial_send_chooser_dialog_new (GtkBuilder* builder);
moserialSendChooserDialog* moserial_send_chooser_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self);
moserialReceiveProgressDialog* moserial_receive_progress_dialog_new (GtkBuilder* builder);
moserialReceiveProgressDialog* moserial_receive_progress_dialog_construct (GType object_type, GtkBuilder* builder);
moserialReceiveChooserDialog* moserial_receive_chooser_dialog_new (GtkBuilder* builder);
moserialReceiveChooserDialog* moserial_receive_chooser_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self);
moserialXmodemFilenameDialog* moserial_xmodem_filename_dialog_new (GtkBuilder* builder);
moserialXmodemFilenameDialog* moserial_xmodem_filename_dialog_construct (GType object_type, GtkBuilder* builder);
moserialRecordDialog* moserial_record_dialog_new (GtkBuilder* builder);
moserialRecordDialog* moserial_record_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self);
static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self);
moserialPreferencesDialog* moserial_preferences_dialog_new (GtkBuilder* builder);
moserialPreferencesDialog* moserial_preferences_dialog_construct (GType object_type, GtkBuilder* builder);
static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self);
static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_connectButtonClick_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self);
moserialHexTextBuffer* moserial_hex_text_buffer_new (void);
moserialHexTextBuffer* moserial_hex_text_buffer_construct (GType object_type);
void moserial_auto_scroll_setup (GtkAdjustment* incomingAsciiVerticalAdjuster, GtkAdjustment* incomingHexVerticalAdjuster, GtkAdjustment* outgoingAsciiVerticalAdjuster, GtkAdjustment* outgoingHexVerticalAdjuster);
static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated (GtkRecentChooserMenu* _sender, gpointer self);
static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void moserial_main_window_finalize (GObject* obj);
static void moserial_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void moserial_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* MOSERIAL_MAIN_WINDOW_authors[] = {"Michael J. Chudobiak <mjc@svn.gnome.org>", "marlodavampire", NULL};
static const char* MOSERIAL_MAIN_WINDOW_license[] = {N_ ("moserial is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n"), N_ ("moserial is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n"), N_ ("You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.")};


moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename) {
	GParameter * __params;
	GParameter * __params_it;
	moserialMainWindow * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	__params_it->name = "startupProfileFilename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, profileFilename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename) {
	return moserial_main_window_construct (MOSERIAL_TYPE_MAIN_WINDOW, builder, profileFilename);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_main_window_applyProfile (moserialMainWindow* self, const char* filename) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_inner_error_ = NULL;
	if (profile_load (self->priv->profile, filename, self->priv->gtkWindow)) {
		char* _tmp0_;
		Settings* _tmp1_;
		Preferences* _tmp2_;
		DefaultPaths* _tmp3_;
		char* _tmp4_;
		GtkRecentManager* recentManager;
		char* _tmp5_;
		char* _tmp6_;
		self->priv->profileFilename = (_tmp0_ = g_strdup (filename), _g_free0 (self->priv->profileFilename), _tmp0_);
		moserial_main_window_ensureDisconnected (self);
		self->priv->currentSettings = (_tmp1_ = settings_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentSettings), _tmp1_);
		self->priv->currentPreferences = (_tmp2_ = preferences_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentPreferences), _tmp2_);
		self->priv->currentPaths = (_tmp3_ = default_paths_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentPaths), _tmp3_);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp4_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_g_free0 (_tmp4_);
		moserial_main_window_setWindowTitle (self, NULL);
		self->priv->profileChanged = FALSE;
		recentManager = _g_object_ref0 (gtk_recent_manager_get_default ());
		_tmp5_ = g_filename_to_uri (filename, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (recentManager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		gtk_recent_manager_add_item (recentManager, _tmp6_ = _tmp5_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (recentManager);
	}
}


static void moserial_main_window_setWindowTitle (moserialMainWindow* self, const char* recordingFilename) {
	GString* builder;
	g_return_if_fail (self != NULL);
	builder = g_string_new ("");
	g_string_append (builder, "moserial");
	if (self->priv->profileFilename != NULL) {
		char* _tmp0_;
		g_string_append (builder, " - ");
		g_string_append (builder, _tmp0_ = g_path_get_basename (self->priv->profileFilename));
		_g_free0 (_tmp0_);
	}
	if (recordingFilename != NULL) {
		char* _tmp1_;
		g_string_append (builder, " - ");
		g_string_append (builder, _tmp1_ = g_path_get_basename (recordingFilename));
		_g_free0 (_tmp1_);
	}
	gtk_window_set_title (self->priv->gtkWindow, builder->str);
	_g_string_free0 (builder);
}


static void moserial_main_window_recentItemOpen (moserialMainWindow* self, GtkRecentChooser* r) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_inner_error_ = NULL;
	_tmp0_ = g_filename_from_uri (gtk_recent_chooser_get_current_uri (r), NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	moserial_main_window_applyProfile (self, _tmp1_ = _tmp0_);
	_g_free0 (_tmp1_);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s) {
	GtkTextIter iter = {0};
	gint i = 0;
	GString* builder;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buf != NULL);
	g_return_if_fail (s != NULL);
	builder = g_string_new ("");
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gunichar c;
			gboolean _tmp1_ = FALSE;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			if (!(i < string_get_length (s))) {
				break;
			}
			c = g_utf8_get_char (s);
			if (g_unichar_isprint (c)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_unichar_isspace (c);
			}
			if (_tmp1_) {
				g_string_append_unichar (builder, c);
			}
			s = g_utf8_next_char (s);
		}
	}
	gtk_text_buffer_get_end_iter (buf, &iter);
	gtk_text_buffer_insert (buf, &iter, builder->str, (gint) string_get_length (builder->str));
	_g_string_free0 (builder);
}


void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w) {
	GError * _inner_error_;
	char* s;
	char* _tmp0_;
	char* _tmp1_;
	glong len = 0L;
	char* _tmp12_;
	char* _tmp13_;
	GtkTextIter echoStartIter = {0};
	GtkTextMark* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	s = NULL;
	s = (_tmp0_ = g_strdup (gtk_entry_get_text (self->priv->entry)), _g_free0 (s), _tmp0_);
	self->priv->serialConnection->echoReference = (_tmp1_ = g_strdup (s), _g_free0 (self->priv->serialConnection->echoReference), _tmp1_);
	if (gtk_combo_box_get_active (self->priv->inputMode) == 0) {
		char* t;
		len = string_get_length (s);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					char* _tmp3_;
					char* _tmp4_;
					if (!_tmp2_) {
						x++;
					}
					_tmp2_ = FALSE;
					if (!(x < len)) {
						break;
					}
					moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (s));
					moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (s));
					moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (s));
					moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp3_ = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (s))));
					_g_free0 (_tmp3_);
					s = (_tmp4_ = g_strdup (g_utf8_next_char (s)), _g_free0 (s), _tmp4_);
				}
			}
		}
		t = moserial_serial_connection_getLineEnd (self->priv->serialConnection, gtk_combo_box_get_active (self->priv->terminationMode));
		len = string_get_length (t);
		{
			gint x;
			x = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					char* _tmp7_;
					if (!_tmp5_) {
						x++;
					}
					_tmp5_ = FALSE;
					if (!(x < len)) {
						break;
					}
					moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (t));
					moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (t));
					moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (t));
					if (x == 0) {
						char* _tmp6_;
						moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp6_ = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (t))));
						_g_free0 (_tmp6_);
					}
					t = (_tmp7_ = g_strdup (g_utf8_next_char (t)), _g_free0 (t), _tmp7_);
				}
			}
		}
		_g_free0 (t);
	} else {
		{
			guchar* _tmp9_;
			gint h_size;
			gint h_length1;
			gint _tmp8_;
			guchar* h;
			h = (_tmp9_ = input_parser_parseHex (s, &_tmp8_, &_inner_error_), h_length1 = _tmp8_, h_size = h_length1, _tmp9_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == HEX_PARSE_ERROR) {
					goto __catch0_hex_parse_error;
				}
				_g_free0 (s);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			len = (glong) h_length1;
			{
				gint x;
				x = 0;
				{
					gboolean _tmp10_;
					_tmp10_ = TRUE;
					while (TRUE) {
						char* _tmp11_;
						if (!_tmp10_) {
							x++;
						}
						_tmp10_ = FALSE;
						if (!(x < len)) {
							break;
						}
						moserial_serial_connection_sendByte (self->priv->serialConnection, h[x]);
						moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, h[x]);
						moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, h[x]);
						moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp11_ = g_strdup_printf ("%c", (gint) h[x]));
						_g_free0 (_tmp11_);
					}
				}
			}
			h = (g_free (h), NULL);
		}
		goto __finally0;
		__catch0_hex_parse_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				GtkMessageDialog* errorDialog;
				errorDialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, e->message));
				gtk_dialog_run ((GtkDialog*) errorDialog);
				gtk_object_destroy ((GtkObject*) errorDialog);
				_g_error_free0 (e);
				_g_object_unref0 (errorDialog);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
	gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp12_ = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
	_g_free0 (_tmp12_);
	gtk_entry_set_text (self->priv->entry, "");
	self->priv->serialConnection->echoCompare = (_tmp13_ = g_strdup (""), _g_free0 (self->priv->serialConnection->echoCompare), _tmp13_);
	gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStartIter);
	self->priv->echoStartMark = (_tmp14_ = _g_object_ref0 (gtk_text_buffer_create_mark (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, TRUE)), _g_object_unref0 (self->priv->echoStartMark), _tmp14_);
	_g_free0 (s);
}


static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_send_chooser_dialog_show (self->priv->sendChooserDialog, default_paths_get_sendFrom (self->priv->currentPaths));
}


static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_send_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self) {
	moserial_szwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self) {
	moserial_main_window_sendComplete (self, _sender);
}


static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog) {
	moserialSzwrapperProtocol protocol = 0;
	char* filename;
	char* _tmp0_;
	char* _tmp1_;
	moserialSzwrapper* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	filename = NULL;
	filename = (_tmp0_ = g_strdup (dialog->filename), _g_free0 (filename), _tmp0_);
	default_paths_set_sendFrom (self->priv->currentPaths, _tmp1_ = mo_utils_getParentFolder (filename));
	_g_free0 (_tmp1_);
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
		case 3:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
			break;
		}
	}
	self->priv->sz = (_tmp2_ = moserial_szwrapper_new (&protocol, self->priv->serialConnection, filename), _g_object_unref0 (self->priv->sz), _tmp2_);
	if (self->priv->sz->running) {
		moserial_send_progress_dialog_show (self->priv->sendProgressDialog);
		g_signal_connect_object (self->priv->sz, "update-status", (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog, 0);
		g_signal_connect_object (self->priv->sendProgressDialog, "transfer-canceled", (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz, 0);
		g_signal_connect_object (self->priv->sz, "transfer-complete", (GCallback) _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete, self, 0);
	}
	_g_free0 (filename);
}


void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->sz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_SZWRAPPER, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->sendProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, &_tmp1_, NULL, FALSE), _tmp1_), 0, NULL, (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz);
	moserial_send_progress_dialog_hide (self->priv->sendProgressDialog);
}


static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_receive_chooser_dialog_show (self->priv->receiveChooserDialog, default_paths_get_receiveTo (self->priv->currentPaths));
}


static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_receive_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self) {
	moserial_rzwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self) {
	moserial_main_window_receiveComplete (self, _sender);
}


static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog) {
	char* filename;
	moserialRzwrapperProtocol protocol = 0;
	moserialRzwrapper* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	filename = g_strdup ("");
	default_paths_set_receiveTo (self->priv->currentPaths, dialog->path);
	if (gtk_combo_box_get_active (dialog->protocolCombo) == 0) {
		char* _tmp0_;
		moserial_xmodem_filename_dialog_show (self->priv->xmodemFilenameDialog);
		filename = (_tmp0_ = g_strdup (self->priv->xmodemFilenameDialog->filename), _g_free0 (filename), _tmp0_);
	}
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
	}
	self->priv->rz = (_tmp1_ = moserial_rzwrapper_new (&protocol, self->priv->serialConnection, dialog->path, filename), _g_object_unref0 (self->priv->rz), _tmp1_);
	if (self->priv->rz->running) {
		moserial_receive_progress_dialog_show (self->priv->receiveProgressDialog);
		g_signal_connect_object (self->priv->rz, "update-status", (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog, 0);
		g_signal_connect_object (self->priv->receiveProgressDialog, "transfer-canceled", (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz, 0);
		g_signal_connect_object (self->priv->rz, "transfer-complete", (GCallback) _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete, self, 0);
	}
	_g_free0 (filename);
}


void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->rz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_RZWRAPPER, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->receiveProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, &_tmp1_, NULL, FALSE), _tmp1_), 0, NULL, (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz);
	moserial_receive_progress_dialog_hide (self->priv->receiveProgressDialog);
}


void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		if (!moserial_main_window_ensureConnected (self)) {
			gtk_toggle_tool_button_set_active (button, FALSE);
			return;
		}
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->stopRecordingLabel);
		moserial_record_dialog_show (self->priv->recordDialog, default_paths_get_recordTo (self->priv->currentPaths));
	} else {
		moserial_serial_stream_recorder_close (self->priv->streamRecorder, preferences_get_recordLaunch (self->priv->currentPreferences));
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->recordLabel);
		moserial_main_window_setWindowTitle (self, NULL);
		if (self->priv->recordTimeoutID > 0) {
			g_source_remove (self->priv->recordTimeoutID);
			self->priv->recordTimeoutID = (guint) 0;
		}
	}
}


void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
}


void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (filename != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		moserial_serial_stream_recorder_open (self->priv->streamRecorder, filename, direction, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		default_paths_set_recordTo (self->priv->currentPaths, _tmp0_ = mo_utils_getParentFolder (filename));
		_g_free0 (_tmp0_);
		if (!moserial_main_window_ensureConnected (self)) {
			moserial_main_window_stopRecording (self, dialog);
		}
		moserial_main_window_setWindowTitle (self, filename);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp1_;
			GtkMessageDialog* _tmp2_;
			GtkMessageDialog* errorDialog;
			errorDialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp1_ = g_strdup_printf ("%s: %s\n%s", _ ("Error: Could not open file"), filename, e->message))), _g_free0 (_tmp1_), _tmp2_);
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_object_destroy ((GtkObject*) errorDialog);
			moserial_main_window_stopRecording (self, dialog);
			_g_error_free0 (e);
			_g_object_unref0 (errorDialog);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean moserial_main_window_recordTimeout (moserialMainWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
	result = FALSE;
	return result;
}


void moserial_main_window_showWindow (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->gtkWindow);
}


static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings) {
	Settings* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (newSettings != NULL);
	self->priv->currentSettings = (_tmp0_ = _g_object_ref0 (newSettings), _g_object_unref0 (self->priv->currentSettings), _tmp0_);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp1_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
	_g_free0 (_tmp1_);
	self->priv->profileChanged = TRUE;
}


static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences) {
	Preferences* _tmp0_;
	char* font;
	PangoFontDescription* _tmp3_;
	GdkColor _tmp5_;
	GdkColor _tmp4_ = {0};
	GdkColor _tmp7_;
	GdkColor _tmp6_ = {0};
	PangoFontDescription* _tmp8_;
	GdkColor _tmp10_;
	GdkColor _tmp9_ = {0};
	GdkColor _tmp12_;
	GdkColor _tmp11_ = {0};
	PangoFontDescription* _tmp13_;
	GdkColor _tmp15_;
	GdkColor _tmp14_ = {0};
	GdkColor _tmp17_;
	GdkColor _tmp16_ = {0};
	PangoFontDescription* _tmp18_;
	GdkColor _tmp20_;
	GdkColor _tmp19_ = {0};
	GdkColor _tmp22_;
	GdkColor _tmp21_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (newPreferences != NULL);
	self->priv->currentPreferences = (_tmp0_ = _g_object_ref0 (newPreferences), _g_object_unref0 (self->priv->currentPreferences), _tmp0_);
	font = NULL;
	if (preferences_get_useSystemMonospaceFont (self->priv->currentPreferences)) {
		char* _tmp1_;
		font = (_tmp1_ = preferences_getSystemDefaultMonospaceFont (), _g_free0 (font), _tmp1_);
	} else {
		char* _tmp2_;
		font = (_tmp2_ = g_strdup (preferences_get_font (self->priv->currentPreferences)), _g_free0 (font), _tmp2_);
	}
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp3_ = pango_font_description_from_string (font));
	_pango_font_description_free0 (_tmp3_);
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp5_ = (preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences), &_tmp4_), _tmp4_), &_tmp5_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp7_ = (preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences), &_tmp6_), _tmp6_), &_tmp7_));
	g_object_set (self->priv->echoTag, "foreground", preferences_get_highlightColor (self->priv->currentPreferences), NULL);
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp8_ = pango_font_description_from_string (font));
	_pango_font_description_free0 (_tmp8_);
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp10_ = (preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences), &_tmp9_), _tmp9_), &_tmp10_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp12_ = (preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences), &_tmp11_), _tmp11_), &_tmp12_));
	moserial_hex_text_buffer_applyPreferences (self->priv->incomingHexTextBuffer, self->priv->currentPreferences);
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp13_ = pango_font_description_from_string (font));
	_pango_font_description_free0 (_tmp13_);
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp15_ = (preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences), &_tmp14_), _tmp14_), &_tmp15_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp17_ = (preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences), &_tmp16_), _tmp16_), &_tmp17_));
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp18_ = pango_font_description_from_string (font));
	_pango_font_description_free0 (_tmp18_);
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp20_ = (preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences), &_tmp19_), _tmp19_), &_tmp20_));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp22_ = (preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences), &_tmp21_), _tmp21_), &_tmp22_));
	moserial_hex_text_buffer_applyPreferences (self->priv->outgoingHexTextBuffer, self->priv->currentPreferences);
	self->priv->profileChanged = TRUE;
	_g_free0 (font);
}


static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_settings_dialog_show (self->priv->settingsDialog, self->priv->currentSettings);
}


static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_preferences_dialog_show (self->priv->preferencesDialog, self->priv->currentPreferences, gtk_toggle_tool_button_get_active (self->priv->recordButton));
}


gboolean moserial_main_window_ensureConnected (moserialMainWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, TRUE);
	}
	result = gtk_toggle_tool_button_get_active (self->priv->connectButton);
	return result;
}


void moserial_main_window_ensureDisconnected (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
	}
}


static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self) {
	moserial_main_window_updateIncoming (self, _sender, data, data_length1, size);
}


static gboolean moserial_main_window_startConnection (moserialMainWindow* self) {
	gboolean result;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!moserial_serial_connection_doConnect (self->priv->serialConnection, self->priv->currentSettings)) {
		char* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* dialog;
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
		dialog = (_tmp1_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp0_ = g_strdup_printf ("%s: %s", _ ("Error: Could not open device"), settings_get_device (self->priv->currentSettings)))), _g_free0 (_tmp0_), _tmp1_);
		gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		result = FALSE;
		_g_object_unref0 (dialog);
		return result;
	}
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, FALSE);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2_ = settings_getStatusbarString (self->priv->currentSettings, TRUE));
	_g_free0 (_tmp2_);
	g_signal_connect_object (self->priv->serialConnection, "new-data", (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self, 0);
	gtk_tool_button_set_label_widget ((GtkToolButton*) self->priv->connectButton, (GtkWidget*) self->priv->disconnectLabel);
	result = TRUE;
	return result;
}


static void moserial_main_window_connectButtonClick (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		moserial_main_window_startConnection (self);
	} else {
		guint _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, TRUE);
		moserial_serial_connection_doDisconnect (self->priv->serialConnection);
		g_signal_handlers_disconnect_matched (self->priv->serialConnection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("new-data", MOSERIAL_TYPE_SERIAL_CONNECTION, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self);
		gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp1_ = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
		_g_free0 (_tmp1_);
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_g_free0 (_tmp2_);
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->connectLabel);
		if (gtk_toggle_tool_button_get_active (self->priv->recordButton)) {
			gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
		}
	}
}


static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self) {
	return moserial_main_window_recordTimeout (self);
}


static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sc != NULL);
	if (self->priv->rz->running) {
		{
			gint x;
			x = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					if (!_tmp0_) {
						x++;
					}
					_tmp0_ = FALSE;
					if (!(x < size)) {
						break;
					}
					moserial_rzwrapper_writeChar (self->priv->rz, data[x]);
				}
			}
		}
		moserial_rzwrapper_flush (self->priv->rz);
	} else {
		if (self->priv->sz->running) {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						if (!_tmp1_) {
							x++;
						}
						_tmp1_ = FALSE;
						if (!(x < size)) {
							break;
						}
						moserial_szwrapper_writeChar (self->priv->sz, data[x]);
					}
				}
			}
		} else {
			{
				gint x;
				x = 0;
				{
					gboolean _tmp2_;
					_tmp2_ = TRUE;
					while (TRUE) {
						char* _tmp3_;
						gunichar _tmp4_;
						gunichar c;
						char* s;
						gboolean _tmp6_ = FALSE;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp12_ = FALSE;
						gboolean _tmp13_ = FALSE;
						gboolean _tmp14_ = FALSE;
						gboolean _tmp15_ = FALSE;
						char* _tmp16_;
						if (!_tmp2_) {
							x++;
						}
						_tmp2_ = FALSE;
						if (!(x < size)) {
							break;
						}
						moserial_hex_text_buffer_add (self->priv->incomingHexTextBuffer, data[x]);
						c = (_tmp4_ = g_utf8_get_char (_tmp3_ = g_strdup_printf ("%c", (gint) data[x])), _g_free0 (_tmp3_), _tmp4_);
						s = g_strdup_printf ("%c", (gint) data[x]);
						if (string_get_length (sc->echoCompare) < string_get_length (sc->echoReference)) {
							char* _tmp5_;
							sc->echoCompare = (_tmp5_ = g_strconcat (sc->echoCompare, s, NULL), _g_free0 (sc->echoCompare), _tmp5_);
						}
						if (g_utf8_validate (s, -1, NULL)) {
							gboolean _tmp7_ = FALSE;
							if (g_unichar_isprint (c)) {
								_tmp7_ = TRUE;
							} else {
								_tmp7_ = g_unichar_isspace (c);
							}
							_tmp6_ = _tmp7_;
						} else {
							_tmp6_ = FALSE;
						}
						if (_tmp6_) {
							gboolean _tmp8_ = FALSE;
							if (sc->lastRxCharWasCR) {
								_tmp8_ = c == '\n';
							} else {
								_tmp8_ = FALSE;
							}
							if (!_tmp8_) {
								moserial_main_window_insertBufferEnd (self, self->priv->incomingAsciiTextBuffer, s);
							}
						} else {
							sc->nonprintable = sc->nonprintable + 1;
						}
						sc->lastRxCharWasCR = c == '\r';
						if (string_get_length (sc->echoCompare) > 0) {
							_tmp9_ = string_get_length (sc->echoCompare) == string_get_length (sc->echoReference);
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							char* _tmp10_;
							char* _tmp11_;
							if (_vala_strcmp0 (sc->echoCompare, sc->echoReference) == 0) {
								GtkTextIter echoStartIter = {0};
								GtkTextIter echoStopIter = {0};
								gtk_text_buffer_get_iter_at_mark (self->priv->incomingAsciiTextBuffer, &echoStartIter, self->priv->echoStartMark);
								gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStopIter);
								gtk_text_buffer_apply_tag_by_name (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, &echoStopIter);
							}
							sc->echoCompare = (_tmp10_ = g_strdup (""), _g_free0 (sc->echoCompare), _tmp10_);
							sc->echoReference = (_tmp11_ = g_strdup (""), _g_free0 (sc->echoReference), _tmp11_);
						}
						if (sc->rx > 32) {
							_tmp14_ = sc->nonprintable > 0;
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							_tmp13_ = (sc->rx / sc->nonprintable) < 4;
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							_tmp12_ = !sc->forced_hex_view;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							sc->forced_hex_view = TRUE;
							gtk_notebook_set_current_page (self->priv->incoming_notebook, 1);
						}
						if (preferences_get_enableTimeout (self->priv->currentPreferences)) {
							_tmp15_ = gtk_toggle_tool_button_get_active (self->priv->recordButton);
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							if (self->priv->recordTimeoutID > 0) {
								g_source_remove (self->priv->recordTimeoutID);
							}
							if (preferences_get_timeout (self->priv->currentPreferences) > 0) {
								self->priv->recordTimeoutID = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) preferences_get_timeout (self->priv->currentPreferences), _moserial_main_window_recordTimeout_gsource_func, g_object_ref (self), g_object_unref);
							}
						}
						moserial_serial_stream_recorder_writeIncoming (self->priv->streamRecorder, data[x]);
						self->priv->recordDataReceived = TRUE;
						gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
						gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp16_ = moserial_serial_connection_getBytecountbarString (sc));
						_g_free0 (_tmp16_);
						_g_free0 (s);
					}
				}
			}
		}
	}
}


static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (inputMode != NULL);
	if (gtk_combo_box_get_active (inputMode) == 1) {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 1);
	} else {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 0);
	}
}


static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelp (moserialMainWindow* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		gtk_show_uri (NULL, "ghelp:moserial", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning (_ ("Unable to display help file: %s"), e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	moserial_main_window_url_hook (self, about, link_);
}


static void moserial_main_window_showAboutDialog (moserialMainWindow* self) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp3_;
	char* license_trans;
	g_return_if_fail (self != NULL);
	license_trans = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (MOSERIAL_MAIN_WINDOW_license[0], "\n", NULL), MOSERIAL_MAIN_WINDOW_license[1], NULL), "\n", NULL), MOSERIAL_MAIN_WINDOW_license[2], NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
	gtk_about_dialog_set_url_hook (_moserial_main_window_url_hook_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_show_about_dialog (self->priv->gtkWindow, "version", VERSION, "copyright", "Copyright © 2009-2010\nMichael J. Chudobiak\n<mjc@svn.gnome.org>", "comments", _ ("A serial terminal for the GNOME desktop, optimized for logging and file capture."), "authors", MOSERIAL_MAIN_WINDOW_authors, "translator-credits", MOSERIAL_MAIN_WINDOW_translators, "logo-icon-name", "moserial", "wrap-license", TRUE, "license", license_trans, "website", "http://live.gnome.org/moserial", NULL, NULL);
	_g_free0 (license_trans);
}


static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	_inner_error_ = NULL;
	{
		gtk_show_uri (NULL, link, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning (_ ("Can't display a clickable URL: %s"), e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void moserial_main_window_quitSizeSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
}


static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, GdkEvent* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
	gtk_main_quit ();
	result = TRUE;
	return result;
}


static gboolean moserial_main_window_keyPress (moserialMainWindow* self, GtkWidget* widget, GdkEventKey* key) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((*key).keyval == 0xff1b) {
		moserial_auto_scroll_scroll (self->priv->va1);
		moserial_auto_scroll_scroll (self->priv->va2);
		moserial_auto_scroll_scroll (self->priv->va3);
		moserial_auto_scroll_scroll (self->priv->va4);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->entry, -1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void moserial_main_window_windowSizeSave (moserialMainWindow* self) {
	gint width;
	gint height;
	gint pos;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	pos = gtk_paned_get_position (self->priv->paned);
	gtk_window_get_size (self->priv->gtkWindow, &width, &height);
	profile_saveWindowSize (self->priv->profile, width, height);
	profile_saveWindowPanedPosition (self->priv->profile, pos);
}


static void moserial_main_window_quitSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename != NULL) {
		if (self->priv->profileChanged) {
			GtkMessageDialog* dialog;
			gint response;
			dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("You have changed your setting or preferences. Do you want to save these changes to the loaded profile?")));
			response = gtk_dialog_run ((GtkDialog*) dialog);
			if (response == GTK_RESPONSE_YES) {
				moserial_main_window_saveProfile (self);
			}
			gtk_object_destroy ((GtkObject*) dialog);
			_g_object_unref0 (dialog);
		} else {
			moserial_main_window_saveProfile (self);
		}
	}
	profile_save (self->priv->profile, NULL, self->priv->gtkWindow);
	gtk_main_quit ();
}


static void moserial_main_window_saveProfile (moserialMainWindow* self) {
	GError * _inner_error_;
	GtkRecentManager* recentManager;
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename == NULL) {
		moserial_main_window_saveProfileAs (self);
	}
	if (self->priv->profileFilename == NULL) {
		return;
	}
	profile_save (self->priv->profile, self->priv->profileFilename, self->priv->gtkWindow);
	self->priv->profileChanged = FALSE;
	recentManager = _g_object_ref0 (gtk_recent_manager_get_default ());
	_tmp0_ = g_filename_to_uri (self->priv->profileFilename, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (recentManager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_recent_manager_add_item (recentManager, _tmp1_ = _tmp0_);
	_g_free0 (_tmp1_);
	_g_object_unref0 (recentManager);
}


static void moserial_main_window_saveProfileAs (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_SAVE, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) dialog, TRUE);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp0_;
		self->priv->profileFilename = (_tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), _g_free0 (self->priv->profileFilename), _tmp0_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		moserial_main_window_saveProfile (self);
	}
	_g_object_unref0 (dialog);
}


static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profileFilename != NULL);
	moserial_main_window_applyProfile (self, profileFilename);
}


static void moserial_main_window_loadProfile (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_OPEN, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp0_;
		moserial_main_window_applyProfile (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog));
		_g_free0 (_tmp0_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void moserial_main_window_copy (moserialMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0_) {
		GtkTextView* tv;
		tv = _g_object_ref0 (GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)));
		gtk_text_buffer_copy_clipboard (gtk_text_view_get_buffer (tv), gtk_clipboard_get (GDK_SELECTION_CLIPBOARD));
		_g_object_unref0 (tv);
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			g_signal_emit_by_name (self->priv->entry, "copy-clipboard");
		}
	}
}


static void moserial_main_window_cut (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
		g_signal_emit_by_name (self->priv->entry, "cut-clipboard");
	}
}


static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0_) {
		GtkTextView* tv;
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		tv = _g_object_ref0 (GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)));
		if (gtk_text_buffer_get_has_selection (gtk_text_view_get_buffer (tv))) {
			gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
		} else {
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
		_g_object_unref0 (tv);
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			gint s;
			gint e;
			s = 0;
			e = 0;
			if (gtk_editable_get_selection_bounds ((GtkEditable*) self->priv->entry, s, e)) {
				gtk_action_set_sensitive (self->priv->cutMenuItem, TRUE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
			} else {
				gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
			}
		} else {
			gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
	}
}


static void moserial_main_window_paste (moserialMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self->priv->entry, "paste-clipboard");
	if (!(g_object_get ((GtkWidget*) self->priv->entry, "has-focus", &_tmp0_, NULL), _tmp0_)) {
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->entry, -1);
	}
}


static void moserial_main_window_clear (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_entry_set_text (self->priv->entry, "");
}


GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self) {
	GtkBuilder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_builder;
	return result;
}


static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value) {
	GtkBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_builder = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_builder), _tmp0_);
	g_object_notify ((GObject *) self, "builder");
}


const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_startupProfileFilename;
	return result;
}


static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_startupProfileFilename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_startupProfileFilename), _tmp0_);
	g_object_notify ((GObject *) self, "startupProfileFilename");
}


static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	moserial_main_window_quitSave (self);
}


static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, GdkEvent* event, gpointer self) {
	return moserial_main_window_deleteSaveSize (self, _sender, event);
}


static gboolean _moserial_main_window_keyPress_gtk_widget_key_press_event (GtkWindow* _sender, GdkEventKey* event, gpointer self) {
	return moserial_main_window_keyPress (self, _sender, event);
}


static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_quitSizeSave (self);
}


static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfileAs (self);
}


static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfile (self);
}


static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_loadProfile (self);
}


static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_copy (self);
}


static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_editMenu (self, _sender);
}


static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_cut (self);
}


static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_paste (self);
}


static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_clear (self);
}


static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self) {
	moserial_main_window_updateSettings (self, _sender, settings);
}


static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showSettingsDialog (self, _sender);
}


static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showHelpButton (self, _sender);
}


static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showAboutDialog (self);
}


static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doSendChooser (self, _sender);
}


static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self) {
	moserial_main_window_doSend (self, _sender);
}


static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doReceiveChooser (self, _sender);
}


static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self) {
	moserial_main_window_doReceive (self, _sender);
}


static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_record (self, _sender);
}


static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self) {
	moserial_main_window_stopRecording (self, _sender);
}


static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self) {
	moserial_main_window_startRecording (self, _sender, fileName, direction);
}


static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self) {
	moserial_main_window_updatePreferences (self, _sender, preferences);
}


static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showPreferencesDialog (self, _sender);
}


static void _moserial_main_window_connectButtonClick_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_connectButtonClick (self, _sender);
}


static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showHelpAction (self, _sender);
}


static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	moserial_main_window_inputModeChanged (self, _sender);
}


static void _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated (GtkRecentChooserMenu* _sender, gpointer self) {
	moserial_main_window_recentItemOpen (self, _sender);
}


static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialMainWindow * self;
	parent_class = G_OBJECT_CLASS (moserial_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_MAIN_WINDOW (obj);
	{
		GtkWindow* _tmp0_;
		Profile* _tmp1_;
		Settings* _tmp2_;
		gint width;
		gint height;
		gint panedPosition;
		gboolean _tmp3_ = FALSE;
		GtkPaned* _tmp4_;
		GtkAction* quit;
		GtkAction* saveAs;
		GtkAction* save;
		GtkAction* open;
		GtkAction* _tmp5_;
		GtkAction* editMenuItem;
		GtkAction* _tmp6_;
		GtkAction* pasteMenuItem;
		GtkAction* clearMenuItem;
		moserialSettingsDialog* _tmp7_;
		GtkToolButton* _tmp8_;
		GtkToolButton* helpButton;
		GtkStatusbar* _tmp9_;
		char* _tmp10_;
		GtkStatusbar* _tmp11_;
		GtkAction* about;
		moserialSendProgressDialog* _tmp12_;
		moserialSendChooserDialog* _tmp13_;
		GtkToolButton* _tmp14_;
		moserialSzwrapper* _tmp16_;
		moserialSzwrapperProtocol _tmp15_;
		moserialReceiveProgressDialog* _tmp17_;
		moserialReceiveChooserDialog* _tmp18_;
		GtkToolButton* _tmp19_;
		moserialXmodemFilenameDialog* _tmp20_;
		moserialRzwrapper* _tmp22_;
		moserialRzwrapperProtocol _tmp21_;
		moserialRecordDialog* _tmp23_;
		GtkToggleToolButton* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		moserialPreferencesDialog* _tmp27_;
		GtkToolButton* preferences;
		GtkToggleToolButton* _tmp28_;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		GtkAction* contents;
		GtkNotebook* _tmp31_;
		GtkNotebook* _tmp32_;
		moserialHexTextBuffer* _tmp33_;
		GtkTextBuffer* _tmp35_;
		GtkTextTagTable* _tmp34_;
		moserialHexTextBuffer* _tmp36_;
		GtkTextBuffer* _tmp38_;
		GtkTextTagTable* _tmp37_;
		GtkTextTag* _tmp39_;
		GtkTextView* _tmp40_;
		PangoFontDescription* _tmp41_;
		GtkTextView* _tmp42_;
		PangoFontDescription* _tmp43_;
		GtkTextView* _tmp44_;
		PangoFontDescription* _tmp45_;
		GtkTextView* _tmp46_;
		PangoFontDescription* _tmp47_;
		GtkScrolledWindow* incomingAsciiScrolledWindow;
		GtkAdjustment* _tmp48_;
		GtkScrolledWindow* incomingHexScrolledWindow;
		GtkAdjustment* _tmp49_;
		GtkScrolledWindow* outgoingAsciiScrolledWindow;
		GtkAdjustment* _tmp50_;
		GtkScrolledWindow* outgoingHexScrolledWindow;
		GtkAdjustment* _tmp51_;
		GtkButton* _tmp52_;
		GtkEntry* _tmp53_;
		GtkComboBox* _tmp54_;
		GtkComboBox* _tmp55_;
		GtkRecentManager* recentManager;
		GtkRecentChooserMenu* recentChooserMenu;
		GtkRecentFilter* filter;
		GtkMenuShell* menuBar;
		GList* children;
		GtkMenuItem* fileMenu;
		GtkMenuItem* _tmp56_;
		GtkMenuShell* fileMenuShell;
		GList* _tmp57_;
		GtkMenuItem* recentFileItem;
		Preferences* _tmp58_;
		DefaultPaths* _tmp59_;
		self->priv->gtkWindow = (_tmp0_ = _g_object_ref0 (GTK_WINDOW (gtk_builder_get_object (self->priv->_builder, "window"))), _g_object_unref0 (self->priv->gtkWindow), _tmp0_);
		g_signal_connect_object ((GtkObject*) self->priv->gtkWindow, "destroy", (GCallback) _moserial_main_window_quitSave_gtk_object_destroy, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->gtkWindow, "delete-event", (GCallback) _moserial_main_window_deleteSaveSize_gtk_widget_delete_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->gtkWindow, "key-press-event", (GCallback) _moserial_main_window_keyPress_gtk_widget_key_press_event, self, 0);
		self->priv->profile = (_tmp1_ = profile_new (), _g_object_unref0 (self->priv->profile), _tmp1_);
		profile_load (self->priv->profile, NULL, self->priv->gtkWindow);
		self->priv->currentSettings = (_tmp2_ = settings_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentSettings), _tmp2_);
		width = profile_getWindowWidth (self->priv->profile);
		height = profile_getWindowHeight (self->priv->profile);
		panedPosition = profile_getWindowPanedPosition (self->priv->profile);
		if (width > 0) {
			_tmp3_ = height > 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gtk_window_resize (self->priv->gtkWindow, width, height);
		}
		self->priv->paned = (_tmp4_ = _g_object_ref0 (GTK_PANED (gtk_builder_get_object (self->priv->_builder, "vpaned"))), _g_object_unref0 (self->priv->paned), _tmp4_);
		if (panedPosition >= (-1)) {
			gtk_paned_set_position (self->priv->paned, panedPosition);
		} else {
			gtk_paned_set_position (self->priv->paned, -1);
		}
		quit = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_quit")));
		g_signal_connect_object (quit, "activate", (GCallback) _moserial_main_window_quitSizeSave_gtk_action_activate, self, 0);
		saveAs = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings_as")));
		g_signal_connect_object (saveAs, "activate", (GCallback) _moserial_main_window_saveProfileAs_gtk_action_activate, self, 0);
		save = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings")));
		g_signal_connect_object (save, "activate", (GCallback) _moserial_main_window_saveProfile_gtk_action_activate, self, 0);
		open = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_open_settings")));
		g_signal_connect_object (open, "activate", (GCallback) _moserial_main_window_loadProfile_gtk_action_activate, self, 0);
		self->priv->copyMenuItem = (_tmp5_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_copy"))), _g_object_unref0 (self->priv->copyMenuItem), _tmp5_);
		g_signal_connect_object (self->priv->copyMenuItem, "activate", (GCallback) _moserial_main_window_copy_gtk_action_activate, self, 0);
		editMenuItem = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_edit")));
		g_signal_connect_object (editMenuItem, "activate", (GCallback) _moserial_main_window_editMenu_gtk_action_activate, self, 0);
		self->priv->cutMenuItem = (_tmp6_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_cut"))), _g_object_unref0 (self->priv->cutMenuItem), _tmp6_);
		gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		g_signal_connect_object (self->priv->cutMenuItem, "activate", (GCallback) _moserial_main_window_cut_gtk_action_activate, self, 0);
		pasteMenuItem = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_paste")));
		g_signal_connect_object (pasteMenuItem, "activate", (GCallback) _moserial_main_window_paste_gtk_action_activate, self, 0);
		clearMenuItem = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_clear")));
		g_signal_connect_object (clearMenuItem, "activate", (GCallback) _moserial_main_window_clear_gtk_action_activate, self, 0);
		self->priv->settingsDialog = (_tmp7_ = moserial_settings_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->settingsDialog), _tmp7_);
		g_signal_connect_object (self->priv->settingsDialog, "update-settings", (GCallback) _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings, self, 0);
		self->priv->settingsButton = (_tmp8_ = _g_object_ref0 (GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_settings"))), _g_object_unref0 (self->priv->settingsButton), _tmp8_);
		g_signal_connect_object (self->priv->settingsButton, "clicked", (GCallback) _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked, self, 0);
		helpButton = _g_object_ref0 (GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_help")));
		g_signal_connect_object (helpButton, "clicked", (GCallback) _moserial_main_window_showHelpButton_gtk_tool_button_clicked, self, 0);
		self->priv->statusbar = (_tmp9_ = _g_object_ref0 (GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "statusbar"))), _g_object_unref0 (self->priv->statusbar), _tmp9_);
		self->priv->statusbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial port status");
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp10_ = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_g_free0 (_tmp10_);
		self->priv->bytecountbar = (_tmp11_ = _g_object_ref0 (GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "bytecountbar"))), _g_object_unref0 (self->priv->bytecountbar), _tmp11_);
		self->priv->bytecountbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial byte counts");
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _ ("TX: 0, RX: 0"));
		about = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_about")));
		g_signal_connect_object (about, "activate", (GCallback) _moserial_main_window_showAboutDialog_gtk_action_activate, self, 0);
		self->priv->sendProgressDialog = (_tmp12_ = moserial_send_progress_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->sendProgressDialog), _tmp12_);
		self->priv->sendChooserDialog = (_tmp13_ = moserial_send_chooser_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->sendChooserDialog), _tmp13_);
		self->priv->send = (_tmp14_ = _g_object_ref0 (GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_send"))), _g_object_unref0 (self->priv->send), _tmp14_);
		g_signal_connect_object (self->priv->send, "clicked", (GCallback) _moserial_main_window_doSendChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->sendChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer, self, 0);
		self->priv->sz = (_tmp16_ = moserial_szwrapper_new ((_tmp15_ = MOSERIAL_SZWRAPPER_PROTOCOL_NULL, &_tmp15_), NULL, NULL), _g_object_unref0 (self->priv->sz), _tmp16_);
		self->priv->receiveProgressDialog = (_tmp17_ = moserial_receive_progress_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->receiveProgressDialog), _tmp17_);
		self->priv->receiveChooserDialog = (_tmp18_ = moserial_receive_chooser_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->receiveChooserDialog), _tmp18_);
		self->priv->receive = (_tmp19_ = _g_object_ref0 (GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_receive"))), _g_object_unref0 (self->priv->receive), _tmp19_);
		g_signal_connect_object (self->priv->receive, "clicked", (GCallback) _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->receiveChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer, self, 0);
		self->priv->xmodemFilenameDialog = (_tmp20_ = moserial_xmodem_filename_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->xmodemFilenameDialog), _tmp20_);
		self->priv->rz = (_tmp22_ = moserial_rzwrapper_new ((_tmp21_ = MOSERIAL_RZWRAPPER_PROTOCOL_NULL, &_tmp21_), NULL, NULL, NULL), _g_object_unref0 (self->priv->rz), _tmp22_);
		self->priv->recordDialog = (_tmp23_ = moserial_record_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->recordDialog), _tmp23_);
		self->priv->recordButton = (_tmp24_ = _g_object_ref0 (GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_logging"))), _g_object_unref0 (self->priv->recordButton), _tmp24_);
		g_signal_connect_object ((GtkToolButton*) self->priv->recordButton, "clicked", (GCallback) _moserial_main_window_record_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "stop-recording", (GCallback) _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "start-recording", (GCallback) _moserial_main_window_startRecording_moserial_record_dialog_start_recording, self, 0);
		self->priv->recordLabel = (_tmp25_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "record_label"))), _g_object_unref0 (self->priv->recordLabel), _tmp25_);
		self->priv->stopRecordingLabel = (_tmp26_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "stop_recording_label"))), _g_object_unref0 (self->priv->stopRecordingLabel), _tmp26_);
		self->priv->preferencesDialog = (_tmp27_ = moserial_preferences_dialog_new (self->priv->_builder), _g_object_unref0 (self->priv->preferencesDialog), _tmp27_);
		g_signal_connect_object (self->priv->preferencesDialog, "update-preferences", (GCallback) _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences, self, 0);
		preferences = _g_object_ref0 (GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_preferences")));
		g_signal_connect_object (preferences, "clicked", (GCallback) _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked, self, 0);
		self->priv->connectButton = (_tmp28_ = _g_object_ref0 (GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_connect"))), _g_object_unref0 (self->priv->connectButton), _tmp28_);
		g_signal_connect_object ((GtkToolButton*) self->priv->connectButton, "clicked", (GCallback) _moserial_main_window_connectButtonClick_gtk_tool_button_clicked, self, 0);
		self->priv->disconnectLabel = (_tmp29_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "disconnect_label"))), _g_object_unref0 (self->priv->disconnectLabel), _tmp29_);
		self->priv->connectLabel = (_tmp30_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "connect_label"))), _g_object_unref0 (self->priv->connectLabel), _tmp30_);
		contents = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_contents")));
		g_signal_connect_object (contents, "activate", (GCallback) _moserial_main_window_showHelpAction_gtk_action_activate, self, 0);
		self->priv->incoming_notebook = (_tmp31_ = _g_object_ref0 (GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "incoming_notebook"))), _g_object_unref0 (self->priv->incoming_notebook), _tmp31_);
		self->priv->outgoing_notebook = (_tmp32_ = _g_object_ref0 (GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "outgoing_notebook"))), _g_object_unref0 (self->priv->outgoing_notebook), _tmp32_);
		self->priv->incomingHexTextBuffer = (_tmp33_ = moserial_hex_text_buffer_new (), _g_object_unref0 (self->priv->incomingHexTextBuffer), _tmp33_);
		self->priv->incomingAsciiTextBuffer = (_tmp35_ = gtk_text_buffer_new (_tmp34_ = gtk_text_tag_table_new ()), _g_object_unref0 (self->priv->incomingAsciiTextBuffer), _tmp35_);
		_g_object_unref0 (_tmp34_);
		self->priv->outgoingHexTextBuffer = (_tmp36_ = moserial_hex_text_buffer_new (), _g_object_unref0 (self->priv->outgoingHexTextBuffer), _tmp36_);
		self->priv->outgoingAsciiTextBuffer = (_tmp38_ = gtk_text_buffer_new (_tmp37_ = gtk_text_tag_table_new ()), _g_object_unref0 (self->priv->outgoingAsciiTextBuffer), _tmp38_);
		_g_object_unref0 (_tmp37_);
		self->priv->echoTag = (_tmp39_ = _g_object_ref0 (gtk_text_buffer_create_tag (self->priv->incomingAsciiTextBuffer, "echo", NULL, NULL)), _g_object_unref0 (self->priv->echoTag), _tmp39_);
		self->priv->incomingHexTextView = (_tmp40_ = _g_object_ref0 (GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_textview"))), _g_object_unref0 (self->priv->incomingHexTextView), _tmp40_);
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp41_ = pango_font_description_from_string ("Monospace 10"));
		_pango_font_description_free0 (_tmp41_);
		gtk_text_view_set_buffer (self->priv->incomingHexTextView, (GtkTextBuffer*) self->priv->incomingHexTextBuffer);
		self->priv->incomingAsciiTextView = (_tmp42_ = _g_object_ref0 (GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_textview"))), _g_object_unref0 (self->priv->incomingAsciiTextView), _tmp42_);
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp43_ = pango_font_description_from_string ("Monospace 10"));
		_pango_font_description_free0 (_tmp43_);
		gtk_text_view_set_buffer (self->priv->incomingAsciiTextView, self->priv->incomingAsciiTextBuffer);
		self->priv->outgoingHexTextView = (_tmp44_ = _g_object_ref0 (GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_textview"))), _g_object_unref0 (self->priv->outgoingHexTextView), _tmp44_);
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp45_ = pango_font_description_from_string ("Monospace 10"));
		_pango_font_description_free0 (_tmp45_);
		gtk_text_view_set_buffer (self->priv->outgoingHexTextView, (GtkTextBuffer*) self->priv->outgoingHexTextBuffer);
		self->priv->outgoingAsciiTextView = (_tmp46_ = _g_object_ref0 (GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_textview"))), _g_object_unref0 (self->priv->outgoingAsciiTextView), _tmp46_);
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp47_ = pango_font_description_from_string ("Monospace 10"));
		_pango_font_description_free0 (_tmp47_);
		gtk_text_view_set_buffer (self->priv->outgoingAsciiTextView, self->priv->outgoingAsciiTextBuffer);
		incomingAsciiScrolledWindow = _g_object_ref0 (GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_scrolledwindow")));
		self->priv->va1 = (_tmp48_ = _g_object_ref0 (gtk_scrolled_window_get_vadjustment (incomingAsciiScrolledWindow)), _g_object_unref0 (self->priv->va1), _tmp48_);
		incomingHexScrolledWindow = _g_object_ref0 (GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_scrolledwindow")));
		self->priv->va2 = (_tmp49_ = _g_object_ref0 (gtk_scrolled_window_get_vadjustment (incomingHexScrolledWindow)), _g_object_unref0 (self->priv->va2), _tmp49_);
		outgoingAsciiScrolledWindow = _g_object_ref0 (GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_scrolledwindow")));
		self->priv->va3 = (_tmp50_ = _g_object_ref0 (gtk_scrolled_window_get_vadjustment (outgoingAsciiScrolledWindow)), _g_object_unref0 (self->priv->va3), _tmp50_);
		outgoingHexScrolledWindow = _g_object_ref0 (GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_scrolledwindow")));
		self->priv->va4 = (_tmp51_ = _g_object_ref0 (gtk_scrolled_window_get_vadjustment (outgoingHexScrolledWindow)), _g_object_unref0 (self->priv->va4), _tmp51_);
		moserial_auto_scroll_setup (self->priv->va1, self->priv->va2, self->priv->va3, self->priv->va4);
		self->priv->sendButton = (_tmp52_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "send"))), _g_object_unref0 (self->priv->sendButton), _tmp52_);
		g_signal_connect_object (self->priv->sendButton, "clicked", (GCallback) _moserial_main_window_sendString_gtk_button_clicked, self, 0);
		self->priv->entry = (_tmp53_ = _g_object_ref0 (GTK_ENTRY (gtk_builder_get_object (self->priv->_builder, "entry"))), _g_object_unref0 (self->priv->entry), _tmp53_);
		g_signal_connect_object (self->priv->entry, "activate", (GCallback) _moserial_main_window_sendString_gtk_entry_activate, self, 0);
		self->priv->inputMode = (_tmp54_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "input_mode"))), _g_object_unref0 (self->priv->inputMode), _tmp54_);
		gtk_combo_box_set_active (self->priv->inputMode, 0);
		g_signal_connect_object (self->priv->inputMode, "changed", (GCallback) _moserial_main_window_inputModeChanged_gtk_combo_box_changed, self, 0);
		self->priv->terminationMode = (_tmp55_ = _g_object_ref0 (GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "termination_mode"))), _g_object_unref0 (self->priv->terminationMode), _tmp55_);
		gtk_combo_box_set_active (self->priv->terminationMode, 0);
		recentManager = _g_object_ref0 (gtk_recent_manager_get_default ());
		recentChooserMenu = g_object_ref_sink ((GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recentManager));
		g_signal_connect_object ((GtkRecentChooser*) recentChooserMenu, "item-activated", (GCallback) _moserial_main_window_recentItemOpen_gtk_recent_chooser_item_activated, self, 0);
		filter = g_object_ref_sink (gtk_recent_filter_new ());
		gtk_recent_filter_add_application (filter, g_get_application_name ());
		gtk_recent_chooser_add_filter ((GtkRecentChooser*) recentChooserMenu, filter);
		gtk_recent_chooser_menu_set_show_numbers (recentChooserMenu, TRUE);
		menuBar = _g_object_ref0 ((GtkMenuShell*) GTK_MENU_BAR (gtk_builder_get_object (self->priv->_builder, "menubar")));
		children = gtk_container_get_children ((GtkContainer*) menuBar);
		fileMenu = NULL;
		fileMenu = (_tmp56_ = _g_object_ref0 (GTK_MENU_ITEM (g_list_first (children)->data)), _g_object_unref0 (fileMenu), _tmp56_);
		fileMenuShell = _g_object_ref0 (GTK_MENU_SHELL (gtk_menu_item_get_submenu (fileMenu)));
		children = (_tmp57_ = gtk_container_get_children ((GtkContainer*) fileMenuShell), _g_list_free0 (children), _tmp57_);
		recentFileItem = _g_object_ref0 (GTK_MENU_ITEM (g_list_nth (children, (guint) 2)->data));
		gtk_menu_item_set_submenu (recentFileItem, (GtkWidget*) recentChooserMenu);
		self->priv->currentPreferences = (_tmp58_ = preferences_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentPreferences), _tmp58_);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		self->priv->profileChanged = FALSE;
		if (!(self->priv->_startupProfileFilename == NULL)) {
			moserial_main_window_loadProfileOnStartup (self, self->priv->_startupProfileFilename);
		}
		self->priv->currentPaths = (_tmp59_ = default_paths_loadFromProfile (self->priv->profile), _g_object_unref0 (self->priv->currentPaths), _tmp59_);
		_g_object_unref0 (quit);
		_g_object_unref0 (saveAs);
		_g_object_unref0 (save);
		_g_object_unref0 (open);
		_g_object_unref0 (editMenuItem);
		_g_object_unref0 (pasteMenuItem);
		_g_object_unref0 (clearMenuItem);
		_g_object_unref0 (helpButton);
		_g_object_unref0 (about);
		_g_object_unref0 (preferences);
		_g_object_unref0 (contents);
		_g_object_unref0 (incomingAsciiScrolledWindow);
		_g_object_unref0 (incomingHexScrolledWindow);
		_g_object_unref0 (outgoingAsciiScrolledWindow);
		_g_object_unref0 (outgoingHexScrolledWindow);
		_g_object_unref0 (recentManager);
		_g_object_unref0 (recentChooserMenu);
		_g_object_unref0 (filter);
		_g_object_unref0 (menuBar);
		_g_list_free0 (children);
		_g_object_unref0 (fileMenu);
		_g_object_unref0 (fileMenuShell);
		_g_object_unref0 (recentFileItem);
	}
	return obj;
}


static void moserial_main_window_class_init (moserialMainWindowClass * klass) {
	moserial_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialMainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME, g_param_spec_string ("startupProfileFilename", "startupProfileFilename", "startupProfileFilename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void moserial_main_window_instance_init (moserialMainWindow * self) {
	self->priv = MOSERIAL_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->serialConnection = moserial_serial_connection_new ();
	self->priv->streamRecorder = moserial_serial_stream_recorder_new ();
	self->priv->recordDataReceived = FALSE;
	self->priv->recordTimeoutID = (guint) 0;
	self->priv->profileFilename = NULL;
	self->priv->profileChanged = FALSE;
}


static void moserial_main_window_finalize (GObject* obj) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->gtkWindow);
	_g_object_unref0 (self->priv->settingsDialog);
	_g_object_unref0 (self->priv->settingsButton);
	_g_object_unref0 (self->priv->recordButton);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->currentPreferences);
	_g_object_unref0 (self->priv->currentPaths);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->bytecountbar);
	_g_object_unref0 (self->priv->send);
	_g_object_unref0 (self->priv->sendProgressDialog);
	_g_object_unref0 (self->priv->sendChooserDialog);
	_g_object_unref0 (self->priv->receive);
	_g_object_unref0 (self->priv->receiveProgressDialog);
	_g_object_unref0 (self->priv->receiveChooserDialog);
	_g_object_unref0 (self->priv->recordDialog);
	_g_object_unref0 (self->priv->preferencesDialog);
	_g_object_unref0 (self->priv->serialConnection);
	_g_object_unref0 (self->priv->incomingHexTextView);
	_g_object_unref0 (self->priv->incomingAsciiTextView);
	_g_object_unref0 (self->priv->outgoingHexTextView);
	_g_object_unref0 (self->priv->outgoingAsciiTextView);
	_g_object_unref0 (self->priv->inputMode);
	_g_object_unref0 (self->priv->terminationMode);
	_g_object_unref0 (self->priv->connectButton);
	_g_object_unref0 (self->priv->disconnectLabel);
	_g_object_unref0 (self->priv->connectLabel);
	_g_object_unref0 (self->priv->recordLabel);
	_g_object_unref0 (self->priv->stopRecordingLabel);
	_g_object_unref0 (self->priv->paned);
	_g_object_unref0 (self->priv->incoming_notebook);
	_g_object_unref0 (self->priv->outgoing_notebook);
	_g_object_unref0 (self->priv->incomingHexTextBuffer);
	_g_object_unref0 (self->priv->outgoingHexTextBuffer);
	_g_object_unref0 (self->priv->incomingAsciiTextBuffer);
	_g_object_unref0 (self->priv->echoTag);
	_g_object_unref0 (self->priv->outgoingAsciiTextBuffer);
	_g_object_unref0 (self->priv->echoStartMark);
	_g_object_unref0 (self->priv->xmodemFilenameDialog);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->sendButton);
	_moserial_serial_stream_recorder_unref0 (self->priv->streamRecorder);
	_g_object_unref0 (self->priv->rz);
	_g_object_unref0 (self->priv->sz);
	_g_object_unref0 (self->priv->profile);
	_g_free0 (self->priv->_startupProfileFilename);
	_g_free0 (self->priv->profileFilename);
	_g_object_unref0 (self->priv->cutMenuItem);
	_g_object_unref0 (self->priv->copyMenuItem);
	_g_object_unref0 (self->priv->va1);
	_g_object_unref0 (self->priv->va2);
	_g_object_unref0 (self->priv->va3);
	_g_object_unref0 (self->priv->va4);
	G_OBJECT_CLASS (moserial_main_window_parent_class)->finalize (obj);
}


GType moserial_main_window_get_type (void) {
	static GType moserial_main_window_type_id = 0;
	if (moserial_main_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialMainWindow), 0, (GInstanceInitFunc) moserial_main_window_instance_init, NULL };
		moserial_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "moserialMainWindow", &g_define_type_info, 0);
	}
	return moserial_main_window_type_id;
}


static void moserial_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		g_value_set_object (value, moserial_main_window_get_builder (self));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		g_value_set_string (value, moserial_main_window_get_startupProfileFilename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		moserial_main_window_set_builder (self, g_value_get_object (value));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		moserial_main_window_set_startupProfileFilename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




