/* readonlycollection.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;
typedef struct _GeeReadOnlyCollectionPrivate GeeReadOnlyCollectionPrivate;

#define GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR (gee_read_only_collection_iterator_get_type ())
#define GEE_READ_ONLY_COLLECTION_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIterator))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR))
#define GEE_READ_ONLY_COLLECTION_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorClass))

typedef struct _GeeReadOnlyCollectionIterator GeeReadOnlyCollectionIterator;
typedef struct _GeeReadOnlyCollectionIteratorClass GeeReadOnlyCollectionIteratorClass;
typedef struct _GeeReadOnlyCollectionIteratorPrivate GeeReadOnlyCollectionIteratorPrivate;

/**
 * Implemented by classes that support a simple iteration over instances of the
 * collection.
 */
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

/**
 * Implemented by classes that support a simple iteration over instances of the
 * collection.
 */
struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

/**
 * Serves as the base interface for implementing collection classes. Defines
 * size, iteration, and modification methods.
 */
struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
};

/**
 * Represents a read-only collection of items.
 */
struct _GeeReadOnlyCollection {
	GObject parent_instance;
	GeeReadOnlyCollectionPrivate * priv;
};

struct _GeeReadOnlyCollectionClass {
	GObjectClass parent_class;
};

struct _GeeReadOnlyCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeCollection* _collection;
};

struct _GeeReadOnlyCollectionIterator {
	GObject parent_instance;
	GeeReadOnlyCollectionIteratorPrivate * priv;
};

struct _GeeReadOnlyCollectionIteratorClass {
	GObjectClass parent_class;
};

struct _GeeReadOnlyCollectionIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};


static gpointer gee_read_only_collection_iterator_parent_class = NULL;
static GeeIteratorIface* gee_read_only_collection_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_read_only_collection_parent_class = NULL;
static GeeIterableIface* gee_read_only_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_read_only_collection_gee_collection_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_read_only_collection_get_type (void);
#define GEE_READ_ONLY_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionPrivate))
enum  {
	GEE_READ_ONLY_COLLECTION_DUMMY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_SIZE,
	GEE_READ_ONLY_COLLECTION_IS_EMPTY,
	GEE_READ_ONLY_COLLECTION_COLLECTION,
	GEE_READ_ONLY_COLLECTION_ELEMENT_TYPE,
	GEE_READ_ONLY_COLLECTION_G_TYPE,
	GEE_READ_ONLY_COLLECTION_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC
};
static void gee_read_only_collection_set_collection (GeeReadOnlyCollection* self, GeeCollection* value);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static GType gee_read_only_collection_iterator_get_type (void);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
static GeeIterator* gee_read_only_collection_real_iterator (GeeIterable* base);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
static gboolean gee_read_only_collection_real_contains (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_collection_real_add (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_collection_real_remove (GeeCollection* base, gconstpointer item);
static void gee_read_only_collection_real_clear (GeeCollection* base);
static gboolean gee_read_only_collection_real_add_all (GeeCollection* base, GeeCollection* collection);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
static gboolean gee_read_only_collection_real_contains_all (GeeCollection* base, GeeCollection* collection);
static gboolean gee_read_only_collection_real_remove_all (GeeCollection* base, GeeCollection* collection);
static gboolean gee_read_only_collection_real_retain_all (GeeCollection* base, GeeCollection* collection);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
static gpointer* gee_read_only_collection_real_to_array (GeeCollection* base, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
gboolean gee_collection_get_is_empty (GeeCollection* self);
#define GEE_READ_ONLY_COLLECTION_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, GeeReadOnlyCollectionIteratorPrivate))
enum  {
	GEE_READ_ONLY_COLLECTION_ITERATOR_DUMMY_PROPERTY,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC,
	GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_read_only_collection_iterator_real_next (GeeIterator* base);
static gpointer gee_read_only_collection_iterator_real_get (GeeIterator* base);
static void gee_read_only_collection_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_read_only_collection_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_read_only_collection_finalize (GObject* obj);
static void gee_read_only_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_read_only_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection) {
	GParameter * __params;
	GParameter * __params_it;
	GeeReadOnlyCollection * self;
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	__params_it->name = "g-type";
	g_value_init (&__params_it->value, G_TYPE_GTYPE);
	g_value_set_gtype (&__params_it->value, g_type);
	__params_it++;
	__params_it->name = "g-dup-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_dup_func);
	__params_it++;
	__params_it->name = "g-destroy-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_destroy_func);
	__params_it++;
	__params_it->name = "collection";
	g_value_init (&__params_it->value, GEE_TYPE_COLLECTION);
	g_value_set_object (&__params_it->value, collection);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection) {
	return gee_read_only_collection_construct (GEE_TYPE_READ_ONLY_COLLECTION, g_type, g_dup_func, g_destroy_func, collection);
}


static GeeIterator* gee_read_only_collection_real_iterator (GeeIterable* base) {
	GeeReadOnlyCollection * self;
	GeeIterator* result;
	self = (GeeReadOnlyCollection*) base;
	if (self->priv->_collection == NULL) {
		result = (GeeIterator*) gee_read_only_collection_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func);
		return result;
	}
	result = gee_iterable_iterator ((GeeIterable*) self->priv->_collection);
	return result;
}


static gboolean gee_read_only_collection_real_contains (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	if (self->priv->_collection == NULL) {
		result = FALSE;
		return result;
	}
	result = gee_collection_contains (self->priv->_collection, item);
	return result;
}


static gboolean gee_read_only_collection_real_add (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}


static gboolean gee_read_only_collection_real_remove (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}


static void gee_read_only_collection_real_clear (GeeCollection* base) {
	GeeReadOnlyCollection * self;
	self = (GeeReadOnlyCollection*) base;
	g_assert_not_reached ();
}


static gboolean gee_read_only_collection_real_add_all (GeeCollection* base, GeeCollection* collection) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}


static gboolean gee_read_only_collection_real_contains_all (GeeCollection* base, GeeCollection* collection) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) collection);
		while (TRUE) {
			gpointer element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = gee_iterator_get (_element_it);
			if (!gee_collection_contains ((GeeCollection*) self, element)) {
				result = FALSE;
				((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
				(_element_it == NULL) ? NULL : (_element_it = (g_object_unref (_element_it), NULL));
				return result;
			}
			((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
		}
		(_element_it == NULL) ? NULL : (_element_it = (g_object_unref (_element_it), NULL));
	}
	result = TRUE;
	return result;
}


static gboolean gee_read_only_collection_real_remove_all (GeeCollection* base, GeeCollection* collection) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}


static gboolean gee_read_only_collection_real_retain_all (GeeCollection* base, GeeCollection* collection) {
	GeeReadOnlyCollection * self;
	gboolean result;
	self = (GeeReadOnlyCollection*) base;
	g_return_val_if_fail (collection != NULL, FALSE);
	g_assert_not_reached ();
}


static gpointer* gee_read_only_collection_real_to_array (GeeCollection* base, int* result_length1) {
	GeeReadOnlyCollection * self;
	gpointer* result;
	gint _tmp0_;
	gpointer* _tmp1_;
	self = (GeeReadOnlyCollection*) base;
	_tmp1_ = NULL;
	result = (_tmp1_ = gee_collection_to_array (self->priv->_collection, &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
	return result;
}


static gint gee_read_only_collection_real_get_size (GeeCollection* base) {
	gint result;
	GeeReadOnlyCollection* self;
	self = (GeeReadOnlyCollection*) base;
	result = gee_collection_get_size (self->priv->_collection);
	return result;
}


static gboolean gee_read_only_collection_real_get_is_empty (GeeCollection* base) {
	gboolean result;
	GeeReadOnlyCollection* self;
	self = (GeeReadOnlyCollection*) base;
	result = gee_collection_get_is_empty (self->priv->_collection);
	return result;
}


static void gee_read_only_collection_set_collection (GeeReadOnlyCollection* self, GeeCollection* value) {
	GeeCollection* _tmp1_;
	GeeCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_collection = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_object_ref (_tmp0_)), (self->priv->_collection == NULL) ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL)), _tmp1_);
	g_object_notify ((GObject *) self, "collection");
}


static GType gee_read_only_collection_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeReadOnlyCollection* self;
	self = (GeeReadOnlyCollection*) base;
	result = self->priv->g_type;
	return result;
}


static gboolean gee_read_only_collection_iterator_real_next (GeeIterator* base) {
	GeeReadOnlyCollectionIterator * self;
	gboolean result;
	self = (GeeReadOnlyCollectionIterator*) base;
	result = FALSE;
	return result;
}


static gpointer gee_read_only_collection_iterator_real_get (GeeIterator* base) {
	GeeReadOnlyCollectionIterator * self;
	gpointer result;
	self = (GeeReadOnlyCollectionIterator*) base;
	result = NULL;
	return result;
}


static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GParameter * __params;
	GParameter * __params_it;
	GeeReadOnlyCollectionIterator * self;
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "g-type";
	g_value_init (&__params_it->value, G_TYPE_GTYPE);
	g_value_set_gtype (&__params_it->value, g_type);
	__params_it++;
	__params_it->name = "g-dup-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_dup_func);
	__params_it++;
	__params_it->name = "g-destroy-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_destroy_func);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static GeeReadOnlyCollectionIterator* gee_read_only_collection_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_read_only_collection_iterator_construct (GEE_READ_ONLY_COLLECTION_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func);
}


static void gee_read_only_collection_iterator_class_init (GeeReadOnlyCollectionIteratorClass * klass) {
	gee_read_only_collection_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyCollectionIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_collection_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_collection_iterator_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_read_only_collection_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_read_only_collection_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_read_only_collection_iterator_real_next;
	iface->get = gee_read_only_collection_iterator_real_get;
}


static void gee_read_only_collection_iterator_instance_init (GeeReadOnlyCollectionIterator * self) {
	self->priv = GEE_READ_ONLY_COLLECTION_ITERATOR_GET_PRIVATE (self);
}


static GType gee_read_only_collection_iterator_get_type (void) {
	static GType gee_read_only_collection_iterator_type_id = 0;
	if (gee_read_only_collection_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollectionIterator), 0, (GInstanceInitFunc) gee_read_only_collection_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_read_only_collection_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_collection_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollectionIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_collection_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_read_only_collection_iterator_type_id;
}


static void gee_read_only_collection_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollectionIterator * self;
	gpointer boxed;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollectionIterator * self;
	self = GEE_READ_ONLY_COLLECTION_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_read_only_collection_class_init (GeeReadOnlyCollectionClass * klass) {
	gee_read_only_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyCollectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_IS_EMPTY, "is-empty");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_COLLECTION, g_param_spec_object ("collection", "collection", "collection", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_COLLECTION_ELEMENT_TYPE, "element-type");
}


static void gee_read_only_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_read_only_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = gee_read_only_collection_real_iterator;
	iface->get_element_type = gee_read_only_collection_real_get_element_type;
}


static void gee_read_only_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_read_only_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = gee_read_only_collection_real_contains;
	iface->add = gee_read_only_collection_real_add;
	iface->remove = gee_read_only_collection_real_remove;
	iface->clear = gee_read_only_collection_real_clear;
	iface->add_all = gee_read_only_collection_real_add_all;
	iface->contains_all = gee_read_only_collection_real_contains_all;
	iface->remove_all = gee_read_only_collection_real_remove_all;
	iface->retain_all = gee_read_only_collection_real_retain_all;
	iface->to_array = gee_read_only_collection_real_to_array;
	iface->get_size = gee_read_only_collection_real_get_size;
	iface->get_is_empty = gee_read_only_collection_real_get_is_empty;
}


static void gee_read_only_collection_instance_init (GeeReadOnlyCollection * self) {
	self->priv = GEE_READ_ONLY_COLLECTION_GET_PRIVATE (self);
}


static void gee_read_only_collection_finalize (GObject* obj) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (obj);
	(self->priv->_collection == NULL) ? NULL : (self->priv->_collection = (g_object_unref (self->priv->_collection), NULL));
	G_OBJECT_CLASS (gee_read_only_collection_parent_class)->finalize (obj);
}


GType gee_read_only_collection_get_type (void) {
	static GType gee_read_only_collection_type_id = 0;
	if (gee_read_only_collection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyCollection), 0, (GInstanceInitFunc) gee_read_only_collection_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_read_only_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyCollection", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_read_only_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
	}
	return gee_read_only_collection_type_id;
}


static void gee_read_only_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollection * self;
	gpointer boxed;
	self = GEE_READ_ONLY_COLLECTION (object);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_SIZE:
		g_value_set_int (value, gee_collection_get_size ((GeeCollection*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_IS_EMPTY:
		g_value_set_boolean (value, gee_collection_get_is_empty ((GeeCollection*) self));
		break;
		case GEE_READ_ONLY_COLLECTION_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyCollection * self;
	self = GEE_READ_ONLY_COLLECTION (object);
	switch (property_id) {
		case GEE_READ_ONLY_COLLECTION_COLLECTION:
		gee_read_only_collection_set_collection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




