
/*  A Bison parser, made from /tmp/gnumeric/src/parser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	257
#define	QUOTED_STRING	258
#define	CONSTANT	259
#define	CELLREF	260
#define	GTE	261
#define	LTE	262
#define	NE	263
#define	SEPARATOR	264
#define	INVALID_TOKEN	265
#define	NEG	266
#define	PLUS	267
#define	RANGE_SEP	268
#define	SHEET_SEP	269

#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998-2000 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jgoldberg@home.com)
 *    Morten Welinder (terra@diku.dk)
 *    Almer S. Tigelaar (almer@gnome.org)
 */
#include <config.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include "gnumeric.h"
#include "number-match.h"
#include "expr.h"
#include "expr-name.h"
#include "sheet.h"
#include "format.h"
#include "application.h"
#include "parse-util.h"
#include "gutils.h"
#include "auto-format.h"
#include "style.h"
#include "portability.h"
#include "str.h"

/* #define YYDEBUG 1 */
/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list (GList *list)
{
	GList *l;
	for (l = list; l; l = l->next)
		expr_tree_unref (l->data);
	g_list_free (list);
}

static void
free_expr_list_list (GList *list)
{
	GList *l;
	for (l = list; l; l = l->next)
		free_expr_list (l->data);
	g_list_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

static void
deallocate_uninit (void)
{
#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
#endif
}

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < (int)deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (void *data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((expr), (ParseDeallocator)&expr_tree_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (void const *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 *
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos + 2);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

#define ERROR -1

/* Bison/Yacc internals */
static int  yylex (void);
static int  yyerror (char *s);

typedef struct {
	/* The expression being parsed */
	char const *expr_text;

	/* A backup of the above, this will always point to the real
	 * expression beginning to calculate the offset in the expression
	 */
	char const *expr_backup;

	/* Location where the parsing is taking place */
	ParsePos const *pos;

	/* Locale info. */
	char decimal_point;
	char separator;
	char array_col_separator;

	/* flags */
	gboolean use_excel_reference_conventions;
	gboolean create_place_holder_for_unknown_func;

	/* The suggested format to use for this expression */
	StyleFormat **desired_format;
	ExprTree *result;

	ParseError *error;
} ParserState;

/* The error returned from the */
static ParserState *state;

static ExprTree *
build_unary_op (Operation op, ExprTree *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (expr_tree_new_unary (op, expr));
}

static ExprTree *
build_binop (ExprTree *l, Operation op, ExprTree *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (expr_tree_new_binary (l, op, r));
}

static ExprTree *
build_array (GList *cols)
{
	Value *array;
	GList *row;
	int x, mx, y;

	if (!cols) {
		/* parser_error = PARSE_ERR_SYNTAX; */
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = row->next;
	}

	array = value_new_array_empty (mx, g_list_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			ExprTree *expr = row->data;
			Value    *v = expr->constant.value;

			g_assert (expr->any.oper == OPER_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = row->next;
		}
		if (x < mx || row) {
			/* parser_error = PARSE_ERR_SYNTAX; */
			value_release (array);
			return NULL;
		}
		y++;
		cols = cols->next;
	}

	return register_expr_allocation (expr_tree_new_constant (array));
}

static gboolean
parse_string_as_value (ExprTree *str)
{
	/*
	 * Try to parse the entered text as a basic value (empty, bool, int,
	 * float, err) if this succeeds, we store this as a Value otherwise, we
	 * return a string.
	 */
	char const *txt = str->constant.value->v_str.val->str;
	Value *v = format_match_simple (txt);

	if (v != NULL) {
		value_release (str->constant.value);
		str->constant.value = v;
		return TRUE;
	}
	return FALSE;
}

/**
 * parse_string_as_value_or_name :
 * @str : An expression with oper constant, whose value is a string.
 *
 * Check to see if a string is a name
 * if it is not check to see if it can be parsed as a value
 */
static ExprTree *
parse_string_as_value_or_name (ExprTree *str)
{
	NamedExpression *expr_name;

	expr_name = expr_name_lookup (state->pos, str->constant.value->v_str.val->str);
	if (expr_name != NULL) {
		unregister_allocation (str); expr_tree_unref (str);
		return register_expr_allocation (expr_tree_new_name (expr_name));
	}

	/* NOTE : parse_string_as_value modifies str in place */
	parse_string_as_value (str);
	return str;
}

static int
gnumeric_parse_error (ParserState *state, ParseErrorID id, char *message, int end, int relative_begin)
{
	g_return_val_if_fail (state->error != NULL, ERROR);

	state->error->id         = id;
	state->error->message    = message;
	state->error->begin_char = (end - relative_begin);
	state->error->end_char   = end;

	return ERROR;
}

/* Make byacc happier */
int yyparse (void);


#line 352 "parser.y"
typedef union {
	ExprTree *tree;
	CellRef  *cell;
	GList    *list;
	Sheet	 *sheet;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		81
#define	YYFLAG		-32768
#define	YYNTBASE	34

#define YYTRANSLATE(x) ((unsigned)(x) <= 269 ? yytranslate[x] : 44)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,    25,    12,     2,    26,
    27,    18,    17,     2,    16,     2,    19,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    33,    13,
    15,    14,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    30,    32,    31,    24,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    28,     2,    29,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    20,    21,    22,    23
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     6,     8,    10,    12,    16,    20,    24,
    28,    32,    36,    40,    44,    48,    52,    56,    60,    64,
    67,    70,    73,    77,    82,    85,    87,    89,    92,    98,
   100,   101,   103,   106,   110,   116,   118,   122,   125,   126,
   128,   130,   132,   136,   140,   141,   143
};

static const short yyrhs[] = {    35,
     0,     1,     0,     5,     0,     4,     0,     3,     0,    39,
     0,    35,    17,    35,     0,    35,    16,    35,     0,    35,
    18,    35,     0,    35,    19,    35,     0,    35,    24,    35,
     0,    35,    12,    35,     0,    35,    15,    35,     0,    35,
    13,    35,     0,    35,    14,    35,     0,    35,     7,    35,
     0,    35,     9,    35,     0,    35,     8,    35,     0,    26,
    35,    27,     0,    35,    25,     0,    16,    35,     0,    17,
    35,     0,    28,    43,    29,     0,     3,    26,    40,    27,
     0,    37,    36,     0,     3,     0,     4,     0,    36,    23,
     0,    30,    36,    31,    36,    23,     0,    37,     0,     0,
     6,     0,    37,     6,     0,     6,    22,     6,     0,    37,
     6,    22,    38,     6,     0,    35,     0,    35,    10,    40,
     0,    10,    40,     0,     0,     5,     0,    36,     0,    41,
     0,    41,    10,    42,     0,    41,    32,    42,     0,     0,
    42,     0,    42,    33,    43,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   375,   380,   388,   389,   390,   391,   392,   393,   394,   395,
   396,   397,   398,   399,   400,   401,   402,   403,   404,   406,
   407,   408,   410,   416,   435,   456,   457,   460,   476,   509,
   510,   513,   517,   522,   533,   548,   553,   559,   569,   572,
   573,   576,   581,   594,   608,   611,   616
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STRING",
"QUOTED_STRING","CONSTANT","CELLREF","GTE","LTE","NE","SEPARATOR","INVALID_TOKEN",
"'&'","'<'","'>'","'='","'-'","'+'","'*'","'/'","NEG","PLUS","RANGE_SEP","SHEET_SEP",
"'^'","'%'","'('","')'","'{'","'}'","'['","']'","'\\\\'","';'","line","exp",
"string_opt_quote","sheetref","opt_sheetref","cellref","arg_list","array_exp",
"array_row","array_cols", NULL
};
#endif

static const short yyr1[] = {     0,
    34,    34,    35,    35,    35,    35,    35,    35,    35,    35,
    35,    35,    35,    35,    35,    35,    35,    35,    35,    35,
    35,    35,    35,    35,    35,    36,    36,    37,    37,    38,
    38,    39,    39,    39,    39,    40,    40,    40,    40,    41,
    41,    42,    42,    42,    42,    43,    43
};

static const short yyr2[] = {     0,
     1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
     2,     2,     3,     4,     2,     1,     1,     2,     5,     1,
     0,     1,     2,     3,     5,     1,     3,     2,     0,     1,
     1,     1,     3,     3,     0,     1,     3
};

static const short yydefact[] = {     0,
     2,     5,     4,     3,    32,     0,     0,     0,    45,     0,
     1,     0,     0,     6,    39,     0,    21,    22,     0,    26,
    27,    40,    41,    42,    46,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    20,
    28,    33,    25,    39,    36,     0,    34,    19,    45,    45,
    45,    23,     0,    16,    18,    17,    12,    14,    15,    13,
     8,     7,     9,    10,    11,    31,    38,    39,    24,    43,
    44,    47,     0,    30,     0,    37,    29,    35,     0,     0,
     0
};

static const short yydefgoto[] = {    79,
    45,    12,    13,    75,    14,    46,    24,    25,    26
};

static const short yypact[] = {     2,
-32768,    46,    -7,-32768,     0,    62,    62,    62,    58,    35,
   121,     4,    31,-32768,    54,    23,    49,    49,    86,-32768,
-32768,-32768,-32768,     1,    -2,    14,    50,    62,    62,    62,
    62,    62,    62,    62,    62,    62,    62,    62,    62,-32768,
-32768,    55,-32768,    54,   107,    56,-32768,-32768,    58,    58,
    58,-32768,    35,    -4,    -4,    -4,   134,    -4,    -4,    -4,
   136,   136,    49,    49,    49,     6,-32768,    54,-32768,-32768,
-32768,-32768,    63,-32768,    79,-32768,-32768,-32768,    87,    89,
-32768
};

static const short yypgoto[] = {-32768,
    17,    -9,    25,-32768,-32768,   -42,-32768,    26,    45
};


#define	YYLAST		161


static const short yytable[] = {    23,
    27,    67,     1,    43,     2,     3,     4,     5,    20,    21,
    49,    35,    36,    37,    38,   -27,    11,     6,     7,    39,
    40,    16,    17,    18,    19,    76,    41,     8,    47,     9,
    51,    10,    50,    20,    21,    10,    42,    20,    21,    23,
    23,    23,    52,    73,    54,    55,    56,    57,    58,    59,
    60,    61,    62,    63,    64,    65,     2,     3,     4,     5,
    20,    21,    22,    44,     2,     3,     4,     5,   -26,     6,
     7,    15,    39,    40,    70,    71,    66,     6,     7,     8,
    53,     9,    69,    10,    78,    77,    80,     8,    81,     9,
    74,    10,    28,    29,    30,    72,     0,    31,    32,    33,
    34,    35,    36,    37,    38,     0,     0,     0,     0,    39,
    40,     0,    48,    28,    29,    30,    68,     0,    31,    32,
    33,    34,    35,    36,    37,    38,     0,    28,    29,    30,
    39,    40,    31,    32,    33,    34,    35,    36,    37,    38,
    28,    29,    30,     0,    39,    40,    32,    33,    34,    35,
    36,    37,    38,    37,    38,     0,     0,    39,    40,    39,
    40
};

static const short yycheck[] = {     9,
    10,    44,     1,    13,     3,     4,     5,     6,     3,     4,
    10,    16,    17,    18,    19,    23,     0,    16,    17,    24,
    25,    22,     6,     7,     8,    68,    23,    26,     6,    28,
    33,    30,    32,     3,     4,    30,     6,     3,     4,    49,
    50,    51,    29,    53,    28,    29,    30,    31,    32,    33,
    34,    35,    36,    37,    38,    39,     3,     4,     5,     6,
     3,     4,     5,    10,     3,     4,     5,     6,    23,    16,
    17,    26,    24,    25,    49,    50,    22,    16,    17,    26,
    31,    28,    27,    30,     6,    23,     0,    26,     0,    28,
    66,    30,     7,     8,     9,    51,    -1,    12,    13,    14,
    15,    16,    17,    18,    19,    -1,    -1,    -1,    -1,    24,
    25,    -1,    27,     7,     8,     9,    10,    -1,    12,    13,
    14,    15,    16,    17,    18,    19,    -1,     7,     8,     9,
    24,    25,    12,    13,    14,    15,    16,    17,    18,    19,
     7,     8,     9,    -1,    24,    25,    13,    14,    15,    16,
    17,    18,    19,    18,    19,    -1,    -1,    24,    25,    24,
    25
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 375 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		state->result = yyvsp[0].tree;
	;
    break;}
case 2:
#line 380 "parser.y"
{
		if (state->result != NULL) {
			expr_tree_unref (state->result);
			state->result = NULL;
		}
	;
    break;}
case 3:
#line 388 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 4:
#line 389 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 5:
#line 390 "parser.y"
{ yyval.tree = parse_string_as_value_or_name (yyvsp[0].tree); ;
    break;}
case 6:
#line 391 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 7:
#line 392 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_ADD,       yyvsp[0].tree); ;
    break;}
case 8:
#line 393 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_SUB,       yyvsp[0].tree); ;
    break;}
case 9:
#line 394 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_MULT,      yyvsp[0].tree); ;
    break;}
case 10:
#line 395 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_DIV,       yyvsp[0].tree); ;
    break;}
case 11:
#line 396 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EXP,       yyvsp[0].tree); ;
    break;}
case 12:
#line 397 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_CONCAT,    yyvsp[0].tree); ;
    break;}
case 13:
#line 398 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_EQUAL,     yyvsp[0].tree); ;
    break;}
case 14:
#line 399 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LT,        yyvsp[0].tree); ;
    break;}
case 15:
#line 400 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GT,        yyvsp[0].tree); ;
    break;}
case 16:
#line 401 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_GTE,       yyvsp[0].tree); ;
    break;}
case 17:
#line 402 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_NOT_EQUAL, yyvsp[0].tree); ;
    break;}
case 18:
#line 403 "parser.y"
{ yyval.tree = build_binop (yyvsp[-2].tree, OPER_LTE,       yyvsp[0].tree); ;
    break;}
case 19:
#line 404 "parser.y"
{ yyval.tree = yyvsp[-1].tree; ;
    break;}
case 20:
#line 406 "parser.y"
{ yyval.tree = build_unary_op (OPER_PERCENT, yyvsp[-1].tree); ;
    break;}
case 21:
#line 407 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_NEG, yyvsp[0].tree); ;
    break;}
case 22:
#line 408 "parser.y"
{ yyval.tree = build_unary_op (OPER_UNARY_PLUS, yyvsp[0].tree); ;
    break;}
case 23:
#line 410 "parser.y"
{
		unregister_allocation (yyvsp[-1].list);
		yyval.tree = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	;
    break;}
case 24:
#line 416 "parser.y"
{
		char const *name = yyvsp[-3].tree->constant.value->v_str.val->str;
		FunctionDefinition *f = func_lookup_by_name (name,
			state->pos->wb);

		/* THINK TODO: Do we want to make this workbook-local??  */
		if (f == NULL && state->create_place_holder_for_unknown_func)
			f = function_add_placeholder (name, "");

		unregister_allocation (yyvsp[-1].list);
		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);

		if (f == NULL) {
			free_expr_list (yyvsp[-1].list);
			YYERROR;
		} else {
			yyval.tree = register_expr_allocation (expr_tree_new_funcall (f, yyvsp[-1].list));
		}
	;
    break;}
case 25:
#line 435 "parser.y"
{
		NamedExpression *expr_name;
		char *name = yyvsp[0].tree->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = yyvsp[-1].sheet;
		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Expression '%s' does not exist on sheet '%s'"), name, yyvsp[-1].sheet->name_quoted),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
	        yyval.tree = register_expr_allocation (expr_tree_new_name (expr_name));
	;
    break;}
case 28:
#line 460 "parser.y"
{
	        char  *name = yyvsp[-1].tree->constant.value->v_str.val->str;
		Sheet *sheet = sheet_lookup_by_name (state->pos->wb, name);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), name),
				state->expr_text - state->expr_backup, strlen (name));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
	        yyval.sheet = sheet;
	;
    break;}
case 29:
#line 476 "parser.y"
{
		/* TODO : Get rid of ParseErr and replace it with something richer.
		 * The replace ment should include more detail as to what the error
		 * was,  and where in the expr string to highlight.
		 *
		 * e.g. for =1+Sheet!A1+2
		 *  We should return "Unknow Sheet 'Sheet'" and the indicies 3:7
		 *  to mark the offending region.
		 */
		Workbook * wb =
		    application_workbook_get_by_name (yyvsp[-3].tree->constant.value->v_str.val->str);
		Sheet *sheet = NULL;
		char *sheetname = yyvsp[-1].tree->constant.value->v_str.val->str;

		if (wb != NULL)
			sheet = sheet_lookup_by_name (wb, sheetname);

		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), sheetname),
				state->expr_text - state->expr_backup, strlen (sheetname));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);

	        yyval.sheet = sheet;
        ;
    break;}
case 31:
#line 510 "parser.y"
{ yyval.sheet = NULL; ;
    break;}
case 32:
#line 513 "parser.y"
{
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 33:
#line 517 "parser.y"
{
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet;
	        yyval.tree = yyvsp[0].tree;
	;
    break;}
case 34:
#line 522 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-2].tree);
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-2].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));
		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-2].tree);
	;
    break;}
case 35:
#line 533 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-3].tree);
		yyvsp[-3].tree->var.ref.sheet = yyvsp[-4].sheet;
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet ? yyvsp[-1].sheet : yyvsp[-4].sheet;
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-3].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));

		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-3].tree);
	;
    break;}
case 36:
#line 548 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 37:
#line 553 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].tree);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
		register_expr_list_allocation (yyval.list);
	;
    break;}
case 38:
#line 559 "parser.y"
{
		GList *tmp = yyvsp[0].list;
		unregister_allocation (yyvsp[0].list);

		if (tmp == NULL)
			tmp = g_list_prepend (NULL, expr_tree_new_constant (value_new_empty ()));

		yyval.list = g_list_prepend (tmp, expr_tree_new_constant (value_new_empty ()));
		register_expr_list_allocation (yyval.list);
	;
    break;}
case 39:
#line 569 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 40:
#line 572 "parser.y"
{ yyval.tree = yyvsp[0].tree; ;
    break;}
case 41:
#line 573 "parser.y"
{ parse_string_as_value (yyvsp[0].tree); yyval.tree = yyvsp[0].tree; ;
    break;}
case 42:
#line 576 "parser.y"
{
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_list_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        ;
    break;}
case 43:
#line 581 "parser.y"
{
		if (state->array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	;
    break;}
case 44:
#line 594 "parser.y"
{
		if (state->array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			/* FIXME: Is this the right error to display? */
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	;
    break;}
case 45:
#line 608 "parser.y"
{ yyval.list = NULL; ;
    break;}
case 46:
#line 611 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_list_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        ;
    break;}
case 47:
#line 616 "parser.y"
{
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_list_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 623 "parser.y"

/**
 * parse_ref_or_string :
 * @string: the string to try.
 *
 * Attempt to parse the text as a cellref, if it fails
 * return a string.
 * DO NOT attempt to do higher level lookups here.
 *     - sheet names
 *     - function names
 *     - expression names
 *     - value parsing
 * must all be handled by the parser not the lexer.
 */
static int
parse_ref_or_string (char const *string)
{
	CellRef   ref;
	Value *v = NULL;

	if (cellref_get (&ref, string, &state->pos->eval)) {
		yylval.tree = register_expr_allocation (expr_tree_new_var (&ref));
		return CELLREF;
	}

	v = value_new_string (string);
	yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
	return STRING;
}

/**
 * find_char:
 * @str:
 * @c:
 *
 * Returns a pointer to character c in str.
 * Callers should check whether p is '\0'!
 **/
static char const *
find_char (char const *str, char c)
{
	for (; *str && *str != c; str++)
		if (*str == '\\' && str[1])
			str++;
	return str;
}

static char const *
find_matching_close (char const *str, char const **res)
{
	for (; *str; str++) {
		if (*str == '(') {
			char const *tmp = str;
			str = find_matching_close (str + 1, res);
			if (*str != ')' && *res == NULL) {
				*res = tmp;
				return str;
			}
		} else if (*str == ')')
			return str;
		else if (*str == '\'' || *str == '\"')
			str = find_char (str + 1, *str);
	}

	return str;
}

int
yylex (void)
{
	int c;
	char const *start;
	gboolean is_number = FALSE;

        while (isspace ((unsigned char)*state->expr_text))
                state->expr_text++;

	start = state->expr_text;
	c = (unsigned char) (*state->expr_text++);

	if (c == '(' || c == ')')
		return c;

	if (state->use_excel_reference_conventions) {
		if (c == ':')
			return RANGE_SEP;
		if (c == '!')
			return SHEET_SEP;
	} else {
		/* Treat '..' as range sep (A1..C3) */
		if (c == '.' && *state->expr_text == '.') {
			state->expr_text++;
			return RANGE_SEP;
		}
		if (c == ':')
			return SHEET_SEP;
	}

	if (c == state->separator)
		return SEPARATOR;

	if (c == state->decimal_point) {
		/* Could be a number or a stand alone  */
		if (!isdigit ((unsigned char)(*state->expr_text)))
			return c;
		is_number = TRUE;
	} else if (isdigit (c)) {
		while (isdigit ((c = (unsigned char)(*state->expr_text++))))
			;
		is_number = TRUE;
	}

	if (is_number) {
		Value *v = NULL;

		if (c == state->decimal_point || tolower (c) == 'e') {
			/* This is float */
			char *end;
			double d;

			errno = 0;
			d = strtod (start, &end);
			if (start != end) {
				if (errno != ERANGE) {
					v = value_new_float ((gnum_float)d);
					state->expr_text = end;
				} else {
					if (tolower (c) != 'e') {
						gnumeric_parse_error (
							state, PERR_OUT_OF_RANGE,
							g_strdup (_("The number is out of range")),
							state->expr_text - state->expr_backup, end - start);
						return INVALID_TOKEN;
					} else {
						/*
						 * For an exponent it's hard to highlight
						 * the right region w/o it turning into an
						 * ugly hack, for now the cursor is put
						 * at the end.
						 */
						gnumeric_parse_error (
							state, PERR_OUT_OF_RANGE,
							g_strdup (_("The number is out of range")),
							0, 0);
						return INVALID_TOKEN;
					}
				}
			} else
				g_warning ("%s is not a double, but was expected to be one", start);
		} else {
			/* This could be a row range ref or an integer */
			char *end;
			long l;

			errno = 0;
			l = strtol (start, &end, 10);
			if (start != end) {
				if (errno != ERANGE) {
					/* Check for a Row range ref (3:4 == A3:IV4) */
					if (*end == ':' && l < SHEET_MAX_COLS) {
					    /* TODO : adjust parser to allow returning
					     * a range, not just a cellref
					     */
					}
					v = value_new_int (l);
					state->expr_text = end;
				} else {
					if (l == LONG_MIN || l == LONG_MAX) {
						gnumeric_parse_error (
							state, PERR_OUT_OF_RANGE,
							g_strdup (_("The number is out of range")),
							state->expr_text - state->expr_backup, end - start);
						return INVALID_TOKEN;
					}
				}
			} else
				g_warning ("%s is not an integer, but was expected to be one", start);
		}

		/* Very odd string,  Could be a bound problem.  Trigger an error */
		if (v == NULL)
			return c;

		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return CONSTANT;
	}

	switch (c){
	case '\'':
	case '"': {
		char const *p;
		char *string, *s;
		char quotes_end = c;
		Value *v;

 		p = state->expr_text;
 		state->expr_text = find_char (state->expr_text, quotes_end);
		if (!*state->expr_text) {
  			gnumeric_parse_error (
  				state, PERR_MISSING_CLOSING_QUOTE,
				g_strdup (_("Could not find matching closing quote")),
  				(p - state->expr_backup) + 1, 1);
			return INVALID_TOKEN;
		}

		s = string = (char *) alloca (1 + state->expr_text - p);
		while (p != state->expr_text){
			if (*p== '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;
		}
		*s = 0;
		state->expr_text++;

		v = value_new_string (string);
		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return QUOTED_STRING;
	}
	}

	if (isalpha ((unsigned char)c) || c == '_' || c == '$'){
		char const *start = state->expr_text - 1;
		char *str;
		int  len;

		while (isalnum ((unsigned char)*state->expr_text) || *state->expr_text == '_' ||
		       *state->expr_text == '$' ||
		       (state->use_excel_reference_conventions && *state->expr_text == '.'))
			state->expr_text++;

		len = state->expr_text - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return parse_ref_or_string (str);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return LTE;
		}
		if (*state->expr_text == '>'){
			state->expr_text++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

ExprTree *
gnumeric_expr_parser (char const *expr_text, ParsePos const *pos,
		      gboolean use_excel_range_conventions,
		      gboolean create_place_holder_for_unknown_func,
		      StyleFormat **desired_format,
		      ParseError *error)
{
	ParserState pstate;
	pstate.expr_text   = expr_text;
	pstate.expr_backup = expr_text;
	pstate.pos	   = pos;

	pstate.decimal_point	   = format_get_decimal ();
	pstate.separator 	   = format_get_arg_sep ();
	pstate.array_col_separator = format_get_col_sep ();

	pstate.use_excel_reference_conventions	    = use_excel_range_conventions;
	pstate.create_place_holder_for_unknown_func = create_place_holder_for_unknown_func;

	pstate.result = NULL;
	pstate.desired_format = desired_format;
	if (pstate.desired_format)
		*pstate.desired_format = NULL;

	pstate.error = error;
	
	if (deallocate_stack == NULL)
		deallocate_init ();

	g_return_val_if_fail (pstate.pos != NULL, NULL);
	g_return_val_if_fail (pstate.expr_text != NULL, NULL);
	g_return_val_if_fail (state == NULL, NULL);

	state = &pstate;
	yyparse ();
	state = NULL;

	if (pstate.result != NULL) {
		deallocate_assert_empty ();
		if (desired_format) {
			StyleFormat *format;
			EvalPos tmp;

			tmp.sheet = pos->sheet;
			tmp.eval = pos->eval;
			format = auto_style_format_suggest (pstate.result, &tmp);
			if (format) {
				/* Override the format that came from a
				 * constant somewhere inside.
				 */
				if (*desired_format)
					style_format_unref (*desired_format);
				*desired_format = format;
			}
		}
		/* If this happens, something is very wrong */
		if (pstate.error->message != NULL) {
			g_warning ("An error occurred and the ExprTree is non-null! This should not happen");
			g_warning ("Error message is %s (%d, %d)", pstate.error->message, pstate.error->begin_char,
					pstate.error->end_char);
		}
	} else {
		/* If there is no error message, attempt to be more detailed */
		if (pstate.error->message == NULL) {
			char const *last_token = pstate.expr_text - 1;

			if (*last_token == '\0') {
				char const *str = pstate.expr_backup;
				char const *res = NULL;
				char const *last = find_matching_close (str, &res);

				if (*last)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_OPEN,
						g_strdup (_("Could not find matching opening parenthesis")),
						(last - str) + 2, 1);
				else if (res != NULL)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_CLOSE,
						g_strdup (_("Could not find matching closing parenthesis")),
						(res - str) + 2, 1);
				else
					gnumeric_parse_error (&pstate, PERR_INVALID_EXPRESSION,
						g_strdup (_("Invalid expression")),
						(pstate.expr_text - pstate.expr_backup) + 1,
						(pstate.expr_text - pstate.expr_backup));
			} else
				gnumeric_parse_error (&pstate, PERR_UNEXPECTED_TOKEN,
					g_strdup_printf (_("Unexpected token %c"), *last_token),
					(last_token - pstate.expr_backup) + 1, 1);
		}

		deallocate_all ();
		if (desired_format && *desired_format) {
			style_format_unref (*desired_format);
			*desired_format = NULL;
		}
	}

	deallocate_uninit ();

	return pstate.result;
}
