/* Event.c generated by valac 0.14.0, the Vala compiler
 * generated from Event.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__dvb_event_audio_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_audio_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_video_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_video_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_teletext_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_teletext_component_unref0_ (var), NULL)))
typedef struct _DVBEventAudioComponentPrivate DVBEventAudioComponentPrivate;
typedef struct _DVBEventParamSpecAudioComponent DVBEventParamSpecAudioComponent;
typedef struct _DVBEventVideoComponentPrivate DVBEventVideoComponentPrivate;
typedef struct _DVBEventParamSpecVideoComponent DVBEventParamSpecVideoComponent;
typedef struct _DVBEventTeletextComponentPrivate DVBEventTeletextComponentPrivate;
typedef struct _DVBEventParamSpecTeletextComponent DVBEventParamSpecTeletextComponent;
typedef struct _DVBParamSpecEvent DVBParamSpecEvent;

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventAudioComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventAudioComponentPrivate * priv;
	gchar* type;
};

struct _DVBEventAudioComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventAudioComponent *self);
};

struct _DVBEventParamSpecAudioComponent {
	GParamSpec parent_instance;
};

struct _DVBEventVideoComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventVideoComponentPrivate * priv;
	gboolean high_definition;
	gchar* aspect_ratio;
	gint frequency;
};

struct _DVBEventVideoComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventVideoComponent *self);
};

struct _DVBEventParamSpecVideoComponent {
	GParamSpec parent_instance;
};

struct _DVBEventTeletextComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventTeletextComponentPrivate * priv;
	gchar* type;
};

struct _DVBEventTeletextComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventTeletextComponent *self);
};

struct _DVBEventParamSpecTeletextComponent {
	GParamSpec parent_instance;
};

struct _DVBParamSpecEvent {
	GParamSpec parent_instance;
};


static gpointer dvb_event_parent_class = NULL;
static gpointer dvb_event_audio_component_parent_class = NULL;
static gpointer dvb_event_video_component_parent_class = NULL;
static gpointer dvb_event_teletext_component_parent_class = NULL;

gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
enum  {
	DVB_EVENT_DUMMY_PROPERTY
};
static void _dvb_event_audio_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self);
static void _dvb_event_video_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self);
static void _dvb_event_teletext_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self);
#define DVB_EVENT_RUNNING_STATUS_UNDEFINED ((guint) 0)
#define DVB_EVENT_RUNNING_STATUS_NOT_RUNNING ((guint) 1)
#define DVB_EVENT_RUNNING_STATUS_STARTS_SOON ((guint) 2)
#define DVB_EVENT_RUNNING_STATUS_PAUSING ((guint) 3)
#define DVB_EVENT_RUNNING_STATUS_RUNNING ((guint) 4)
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gboolean dvb_event_has_expired (DVBEvent* self);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
gboolean dvb_event_is_running (DVBEvent* self);
void dvb_event_get_utc_start_time (DVBEvent* self, struct tm* result);
gchar* dvb_event_to_string (DVBEvent* self);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
time_t dvb_event_get_start_timestamp (DVBEvent* self);
gdouble dvb_event_get_overlap_percentage (DVBEvent* self, DVBEvent* other);
time_t dvb_utils_t_max (time_t a, time_t b);
time_t dvb_utils_t_min (time_t a, time_t b);
gint dvb_event_compare (DVBEvent* event1, DVBEvent* event2);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
guint dvb_event_hash (DVBEvent* event);
enum  {
	DVB_EVENT_AUDIO_COMPONENT_DUMMY_PROPERTY
};
DVBEventAudioComponent* dvb_event_audio_component_new (void);
DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type);
static void dvb_event_audio_component_finalize (DVBEventAudioComponent* obj);
enum  {
	DVB_EVENT_VIDEO_COMPONENT_DUMMY_PROPERTY
};
DVBEventVideoComponent* dvb_event_video_component_new (void);
DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type);
static void dvb_event_video_component_finalize (DVBEventVideoComponent* obj);
enum  {
	DVB_EVENT_TELETEXT_COMPONENT_DUMMY_PROPERTY
};
DVBEventTeletextComponent* dvb_event_teletext_component_new (void);
DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type);
static void dvb_event_teletext_component_finalize (DVBEventTeletextComponent* obj);
static void dvb_event_finalize (DVBEvent* obj);


static void _dvb_event_audio_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_audio_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_audio_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_video_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_video_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_video_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_teletext_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_teletext_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_teletext_component_unref0_, NULL);
	g_slist_free (self);
}


DVBEvent* dvb_event_construct (GType object_type) {
	DVBEvent* self = NULL;
	self = (DVBEvent*) g_type_create_instance (object_type);
	__g_slist_free__dvb_event_audio_component_unref0_0 (self->audio_components);
	self->audio_components = NULL;
	__g_slist_free__dvb_event_video_component_unref0_0 (self->video_components);
	self->video_components = NULL;
	__g_slist_free__dvb_event_teletext_component_unref0_0 (self->teletext_components);
	self->teletext_components = NULL;
	self->year = (guint) 0;
	self->month = (guint) 0;
	self->hour = (guint) 0;
	self->day = (guint) 0;
	self->minute = (guint) 0;
	self->second = (guint) 0;
	self->duration = (guint) 0;
	self->running_status = DVB_EVENT_RUNNING_STATUS_UNDEFINED;
	return self;
}


DVBEvent* dvb_event_new (void) {
	return dvb_event_construct (DVB_TYPE_EVENT);
}


/**
         * Whether the event has started and ended in the past
         */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


gboolean dvb_event_has_expired (DVBEvent* self) {
	gboolean result = FALSE;
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm current_utc;
	time_t _tmp2_ = 0;
	time_t current_time;
	time_t _tmp3_ = 0;
	time_t end_timestamp;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	g_time_gm (_tmp0_, &_tmp1_);
	current_utc = _tmp1_;
	current_utc.tm_isdst = -1;
	_tmp2_ = mktime (&current_utc);
	current_time = _tmp2_;
	_tmp3_ = dvb_event_get_end_timestamp (self);
	end_timestamp = _tmp3_;
	result = end_timestamp < current_time;
	return result;
}


gboolean dvb_event_is_running (DVBEvent* self) {
	gboolean result = FALSE;
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm time_now;
	struct tm _tmp2_ = {0};
	struct tm time_start;
	struct tm _tmp3_;
	time_t _tmp4_ = 0;
	time_t timestamp_now;
	struct tm _tmp5_;
	time_t _tmp6_ = 0;
	time_t timestamp_start;
	time_t _tmp7_;
	time_t _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	g_time_gm (_tmp0_, &_tmp1_);
	time_now = _tmp1_;
	dvb_event_get_utc_start_time (self, &_tmp2_);
	time_start = _tmp2_;
	_tmp3_ = time_now;
	_tmp4_ = timegm (&_tmp3_);
	timestamp_now = _tmp4_;
	_tmp5_ = time_start;
	_tmp6_ = timegm (&_tmp5_);
	timestamp_start = _tmp6_;
	_tmp7_ = timestamp_now;
	_tmp8_ = timestamp_start;
	if ((_tmp7_ - _tmp8_) >= ((time_t) 0)) {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = dvb_event_has_expired (self);
		result = !_tmp9_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


gchar* dvb_event_to_string (DVBEvent* self) {
	gchar* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	guint _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* text;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->id;
	_tmp1_ = self->year;
	_tmp2_ = self->month;
	_tmp3_ = self->day;
	_tmp4_ = self->hour;
	_tmp5_ = self->minute;
	_tmp6_ = self->second;
	_tmp7_ = g_strdup_printf ("ID: %u\nDate: %04u-%02u-%02u %02u:%02u:%02u\n", _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->duration;
	_tmp10_ = self->name;
	_tmp11_ = self->description;
	_tmp12_ = g_strdup_printf ("Duration: %u\nName: %s\nDescription: %s\n", _tmp9_, _tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp8_);
	text = _tmp15_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				GSList* _tmp20_;
				guint _tmp21_ = 0U;
				const gchar* _tmp22_;
				GSList* _tmp23_;
				gint _tmp24_;
				gconstpointer _tmp25_ = NULL;
				const gchar* _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = self->audio_components;
				_tmp21_ = g_slist_length (_tmp20_);
				if (!(((guint) _tmp19_) < _tmp21_)) {
					break;
				}
				_tmp22_ = text;
				_tmp23_ = self->audio_components;
				_tmp24_ = i;
				_tmp25_ = g_slist_nth_data (_tmp23_, (guint) _tmp24_);
				_tmp26_ = ((DVBEventAudioComponent*) _tmp25_)->type;
				_tmp27_ = g_strdup_printf ("%s ", _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp22_, _tmp28_, NULL);
				_g_free0 (text);
				text = _tmp29_;
				_g_free0 (_tmp28_);
			}
		}
	}
	result = text;
	return result;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm utc_time;
	struct tm _tmp1_;
	time_t _tmp2_ = 0;
	time_t utc_timestamp;
	struct tm _tmp3_ = {0};
	struct tm local_time;
	g_return_if_fail (self != NULL);
	dvb_event_get_utc_start_time (self, &_tmp0_);
	utc_time = _tmp0_;
	_tmp1_ = utc_time;
	_tmp2_ = timegm (&_tmp1_);
	utc_timestamp = _tmp2_;
	g_time_local (utc_timestamp, &_tmp3_);
	local_time = _tmp3_;
	*result = local_time;
	return;
}


void dvb_event_get_utc_start_time (DVBEvent* self, struct tm* result) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm utc_time;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->year;
	_tmp1_ = self->month;
	_tmp2_ = self->day;
	_tmp3_ = self->hour;
	_tmp4_ = self->minute;
	_tmp5_ = self->second;
	dvb_utils_create_utc_time ((gint) _tmp0_, (gint) _tmp1_, (gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, (gint) _tmp5_, &_tmp6_);
	utc_time = _tmp6_;
	*result = utc_time;
	return;
}


time_t dvb_event_get_start_timestamp (DVBEvent* self) {
	time_t result = 0;
	struct tm _tmp0_ = {0};
	struct tm utc_time;
	time_t _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	dvb_event_get_utc_start_time (self, &_tmp0_);
	utc_time = _tmp0_;
	_tmp1_ = mktime (&utc_time);
	result = _tmp1_;
	return result;
}


/**
         * @returns: UNIX time stamp
         */
time_t dvb_event_get_end_timestamp (DVBEvent* self) {
	time_t result = 0;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	struct tm _tmp6_ = {0};
	struct tm end_time;
	time_t _tmp7_ = 0;
	time_t before;
	gint _tmp8_;
	guint _tmp9_;
	time_t _tmp10_ = 0;
	time_t after;
	guint _tmp11_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->year;
	_tmp1_ = self->month;
	_tmp2_ = self->day;
	_tmp3_ = self->hour;
	_tmp4_ = self->minute;
	_tmp5_ = self->second;
	dvb_utils_create_utc_time ((gint) _tmp0_, (gint) _tmp1_, (gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, (gint) _tmp5_, &_tmp6_);
	end_time = _tmp6_;
	_tmp7_ = mktime (&end_time);
	before = _tmp7_;
	_tmp8_ = end_time.tm_sec;
	_tmp9_ = self->duration;
	end_time.tm_sec = _tmp8_ + ((gint) _tmp9_);
	_tmp10_ = mktime (&end_time);
	after = _tmp10_;
	_tmp11_ = self->duration;
	g_assert ((after - before) == ((time_t) _tmp11_));
	result = after;
	return result;
}


gdouble dvb_event_get_overlap_percentage (DVBEvent* self, DVBEvent* other) {
	gdouble result = 0.0;
	time_t _tmp0_ = 0;
	time_t this_start;
	time_t _tmp1_ = 0;
	time_t this_end;
	DVBEvent* _tmp2_;
	time_t _tmp3_ = 0;
	time_t other_start;
	DVBEvent* _tmp4_;
	time_t _tmp5_ = 0;
	time_t other_end;
	gboolean _tmp6_ = FALSE;
	time_t _tmp7_;
	time_t _tmp8_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (other != NULL, 0.0);
	_tmp0_ = dvb_event_get_start_timestamp (self);
	this_start = _tmp0_;
	_tmp1_ = dvb_event_get_end_timestamp (self);
	this_end = _tmp1_;
	_tmp2_ = other;
	_tmp3_ = dvb_event_get_start_timestamp (_tmp2_);
	other_start = _tmp3_;
	_tmp4_ = other;
	_tmp5_ = dvb_event_get_end_timestamp (_tmp4_);
	other_end = _tmp5_;
	_tmp7_ = this_start;
	_tmp8_ = other_end;
	if (_tmp7_ <= _tmp8_) {
		time_t _tmp9_;
		time_t _tmp10_;
		_tmp9_ = this_end;
		_tmp10_ = other_start;
		_tmp6_ = _tmp9_ >= _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		time_t _tmp12_;
		time_t _tmp13_;
		time_t _tmp14_ = 0;
		time_t start;
		time_t _tmp15_;
		time_t _tmp16_;
		time_t _tmp17_ = 0;
		time_t end;
		time_t _tmp18_;
		time_t _tmp19_;
		gdouble _tmp20_ = 0.0;
		time_t _tmp21_;
		time_t _tmp22_;
		_tmp12_ = this_start;
		_tmp13_ = other_start;
		_tmp14_ = dvb_utils_t_max (_tmp12_, _tmp13_);
		start = _tmp14_;
		_tmp15_ = this_end;
		_tmp16_ = other_end;
		_tmp17_ = dvb_utils_t_min (_tmp15_, _tmp16_);
		end = _tmp17_;
		_tmp18_ = start;
		_tmp19_ = end;
		_tmp20_ = fabs ((gdouble) (_tmp18_ - _tmp19_));
		_tmp21_ = this_end;
		_tmp22_ = this_start;
		result = _tmp20_ / (_tmp21_ - _tmp22_);
		return result;
	}
	result = (gdouble) 0;
	return result;
}


/**
         * @returns: negative value if event1 starts before event2,
         * positive value if event1 starts after event2 and zero else
         *
         * Compare the starting time of two events
         */
gint dvb_event_compare (DVBEvent* event1, DVBEvent* event2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	DVBEvent* _tmp1_;
	gboolean _tmp3_;
	DVBEvent* _tmp12_;
	time_t _tmp13_ = 0;
	time_t event1_time;
	DVBEvent* _tmp14_;
	time_t _tmp15_ = 0;
	time_t event2_time;
	time_t _tmp16_;
	time_t _tmp17_;
	_tmp1_ = event1;
	if (_tmp1_ == NULL) {
		DVBEvent* _tmp2_;
		_tmp2_ = event2;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		DVBEvent* _tmp5_;
		gboolean _tmp7_;
		_tmp5_ = event1;
		if (_tmp5_ == NULL) {
			DVBEvent* _tmp6_;
			_tmp6_ = event2;
			_tmp4_ = _tmp6_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp7_ = _tmp4_;
		if (_tmp7_) {
			result = +1;
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			DVBEvent* _tmp9_;
			gboolean _tmp11_;
			_tmp9_ = event1;
			if (_tmp9_ != NULL) {
				DVBEvent* _tmp10_;
				_tmp10_ = event2;
				_tmp8_ = _tmp10_ == NULL;
			} else {
				_tmp8_ = FALSE;
			}
			_tmp11_ = _tmp8_;
			if (_tmp11_) {
				result = -1;
				return result;
			}
		}
	}
	_tmp12_ = event1;
	_tmp13_ = dvb_event_get_end_timestamp (_tmp12_);
	event1_time = _tmp13_;
	_tmp14_ = event2;
	_tmp15_ = dvb_event_get_end_timestamp (_tmp14_);
	event2_time = _tmp15_;
	_tmp16_ = event1_time;
	_tmp17_ = event2_time;
	if (_tmp16_ < _tmp17_) {
		result = -1;
		return result;
	} else {
		time_t _tmp18_;
		time_t _tmp19_;
		_tmp18_ = event1_time;
		_tmp19_ = event2_time;
		if (_tmp18_ > _tmp19_) {
			result = +1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


/**
         * @returns: TRUE if event1 and event2 represent the same event,
         * else FALSE
         *
         * event1 and event2 must be part of the same transport stream
         */
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DVBEvent* _tmp1_;
	gboolean _tmp3_;
	DVBEvent* _tmp4_;
	guint _tmp5_;
	DVBEvent* _tmp6_;
	guint _tmp7_;
	_tmp1_ = event1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DVBEvent* _tmp2_;
		_tmp2_ = event2;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = event1;
	_tmp5_ = _tmp4_->id;
	_tmp6_ = event2;
	_tmp7_ = _tmp6_->id;
	result = _tmp5_ == _tmp7_;
	return result;
}


guint dvb_event_hash (DVBEvent* event) {
	guint result = 0U;
	DVBEvent* _tmp0_;
	guint _tmp1_;
	_tmp0_ = event;
	_tmp1_ = _tmp0_->id;
	result = _tmp1_;
	return result;
}


DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type) {
	DVBEventAudioComponent* self = NULL;
	self = (DVBEventAudioComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventAudioComponent* dvb_event_audio_component_new (void) {
	return dvb_event_audio_component_construct (DVB_EVENT_TYPE_AUDIO_COMPONENT);
}


static void dvb_event_value_audio_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_audio_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_audio_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_audio_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_audio_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_audio_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_audio_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventAudioComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_audio_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_audio_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventAudioComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_audio_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecAudioComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_AUDIO_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_audio_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_audio_component (GValue* value, gpointer v_object) {
	DVBEventAudioComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_AUDIO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_audio_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_audio_component_unref (old);
	}
}


void dvb_event_value_take_audio_component (GValue* value, gpointer v_object) {
	DVBEventAudioComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_AUDIO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_audio_component_unref (old);
	}
}


static void dvb_event_audio_component_class_init (DVBEventAudioComponentClass * klass) {
	dvb_event_audio_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_AUDIO_COMPONENT_CLASS (klass)->finalize = dvb_event_audio_component_finalize;
}


static void dvb_event_audio_component_instance_init (DVBEventAudioComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_audio_component_finalize (DVBEventAudioComponent* obj) {
	DVBEventAudioComponent * self;
	self = DVB_EVENT_AUDIO_COMPONENT (obj);
	_g_free0 (self->type);
}


GType dvb_event_audio_component_get_type (void) {
	static volatile gsize dvb_event_audio_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_audio_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_audio_component_init, dvb_event_value_audio_component_free_value, dvb_event_value_audio_component_copy_value, dvb_event_value_audio_component_peek_pointer, "p", dvb_event_value_audio_component_collect_value, "p", dvb_event_value_audio_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventAudioComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_audio_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventAudioComponent), 0, (GInstanceInitFunc) dvb_event_audio_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_audio_component_type_id;
		dvb_event_audio_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventAudioComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_audio_component_type_id__volatile, dvb_event_audio_component_type_id);
	}
	return dvb_event_audio_component_type_id__volatile;
}


gpointer dvb_event_audio_component_ref (gpointer instance) {
	DVBEventAudioComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_audio_component_unref (gpointer instance) {
	DVBEventAudioComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_AUDIO_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type) {
	DVBEventVideoComponent* self = NULL;
	self = (DVBEventVideoComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventVideoComponent* dvb_event_video_component_new (void) {
	return dvb_event_video_component_construct (DVB_EVENT_TYPE_VIDEO_COMPONENT);
}


static void dvb_event_value_video_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_video_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_video_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_video_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_video_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_video_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_video_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventVideoComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_video_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_video_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventVideoComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_video_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecVideoComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_VIDEO_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_video_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_video_component (GValue* value, gpointer v_object) {
	DVBEventVideoComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_VIDEO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_video_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_video_component_unref (old);
	}
}


void dvb_event_value_take_video_component (GValue* value, gpointer v_object) {
	DVBEventVideoComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_VIDEO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_video_component_unref (old);
	}
}


static void dvb_event_video_component_class_init (DVBEventVideoComponentClass * klass) {
	dvb_event_video_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_VIDEO_COMPONENT_CLASS (klass)->finalize = dvb_event_video_component_finalize;
}


static void dvb_event_video_component_instance_init (DVBEventVideoComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_video_component_finalize (DVBEventVideoComponent* obj) {
	DVBEventVideoComponent * self;
	self = DVB_EVENT_VIDEO_COMPONENT (obj);
	_g_free0 (self->aspect_ratio);
}


GType dvb_event_video_component_get_type (void) {
	static volatile gsize dvb_event_video_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_video_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_video_component_init, dvb_event_value_video_component_free_value, dvb_event_value_video_component_copy_value, dvb_event_value_video_component_peek_pointer, "p", dvb_event_value_video_component_collect_value, "p", dvb_event_value_video_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventVideoComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_video_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventVideoComponent), 0, (GInstanceInitFunc) dvb_event_video_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_video_component_type_id;
		dvb_event_video_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventVideoComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_video_component_type_id__volatile, dvb_event_video_component_type_id);
	}
	return dvb_event_video_component_type_id__volatile;
}


gpointer dvb_event_video_component_ref (gpointer instance) {
	DVBEventVideoComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_video_component_unref (gpointer instance) {
	DVBEventVideoComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_VIDEO_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type) {
	DVBEventTeletextComponent* self = NULL;
	self = (DVBEventTeletextComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventTeletextComponent* dvb_event_teletext_component_new (void) {
	return dvb_event_teletext_component_construct (DVB_EVENT_TYPE_TELETEXT_COMPONENT);
}


static void dvb_event_value_teletext_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_teletext_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_teletext_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_teletext_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_teletext_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_teletext_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_teletext_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventTeletextComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_teletext_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_teletext_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventTeletextComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_teletext_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecTeletextComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_TELETEXT_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_teletext_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object) {
	DVBEventTeletextComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_teletext_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_teletext_component_unref (old);
	}
}


void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object) {
	DVBEventTeletextComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_teletext_component_unref (old);
	}
}


static void dvb_event_teletext_component_class_init (DVBEventTeletextComponentClass * klass) {
	dvb_event_teletext_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_TELETEXT_COMPONENT_CLASS (klass)->finalize = dvb_event_teletext_component_finalize;
}


static void dvb_event_teletext_component_instance_init (DVBEventTeletextComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_teletext_component_finalize (DVBEventTeletextComponent* obj) {
	DVBEventTeletextComponent * self;
	self = DVB_EVENT_TELETEXT_COMPONENT (obj);
	_g_free0 (self->type);
}


GType dvb_event_teletext_component_get_type (void) {
	static volatile gsize dvb_event_teletext_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_teletext_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_teletext_component_init, dvb_event_value_teletext_component_free_value, dvb_event_value_teletext_component_copy_value, dvb_event_value_teletext_component_peek_pointer, "p", dvb_event_value_teletext_component_collect_value, "p", dvb_event_value_teletext_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventTeletextComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_teletext_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventTeletextComponent), 0, (GInstanceInitFunc) dvb_event_teletext_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_teletext_component_type_id;
		dvb_event_teletext_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventTeletextComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_teletext_component_type_id__volatile, dvb_event_teletext_component_type_id);
	}
	return dvb_event_teletext_component_type_id__volatile;
}


gpointer dvb_event_teletext_component_ref (gpointer instance) {
	DVBEventTeletextComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_teletext_component_unref (gpointer instance) {
	DVBEventTeletextComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_unref (value->data[0].v_pointer);
	}
}


static void dvb_value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_value_set_event (GValue* value, gpointer v_object) {
	DVBEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_unref (old);
	}
}


void dvb_value_take_event (GValue* value, gpointer v_object) {
	DVBEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_unref (old);
	}
}


static void dvb_event_class_init (DVBEventClass * klass) {
	dvb_event_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_CLASS (klass)->finalize = dvb_event_finalize;
}


static void dvb_event_instance_init (DVBEvent * self) {
	self->ref_count = 1;
}


static void dvb_event_finalize (DVBEvent* obj) {
	DVBEvent * self;
	self = DVB_EVENT (obj);
	_g_free0 (self->name);
	_g_free0 (self->description);
	_g_free0 (self->extended_description);
	__g_slist_free__dvb_event_audio_component_unref0_0 (self->audio_components);
	__g_slist_free__dvb_event_video_component_unref0_0 (self->video_components);
	__g_slist_free__dvb_event_teletext_component_unref0_0 (self->teletext_components);
}


/**
     * Represents an EPG event (i.e. a show with all its information)
     */
GType dvb_event_get_type (void) {
	static volatile gsize dvb_event_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_value_event_init, dvb_value_event_free_value, dvb_value_event_copy_value, dvb_value_event_peek_pointer, "p", dvb_value_event_collect_value, "p", dvb_value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEvent), 0, (GInstanceInitFunc) dvb_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_type_id;
		dvb_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_type_id__volatile, dvb_event_type_id);
	}
	return dvb_event_type_id__volatile;
}


gpointer dvb_event_ref (gpointer instance) {
	DVBEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_unref (gpointer instance) {
	DVBEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



