/* Settings.c generated by valac 0.12.0, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
typedef struct _DVBSettingsPrivate DVBSettingsPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBSettings {
	GObject parent_instance;
	DVBSettingsPrivate * priv;
};

struct _DVBSettingsClass {
	GObjectClass parent_class;
};

struct _DVBSettingsPrivate {
	GKeyFile* keyfile;
};


static gpointer dvb_settings_parent_class = NULL;
static DVBLoggingLogger* dvb_settings_log;
static DVBLoggingLogger* dvb_settings_log = NULL;

GType dvb_settings_get_type (void) G_GNUC_CONST;
#define DVB_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SETTINGS, DVBSettingsPrivate))
enum  {
	DVB_SETTINGS_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_SETTINGS_TIMERS_SECTION "timers"
#define DVB_SETTINGS_MARGIN_START "margin_start"
#define DVB_SETTINGS_MARGIN_END "margin_end"
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
#define DVB_SETTINGS_STREAMING_SECTION "streaming"
#define DVB_SETTINGS_INTERFACE "interface"
#define DVB_SETTINGS_DEFAULT_MARGIN_START 5
#define DVB_SETTINGS_DEFAULT_MARGIN_END 5
#define DVB_SETTINGS_DEFAULT_SCAN_INTERVAL 30
#define DVB_SETTINGS_DEFAULT_INTERFACE "lo"
#define DVB_SETTINGS_DEFAULT_SETTINGS "[timers]\n" \
"        margin_start=5\n" \
"        margin_end=5\n" \
"        [epg]\n" \
"        scan_interval=30\n" \
"        [streaming]\n" \
"        interface=lo"
gint dvb_settings_get_epg_scan_interval (DVBSettings* self);
gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gint dvb_settings_get_timers_margin_start (DVBSettings* self);
gint dvb_settings_get_timers_margin_end (DVBSettings* self);
gchar* dvb_settings_get_streaming_interface (DVBSettings* self);
gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
GFile* dvb_settings_get_settings_file (DVBSettings* self);
gboolean dvb_settings_load (DVBSettings* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_settings_save (DVBSettings* self);
gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error);
gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error);
void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error);
void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error);
void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error);
void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error);
void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error);
void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error);
void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error);
void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error);
DVBSettings* dvb_settings_new (void);
DVBSettings* dvb_settings_construct (GType object_type);
static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_settings_finalize (GObject* obj);


gint dvb_settings_get_epg_scan_interval (DVBSettings* self) {
	gint result = 0;
	gint val = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_EPG_SECTION, DVB_SETTINGS_SCAN_INTERVAL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch181_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	val = _tmp1_;
	goto __finally181;
	__catch181_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Settings.vala:64: %s", e->message);
		val = DVB_SETTINGS_DEFAULT_SCAN_INTERVAL;
		_g_error_free0 (e);
	}
	__finally181:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = val * 60;
	return result;
}


gint dvb_settings_get_timers_margin_start (DVBSettings* self) {
	gint result = 0;
	gint start_margin = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_START, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch182_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	start_margin = _tmp1_;
	goto __finally182;
	__catch182_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Settings.vala:75: %s", e->message);
		start_margin = DVB_SETTINGS_DEFAULT_MARGIN_START;
		_g_error_free0 (e);
	}
	__finally182:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = start_margin;
	return result;
}


gint dvb_settings_get_timers_margin_end (DVBSettings* self) {
	gint result = 0;
	gint end_margin = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_settings_get_integer (self, DVB_SETTINGS_TIMERS_SECTION, DVB_SETTINGS_MARGIN_END, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch183_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	end_margin = _tmp1_;
	goto __finally183;
	__catch183_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Settings.vala:86: %s", e->message);
		end_margin = DVB_SETTINGS_DEFAULT_MARGIN_END;
		_g_error_free0 (e);
	}
	__finally183:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = end_margin;
	return result;
}


gchar* dvb_settings_get_streaming_interface (DVBSettings* self) {
	gchar* result = NULL;
	gchar* val = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_settings_get_string (self, DVB_SETTINGS_STREAMING_SECTION, DVB_SETTINGS_INTERFACE, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch184_g_key_file_error;
		}
		_g_free0 (val);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (val);
	val = _tmp1_;
	goto __finally184;
	__catch184_g_key_file_error:
	{
		GError * e;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Settings.vala:97: %s", e->message);
		_tmp2_ = g_strdup (DVB_SETTINGS_DEFAULT_INTERFACE);
		_g_free0 (val);
		val = _tmp2_;
		_g_error_free0 (e);
	}
	__finally184:
	if (_inner_error_ != NULL) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = val;
	return result;
}


GFile* dvb_settings_get_settings_file (DVBSettings* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* config_dir;
	GFile* _tmp2_ = NULL;
	GFile* our_config;
	GFile* _tmp3_ = NULL;
	GFile* settings_file;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = g_file_get_child (config_dir, "gnome-dvb-daemon");
	our_config = _tmp2_;
	_tmp3_ = g_file_get_child (our_config, "settings.ini");
	settings_file = _tmp3_;
	result = settings_file;
	_g_object_unref0 (our_config);
	_g_object_unref0 (config_dir);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	guint8* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = -1;
	_tmp0_ = strlen (self);
	res_length1 = (gint) _tmp0_;
	_tmp1_ = res;
	*result_length1 = res_length1;
	result = _tmp1_;
	return result;
}


gboolean dvb_settings_load (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* settings_file;
	gboolean success;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	success = TRUE;
	_tmp1_ = g_file_query_exists (settings_file, NULL);
	if (!_tmp1_) {
		GFileOutputStream* stream;
		GFileOutputStream* _tmp2_ = NULL;
		GFileOutputStream* _tmp3_;
		guint8* _tmp6_ = NULL;
		gint _tmp7_;
		stream = NULL;
		_tmp2_ = g_file_create (settings_file, 0, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch185_g_error;
		}
		_g_object_unref0 (stream);
		stream = _tmp3_;
		goto __finally185;
		__catch185_g_error:
		{
			GError * e;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = g_file_get_path (settings_file);
			_tmp5_ = _tmp4_;
			dvb_logging_logger_error (dvb_settings_log, "Settings.vala:120: Could not create file %s: %s", _tmp5_, e->message);
			_g_free0 (_tmp5_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			return result;
		}
		__finally185:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp6_ = string_get_data (DVB_SETTINGS_DEFAULT_SETTINGS, &_tmp7_);
		g_output_stream_write ((GOutputStream*) stream, _tmp6_, (gsize) _tmp7_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch186_g_error;
		}
		goto __finally186;
		__catch186_g_error:
		{
			GError * e;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = g_file_get_path (settings_file);
			_tmp9_ = _tmp8_;
			dvb_logging_logger_error (dvb_settings_log, "Settings.vala:128: Could not write to file %s: %s", _tmp9_, e->message);
			_g_free0 (_tmp9_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally186:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch187_g_error;
		}
		goto __finally187;
		__catch187_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_settings_log, "Settings.vala:136: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally187:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (stream);
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (stream);
	}
	if (success) {
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = g_file_get_path (settings_file);
		_tmp11_ = _tmp10_;
		g_key_file_load_from_file (self->priv->keyfile, _tmp11_, 0, &_inner_error_);
		_g_free0 (_tmp11_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch188_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch188_g_file_error;
			}
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally188;
		__catch188_g_key_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_settings_log, "Settings.vala:145: Could not load settings: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
		goto __finally188;
		__catch188_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_settings_log, "Settings.vala:148: Could not load settings: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally188:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (settings_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (settings_file);
	return result;
}


gboolean dvb_settings_save (DVBSettings* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* settings_file;
	GFileOutputStream* stream;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* _tmp2_;
	gchar* data;
	gsize data_len = 0UL;
	gsize _tmp5_;
	gchar* _tmp6_ = NULL;
	guint8* _tmp7_ = NULL;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = dvb_settings_get_settings_file (self);
	settings_file = _tmp0_;
	stream = NULL;
	_tmp1_ = g_file_replace (settings_file, NULL, TRUE, 0, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch189_g_error;
	}
	_g_object_unref0 (stream);
	stream = _tmp2_;
	goto __finally189;
	__catch189_g_error:
	{
		GError * e;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_file_get_path (settings_file);
		_tmp4_ = _tmp3_;
		dvb_logging_logger_error (dvb_settings_log, "Settings.vala:163: Could not replace file %s: %s", _tmp4_, e->message);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally189:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	data = NULL;
	_tmp6_ = g_key_file_to_data (self->priv->keyfile, &_tmp5_, NULL);
	data_len = _tmp5_;
	_g_free0 (data);
	data = _tmp6_;
	_tmp7_ = string_get_data (data, &_tmp8_);
	g_output_stream_write_all ((GOutputStream*) stream, _tmp7_, (gsize) _tmp8_, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch190_g_error;
	}
	goto __finally190;
	__catch190_g_error:
	{
		GError * e;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = g_file_get_path (settings_file);
		_tmp10_ = _tmp9_;
		dvb_logging_logger_error (dvb_settings_log, "Settings.vala:175: Could not write to file %s: %s", _tmp10_, e->message);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		return result;
	}
	__finally190:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch191_g_error;
	}
	goto __finally191;
	__catch191_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_settings_log, "Settings.vala:184: %s", e->message);
		_g_error_free0 (e);
	}
	__finally191:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (stream);
		_g_object_unref0 (settings_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_free0 (data);
	_g_object_unref0 (stream);
	_g_object_unref0 (settings_file);
	return result;
}


gchar* dvb_settings_get_string (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_key_file_get_string (self->priv->keyfile, group_name, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


gboolean dvb_settings_get_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = g_key_file_get_boolean (self->priv->keyfile, group_name, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


gint dvb_settings_get_integer (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = g_key_file_get_integer (self->priv->keyfile, group_name, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


gdouble dvb_settings_get_double (DVBSettings* self, const gchar* group_name, const gchar* key, GError** error) {
	gdouble result = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (group_name != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp0_ = g_key_file_get_double (self->priv->keyfile, group_name, key, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0.0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
	}
	result = _tmp1_;
	return result;
}


gchar** dvb_settings_get_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gchar** result = NULL;
	gsize _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	gchar** _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = g_key_file_get_string_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


gboolean* dvb_settings_get_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gboolean* result = NULL;
	gsize _tmp0_;
	gboolean* _tmp1_ = NULL;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	gboolean* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = g_key_file_get_boolean_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


gint* dvb_settings_get_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gint* result = NULL;
	gsize _tmp0_;
	gint* _tmp1_ = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	gint* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = g_key_file_get_integer_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


gdouble* dvb_settings_get_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, int* result_length1, GError** error) {
	gdouble* result = NULL;
	gsize _tmp0_;
	gdouble* _tmp1_ = NULL;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	gdouble* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = g_key_file_get_double_list (self->priv->keyfile, group_name, key, &_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	__tmp2__size_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp2__length1;
	result = _tmp3_;
	return result;
}


void dvb_settings_set_string (DVBSettings* self, const gchar* group_name, const gchar* key, const gchar* val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	g_key_file_set_string (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_boolean (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_double (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_integer (DVBSettings* self, const gchar* group_name, const gchar* key, gint val, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer (self->priv->keyfile, group_name, key, val);
}


void dvb_settings_set_string_list (DVBSettings* self, const gchar* group_name, const gchar* key, gchar** val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_string_list (self->priv->keyfile, group_name, key, (const gchar* const*) val, val_length1);
}


void dvb_settings_set_boolean_list (DVBSettings* self, const gchar* group_name, const gchar* key, gboolean* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_boolean_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_double_list (DVBSettings* self, const gchar* group_name, const gchar* key, gdouble* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_double_list (self->priv->keyfile, group_name, key, val, val_length1);
}


void dvb_settings_set_integer_list (DVBSettings* self, const gchar* group_name, const gchar* key, gint* val, int val_length1, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (key != NULL);
	g_key_file_set_integer_list (self->priv->keyfile, group_name, key, val, val_length1);
}


DVBSettings* dvb_settings_construct (GType object_type) {
	DVBSettings * self = NULL;
	self = (DVBSettings*) g_object_new (object_type, NULL);
	return self;
}


DVBSettings* dvb_settings_new (void) {
	return dvb_settings_construct (DVB_TYPE_SETTINGS);
}


static GObject * dvb_settings_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSettings * self;
	GKeyFile* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SETTINGS (obj);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	return obj;
}


static void dvb_settings_class_init (DVBSettingsClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSettingsPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_settings_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_settings_log = _tmp1_;
}


static void dvb_settings_instance_init (DVBSettings * self) {
	self->priv = DVB_SETTINGS_GET_PRIVATE (self);
}


static void dvb_settings_finalize (GObject* obj) {
	DVBSettings * self;
	self = DVB_SETTINGS (obj);
	_g_key_file_free0 (self->priv->keyfile);
	G_OBJECT_CLASS (dvb_settings_parent_class)->finalize (obj);
}


GType dvb_settings_get_type (void) {
	static volatile gsize dvb_settings_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_settings_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSettings), 0, (GInstanceInitFunc) dvb_settings_instance_init, NULL };
		GType dvb_settings_type_id;
		dvb_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSettings", &g_define_type_info, 0);
		g_once_init_leave (&dvb_settings_type_id__volatile, dvb_settings_type_id);
	}
	return dvb_settings_type_id__volatile;
}



