/* DeviceGroup.c generated by valac 0.12.0, the Vala compiler
 * generated from DeviceGroup.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
typedef struct _DVBDeviceGroupPrivate DVBDeviceGroupPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_ID_BUS_RECORDER_PROXY (dvb_id_bus_recorder_proxy_get_type ())

#define DVB_TYPE_TIMER_INFO (dvb_timer_info_get_type ())
typedef struct _DVBTimerInfo DVBTimerInfo;

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

#define DVB_TYPE_ID_BUS_CHANNEL_LIST_PROXY (dvb_id_bus_channel_list_proxy_get_type ())

#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_ID_BUS_SCHEDULE_PROXY (dvb_id_bus_schedule_proxy_get_type ())

#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	gchar* (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};

struct _DVBDeviceGroup {
	GObject parent_instance;
	DVBDeviceGroupPrivate * priv;
};

struct _DVBDeviceGroupClass {
	GObjectClass parent_class;
};

struct _DVBDeviceGroupPrivate {
	guint _Id;
	gchar* _Name;
	DVBDevice* _reference_device;
	GeeSet* devices;
	GStaticRecMutex __lock_devices;
	DVBRecorder* _recorder;
	DVBEPGScanner* _epgscanner;
	DVBChannelFactory* _channelfactory;
	GeeHashSet* schedules;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBTimerInfo {
	guint32 id;
	guint duration;
	gboolean active;
	gchar* channel_name;
	gchar* title;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	gboolean (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
	gboolean (*SetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
	gboolean (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
	gboolean (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
	gboolean (*SetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
	gboolean (*GetTitle) (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
};

struct _DVBChannelInfo {
	guint id;
	gchar* name;
	gboolean is_radio;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
	gboolean (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
	gboolean (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelsOfGroup) (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
	gboolean (*AddChannelToGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
	gboolean (*RemoveChannelFromGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
};

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	gchar* name;
	guint duration;
	gchar* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};


static gpointer dvb_device_group_parent_class = NULL;
static DVBLoggingLogger* dvb_device_group_log;
static DVBLoggingLogger* dvb_device_group_log = NULL;
extern GDBusConnection* main_conn;
static DVBIDBusDeviceGroupIface* dvb_device_group_dvb_id_bus_device_group_parent_iface = NULL;
static GeeIterableIface* dvb_device_group_gee_iterable_parent_iface = NULL;

GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_recorder_get_type (void) G_GNUC_CONST;
GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
#define DVB_DEVICE_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupPrivate))
enum  {
	DVB_DEVICE_GROUP_DUMMY_PROPERTY,
	DVB_DEVICE_GROUP_SIZE,
	DVB_DEVICE_GROUP_ID,
	DVB_DEVICE_GROUP_CHANNELS,
	DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY,
	DVB_DEVICE_GROUP_TYPE,
	DVB_DEVICE_GROUP_RECORDER,
	DVB_DEVICE_GROUP_EPGSCANNER,
	DVB_DEVICE_GROUP_CHANNEL_FACTORY,
	DVB_DEVICE_GROUP_NAME,
	DVB_DEVICE_GROUP_REFERENCE_DEVICE,
	DVB_DEVICE_GROUP_ELEMENT_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDevice* dvb_device_group_get_reference_device (DVBDeviceGroup* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value);
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
gboolean dvb_device_group_register_channel_list (DVBDeviceGroup* self);
gboolean dvb_device_group_register_recorder (DVBDeviceGroup* self);
void dvb_device_group_destroy (DVBDeviceGroup* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
void dvb_recorder_stop (DVBRecorder* self);
void dvb_channel_factory_destroy (DVBChannelFactory* self);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
void dvb_device_group_create_and_add_device (DVBDeviceGroup* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value);
GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self);
void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value);
gboolean dvb_device_group_add_and_emit (DVBDeviceGroup* self, DVBDevice* device);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
void dvb_device_group_set_reference_device (DVBDeviceGroup* self, DVBDevice* value);
gboolean dvb_device_group_remove_and_emit (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
gboolean dvb_device_is_busy (DVBDevice* self);
static gchar* dvb_device_group_real_GetType (DVBIDBusDeviceGroup* base, GError** error);
static gboolean dvb_device_group_real_AddDevice (DVBIDBusDeviceGroup* base, guint adapter, guint frontend, GError** error);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device);
GQuark dvb_database_sql_error_quark (void);
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
gboolean dvb_database_config_store_add_device_to_group (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static char* dvb_device_group_real_GetRecorder (DVBIDBusDeviceGroup* base, GError** error);
#define DVB_CONSTANTS_DBUS_RECORDER_PATH "/org/gnome/DVB/DeviceGroup/%u/Recorder"
DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
GType dvb_id_bus_recorder_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recorder_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_timer_info_get_type (void) G_GNUC_CONST;
DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self);
void dvb_timer_info_free (DVBTimerInfo* self);
void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest);
void dvb_timer_info_destroy (DVBTimerInfo* self);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_recorder_get_type (void) G_GNUC_CONST;
static gboolean dvb_device_group_real_RemoveDevice (DVBIDBusDeviceGroup* base, guint adapter, guint frontend, GError** error);
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
gboolean dvb_database_config_store_remove_device_from_group (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
static gchar* dvb_device_group_real_GetName (DVBIDBusDeviceGroup* base, GError** error);
const gchar* dvb_device_group_get_Name (DVBDeviceGroup* self);
static gboolean dvb_device_group_real_SetName (DVBIDBusDeviceGroup* base, const gchar* name, GError** error);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_database_config_store_update_from_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
static char* dvb_device_group_real_GetChannelList (DVBIDBusDeviceGroup* base, GError** error);
#define DVB_CONSTANTS_DBUS_CHANNEL_LIST_PATH "/org/gnome/DVB/DeviceGroup/%u/ChannelList"
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_id_bus_channel_list_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_channel_list_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_info_get_type (void) G_GNUC_CONST;
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_get_type (void) G_GNUC_CONST;
static gchar** dvb_device_group_real_GetMembers (DVBIDBusDeviceGroup* base, int* result_length1, GError** error);
#define DVB_CONSTANTS_DVB_DEVICE_PATH "/dev/dvb/adapter%u/frontend%u"
static gboolean dvb_device_group_real_GetSchedule (DVBIDBusDeviceGroup* base, guint channel_sid, char** opath, GError** error);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
#define DVB_CONSTANTS_DBUS_SCHEDULE_PATH "/org/gnome/DVB/DeviceGroup/%u/Schedule/%u"
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
GType dvb_id_bus_schedule_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_schedule_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_event_info_get_type (void) G_GNUC_CONST;
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void) G_GNUC_CONST;
static gchar* dvb_device_group_real_GetRecordingsDirectory (DVBIDBusDeviceGroup* base, GError** error);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
static gboolean dvb_device_group_real_SetRecordingsDirectory (DVBIDBusDeviceGroup* base, const gchar* location, GError** error);
void dvb_device_group_set_RecordingsDirectory (DVBDeviceGroup* self, GFile* value);
static GeeIterator* dvb_device_group_real_iterator (GeeIterable* base);
static void dvb_device_group_update_all_devices (DVBDeviceGroup* self);
static void dvb_device_group_set_Id (DVBDeviceGroup* self, guint value);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
static GObject * dvb_device_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
guint dvb_device_hash (DVBDevice* device);
static guint _dvb_device_hash_ghash_func (gconstpointer key);
static gboolean _dvb_device_equal_gequal_func (gconstpointer a, gconstpointer b);
DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup);
DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup);
DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev);
DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev);
static void dvb_device_group_finalize (GObject* obj);
static void _vala_dvb_device_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_device_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
         * @id: ID of group
         * @reference_device: All devices of this group will inherit
         * the settings from this device
         * @with_epg_scanner: Whether to provide an EPG scanner
         */
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner) {
	DVBDeviceGroup * self = NULL;
	DVBChannelList* _tmp0_ = NULL;
	g_return_val_if_fail (reference_device != NULL, NULL);
	self = (DVBDeviceGroup*) g_object_new (object_type, "Id", id, "reference-device", reference_device, NULL);
	_tmp0_ = dvb_device_get_Channels (self->priv->_reference_device);
	dvb_channel_list_set_GroupId (_tmp0_, id);
	if (with_epg_scanner) {
		DVBEPGScanner* _tmp1_ = NULL;
		_tmp1_ = dvb_epg_scanner_new (self);
		_g_object_unref0 (self->priv->_epgscanner);
		self->priv->_epgscanner = _tmp1_;
	} else {
		_g_object_unref0 (self->priv->_epgscanner);
		self->priv->_epgscanner = NULL;
	}
	dvb_device_group_register_channel_list (self);
	dvb_device_group_register_recorder (self);
	return self;
}


DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner) {
	return dvb_device_group_construct (DVB_TYPE_DEVICE_GROUP, id, reference_device, with_epg_scanner);
}


void dvb_device_group_destroy (DVBDeviceGroup* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_logging_logger_debug (dvb_device_group_log, "DeviceGroup.vala:107: Destroying group %u", self->priv->_Id);
	dvb_device_group_stop_epg_scanner (self);
	dvb_recorder_stop (self->priv->_recorder);
	dvb_channel_factory_destroy (self->priv->_channelfactory);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->schedules);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		gee_collection_clear ((GeeCollection*) self->priv->devices);
		__finally49:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_epgscanner != NULL) {
		dvb_epg_scanner_start (self->priv->_epgscanner);
	}
}


void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_epgscanner != NULL) {
		dvb_epg_scanner_stop (self->priv->_epgscanner);
	}
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         *
         * Creates a new device first and adds it to the group.
         * The new device inherits the settings from the reference
         * device.
         */
void dvb_device_group_create_and_add_device (DVBDeviceGroup* self, guint adapter, guint frontend) {
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* new_dev;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_device_new_with_type (adapter, frontend);
	new_dev = _tmp0_;
	dvb_device_group_add (self, new_dev);
	_g_object_unref0 (new_dev);
}


/**
         * Add device to group. The device's settings will be overridden
         * with those of the reference device.
         */
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device) {
	gboolean result = FALSE;
	DVBAdapterType _tmp0_;
	DVBAdapterType _tmp1_;
	gboolean _result_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = dvb_device_get_Type (device);
	_tmp1_ = dvb_device_group_get_Type (self);
	if (_tmp0_ != _tmp1_) {
		g_warning ("DeviceGroup.vala:146: Cannot add device, because it is not of same typ" \
"e");
		result = FALSE;
		return result;
	}
	{
		DVBChannelList* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gboolean _tmp4_;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		_tmp2_ = dvb_device_get_Channels (self->priv->_reference_device);
		dvb_device_set_Channels (device, _tmp2_);
		_tmp3_ = dvb_device_get_RecordingsDirectory (self->priv->_reference_device);
		dvb_device_set_RecordingsDirectory (device, _tmp3_);
		_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->devices, device);
		_result_ = _tmp4_;
		__finally50:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_device_group_add_and_emit (DVBDeviceGroup* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = dvb_device_group_add (self, device);
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = dvb_device_get_Adapter (device);
		_tmp2_ = dvb_device_get_Frontend (device);
		g_signal_emit_by_name ((DVBIDBusDeviceGroup*) self, "device-added", _tmp1_, _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		_tmp0_ = gee_collection_contains ((GeeCollection*) self->priv->devices, device);
		_result_ = _tmp0_;
		__finally51:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	{
		gboolean _tmp0_;
		gboolean _tmp1_;
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		_tmp0_ = gee_collection_remove ((GeeCollection*) self->priv->devices, device);
		_result_ = _tmp0_;
		_tmp1_ = dvb_device_equal (device, self->priv->_reference_device);
		if (_tmp1_) {
			{
				GeeIterator* _tmp2_ = NULL;
				GeeIterator* _dev_it;
				_tmp2_ = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
				_dev_it = _tmp2_;
				while (TRUE) {
					gboolean _tmp3_;
					gpointer _tmp4_ = NULL;
					DVBDevice* dev;
					_tmp3_ = gee_iterator_next (_dev_it);
					if (!_tmp3_) {
						break;
					}
					_tmp4_ = gee_iterator_get (_dev_it);
					dev = (DVBDevice*) _tmp4_;
					dvb_logging_logger_debug (dvb_device_group_log, "DeviceGroup.vala:183: Assigning new reference device");
					dvb_device_group_set_reference_device (self, dev);
					_g_object_unref0 (dev);
					break;
				}
				_g_object_unref0 (_dev_it);
			}
		}
		__finally52:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_device_group_remove_and_emit (DVBDeviceGroup* self, DVBDevice* device) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_tmp0_ = dvb_device_group_remove (self, device);
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = dvb_device_get_Adapter (device);
		_tmp2_ = dvb_device_get_Frontend (device);
		g_signal_emit_by_name ((DVBIDBusDeviceGroup*) self, "device-removed", _tmp1_, _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Get first device that isn't busy.
         * If all devices are busy NULL is returned.
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self) {
	DVBDevice* result = NULL;
	DVBDevice* _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _dev_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
			_dev_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBDevice* dev;
				gboolean _tmp3_;
				_tmp1_ = gee_iterator_next (_dev_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_dev_it);
				dev = (DVBDevice*) _tmp2_;
				_tmp3_ = dvb_device_is_busy (dev);
				if (!_tmp3_) {
					DVBDevice* _tmp4_;
					_tmp4_ = _g_object_ref0 (dev);
					_g_object_unref0 (_result_);
					_result_ = _tmp4_;
					_g_object_unref0 (dev);
					break;
				}
				_g_object_unref0 (dev);
			}
			_g_object_unref0 (_dev_it);
		}
		__finally53:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


/**
         * @returns: Name of adapter type the group holds
         * or an empty string when group with given id doesn't exist.
         */
static gchar* dvb_device_group_real_GetType (DVBIDBusDeviceGroup* base, GError** error) {
	DVBDeviceGroup * self;
	gchar* result = NULL;
	gchar* type_str = NULL;
	DVBAdapterType _tmp0_;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_group_get_Type (self);
	switch (_tmp0_) {
		case DVB_ADAPTER_TYPE_DVB_T:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("DVB-T");
			_g_free0 (type_str);
			type_str = _tmp1_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_S:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("DVB-S");
			_g_free0 (type_str);
			type_str = _tmp2_;
			break;
		}
		case DVB_ADAPTER_TYPE_DVB_C:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("DVB-C");
			_g_free0 (type_str);
			type_str = _tmp3_;
			break;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			_g_free0 (type_str);
			type_str = _tmp4_;
			break;
		}
	}
	result = type_str;
	return result;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new device and adds it to the DeviceGroup.
         * The new device will inherit all settings from the group's
         * reference device.
         */
static gboolean dvb_device_group_real_AddDevice (DVBIDBusDeviceGroup* base, guint adapter, guint frontend, GError** error) {
	DVBDeviceGroup * self;
	gboolean result = FALSE;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* device;
	DVBManager* _tmp1_ = NULL;
	DVBManager* _tmp2_;
	DVBManager* manager;
	gboolean _tmp3_;
	guint group_id;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_new_with_type (adapter, frontend);
	device = _tmp0_;
	if (device == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	_tmp1_ = dvb_manager_get_instance ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = dvb_manager_device_is_in_any_group (manager, device);
	if (_tmp3_) {
		dvb_logging_logger_debug (dvb_device_group_log, "Device with adapter %u, frontend %u is" "already part of a group", adapter, frontend);
		result = FALSE;
		_g_object_unref0 (manager);
		_g_object_unref0 (device);
		return result;
	}
	group_id = self->priv->_Id;
	dvb_logging_logger_debug (dvb_device_group_log, "DeviceGroup.vala:258: Adding device with adapter %u, frontend %u to gr" \
"oup %u", adapter, frontend, group_id);
	_tmp4_ = dvb_device_group_add (self, device);
	if (_tmp4_) {
		DVBdatabaseConfigStore* _tmp5_ = NULL;
		DVBdatabaseConfigStore* _tmp6_;
		_tmp5_ = dvb_factory_get_config_store ();
		_tmp6_ = _tmp5_;
		dvb_database_config_store_add_device_to_group (_tmp6_, device, self, &_inner_error_);
		_g_object_unref0 (_tmp6_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch54_dvb_database_sql_error;
			}
			_g_object_unref0 (manager);
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally54;
		__catch54_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			dvb_logging_logger_error (dvb_device_group_log, "DeviceGroup.vala:266: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (manager);
			_g_object_unref0 (device);
			return result;
		}
		__finally54:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (manager);
				_g_object_unref0 (device);
				return FALSE;
			} else {
				_g_object_unref0 (manager);
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		g_signal_emit_by_name ((DVBIDBusDeviceGroup*) self, "device-added", adapter, frontend);
		result = TRUE;
		_g_object_unref0 (manager);
		_g_object_unref0 (device);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (manager);
	_g_object_unref0 (device);
	return result;
}


/**
         * @returns: Object path of the device's recorder
         *
         * Returns the object path to the device's recorder.
         */
static char* dvb_device_group_real_GetRecorder (DVBIDBusDeviceGroup* base, GError** error) {
	DVBDeviceGroup * self;
	char* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	char* _tmp2_ = NULL;
	char* _tmp3_;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = g_strdup_printf (DVB_CONSTANTS_DBUS_RECORDER_PATH, self->priv->_Id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gboolean dvb_device_group_register_recorder (DVBDeviceGroup* self) {
	gboolean result = FALSE;
	DVBRecorder* _tmp0_ = NULL;
	DVBRecorder* _tmp1_;
	DVBRecorder* recorder;
	gchar* _tmp2_ = NULL;
	gchar* path;
	g_return_val_if_fail (self != NULL, FALSE);
	dvb_logging_logger_debug (dvb_device_group_log, "DeviceGroup.vala:289: Creating new Recorder D-Bus service for group %u", self->priv->_Id);
	_tmp0_ = dvb_device_group_get_recorder (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recorder = _tmp1_;
	_tmp2_ = g_strdup_printf (DVB_CONSTANTS_DBUS_RECORDER_PATH, self->priv->_Id);
	path = _tmp2_;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_RECORDER, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, path, (DVBIDBusRecorder*) recorder);
	result = TRUE;
	_g_free0 (path);
	_g_object_unref0 (recorder);
	return result;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @returns: TRUE when device has been removed successfully
         *
         * Removes the device from the group. If the group contains
         * no devices after the removal it's removed as well.
         */
static gboolean dvb_device_group_real_RemoveDevice (DVBIDBusDeviceGroup* base, guint adapter, guint frontend, GError** error) {
	DVBDeviceGroup * self;
	gboolean result = FALSE;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* dev;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_new (adapter, frontend);
	dev = _tmp0_;
	_tmp1_ = dvb_device_group_contains (self, dev);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = dvb_device_group_remove (self, dev);
		if (_tmp2_) {
			DVBdatabaseConfigStore* _tmp3_ = NULL;
			DVBdatabaseConfigStore* _tmp4_;
			gint _tmp5_;
			dvb_device_group_stop_epg_scanner (self);
			_tmp3_ = dvb_factory_get_config_store ();
			_tmp4_ = _tmp3_;
			dvb_database_config_store_remove_device_from_group (_tmp4_, dev, self, &_inner_error_);
			_g_object_unref0 (_tmp4_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch55_dvb_database_sql_error;
				}
				_g_object_unref0 (dev);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			goto __finally55;
			__catch55_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				dvb_logging_logger_error (dvb_device_group_log, "DeviceGroup.vala:322: %s", e->message);
				result = FALSE;
				_g_error_free0 (e);
				_g_object_unref0 (dev);
				return result;
			}
			__finally55:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_DBUS_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dev);
					return FALSE;
				} else {
					_g_object_unref0 (dev);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_tmp5_ = dvb_device_group_get_size (self);
			if (_tmp5_ > 0) {
				dvb_device_group_start_epg_scanner (self);
			}
			g_signal_emit_by_name ((DVBIDBusDeviceGroup*) self, "device-removed", adapter, frontend);
			result = TRUE;
			_g_object_unref0 (dev);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (dev);
	return result;
}


/**
         * @returns: Name of the device group
         */
static gchar* dvb_device_group_real_GetName (DVBIDBusDeviceGroup* base, GError** error) {
	DVBDeviceGroup * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = g_strdup (self->priv->_Name);
	result = _tmp0_;
	return result;
}


/**
         * @name: Name of the group
         * @returns: TRUE on success
         */
static gboolean dvb_device_group_real_SetName (DVBIDBusDeviceGroup* base, const gchar* name, GError** error) {
	DVBDeviceGroup * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	GError * _inner_error_ = NULL;
	self = (DVBDeviceGroup*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	dvb_device_group_set_Name (self, name);
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	dvb_database_config_store_update_from_group (config, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch56_dvb_database_sql_error;
		}
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (config);
	goto __finally56;
	__catch56_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_device_group_log, "DeviceGroup.vala:357: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally56:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


/**
         * @returns: Object path to the ChannelList service for this device
         */
static char* dvb_device_group_real_GetChannelList (DVBIDBusDeviceGroup* base, GError** error) {
	DVBDeviceGroup * self;
	char* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	char* _tmp2_ = NULL;
	char* _tmp3_;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = g_strdup_printf (DVB_CONSTANTS_DBUS_CHANNEL_LIST_PATH, self->priv->_Id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gboolean dvb_device_group_register_channel_list (DVBDeviceGroup* self) {
	gboolean result = FALSE;
	DVBChannelList* _tmp0_ = NULL;
	DVBChannelList* _tmp1_;
	DVBChannelList* channels;
	gchar* _tmp2_ = NULL;
	gchar* path;
	g_return_val_if_fail (self != NULL, FALSE);
	dvb_logging_logger_debug (dvb_device_group_log, "DeviceGroup.vala:372: Creating new ChannelList D-Bus service for group" \
" %u", self->priv->_Id);
	_tmp0_ = dvb_device_group_get_Channels (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	channels = _tmp1_;
	_tmp2_ = g_strdup_printf (DVB_CONSTANTS_DBUS_CHANNEL_LIST_PATH, self->priv->_Id);
	path = _tmp2_;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_CHANNEL_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, path, (DVBIDBusChannelList*) channels);
	result = TRUE;
	_g_free0 (path);
	_g_object_unref0 (channels);
	return result;
}


/**
         * @returns: List of paths to the devices that are part of
         * the group (e.g. /dev/dvb/adapter0/frontend0)
         */
static gchar** dvb_device_group_real_GetMembers (DVBIDBusDeviceGroup* base, int* result_length1, GError** error) {
	DVBDeviceGroup * self;
	gchar** result = NULL;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** groupdevs;
	gint groupdevs_length1;
	gint _groupdevs_size_;
	gint i;
	gchar** _tmp9_;
	GError * _inner_error_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_group_get_size (self);
	_tmp1_ = g_new0 (gchar*, _tmp0_ + 1);
	groupdevs = _tmp1_;
	groupdevs_length1 = _tmp0_;
	_groupdevs_size_ = _tmp0_;
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _dev_it;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
			_dev_it = _tmp2_;
			while (TRUE) {
				gboolean _tmp3_;
				gpointer _tmp4_ = NULL;
				DVBDevice* dev;
				guint _tmp5_;
				guint _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp3_ = gee_iterator_next (_dev_it);
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = gee_iterator_get (_dev_it);
				dev = (DVBDevice*) _tmp4_;
				_tmp5_ = dvb_device_get_Adapter (dev);
				_tmp6_ = dvb_device_get_Frontend (dev);
				_tmp7_ = g_strdup_printf (DVB_CONSTANTS_DVB_DEVICE_PATH, _tmp5_, _tmp6_);
				_tmp8_ = _tmp7_;
				_g_free0 (groupdevs[i]);
				groupdevs[i] = _tmp8_;
				i++;
				_g_object_unref0 (dev);
			}
			_g_object_unref0 (_dev_it);
		}
		__finally57:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				groupdevs = (_vala_array_free (groupdevs, groupdevs_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			} else {
				groupdevs = (_vala_array_free (groupdevs, groupdevs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp9_ = groupdevs;
	*result_length1 = groupdevs_length1;
	result = _tmp9_;
	return result;
}


/**
         * @channel_sid: ID of the channel
         * @opath: Device group's DBus path
         * @returns: TRUE on success
         */
static gboolean dvb_device_group_real_GetSchedule (DVBIDBusDeviceGroup* base, guint channel_sid, char** opath, GError** error) {
	DVBDeviceGroup * self;
	char* _opath = NULL;
	gboolean result = FALSE;
	DVBChannelList* _tmp0_ = NULL;
	gboolean _tmp1_;
	char* _tmp11_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_group_get_Channels (self);
	_tmp1_ = dvb_channel_list_contains (_tmp0_, channel_sid);
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* path;
		gboolean _tmp3_;
		char* _tmp10_ = NULL;
		_tmp2_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCHEDULE_PATH, self->priv->_Id, channel_sid);
		path = _tmp2_;
		_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->schedules, path);
		if (!_tmp3_) {
			DVBChannelList* _tmp4_ = NULL;
			DVBChannel* _tmp5_ = NULL;
			DVBChannel* _tmp6_;
			DVBSchedule* _tmp7_ = NULL;
			DVBSchedule* _tmp8_;
			DVBSchedule* _tmp9_;
			DVBSchedule* schedule;
			_tmp4_ = dvb_device_group_get_Channels (self);
			_tmp5_ = dvb_channel_list_get_channel (_tmp4_, channel_sid);
			_tmp6_ = _tmp5_;
			_tmp7_ = dvb_channel_get_Schedule (_tmp6_);
			_tmp8_ = _g_object_ref0 (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp6_);
			schedule = _tmp9_;
			dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_SCHEDULE, (GBoxedCopyFunc) g_object_ref, g_object_unref, main_conn, path, (DVBIDBusSchedule*) schedule);
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->schedules, path);
			_g_object_unref0 (schedule);
		}
		_tmp10_ = g_strdup (path);
		_g_free0 (_opath);
		_opath = _tmp10_;
		result = TRUE;
		_g_free0 (path);
		if (opath) {
			*opath = _opath;
		} else {
			_g_free0 (_opath);
		}
		return result;
	}
	_tmp11_ = g_strdup ("");
	_g_free0 (_opath);
	_opath = _tmp11_;
	result = FALSE;
	if (opath) {
		*opath = _opath;
	} else {
		_g_free0 (_opath);
	}
	return result;
}


/**
         * @returns: Location of the recordings directory
         */
static gchar* dvb_device_group_real_GetRecordingsDirectory (DVBIDBusDeviceGroup* base, GError** error) {
	DVBDeviceGroup * self;
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = dvb_device_group_get_RecordingsDirectory (self);
	_tmp1_ = g_file_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * @location: Location of the recordings directory
         * @returns: TRUE on success
         */
static gboolean dvb_device_group_real_SetRecordingsDirectory (DVBIDBusDeviceGroup* base, const gchar* location, GError** error) {
	DVBDeviceGroup * self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* config;
	GError * _inner_error_ = NULL;
	self = (DVBDeviceGroup*) base;
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (location);
	_tmp1_ = _tmp0_;
	dvb_device_group_set_RecordingsDirectory (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = dvb_factory_get_config_store ();
	config = _tmp2_;
	dvb_database_config_store_update_from_group (config, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch58_dvb_database_sql_error;
		}
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (config);
	goto __finally58;
	__catch58_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_device_group_log, "DeviceGroup.vala:446: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally58:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static GeeIterator* dvb_device_group_real_iterator (GeeIterable* base) {
	DVBDeviceGroup * self;
	GeeIterator* result = NULL;
	GeeIterator* _tmp0_ = NULL;
	self = (DVBDeviceGroup*) base;
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
	result = _tmp0_;
	return result;
}


/**
         * Set RecordingsDirectory property of all
         * devices to the values of the reference device
         */
static void dvb_device_group_update_all_devices (DVBDeviceGroup* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_devices);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _device_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->priv->devices);
			_device_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBDevice* device;
				_tmp1_ = gee_iterator_next (_device_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_device_it);
				device = (DVBDevice*) _tmp2_;
				if (device != self->priv->_reference_device) {
					GFile* _tmp3_ = NULL;
					_tmp3_ = dvb_device_get_RecordingsDirectory (self->priv->_reference_device);
					dvb_device_set_RecordingsDirectory (device, _tmp3_);
				}
				_g_object_unref0 (device);
			}
			_g_object_unref0 (_device_it);
		}
		__finally59:
		g_static_rec_mutex_unlock (&self->priv->__lock_devices);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gint dvb_device_group_get_size (DVBDeviceGroup* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->devices);
	result = _tmp0_;
	return result;
}


guint dvb_device_group_get_Id (DVBDeviceGroup* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Id;
	return result;
}


static void dvb_device_group_set_Id (DVBDeviceGroup* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_device_get_Channels (self->priv->_reference_device);
	result = _tmp0_;
	return result;
}


GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_device_get_RecordingsDirectory (self->priv->_reference_device);
	result = _tmp0_;
	return result;
}


void dvb_device_group_set_RecordingsDirectory (DVBDeviceGroup* self, GFile* value) {
	g_return_if_fail (self != NULL);
	dvb_device_set_RecordingsDirectory (self->priv->_reference_device, value);
	dvb_device_group_update_all_devices (self);
	g_object_notify ((GObject *) self, "RecordingsDirectory");
}


DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self) {
	DVBAdapterType result;
	DVBAdapterType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_device_get_Type (self->priv->_reference_device);
	result = _tmp0_;
	return result;
}


DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self) {
	DVBRecorder* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_recorder;
	return result;
}


DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self) {
	DVBEPGScanner* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_epgscanner;
	return result;
}


DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self) {
	DVBChannelFactory* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channelfactory;
	return result;
}


const gchar* dvb_device_group_get_Name (DVBDeviceGroup* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Name;
	return result;
}


void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_Name);
	self->priv->_Name = _tmp0_;
	g_object_notify ((GObject *) self, "Name");
}


DVBDevice* dvb_device_group_get_reference_device (DVBDeviceGroup* self) {
	DVBDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_reference_device;
	return result;
}


void dvb_device_group_set_reference_device (DVBDeviceGroup* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_reference_device);
	self->priv->_reference_device = _tmp0_;
	g_object_notify ((GObject *) self, "reference-device");
}


static GType dvb_device_group_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBDeviceGroup* self;
	self = (DVBDeviceGroup*) base;
	result = DVB_TYPE_DEVICE;
	return result;
}


static guint _dvb_device_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_device_hash (key);
	return result;
}


static gboolean _dvb_device_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_device_equal (a, b);
	return result;
}


static GObject * dvb_device_group_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBDeviceGroup * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	DVBChannelFactory* _tmp2_ = NULL;
	DVBRecorder* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_device_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_DEVICE_GROUP (obj);
	_tmp0_ = gee_hash_set_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _dvb_device_hash_ghash_func, _dvb_device_equal_gequal_func);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (self->priv->schedules);
	self->priv->schedules = _tmp1_;
	gee_collection_add ((GeeCollection*) self->priv->devices, self->priv->_reference_device);
	_tmp2_ = dvb_channel_factory_new (self);
	_g_object_unref0 (self->priv->_channelfactory);
	self->priv->_channelfactory = _tmp2_;
	_tmp3_ = dvb_recorder_new (self);
	_g_object_unref0 (self->priv->_recorder);
	self->priv->_recorder = _tmp3_;
	return obj;
}


static void dvb_device_group_class_init (DVBDeviceGroupClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_device_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDeviceGroupPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_device_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_device_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_device_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_RECORDER, g_param_spec_object ("recorder", "recorder", "recorder", DVB_TYPE_RECORDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_EPGSCANNER, g_param_spec_object ("epgscanner", "epgscanner", "epgscanner", DVB_TYPE_EPG_SCANNER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_CHANNEL_FACTORY, g_param_spec_object ("channel-factory", "channel-factory", "channel-factory", DVB_TYPE_CHANNEL_FACTORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_REFERENCE_DEVICE, g_param_spec_object ("reference-device", "reference-device", "reference-device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_DEVICE_GROUP_ELEMENT_TYPE, "element-type");
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_device_group_log = _tmp1_;
}


static void dvb_device_group_dvb_id_bus_device_group_interface_init (DVBIDBusDeviceGroupIface * iface) {
	dvb_device_group_dvb_id_bus_device_group_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetType = (gchar* (*)(DVBIDBusDeviceGroup* ,GError**)) dvb_device_group_real_GetType;
	iface->AddDevice = (gboolean (*)(DVBIDBusDeviceGroup* ,guint ,guint ,GError**)) dvb_device_group_real_AddDevice;
	iface->GetRecorder = (char* (*)(DVBIDBusDeviceGroup* ,GError**)) dvb_device_group_real_GetRecorder;
	iface->RemoveDevice = (gboolean (*)(DVBIDBusDeviceGroup* ,guint ,guint ,GError**)) dvb_device_group_real_RemoveDevice;
	iface->GetName = (gchar* (*)(DVBIDBusDeviceGroup* ,GError**)) dvb_device_group_real_GetName;
	iface->SetName = (gboolean (*)(DVBIDBusDeviceGroup* ,const gchar* ,GError**)) dvb_device_group_real_SetName;
	iface->GetChannelList = (char* (*)(DVBIDBusDeviceGroup* ,GError**)) dvb_device_group_real_GetChannelList;
	iface->GetMembers = (gchar** (*)(DVBIDBusDeviceGroup* ,int* ,GError**)) dvb_device_group_real_GetMembers;
	iface->GetSchedule = (gboolean (*)(DVBIDBusDeviceGroup* ,guint ,char** ,GError**)) dvb_device_group_real_GetSchedule;
	iface->GetRecordingsDirectory = (gchar* (*)(DVBIDBusDeviceGroup* ,GError**)) dvb_device_group_real_GetRecordingsDirectory;
	iface->SetRecordingsDirectory = (gboolean (*)(DVBIDBusDeviceGroup* ,const gchar* ,GError**)) dvb_device_group_real_SetRecordingsDirectory;
}


static void dvb_device_group_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_device_group_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_device_group_real_iterator;
	iface->get_element_type = dvb_device_group_real_get_element_type;
}


static void dvb_device_group_instance_init (DVBDeviceGroup * self) {
	self->priv = DVB_DEVICE_GROUP_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_devices);
}


static void dvb_device_group_finalize (GObject* obj) {
	DVBDeviceGroup * self;
	self = DVB_DEVICE_GROUP (obj);
	_g_free0 (self->priv->_Name);
	_g_object_unref0 (self->priv->_reference_device);
	g_static_rec_mutex_free (&self->priv->__lock_devices);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->_recorder);
	_g_object_unref0 (self->priv->_epgscanner);
	_g_object_unref0 (self->priv->_channelfactory);
	_g_object_unref0 (self->priv->schedules);
	G_OBJECT_CLASS (dvb_device_group_parent_class)->finalize (obj);
}


/**
     * A group of devices that share the same settings
     * (list of channels, recordings dir)
     */
GType dvb_device_group_get_type (void) {
	static volatile gsize dvb_device_group_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_device_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDeviceGroup), 0, (GInstanceInitFunc) dvb_device_group_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_device_group_info = { (GInterfaceInitFunc) dvb_device_group_dvb_id_bus_device_group_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_device_group_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_device_group_type_id;
		dvb_device_group_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDeviceGroup", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_device_group_type_id, DVB_TYPE_ID_BUS_DEVICE_GROUP, &dvb_id_bus_device_group_info);
		g_type_add_interface_static (dvb_device_group_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_device_group_type_id__volatile, dvb_device_group_type_id);
	}
	return dvb_device_group_type_id__volatile;
}


static void _vala_dvb_device_group_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDeviceGroup * self;
	self = DVB_DEVICE_GROUP (object);
	switch (property_id) {
		case DVB_DEVICE_GROUP_SIZE:
		g_value_set_int (value, dvb_device_group_get_size (self));
		break;
		case DVB_DEVICE_GROUP_ID:
		g_value_set_uint (value, dvb_device_group_get_Id (self));
		break;
		case DVB_DEVICE_GROUP_CHANNELS:
		g_value_set_object (value, dvb_device_group_get_Channels (self));
		break;
		case DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_group_get_RecordingsDirectory (self));
		break;
		case DVB_DEVICE_GROUP_TYPE:
		g_value_set_enum (value, dvb_device_group_get_Type (self));
		break;
		case DVB_DEVICE_GROUP_RECORDER:
		g_value_set_object (value, dvb_device_group_get_recorder (self));
		break;
		case DVB_DEVICE_GROUP_EPGSCANNER:
		g_value_set_object (value, dvb_device_group_get_epgscanner (self));
		break;
		case DVB_DEVICE_GROUP_CHANNEL_FACTORY:
		g_value_set_object (value, dvb_device_group_get_channel_factory (self));
		break;
		case DVB_DEVICE_GROUP_NAME:
		g_value_set_string (value, dvb_device_group_get_Name (self));
		break;
		case DVB_DEVICE_GROUP_REFERENCE_DEVICE:
		g_value_set_object (value, dvb_device_group_get_reference_device (self));
		break;
		case DVB_DEVICE_GROUP_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_device_group_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDeviceGroup * self;
	self = DVB_DEVICE_GROUP (object);
	switch (property_id) {
		case DVB_DEVICE_GROUP_ID:
		dvb_device_group_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_GROUP_RECORDINGS_DIRECTORY:
		dvb_device_group_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_GROUP_NAME:
		dvb_device_group_set_Name (self, g_value_get_string (value));
		break;
		case DVB_DEVICE_GROUP_REFERENCE_DEVICE:
		dvb_device_group_set_reference_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



