
#include <src/Main.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <signal.h>
#include <gst/gst.h>
#include <stdio.h>
#include <gee/list.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gst/rtsp-server/rtsp-media-mapping.h>
#include "src/Constants.h"
#include "src/Factory.h"
#include "src/TimersStore.h"
#include "src/ConfigStore.h"
#include "src/DeviceGroup.h"
#include "src/Recorder.h"
#include "src/Timer.h"
#include "src/rtsp/MediaMapping.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



static DVBManager* main_manager = NULL;
static DVBRecordingsStore* main_recstore = NULL;
static gboolean main_has_debug = FALSE;
static gboolean main_has_version = FALSE;
static gboolean main_disable_epg_scanner = FALSE;
static GMainLoop* main_mainloop = NULL;
static GstRTSPServer* main_server = NULL;
guint _dynamic_RequestName0 (DBusGProxy* self, const char* param1, guint param2, GError** error);
static gboolean main_start_manager (void);
static gboolean main_start_recordings_store (guint32 minimum_id);
static void main_on_exit (gint signum);
static void main_log_func (const char* log_domain, GLogLevelFlags log_levels, const char* message);
static void _main_on_exit_cutils_signal_signal_handler (gint signum);
static void _main_log_func_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self);
static void main_instance_init (Main * self);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const GOptionEntry MAIN_options[] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &main_has_debug, "Display debug statements on stdout", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_has_version, "Display version number", NULL}, {"disable-epg-scanner", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_epg_scanner, "Disable scanning for EPG data", NULL}, {NULL}};


guint _dynamic_RequestName0 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


static gboolean main_start_manager (void) {
	GError * inner_error;
	inner_error = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		/* try to register service in session bus*/
		request_name_result = _dynamic_RequestName0 (bus, DVB_CONSTANTS_DBUS_SERVICE, (guint) 0, &inner_error);
		if (inner_error != NULL) {
			(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
			(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
			goto __catch4_g_error;
			goto __finally4;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			g_debug ("Main.vala:35: Creating new Manager D-Bus service");
			main_manager = dvb_manager_get_instance ();
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), DVB_CONSTANTS_DBUS_MANAGER_PATH, (GObject*) main_manager);
		} else {
			gboolean _tmp0;
			g_debug ("Main.vala:43: Manager D-Bus service is already running");
			return (_tmp0 = FALSE, (conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL)), (bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL)), _tmp0);
		}
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp1;
			g_error ("Main.vala:48: Oops %s", e->message);
			return (_tmp1 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp1);
		}
	}
	__finally4:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return TRUE;
}


static gboolean main_start_recordings_store (guint32 minimum_id) {
	GError * inner_error;
	inner_error = NULL;
	g_debug ("Main.vala:56: Creating new RecordingsStore D-Bus service");
	{
		DBusGConnection* conn;
		DVBRecordingsStore* _tmp1;
		DVBRecordingsStore* _tmp0;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
		_tmp1 = NULL;
		_tmp0 = NULL;
		main_recstore = (_tmp1 = (_tmp0 = dvb_recordings_store_get_instance (), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (main_recstore == NULL) ? NULL : (main_recstore = (g_object_unref (main_recstore), NULL)), _tmp1);
		dvb_recordings_store_update_last_id (main_recstore, minimum_id);
		_vala_dbus_register_object (dbus_g_connection_get_connection (conn), DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH, (GObject*) main_recstore);
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp2;
			g_error ("Main.vala:68: Oops %s", e->message);
			return (_tmp2 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp2);
		}
	}
	__finally5:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return TRUE;
}


static void main_on_exit (gint signum) {
	GstRTSPServer* _tmp0;
	DVBRecordingsStore* _tmp1;
	g_message ("Main.vala:76: Exiting");
	_tmp0 = NULL;
	main_server = (_tmp0 = NULL, (main_server == NULL) ? NULL : (main_server = (g_object_unref (main_server), NULL)), _tmp0);
	dvb_manager_shutdown ();
	dvb_factory_shutdown ();
	dvb_recordings_store_shutdown ();
	_tmp1 = NULL;
	main_recstore = (_tmp1 = NULL, (main_recstore == NULL) ? NULL : (main_recstore = (g_object_unref (main_recstore), NULL)), _tmp1);
	main_manager = NULL;
	g_main_loop_quit (main_mainloop);
}


static void main_log_func (const char* log_domain, GLogLevelFlags log_levels, const char* message) {
	g_return_if_fail (message != NULL);
	if (main_has_debug) {
		g_log_default_handler (log_domain, log_levels, message, NULL);
	}
}


gboolean main_get_disable_epg_scanner (void) {
	return main_disable_epg_scanner;
}


static void _main_on_exit_cutils_signal_signal_handler (gint signum) {
	main_on_exit (signum);
}


static void _main_log_func_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self) {
	main_log_func (log_domain, log_levels, message);
}


gint main_main (char** args, int args_length1) {
	GError * inner_error;
	GOptionContext* context;
	GMainLoop* _tmp2;
	guint32 max_id;
	DVBTimersStore* timers_store;
	DVBConfigStore* config_store;
	GeeList* device_groups;
	GstRTSPServer* _tmp6;
	DVBMediaMapping* _tmp7;
	gint _tmp8;
	inner_error = NULL;
	signal (SIGINT, _main_on_exit_cutils_signal_signal_handler);
	signal (SIGTERM, _main_on_exit_cutils_signal_signal_handler);
	context = g_option_context_new ("- record and watch TV shows using one or more DVB adapters");
	g_option_context_add_main_entries (context, MAIN_options, NULL);
	g_option_context_add_group (context, gst_init_get_option_group ());
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_OPTION_ERROR) {
				goto __catch6_g_option_error;
			}
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_option_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gint _tmp0;
			fprintf (stderr, "%s\n", e->message);
			fprintf (stderr, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			return (_tmp0 = 1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp0);
		}
	}
	__finally6:
	if (inner_error != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	if (main_has_version) {
		gint _tmp1;
		fprintf (stdout, PACKAGE_NAME);
		fprintf (stdout, " %s\n", PACKAGE_VERSION);
		return (_tmp1 = 0, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp1);
	}
	g_log_set_handler (NULL, (G_LOG_LEVEL_DEBUG | G_LOG_FLAG_FATAL) | G_LOG_FLAG_RECURSION, _main_log_func_glog_func, NULL);
	/* Creating a GLib main loop with a default context*/
	_tmp2 = NULL;
	main_mainloop = (_tmp2 = g_main_loop_new (NULL, FALSE), (main_mainloop == NULL) ? NULL : (main_mainloop = (g_main_loop_unref (main_mainloop), NULL)), _tmp2);
	/* Initializing GStreamer*/
	gst_init (&args_length1, &args);
	if (!main_start_manager ()) {
		gint _tmp3;
		return (_tmp3 = -1, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp3);
	}
	max_id = (guint32) 0;
	timers_store = dvb_factory_get_timers_store ();
	config_store = dvb_factory_get_config_store ();
	device_groups = dvb_config_store_get_all_device_groups (config_store);
	{
		GeeIterator* _device_group_it;
		_device_group_it = gee_iterable_iterator ((GeeIterable*) device_groups);
		while (gee_iterator_next (_device_group_it)) {
			DVBDeviceGroup* device_group;
			device_group = (DVBDeviceGroup*) gee_iterator_get (_device_group_it);
			if (dvb_manager_add_device_group (main_manager, device_group)) {
				DVBRecorder* _tmp4;
				DVBRecorder* rec;
				GeeList* timers;
				_tmp4 = NULL;
				rec = (_tmp4 = dvb_device_group_get_recorder (device_group), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
				/* Restore timers*/
				timers = dvb_timers_store_get_all_timers_of_device_group (timers_store, device_group);
				{
					GeeIterator* _t_it;
					_t_it = gee_iterable_iterator ((GeeIterable*) timers);
					while (gee_iterator_next (_t_it)) {
						DVBTimer* t;
						t = (DVBTimer*) gee_iterator_get (_t_it);
						if (dvb_timer_get_Id (t) > max_id) {
							max_id = dvb_timer_get_Id (t);
						}
						if (dvb_recorder_add_timer (rec, t) == 0) {
							dvb_timers_store_remove_timer_from_device_group (timers_store, (guint) dvb_timer_get_Id (t), device_group);
						}
						(t == NULL) ? NULL : (t = (g_object_unref (t), NULL));
					}
					(_t_it == NULL) ? NULL : (_t_it = (g_object_unref (_t_it), NULL));
				}
				(rec == NULL) ? NULL : (rec = (g_object_unref (rec), NULL));
				(timers == NULL) ? NULL : (timers = (g_object_unref (timers), NULL));
			}
			(device_group == NULL) ? NULL : (device_group = (g_object_unref (device_group), NULL));
		}
		(_device_group_it == NULL) ? NULL : (_device_group_it = (g_object_unref (_device_group_it), NULL));
	}
	timers_store = NULL;
	config_store = NULL;
	if (!main_start_recordings_store (max_id)) {
		gint _tmp5;
		return (_tmp5 = -1, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), (device_groups == NULL) ? NULL : (device_groups = (g_object_unref (device_groups), NULL)), _tmp5);
	}
	_tmp6 = NULL;
	main_server = (_tmp6 = gst_rtsp_server_new (), (main_server == NULL) ? NULL : (main_server = (g_object_unref (main_server), NULL)), _tmp6);
	_tmp7 = NULL;
	gst_rtsp_server_set_media_mapping (main_server, (GstRTSPMediaMapping*) (_tmp7 = dvb_media_mapping_new ()));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL));
	gst_rtsp_server_attach (main_server, NULL);
	/* Start GLib mainloop*/
	g_main_loop_run (main_mainloop);
	return (_tmp8 = 0, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), (device_groups == NULL) ? NULL : (device_groups = (g_object_unref (device_groups), NULL)), _tmp8);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return main_main (argv, argc);
}


Main* main_new (void) {
	Main* self;
	self = g_slice_new0 (Main);
	main_instance_init (self);
	return self;
}


static void main_instance_init (Main * self) {
}


void main_free (Main* self) {
	g_slice_free (Main, self);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}




