
#include <src/Device.h>
#include <gst/gst.h>
#include "src/ChannelList.h"




struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	DVBChannelList* _Channels;
	GFile* _RecordingsDirectory;
	char* adapter_name;
	DVBAdapterType adapter_type;
};

#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_TYPE,
	DVB_DEVICE_NAME,
	DVB_DEVICE_CHANNELS,
	DVB_DEVICE_RECORDINGS_DIRECTORY
};
#define DVB_DEVICE_PRIME 31
static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, gboolean get_type);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
static gpointer dvb_device_parent_class = NULL;
static void dvb_device_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType dvb_adapter_type_get_type (void) {
	static GType dvb_adapter_type_type_id = 0;
	if (G_UNLIKELY (dvb_adapter_type_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {DVB_ADAPTER_TYPE_DVB_T, "DVB_ADAPTER_TYPE_DVB_T", "dvb-t"}, {DVB_ADAPTER_TYPE_DVB_S, "DVB_ADAPTER_TYPE_DVB_S", "dvb-s"}, {DVB_ADAPTER_TYPE_DVB_C, "DVB_ADAPTER_TYPE_DVB_C", "dvb-c"}, {0, NULL, NULL}};
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
	}
	return dvb_adapter_type_type_id;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend, gboolean get_type_and_name) {
	GParameter * __params;
	GParameter * __params_it;
	DVBDevice * self;
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "Adapter";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, adapter);
	__params_it++;
	__params_it->name = "Frontend";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frontend);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	dvb_device_setAdapterTypeAndName (self, adapter, get_type_and_name);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend, gboolean get_type_and_name) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend, get_type_and_name);
}


DVBDevice* dvb_device_new_full (guint adapter, guint frontend, DVBChannelList* channels, GFile* recordings_dir) {
	DVBDevice* dev;
	g_return_val_if_fail (channels != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	dev = dvb_device_new (adapter, frontend, TRUE);
	dvb_device_set_Channels (dev, channels);
	dvb_device_set_RecordingsDirectory (dev, recordings_dir);
	return dev;
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	gboolean _tmp0;
	gboolean _tmp2;
	_tmp0 = FALSE;
	if (dev1 == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = dev2 == NULL;
	}
	if (_tmp0) {
		return FALSE;
	}
	_tmp2 = FALSE;
	if (dev1->priv->_Adapter == dev2->priv->_Adapter) {
		_tmp2 = dev2->priv->_Frontend == dev2->priv->_Frontend;
	} else {
		_tmp2 = FALSE;
	}
	return _tmp2;
}


guint dvb_device_hash (DVBDevice* device) {
	if (device == NULL) {
		return (guint) 0;
	}
	return dvb_device_hash_without_device (device->priv->_Adapter, device->priv->_Frontend);
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	return ((2 * DVB_DEVICE_PRIME) + (DVB_DEVICE_PRIME * adapter)) + frontend;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstElement* _tmp1;
	GstBus* bus;
	gboolean busy_val;
	gboolean _tmp7;
	g_return_val_if_fail (self != NULL, FALSE);
	dvbsrc = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	if (dvbsrc == NULL) {
		gboolean _tmp0;
		g_critical ("Device.vala:65: Could not create dvbsrc element");
		return (_tmp0 = TRUE, (dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)), _tmp0);
	}
	g_object_set ((GObject*) dvbsrc, "adapter", self->priv->_Adapter, NULL);
	g_object_set ((GObject*) dvbsrc, "frontend", self->priv->_Frontend, NULL);
	pipeline = (GstElement*) ((GstPipeline*) gst_pipeline_new (""));
	_tmp1 = NULL;
	gst_bin_add (GST_BIN (pipeline), (_tmp1 = dvbsrc, (_tmp1 == NULL) ? NULL : gst_object_ref (_tmp1)));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	busy_val = FALSE;
	while (gst_bus_have_pending (bus)) {
		GstMessage* msg;
		gboolean _tmp2;
		msg = gst_bus_pop (bus);
		_tmp2 = FALSE;
		if (msg->type == GST_MESSAGE_ERROR) {
			_tmp2 = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			GError* gerror;
			char* debug_text;
			char* _tmp6;
			char* _tmp5;
			GError* _tmp4;
			GError* _tmp3;
			gerror = NULL;
			debug_text = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp4 = NULL;
			_tmp3 = NULL;
			(gst_message_parse_error (msg, &_tmp3, &_tmp5), gerror = (_tmp4 = _tmp3, (gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL)), _tmp4));
			debug_text = (_tmp6 = _tmp5, debug_text = (g_free (debug_text), NULL), _tmp6);
			g_debug ("Device.vala:87: Error tuning: %s; %s", gerror->message, debug_text);
			busy_val = TRUE;
			(gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL));
			debug_text = (g_free (debug_text), NULL);
		}
		(msg == NULL) ? NULL : (msg = (gst_message_unref (msg), NULL));
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	return (_tmp7 = busy_val, (dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)), (pipeline == NULL) ? NULL : (pipeline = (gst_object_unref (pipeline), NULL)), (bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL)), _tmp7);
}


static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, gboolean get_type) {
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstElement* _tmp2;
	GstBus* bus;
	gboolean success;
	char* adapter_type;
	gboolean _tmp10;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!get_type) {
		return TRUE;
	}
	dvbsrc = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	if (dvbsrc == NULL) {
		gboolean _tmp1;
		g_critical ("Device.vala:103: Could not create dvbsrc element");
		return (_tmp1 = FALSE, (dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)), _tmp1);
	}
	g_object_set ((GObject*) dvbsrc, "adapter", adapter, NULL);
	pipeline = (GstElement*) ((GstPipeline*) gst_pipeline_new ("type_name"));
	_tmp2 = NULL;
	gst_bin_add (GST_BIN (pipeline), (_tmp2 = dvbsrc, (_tmp2 == NULL) ? NULL : gst_object_ref (_tmp2)));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	success = FALSE;
	adapter_type = NULL;
	while (gst_bus_have_pending (bus)) {
		GstMessage* msg;
		gboolean _tmp3;
		msg = gst_bus_pop (bus);
		_tmp3 = FALSE;
		if (msg->type == GST_MESSAGE_ELEMENT) {
			_tmp3 = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp3 = FALSE;
		}
		if (_tmp3) {
			const GstStructure* structure;
			structure = msg->structure;
			if (_vala_strcmp0 (gst_structure_get_name (structure), "dvb-adapter") == 0) {
				char* _tmp4;
				char* _tmp5;
				_tmp4 = NULL;
				adapter_type = (_tmp4 = g_strdup_printf ("%s", gst_structure_get_string (structure, "type")), adapter_type = (g_free (adapter_type), NULL), _tmp4);
				_tmp5 = NULL;
				self->priv->adapter_name = (_tmp5 = g_strdup_printf ("%s", gst_structure_get_string (structure, "name")), self->priv->adapter_name = (g_free (self->priv->adapter_name), NULL), _tmp5);
				success = TRUE;
				(msg == NULL) ? NULL : (msg = (gst_message_unref (msg), NULL));
				break;
			}
		} else {
			if (msg->type == GST_MESSAGE_ERROR) {
				GError* gerror;
				char* debug;
				char* _tmp9;
				char* _tmp8;
				GError* _tmp7;
				GError* _tmp6;
				gerror = NULL;
				debug = NULL;
				_tmp9 = NULL;
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				(gst_message_parse_error (msg, &_tmp6, &_tmp8), gerror = (_tmp7 = _tmp6, (gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL)), _tmp7));
				debug = (_tmp9 = _tmp8, debug = (g_free (debug), NULL), _tmp9);
				g_critical ("Device.vala:133: %s %s", gerror->message, debug);
				(gerror == NULL) ? NULL : (gerror = (g_error_free (gerror), NULL));
				debug = (g_free (debug), NULL);
			}
		}
		(msg == NULL) ? NULL : (msg = (gst_message_unref (msg), NULL));
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	if (_vala_strcmp0 (adapter_type, "DVB-T") == 0) {
		self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_T;
	} else {
		if (_vala_strcmp0 (adapter_type, "DVB-S") == 0) {
			self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_S;
		} else {
			if (_vala_strcmp0 (adapter_type, "DVB-C") == 0) {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_C;
			} else {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_UNKNOWN;
			}
		}
	}
	return (_tmp10 = success, (dvbsrc == NULL) ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)), (pipeline == NULL) ? NULL : (pipeline = (gst_object_unref (pipeline), NULL)), (bus == NULL) ? NULL : (bus = (gst_object_unref (bus), NULL)), adapter_type = (g_free (adapter_type), NULL), _tmp10);
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Adapter;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Adapter = value;
	g_object_notify ((GObject *) self, "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return self->priv->_Frontend;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frontend = value;
	g_object_notify ((GObject *) self, "Frontend");
}


DVBAdapterType dvb_device_get_Type (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->adapter_type;
}


const char* dvb_device_get_Name (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->adapter_name;
}


DVBChannelList* dvb_device_get_Channels (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_Channels;
}


void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value) {
	DVBChannelList* _tmp2;
	DVBChannelList* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Channels = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_Channels == NULL) ? NULL : (self->priv->_Channels = (g_object_unref (self->priv->_Channels), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "Channels");
}


GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_RecordingsDirectory;
}


void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_RecordingsDirectory = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_RecordingsDirectory == NULL) ? NULL : (self->priv->_RecordingsDirectory = (g_object_unref (self->priv->_RecordingsDirectory), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "RecordingsDirectory");
}


static void dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	gpointer boxed;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_TYPE:
		g_value_set_enum (value, dvb_device_get_Type (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		case DVB_DEVICE_CHANNELS:
		g_value_set_object (value, dvb_device_get_Channels (self));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_get_RecordingsDirectory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_CHANNELS:
		dvb_device_set_Channels (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		dvb_device_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = DVB_DEVICE (obj);
	(self->priv->_Channels == NULL) ? NULL : (self->priv->_Channels = (g_object_unref (self->priv->_Channels), NULL));
	(self->priv->_RecordingsDirectory == NULL) ? NULL : (self->priv->_RecordingsDirectory = (g_object_unref (self->priv->_RecordingsDirectory), NULL));
	self->priv->adapter_name = (g_free (self->priv->adapter_name), NULL);
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static GType dvb_device_type_id = 0;
	if (dvb_device_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
	}
	return dvb_device_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




