
#include <src/ConfigStore.h>







GeeList* dvb_config_store_get_all_device_groups (DVBConfigStore* self) {
	return DVB_CONFIG_STORE_GET_INTERFACE (self)->get_all_device_groups (self);
}


void dvb_config_store_add_device_group (DVBConfigStore* self, DVBDeviceGroup* dev_group) {
	DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_group (self, dev_group);
}


void dvb_config_store_remove_device_group (DVBConfigStore* self, DVBDeviceGroup* devgroup) {
	DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_group (self, devgroup);
}


void dvb_config_store_add_device_to_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	DVB_CONFIG_STORE_GET_INTERFACE (self)->add_device_to_group (self, dev, devgroup);
}


void dvb_config_store_remove_device_from_group (DVBConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup) {
	DVB_CONFIG_STORE_GET_INTERFACE (self)->remove_device_from_group (self, dev, devgroup);
}


static void dvb_config_store_base_init (DVBConfigStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_config_store_get_type (void) {
	static GType dvb_config_store_type_id = 0;
	if (dvb_config_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBConfigStoreIface), (GBaseInitFunc) dvb_config_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_config_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBConfigStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_config_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_config_store_type_id;
}




