
#include <src/IDBusChannelList.h>
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* result, GError** error);


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: List of channel IDs aka SIDs of all channels
         */
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetRadioChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetTVChannels (self, result_length1);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of channel if channel with id exists
         * otherwise an empty string
         */
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelName (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         */
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelNetwork (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Whether the channel is a radio channel or not
         */
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->IsRadioChannel (self, channel_id);
}


static gboolean _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error) {
	guint* result;
	int result_length1;
	result = dvb_id_bus_channel_list_GetChannels (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error) {
	guint* result;
	int result_length1;
	result = dvb_id_bus_channel_list_GetRadioChannels (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, GArray** dbus_result, GError** error) {
	guint* result;
	int result_length1;
	result = dvb_id_bus_channel_list_GetTVChannels (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id, char** result, GError** error) {
	*result = dvb_id_bus_channel_list_GetChannelName (self, channel_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id, char** result, GError** error) {
	*result = dvb_id_bus_channel_list_GetChannelNetwork (self, channel_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id, gboolean* result, GError** error) {
	*result = dvb_id_bus_channel_list_IsRadioChannel (self, channel_id);
	return !error || !*error;
}


static void dvb_id_bus_channel_list_base_init (DVBIDBusChannelListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_CHANNEL_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		static const DBusGMethodInfo dvb_id_bus_channel_list_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_channel_list_GetChannels, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_channel_list_GetRadioChannels, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 57 },
{ (GCallback) _dbus_dvb_id_bus_channel_list_GetTVChannels, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 119 },
{ (GCallback) _dbus_dvb_id_bus_channel_list_GetChannelName, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 178 },
{ (GCallback) _dbus_dvb_id_bus_channel_list_GetChannelNetwork, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 252 },
{ (GCallback) _dbus_dvb_id_bus_channel_list_IsRadioChannel, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 329 },
}
;
		static const DBusGObjectInfo dvb_id_bus_channel_list_dbus_object_info = { 0, dvb_id_bus_channel_list_dbus_methods, 6, "org.gnome.DVB.ChannelList\0GetChannels\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.ChannelList\0GetRadioChannels\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.ChannelList\0GetTVChannels\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.ChannelList\0GetChannelName\0S\0channel_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.ChannelList\0GetChannelNetwork\0S\0channel_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.ChannelList\0IsRadioChannel\0S\0channel_id\0I\0u\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.ChannelList\0Changed\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_CHANNEL_LIST, &dvb_id_bus_channel_list_dbus_object_info);
	}
}


GType dvb_id_bus_channel_list_get_type (void) {
	static GType dvb_id_bus_channel_list_type_id = 0;
	if (dvb_id_bus_channel_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusChannelListIface), (GBaseInitFunc) dvb_id_bus_channel_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_channel_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusChannelList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_channel_list_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_channel_list_type_id;
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) (gpointer data1, guint arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}



