/* trf-persona.c generated by valac 0.14.0, the Vala compiler
 * generated from trf-persona.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *         Travis Reitter <travis.reitter@collabora.co.uk>
 *         Marco Barisione <marco.barisione@collabora.co.uk>
 *         Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>


#define TRF_TYPE_PERSONA (trf_persona_get_type ())
#define TRF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA, TrfPersona))
#define TRF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA, TrfPersonaClass))
#define TRF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA))
#define TRF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA))
#define TRF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA, TrfPersonaClass))

typedef struct _TrfPersona TrfPersona;
typedef struct _TrfPersonaClass TrfPersonaClass;
typedef struct _TrfPersonaPrivate TrfPersonaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TRF_TYPE_PERSONA_STORE (trf_persona_store_get_type ())
#define TRF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStore))
#define TRF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))
#define TRF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA_STORE))
#define TRF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA_STORE))
#define TRF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))

typedef struct _TrfPersonaStore TrfPersonaStore;
typedef struct _TrfPersonaStoreClass TrfPersonaStoreClass;
typedef struct _TrfPersonaChangeNicknameData TrfPersonaChangeNicknameData;
typedef struct _TrfPersonaChangePhoneNumbersData TrfPersonaChangePhoneNumbersData;
typedef struct _TrfPersonaChangeEmailAddressesData TrfPersonaChangeEmailAddressesData;
typedef struct _TrfPersonaChangeAvatarData TrfPersonaChangeAvatarData;
typedef struct _TrfPersonaChangeStructuredNameData TrfPersonaChangeStructuredNameData;
typedef struct _TrfPersonaChangeFullNameData TrfPersonaChangeFullNameData;
typedef struct _TrfPersonaChangeGenderData TrfPersonaChangeGenderData;
typedef struct _TrfPersonaChangeBirthdayData TrfPersonaChangeBirthdayData;
typedef struct _TrfPersonaChangeRolesData TrfPersonaChangeRolesData;
typedef struct _TrfPersonaChangeNotesData TrfPersonaChangeNotesData;
typedef struct _TrfPersonaChangeUrlsData TrfPersonaChangeUrlsData;
typedef struct _TrfPersonaChangePostalAddressesData TrfPersonaChangePostalAddressesData;
typedef struct _TrfPersonaChangeImAddressesData TrfPersonaChangeImAddressesData;
typedef struct _TrfPersonaChangeIsFavouriteData TrfPersonaChangeIsFavouriteData;
typedef struct _TrfPersonaChangeLocalIdsData TrfPersonaChangeLocalIdsData;
typedef struct _TrfPersonaChangeWebServiceAddressesData TrfPersonaChangeWebServiceAddressesData;

#define TRF_TYPE_FIELDS (trf_fields_get_type ())

#define TRF_TYPE_POSTAL_ADDRESS_FIELDS (trf_postal_address_fields_get_type ())

#define TRF_TYPE_ROLE_FIELDS (trf_role_fields_get_type ())

#define TRF_TYPE_IM_FIELDS (trf_im_fields_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRF_TYPE_PHONE_FIELDS (trf_phone_fields_get_type ())

#define TRF_TYPE_EMAIL_FIELDS (trf_email_fields_get_type ())

#define TRF_TYPE_URLS_FIELDS (trf_urls_fields_get_type ())

struct _TrfPersona {
	FolksPersona parent_instance;
	TrfPersonaPrivate * priv;
};

struct _TrfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TrfPersonaPrivate {
	gchar* _nickname;
	gboolean _is_favourite;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	TrackerSparqlCursor* _cursor;
	gchar* _tracker_id;
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	FolksGender _gender;
	GDateTime* _birthday;
	GeeHashSet* _roles;
	GeeSet* _roles_ro;
	GeeHashSet* _notes;
	GeeSet* _notes_ro;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashSet* _postal_addresses;
	GeeSet* _postal_addresses_ro;
	GeeHashMap* _tracker_ids_ims;
	GeeHashMultiMap* _im_addresses;
	GeeHashSet* _local_ids;
	GeeSet* _local_ids_ro;
	GeeHashMultiMap* _web_service_addresses;
};

struct _TrfPersonaChangeNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gchar* nickname;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
};

struct _TrfPersonaChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* phone_numbers;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* email_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GLoadableIcon* avatar;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GLoadableIcon* _tmp2_;
};

struct _TrfPersonaChangeStructuredNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	FolksStructuredName* structured_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksStructuredName* _tmp2_;
};

struct _TrfPersonaChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gchar* full_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
};

struct _TrfPersonaChangeGenderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	FolksGender gender;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksGender _tmp2_;
};

struct _TrfPersonaChangeBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GDateTime* birthday;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
};

struct _TrfPersonaChangeRolesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* roles;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeNotesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* notes;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* urls;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangePostalAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* postal_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeSet* _tmp2_;
};

struct _TrfPersonaChangeImAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeMultiMap* im_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeMultiMap* _tmp2_;
};

struct _TrfPersonaChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	gboolean is_favourite;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
};

struct _TrfPersonaChangeLocalIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeSet* local_ids;
	GeeSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksPersonaStore* _tmp7_;
	FolksPersonaStore* _tmp8_;
	GeeSet* _tmp9_;
};

struct _TrfPersonaChangeWebServiceAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrfPersona* self;
	GeeMultiMap* web_service_addresses;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GeeMultiMap* _tmp2_;
};

typedef enum  {
	TRF_FIELDS_TRACKER_ID,
	TRF_FIELDS_FULL_NAME,
	TRF_FIELDS_FAMILY_NAME,
	TRF_FIELDS_GIVEN_NAME,
	TRF_FIELDS_ADDITIONAL_NAMES,
	TRF_FIELDS_PREFIXES,
	TRF_FIELDS_SUFFIXES,
	TRF_FIELDS_NICKNAME,
	TRF_FIELDS_BIRTHDAY,
	TRF_FIELDS_AVATAR_URL,
	TRF_FIELDS_IM_ADDRESSES,
	TRF_FIELDS_PHONES,
	TRF_FIELDS_EMAILS,
	TRF_FIELDS_URLS,
	TRF_FIELDS_FAVOURITE,
	TRF_FIELDS_CONTACT_URN,
	TRF_FIELDS_ROLES,
	TRF_FIELDS_NOTE,
	TRF_FIELDS_GENDER,
	TRF_FIELDS_POSTAL_ADDRESS,
	TRF_FIELDS_LOCAL_IDS_PROPERTY
} TrfFields;

typedef enum  {
	TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID,
	TRF_POSTAL_ADDRESS_FIELDS_POBOX,
	TRF_POSTAL_ADDRESS_FIELDS_DISTRICT,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTY,
	TRF_POSTAL_ADDRESS_FIELDS_LOCALITY,
	TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE,
	TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_ADDRESS_LOCATION,
	TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTRY,
	TRF_POSTAL_ADDRESS_FIELDS_REGION
} TrfPostalAddressFields;

typedef enum  {
	TRF_ROLE_FIELDS_TRACKER_ID,
	TRF_ROLE_FIELDS_ROLE,
	TRF_ROLE_FIELDS_DEPARTMENT,
	TRF_ROLE_FIELDS_TITLE
} TrfRoleFields;

typedef enum  {
	TRF_IM_FIELDS_TRACKER_ID,
	TRF_IM_FIELDS_PROTO,
	TRF_IM_FIELDS_ID,
	TRF_IM_FIELDS_IM_NICKNAME
} TrfIMFields;

typedef enum  {
	TRF_PHONE_FIELDS_TRACKER_ID,
	TRF_PHONE_FIELDS_PHONE
} TrfPhoneFields;

typedef enum  {
	TRF_EMAIL_FIELDS_TRACKER_ID,
	TRF_EMAIL_FIELDS_EMAIL
} TrfEmailFields;

typedef enum  {
	TRF_URLS_FIELDS_TRACKER_ID,
	TRF_URLS_FIELDS_BLOG,
	TRF_URLS_FIELDS_WEBSITE,
	TRF_URLS_FIELDS_URL
} TrfUrlsFields;


static gpointer trf_persona_parent_class = NULL;
static FolksAvatarDetailsIface* trf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* trf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* trf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* trf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGenderDetailsIface* trf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* trf_persona_folks_im_details_parent_iface = NULL;
static FolksLocalIdDetailsIface* trf_persona_folks_local_id_details_parent_iface = NULL;
static FolksNameDetailsIface* trf_persona_folks_name_details_parent_iface = NULL;
static FolksNoteDetailsIface* trf_persona_folks_note_details_parent_iface = NULL;
static FolksPhoneDetailsIface* trf_persona_folks_phone_details_parent_iface = NULL;
static FolksPostalAddressDetailsIface* trf_persona_folks_postal_address_details_parent_iface = NULL;
static FolksRoleDetailsIface* trf_persona_folks_role_details_parent_iface = NULL;
static FolksUrlDetailsIface* trf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* trf_persona_folks_web_service_details_parent_iface = NULL;

GType trf_persona_get_type (void) G_GNUC_CONST;
#define TRF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRF_TYPE_PERSONA, TrfPersonaPrivate))
enum  {
	TRF_PERSONA_DUMMY_PROPERTY,
	TRF_PERSONA_NICKNAME,
	TRF_PERSONA_PHONE_NUMBERS,
	TRF_PERSONA_EMAIL_ADDRESSES,
	TRF_PERSONA_LINKABLE_PROPERTIES,
	TRF_PERSONA_WRITEABLE_PROPERTIES,
	TRF_PERSONA_AVATAR,
	TRF_PERSONA_STRUCTURED_NAME,
	TRF_PERSONA_FULL_NAME,
	TRF_PERSONA_GENDER,
	TRF_PERSONA_BIRTHDAY,
	TRF_PERSONA_CALENDAR_EVENT_ID,
	TRF_PERSONA_ROLES,
	TRF_PERSONA_NOTES,
	TRF_PERSONA_URLS,
	TRF_PERSONA_POSTAL_ADDRESSES,
	TRF_PERSONA_IM_ADDRESSES,
	TRF_PERSONA_IS_FAVOURITE,
	TRF_PERSONA_LOCAL_IDS,
	TRF_PERSONA_WEB_SERVICE_ADDRESSES
};
static void trf_persona_real_change_nickname_data_free (gpointer _data);
static void trf_persona_real_change_nickname (FolksNameDetails* base, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_nickname_co (TrfPersonaChangeNicknameData* _data_);
GType trf_persona_store_get_type (void) G_GNUC_CONST;
void _trf_persona_store_set_nickname (TrfPersonaStore* self, TrfPersona* persona, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_nickname_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_phone_numbers_data_free (gpointer _data);
static void trf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_phone_numbers_co (TrfPersonaChangePhoneNumbersData* _data_);
void _trf_persona_store_set_phones (TrfPersonaStore* self, FolksPersona* persona, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_phones_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_email_addresses_data_free (gpointer _data);
static void trf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_email_addresses_co (TrfPersonaChangeEmailAddressesData* _data_);
void _trf_persona_store_set_emails (TrfPersonaStore* self, FolksPersona* persona, GeeSet* emails, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_emails_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_avatar_data_free (gpointer _data);
static void trf_persona_real_change_avatar (FolksAvatarDetails* base, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_avatar_co (TrfPersonaChangeAvatarData* _data_);
void _trf_persona_store_set_avatar (TrfPersonaStore* self, FolksPersona* persona, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_avatar_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_structured_name_data_free (gpointer _data);
static void trf_persona_real_change_structured_name (FolksNameDetails* base, FolksStructuredName* structured_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_structured_name_co (TrfPersonaChangeStructuredNameData* _data_);
void _trf_persona_store_set_structured_name (TrfPersonaStore* self, FolksPersona* persona, FolksStructuredName* sname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_structured_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_structured_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_full_name_data_free (gpointer _data);
static void trf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_full_name_co (TrfPersonaChangeFullNameData* _data_);
void _trf_persona_store_set_full_name (TrfPersonaStore* self, FolksPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_full_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_gender_data_free (gpointer _data);
static void trf_persona_real_change_gender (FolksGenderDetails* base, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_gender_co (TrfPersonaChangeGenderData* _data_);
void _trf_persona_store_set_gender (TrfPersonaStore* self, FolksPersona* persona, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_gender_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_gender_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_birthday_data_free (gpointer _data);
static void trf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_birthday_co (TrfPersonaChangeBirthdayData* _data_);
void _trf_persona_store_set_birthday (TrfPersonaStore* self, FolksPersona* persona, GDateTime* bday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_birthday_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_roles_data_free (gpointer _data);
static void trf_persona_real_change_roles (FolksRoleDetails* base, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_roles_co (TrfPersonaChangeRolesData* _data_);
void _trf_persona_store_set_roles (TrfPersonaStore* self, FolksPersona* persona, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_roles_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_roles_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_notes_data_free (gpointer _data);
static void trf_persona_real_change_notes (FolksNoteDetails* base, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_notes_co (TrfPersonaChangeNotesData* _data_);
void _trf_persona_store_set_notes (TrfPersonaStore* self, FolksPersona* persona, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_notes_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_notes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_urls_data_free (gpointer _data);
static void trf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_urls_co (TrfPersonaChangeUrlsData* _data_);
void _trf_persona_store_set_urls (TrfPersonaStore* self, FolksPersona* persona, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_urls_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_postal_addresses_data_free (gpointer _data);
static void trf_persona_real_change_postal_addresses (FolksPostalAddressDetails* base, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_postal_addresses_co (TrfPersonaChangePostalAddressesData* _data_);
void _trf_persona_store_set_postal_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_postal_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_postal_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_im_addresses_data_free (gpointer _data);
static void trf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_im_addresses_co (TrfPersonaChangeImAddressesData* _data_);
void _trf_persona_store_set_im_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_im_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_is_favourite_data_free (gpointer _data);
static void trf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_is_favourite_co (TrfPersonaChangeIsFavouriteData* _data_);
void _trf_persona_store_set_is_favourite (TrfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_is_favourite_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_local_ids_data_free (gpointer _data);
static void trf_persona_real_change_local_ids (FolksLocalIdDetails* base, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_local_ids_co (TrfPersonaChangeLocalIdsData* _data_);
void _trf_persona_store_set_local_ids (TrfPersonaStore* self, TrfPersona* persona, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_local_ids_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_local_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void trf_persona_real_change_web_service_addresses_data_free (gpointer _data);
static void trf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean trf_persona_real_change_web_service_addresses_co (TrfPersonaChangeWebServiceAddressesData* _data_);
void _trf_persona_store_set_web_service_addrs (TrfPersonaStore* self, TrfPersona* persona, GeeMultiMap* ws_obj, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_web_service_addrs_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id);
TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
GType trf_fields_get_type (void) G_GNUC_CONST;
#define TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#default-conta" \
"ct-me"
static void _trf_persona_update_names (TrfPersona* self);
static void _trf_persona_update_avatar (TrfPersona* self);
static void _trf_persona_update_im_addresses (TrfPersona* self);
static void _trf_persona_update_phones (TrfPersona* self);
static void _trf_persona_update_email_addresses (TrfPersona* self);
static void _trf_persona_update_urls (TrfPersona* self);
static void _trf_persona_update_favourite (TrfPersona* self);
static void _trf_persona_update_roles (TrfPersona* self);
static void _trf_persona_update_bday (TrfPersona* self);
static void _trf_persona_update_note (TrfPersona* self);
static void _trf_persona_update_gender (TrfPersona* self);
static void _trf_persona_update_postal_addresses (TrfPersona* self);
static void _trf_persona_update_local_ids (TrfPersona* self);
gchar* trf_persona_tracker_id (TrfPersona* self);
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn);
void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname);
void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name);
void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name);
void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names);
void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes);
void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes);
GType trf_postal_address_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids);
gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddressFieldDetails* postal_address_fd);
gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id);
void _trf_persona_set_gender (TrfPersona* self, gint gender_id);
gint trf_persona_store_get_gender_male_id (TrfPersonaStore* self);
gint trf_persona_store_get_gender_female_id (TrfPersonaStore* self);
void _trf_persona_set_note (TrfPersona* self, const gchar* note_content);
void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday);
GType trf_role_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* role, const gchar* title, const gchar* org);
gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id);
gboolean _trf_persona_set_avatar_from_uri (TrfPersona* self, const gchar* avatar_url);
gboolean _trf_persona_set_avatar (TrfPersona* self, GLoadableIcon* avatar);
GeeSet* trf_persona_store_unserialize_local_ids (const gchar* local_ids);
gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs);
GeeMultiMap* trf_persona_store_unserialize_web_services (const gchar* ws_addrs);
GType trf_im_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify);
gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify);
GType trf_phone_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id);
gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id);
gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id);
gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id);
GType trf_email_fields_get_type (void) G_GNUC_CONST;
GType trf_urls_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type);
gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id);
gint trf_persona_store_get_favorite_id (TrfPersonaStore* self);
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav);
static void trf_persona_finalize (GObject* obj);
static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TRF_PERSONA__linkable_properties[3] = {"im-addresses", "local-ids", "web-service-addresses"};
static const gchar* TRF_PERSONA__writeable_properties[14] = {"phone-numbers", "email-addresses", "avatar", "structured-name", "full-name", "gender", "birthday", "roles", "notes", "urls", "im-addresses", "is-favourite", "local-ids", "web-service-addresses"};

static void trf_persona_real_change_nickname_data_free (gpointer _data) {
	TrfPersonaChangeNicknameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->nickname);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeNicknameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void trf_persona_real_change_nickname (FolksNameDetails* base, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeNicknameData* _data_;
	TrfPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeNicknameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_nickname_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = nickname;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->nickname = _tmp2_;
	trf_persona_real_change_nickname_co (_data_);
}


static void trf_persona_real_change_nickname_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeNicknameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeNicknameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_nickname_co (_data_);
}


static gboolean trf_persona_real_change_nickname_co (TrfPersonaChangeNicknameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->nickname;
	_data_->_state_ = 1;
	_trf_persona_store_set_nickname (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->self, _data_->_tmp2_, trf_persona_change_nickname_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_nickname_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_phone_numbers_data_free (gpointer _data) {
	TrfPersonaChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangePhoneNumbersData, _data_);
}


static void trf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangePhoneNumbersData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->phone_numbers = _tmp2_;
	trf_persona_real_change_phone_numbers_co (_data_);
}


static void trf_persona_real_change_phone_numbers_finish (FolksPhoneDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangePhoneNumbersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_phone_numbers_co (_data_);
}


static gboolean trf_persona_real_change_phone_numbers_co (TrfPersonaChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->phone_numbers;
	_data_->_state_ = 1;
	_trf_persona_store_set_phones (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_phone_numbers_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_phones_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_email_addresses_data_free (gpointer _data) {
	TrfPersonaChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeEmailAddressesData, _data_);
}


static void trf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeEmailAddressesData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeEmailAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_email_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->email_addresses = _tmp2_;
	trf_persona_real_change_email_addresses_co (_data_);
}


static void trf_persona_real_change_email_addresses_finish (FolksEmailDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeEmailAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeEmailAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_email_addresses_co (_data_);
}


static gboolean trf_persona_real_change_email_addresses_co (TrfPersonaChangeEmailAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->email_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_emails (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_email_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_emails_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_avatar_data_free (gpointer _data) {
	TrfPersonaChangeAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->avatar);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeAvatarData, _data_);
}


static void trf_persona_real_change_avatar (FolksAvatarDetails* base, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeAvatarData* _data_;
	TrfPersona* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = avatar;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->avatar = _tmp2_;
	trf_persona_real_change_avatar_co (_data_);
}


static void trf_persona_real_change_avatar_finish (FolksAvatarDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_avatar_co (_data_);
}


static gboolean trf_persona_real_change_avatar_co (TrfPersonaChangeAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->avatar;
	_data_->_state_ = 1;
	_trf_persona_store_set_avatar (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_avatar_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_avatar_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_structured_name_data_free (gpointer _data) {
	TrfPersonaChangeStructuredNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->structured_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeStructuredNameData, _data_);
}


static void trf_persona_real_change_structured_name (FolksNameDetails* base, FolksStructuredName* structured_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeStructuredNameData* _data_;
	TrfPersona* _tmp0_;
	FolksStructuredName* _tmp1_;
	FolksStructuredName* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeStructuredNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_structured_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_structured_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = structured_name;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->structured_name = _tmp2_;
	trf_persona_real_change_structured_name_co (_data_);
}


static void trf_persona_real_change_structured_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeStructuredNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_structured_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeStructuredNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_structured_name_co (_data_);
}


static gboolean trf_persona_real_change_structured_name_co (TrfPersonaChangeStructuredNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->structured_name;
	_data_->_state_ = 1;
	_trf_persona_store_set_structured_name (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_structured_name_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_structured_name_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_full_name_data_free (gpointer _data) {
	TrfPersonaChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeFullNameData, _data_);
}


static void trf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeFullNameData* _data_;
	TrfPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->full_name = _tmp2_;
	trf_persona_real_change_full_name_co (_data_);
}


static void trf_persona_real_change_full_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_full_name_co (_data_);
}


static gboolean trf_persona_real_change_full_name_co (TrfPersonaChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->full_name;
	_data_->_state_ = 1;
	_trf_persona_store_set_full_name (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_full_name_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_full_name_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_gender_data_free (gpointer _data) {
	TrfPersonaChangeGenderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeGenderData, _data_);
}


static void trf_persona_real_change_gender (FolksGenderDetails* base, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeGenderData* _data_;
	TrfPersona* _tmp0_;
	FolksGender _tmp1_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeGenderData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_gender);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_gender_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = gender;
	_data_->gender = _tmp1_;
	trf_persona_real_change_gender_co (_data_);
}


static void trf_persona_real_change_gender_finish (FolksGenderDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeGenderData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_gender_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeGenderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_gender_co (_data_);
}


static gboolean trf_persona_real_change_gender_co (TrfPersonaChangeGenderData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->gender;
	_data_->_state_ = 1;
	_trf_persona_store_set_gender (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_gender_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_gender_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_birthday_data_free (gpointer _data) {
	TrfPersonaChangeBirthdayData* _data_;
	_data_ = _data;
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void trf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeBirthdayData* _data_;
	TrfPersona* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = birthday;
	_tmp2_ = _g_date_time_ref0 (_tmp1_);
	_data_->birthday = _tmp2_;
	trf_persona_real_change_birthday_co (_data_);
}


static void trf_persona_real_change_birthday_finish (FolksBirthdayDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_birthday_co (_data_);
}


static gboolean trf_persona_real_change_birthday_co (TrfPersonaChangeBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->birthday;
	_data_->_tmp3_ = _g_date_time_ref0 (_data_->_tmp2_);
	_data_->_state_ = 1;
	_trf_persona_store_set_birthday (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp3_, trf_persona_change_birthday_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_birthday_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_roles_data_free (gpointer _data) {
	TrfPersonaChangeRolesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->roles);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeRolesData, _data_);
}


static void trf_persona_real_change_roles (FolksRoleDetails* base, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeRolesData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeRolesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_roles);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_roles_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = roles;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->roles = _tmp2_;
	trf_persona_real_change_roles_co (_data_);
}


static void trf_persona_real_change_roles_finish (FolksRoleDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeRolesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_roles_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeRolesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_roles_co (_data_);
}


static gboolean trf_persona_real_change_roles_co (TrfPersonaChangeRolesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->roles;
	_data_->_state_ = 1;
	_trf_persona_store_set_roles (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_roles_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_roles_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_notes_data_free (gpointer _data) {
	TrfPersonaChangeNotesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->notes);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeNotesData, _data_);
}


static void trf_persona_real_change_notes (FolksNoteDetails* base, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeNotesData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeNotesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_notes);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_notes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = notes;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->notes = _tmp2_;
	trf_persona_real_change_notes_co (_data_);
}


static void trf_persona_real_change_notes_finish (FolksNoteDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeNotesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_notes_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeNotesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_notes_co (_data_);
}


static gboolean trf_persona_real_change_notes_co (TrfPersonaChangeNotesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->notes;
	_data_->_state_ = 1;
	_trf_persona_store_set_notes (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_notes_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_notes_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_urls_data_free (gpointer _data) {
	TrfPersonaChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeUrlsData, _data_);
}


static void trf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeUrlsData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeUrlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_urls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = urls;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->urls = _tmp2_;
	trf_persona_real_change_urls_co (_data_);
}


static void trf_persona_real_change_urls_finish (FolksUrlDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeUrlsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeUrlsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_urls_co (_data_);
}


static gboolean trf_persona_real_change_urls_co (TrfPersonaChangeUrlsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->urls;
	_data_->_state_ = 1;
	_trf_persona_store_set_urls (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_urls_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_urls_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_postal_addresses_data_free (gpointer _data) {
	TrfPersonaChangePostalAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->postal_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangePostalAddressesData, _data_);
}


static void trf_persona_real_change_postal_addresses (FolksPostalAddressDetails* base, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangePostalAddressesData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangePostalAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_postal_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_postal_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = postal_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->postal_addresses = _tmp2_;
	trf_persona_real_change_postal_addresses_co (_data_);
}


static void trf_persona_real_change_postal_addresses_finish (FolksPostalAddressDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangePostalAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_postal_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangePostalAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_postal_addresses_co (_data_);
}


static gboolean trf_persona_real_change_postal_addresses_co (TrfPersonaChangePostalAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->postal_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_postal_addresses (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_postal_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_postal_addresses_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_im_addresses_data_free (gpointer _data) {
	TrfPersonaChangeImAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->im_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeImAddressesData, _data_);
}


static void trf_persona_real_change_im_addresses (FolksImDetails* base, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeImAddressesData* _data_;
	TrfPersona* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeImAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_im_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_im_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = im_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->im_addresses = _tmp2_;
	trf_persona_real_change_im_addresses_co (_data_);
}


static void trf_persona_real_change_im_addresses_finish (FolksImDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeImAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_im_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeImAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_im_addresses_co (_data_);
}


static gboolean trf_persona_real_change_im_addresses_co (TrfPersonaChangeImAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->im_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_im_addresses (TRF_PERSONA_STORE (_data_->_tmp1_), (FolksPersona*) _data_->self, _data_->_tmp2_, trf_persona_change_im_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_im_addresses_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_is_favourite_data_free (gpointer _data) {
	TrfPersonaChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeIsFavouriteData, _data_);
}


static void trf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeIsFavouriteData* _data_;
	TrfPersona* _tmp0_;
	gboolean _tmp1_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	trf_persona_real_change_is_favourite_co (_data_);
}


static void trf_persona_real_change_is_favourite_finish (FolksFavouriteDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_is_favourite_co (_data_);
}


static gboolean trf_persona_real_change_is_favourite_co (TrfPersonaChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_favourite;
	_data_->_tmp1_ = _data_->is_favourite;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->is_favourite;
	_data_->_state_ = 1;
	_trf_persona_store_set_is_favourite (TRF_PERSONA_STORE (_data_->_tmp3_), (FolksPersona*) _data_->self, _data_->_tmp4_, trf_persona_change_is_favourite_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_is_favourite_finish (TRF_PERSONA_STORE (_data_->_tmp3_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_local_ids_data_free (gpointer _data) {
	TrfPersonaChangeLocalIdsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->local_ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeLocalIdsData, _data_);
}


static void trf_persona_real_change_local_ids (FolksLocalIdDetails* base, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeLocalIdsData* _data_;
	TrfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeLocalIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_local_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_local_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = local_ids;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->local_ids = _tmp2_;
	trf_persona_real_change_local_ids_co (_data_);
}


static void trf_persona_real_change_local_ids_finish (FolksLocalIdDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeLocalIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_local_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeLocalIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_local_ids_co (_data_);
}


static gboolean trf_persona_real_change_local_ids_co (TrfPersonaChangeLocalIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->local_ids;
	_data_->_tmp1_ = folks_persona_get_uid ((FolksPersona*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = gee_collection_contains ((GeeCollection*) _data_->_tmp0_, _data_->_tmp2_);
	if (_data_->_tmp3_ == FALSE) {
		_data_->_tmp4_ = _data_->local_ids;
		_data_->_tmp5_ = folks_persona_get_uid ((FolksPersona*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		gee_collection_add ((GeeCollection*) _data_->_tmp4_, _data_->_tmp6_);
	}
	_data_->_tmp7_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->local_ids;
	_data_->_state_ = 1;
	_trf_persona_store_set_local_ids (TRF_PERSONA_STORE (_data_->_tmp8_), _data_->self, _data_->_tmp9_, trf_persona_change_local_ids_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_local_ids_finish (TRF_PERSONA_STORE (_data_->_tmp8_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void trf_persona_real_change_web_service_addresses_data_free (gpointer _data) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrfPersonaChangeWebServiceAddressesData, _data_);
}


static void trf_persona_real_change_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrfPersona * self;
	TrfPersonaChangeWebServiceAddressesData* _data_;
	TrfPersona* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	self = (TrfPersona*) base;
	_data_ = g_slice_new0 (TrfPersonaChangeWebServiceAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, trf_persona_real_change_web_service_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, trf_persona_real_change_web_service_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = web_service_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->web_service_addresses = _tmp2_;
	trf_persona_real_change_web_service_addresses_co (_data_);
}


static void trf_persona_real_change_web_service_addresses_finish (FolksWebServiceDetails* base, GAsyncResult* _res_, GError** error) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void trf_persona_change_web_service_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrfPersonaChangeWebServiceAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	trf_persona_real_change_web_service_addresses_co (_data_);
}


static gboolean trf_persona_real_change_web_service_addresses_co (TrfPersonaChangeWebServiceAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->web_service_addresses;
	_data_->_state_ = 1;
	_trf_persona_store_set_web_service_addrs (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->self, _data_->_tmp2_, trf_persona_change_web_service_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_trf_persona_store_set_web_service_addrs_finish (TRF_PERSONA_STORE (_data_->_tmp1_), _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param tracker_id the tracker id belonging to nco:PersonContact
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = store_id;
	_tmp1_ = tracker_id;
	_tmp2_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the nco:Contact whose details are stored in the cursor.
   */
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	TrfPersona * self = NULL;
	TrfPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* uid;
	TrfPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* iid;
	gboolean is_user;
	gchar* _tmp10_;
	gchar* fullname;
	TrackerSparqlCursor* _tmp11_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	TrfPersonaStore* _tmp25_;
	gboolean _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GeeHashSet* _tmp31_;
	GeeHashSet* _tmp32_;
	GeeSet* _tmp33_;
	GeeSet* _tmp34_;
	GeeHashSet* _tmp35_;
	GeeHashSet* _tmp36_;
	GeeSet* _tmp37_;
	GeeSet* _tmp38_;
	GeeHashSet* _tmp39_;
	GeeHashSet* _tmp40_;
	GeeSet* _tmp41_;
	GeeSet* _tmp42_;
	GeeHashSet* _tmp43_;
	GeeHashSet* _tmp44_;
	GeeSet* _tmp45_;
	GeeSet* _tmp46_;
	GeeHashSet* _tmp47_;
	GeeHashSet* _tmp48_;
	GeeSet* _tmp49_;
	GeeSet* _tmp50_;
	GeeHashSet* _tmp51_;
	GeeHashSet* _tmp52_;
	GeeSet* _tmp53_;
	GeeSet* _tmp54_;
	GeeHashSet* _tmp55_;
	GeeHashSet* _tmp56_;
	GeeSet* _tmp57_;
	GeeSet* _tmp58_;
	TrackerSparqlCursor* _tmp59_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tracker_id;
	_tmp4_ = folks_persona_build_uid (BACKEND_NAME, _tmp2_, _tmp3_);
	uid = _tmp4_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = tracker_id;
	_tmp9_ = trf_persona_build_iid (_tmp7_, _tmp8_);
	iid = _tmp9_;
	is_user = FALSE;
	_tmp10_ = g_strdup ("");
	fullname = _tmp10_;
	_tmp11_ = cursor;
	if (_tmp11_ != NULL) {
		TrackerSparqlCursor* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		TrackerSparqlCursor* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* contact_urn;
		const gchar* _tmp20_;
		_tmp12_ = cursor;
		_tmp13_ = tracker_sparql_cursor_get_string (_tmp12_, (gint) TRF_FIELDS_FULL_NAME, NULL);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (fullname);
		fullname = _tmp14_;
		_tmp15_ = fullname;
		if (_tmp15_ == NULL) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("");
			_g_free0 (fullname);
			fullname = _tmp16_;
		}
		_tmp17_ = cursor;
		_tmp18_ = tracker_sparql_cursor_get_string (_tmp17_, (gint) TRF_FIELDS_CONTACT_URN, NULL);
		_tmp19_ = g_strdup (_tmp18_);
		contact_urn = _tmp19_;
		_tmp20_ = contact_urn;
		if (g_strcmp0 (_tmp20_, TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN) == 0) {
			is_user = TRUE;
		}
		_g_free0 (contact_urn);
	}
	_tmp21_ = iid;
	g_debug ("trf-persona.vala:540: Creating new Trf.Persona with iid '%s'", _tmp21_);
	_tmp22_ = fullname;
	_tmp23_ = uid;
	_tmp24_ = iid;
	_tmp25_ = store;
	_tmp26_ = is_user;
	self = (TrfPersona*) g_object_new (object_type, "display-id", _tmp22_, "uid", _tmp23_, "iid", _tmp24_, "store", _tmp25_, "is-user", _tmp26_, NULL);
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp27_ = fullname;
	_tmp28_ = g_strdup (_tmp27_);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp28_;
	_tmp29_ = tracker_id;
	_tmp30_ = g_strdup (_tmp29_);
	_g_free0 (self->priv->_tracker_id);
	self->priv->_tracker_id = _tmp30_;
	_g_object_unref0 (self->priv->_structured_name);
	self->priv->_structured_name = NULL;
	_tmp31_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp31_;
	_tmp32_ = self->priv->_phone_numbers;
	_tmp33_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp32_);
	_tmp34_ = _tmp33_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp34_;
	_tmp35_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp35_;
	_tmp36_ = self->priv->_email_addresses;
	_tmp37_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp36_);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp38_;
	_tmp39_ = gee_hash_set_new (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp39_;
	_tmp40_ = self->priv->_roles;
	_tmp41_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp40_);
	_tmp42_ = _tmp41_;
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp42_;
	_tmp43_ = gee_hash_set_new (FOLKS_TYPE_NOTE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_notes);
	self->priv->_notes = _tmp43_;
	_tmp44_ = self->priv->_notes;
	_tmp45_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp44_);
	_tmp46_ = _tmp45_;
	_g_object_unref0 (self->priv->_notes_ro);
	self->priv->_notes_ro = _tmp46_;
	_tmp47_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp47_;
	_tmp48_ = self->priv->_urls;
	_tmp49_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp48_);
	_tmp50_ = _tmp49_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp50_;
	_tmp51_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp51_;
	_tmp52_ = self->priv->_postal_addresses;
	_tmp53_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp52_);
	_tmp54_ = _tmp53_;
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp54_;
	_tmp55_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = _tmp55_;
	_tmp56_ = self->priv->_local_ids;
	_tmp57_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp56_);
	_tmp58_ = _tmp57_;
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp58_;
	_tmp59_ = cursor;
	if (_tmp59_ != NULL) {
		TrackerSparqlCursor* _tmp60_;
		_tmp60_ = cursor;
		self->priv->_cursor = _tmp60_;
		_trf_persona_update_names (self);
		_trf_persona_update_avatar (self);
		_trf_persona_update_im_addresses (self);
		_trf_persona_update_phones (self);
		_trf_persona_update_email_addresses (self);
		_trf_persona_update_urls (self);
		_trf_persona_update_favourite (self);
		_trf_persona_update_roles (self);
		_trf_persona_update_bday (self);
		_trf_persona_update_note (self);
		_trf_persona_update_gender (self);
		_trf_persona_update_postal_addresses (self);
		_trf_persona_update_local_ids (self);
	}
	_g_free0 (fullname);
	_g_free0 (iid);
	_g_free0 (uid);
	return self;
}


TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	return trf_persona_construct (TRF_TYPE_PERSONA, store, tracker_id, cursor);
}


gchar* trf_persona_tracker_id (TrfPersona* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tracker_id;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * {@inheritDoc}
   */
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	TrfPersona * self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "im-addresses") == 0) {
		{
			GeeHashMultiMap* _tmp1_;
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _protocol_it;
			_tmp1_ = self->priv->_im_addresses;
			_tmp2_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_protocol_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				gboolean _tmp7_ = FALSE;
				GeeIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				gchar* protocol;
				GeeHashMultiMap* _tmp10_;
				const gchar* _tmp11_;
				GeeCollection* _tmp12_ = NULL;
				GeeCollection* im_fds;
				_tmp6_ = _protocol_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _protocol_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				protocol = (gchar*) _tmp9_;
				_tmp10_ = self->priv->_im_addresses;
				_tmp11_ = protocol;
				_tmp12_ = gee_multi_map_get ((GeeMultiMap*) _tmp10_, _tmp11_);
				im_fds = _tmp12_;
				{
					GeeCollection* _tmp13_;
					GeeIterator* _tmp14_ = NULL;
					GeeIterator* _im_fd_it;
					_tmp13_ = im_fds;
					_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
					_im_fd_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						gboolean _tmp16_ = FALSE;
						GeeIterator* _tmp17_;
						gpointer _tmp18_ = NULL;
						FolksImFieldDetails* im_fd;
						FolksPersonaLinkablePropertyCallback _tmp19_;
						void* _tmp19__target;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						FolksImFieldDetails* _tmp23_;
						gconstpointer _tmp24_;
						const gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp15_ = _im_fd_it;
						_tmp16_ = gee_iterator_next (_tmp15_);
						if (!_tmp16_) {
							break;
						}
						_tmp17_ = _im_fd_it;
						_tmp18_ = gee_iterator_get (_tmp17_);
						im_fd = (FolksImFieldDetails*) _tmp18_;
						_tmp19_ = callback;
						_tmp19__target = callback_target;
						_tmp20_ = protocol;
						_tmp21_ = g_strconcat (_tmp20_, ":", NULL);
						_tmp22_ = _tmp21_;
						_tmp23_ = im_fd;
						_tmp24_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_strconcat (_tmp22_, (const gchar*) _tmp25_, NULL);
						_tmp27_ = _tmp26_;
						_tmp19_ (_tmp27_, _tmp19__target);
						_g_free0 (_tmp27_);
						_g_free0 (_tmp22_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_fds);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		const gchar* _tmp28_;
		_tmp28_ = prop_name;
		if (g_strcmp0 (_tmp28_, "local-ids") == 0) {
			{
				GeeHashSet* _tmp29_;
				GeeIterator* _tmp30_ = NULL;
				GeeIterator* _id_it;
				_tmp29_ = self->priv->_local_ids;
				_tmp30_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp29_);
				_id_it = _tmp30_;
				while (TRUE) {
					GeeIterator* _tmp31_;
					gboolean _tmp32_ = FALSE;
					GeeIterator* _tmp33_;
					gpointer _tmp34_ = NULL;
					gchar* id;
					FolksPersonaLinkablePropertyCallback _tmp35_;
					void* _tmp35__target;
					const gchar* _tmp36_;
					_tmp31_ = _id_it;
					_tmp32_ = gee_iterator_next (_tmp31_);
					if (!_tmp32_) {
						break;
					}
					_tmp33_ = _id_it;
					_tmp34_ = gee_iterator_get (_tmp33_);
					id = (gchar*) _tmp34_;
					_tmp35_ = callback;
					_tmp35__target = callback_target;
					_tmp36_ = id;
					_tmp35_ (_tmp36_, _tmp35__target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
		} else {
			const gchar* _tmp37_;
			_tmp37_ = prop_name;
			if (g_strcmp0 (_tmp37_, "web-service-addresses") == 0) {
				{
					GeeHashMultiMap* _tmp38_;
					GeeSet* _tmp39_ = NULL;
					GeeSet* _tmp40_;
					GeeIterator* _tmp41_ = NULL;
					GeeIterator* _tmp42_;
					GeeIterator* _web_service_it;
					_tmp38_ = self->priv->_web_service_addresses;
					_tmp39_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
					_tmp42_ = _tmp41_;
					_g_object_unref0 (_tmp40_);
					_web_service_it = _tmp42_;
					while (TRUE) {
						GeeIterator* _tmp43_;
						gboolean _tmp44_ = FALSE;
						GeeIterator* _tmp45_;
						gpointer _tmp46_ = NULL;
						gchar* web_service;
						GeeHashMultiMap* _tmp47_;
						const gchar* _tmp48_;
						GeeCollection* _tmp49_ = NULL;
						GeeCollection* web_service_addresses;
						_tmp43_ = _web_service_it;
						_tmp44_ = gee_iterator_next (_tmp43_);
						if (!_tmp44_) {
							break;
						}
						_tmp45_ = _web_service_it;
						_tmp46_ = gee_iterator_get (_tmp45_);
						web_service = (gchar*) _tmp46_;
						_tmp47_ = self->priv->_web_service_addresses;
						_tmp48_ = web_service;
						_tmp49_ = gee_multi_map_get ((GeeMultiMap*) _tmp47_, _tmp48_);
						web_service_addresses = _tmp49_;
						{
							GeeCollection* _tmp50_;
							GeeIterator* _tmp51_ = NULL;
							GeeIterator* _ws_fd_it;
							_tmp50_ = web_service_addresses;
							_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
							_ws_fd_it = _tmp51_;
							while (TRUE) {
								GeeIterator* _tmp52_;
								gboolean _tmp53_ = FALSE;
								GeeIterator* _tmp54_;
								gpointer _tmp55_ = NULL;
								FolksWebServiceFieldDetails* ws_fd;
								FolksPersonaLinkablePropertyCallback _tmp56_;
								void* _tmp56__target;
								const gchar* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
								FolksWebServiceFieldDetails* _tmp60_;
								gconstpointer _tmp61_;
								const gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								_tmp52_ = _ws_fd_it;
								_tmp53_ = gee_iterator_next (_tmp52_);
								if (!_tmp53_) {
									break;
								}
								_tmp54_ = _ws_fd_it;
								_tmp55_ = gee_iterator_get (_tmp54_);
								ws_fd = (FolksWebServiceFieldDetails*) _tmp55_;
								_tmp56_ = callback;
								_tmp56__target = callback_target;
								_tmp57_ = web_service;
								_tmp58_ = g_strconcat (_tmp57_, ":", NULL);
								_tmp59_ = _tmp58_;
								_tmp60_ = ws_fd;
								_tmp61_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp60_);
								_tmp62_ = _tmp61_;
								_tmp63_ = g_strconcat (_tmp59_, (const gchar*) _tmp62_, NULL);
								_tmp64_ = _tmp63_;
								_tmp56_ (_tmp64_, _tmp56__target);
								_g_free0 (_tmp64_);
								_g_free0 (_tmp59_);
								_g_object_unref0 (ws_fd);
							}
							_g_object_unref0 (_ws_fd_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
			} else {
				const gchar* _tmp65_;
				FolksPersonaLinkablePropertyCallback _tmp66_;
				void* _tmp66__target;
				_tmp65_ = prop_name;
				_tmp66_ = callback;
				_tmp66__target = callback_target;
				FOLKS_PERSONA_CLASS (trf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), _tmp65_, _tmp66_, _tmp66__target);
			}
		}
	}
}


void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fn;
	if (_tmp0_ == NULL) {
		fn = "";
	}
	_tmp1_ = self->priv->_full_name;
	_tmp2_ = fn;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = fn;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp4_;
		g_object_notify ((GObject*) self, "full-name");
	}
}


void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = nickname;
	if (_tmp0_ == NULL) {
		nickname = "";
	}
	_tmp1_ = self->priv->_nickname;
	_tmp2_ = nickname;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = nickname;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp4_;
		g_object_notify ((GObject*) self, "nickname");
	}
}


void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = family_name;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_;
			FolksStructuredName* _tmp3_;
			_tmp2_ = family_name;
			_tmp3_ = folks_structured_name_new (_tmp2_, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = family_name;
			folks_structured_name_set_family_name (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = given_name;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_;
			FolksStructuredName* _tmp3_;
			_tmp2_ = given_name;
			_tmp3_ = folks_structured_name_new (NULL, _tmp2_, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = given_name;
			folks_structured_name_set_given_name (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = additional_names;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_;
			FolksStructuredName* _tmp3_;
			_tmp2_ = additional_names;
			_tmp3_ = folks_structured_name_new (NULL, NULL, _tmp2_, NULL, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = additional_names;
			folks_structured_name_set_additional_names (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = prefixes;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_;
			FolksStructuredName* _tmp3_;
			_tmp2_ = prefixes;
			_tmp3_ = folks_structured_name_new (NULL, NULL, NULL, _tmp2_, NULL);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = prefixes;
			folks_structured_name_set_prefixes (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = suffixes;
	if (_tmp0_ != NULL) {
		FolksStructuredName* _tmp1_;
		_tmp1_ = self->priv->_structured_name;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_;
			FolksStructuredName* _tmp3_;
			_tmp2_ = suffixes;
			_tmp3_ = folks_structured_name_new (NULL, NULL, NULL, NULL, _tmp2_);
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = _tmp3_;
		} else {
			FolksStructuredName* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->_structured_name;
			_tmp5_ = suffixes;
			folks_structured_name_set_suffixes (_tmp4_, _tmp5_);
		}
		g_object_notify ((GObject*) self, "structured-name");
	}
}


static void _trf_persona_update_postal_addresses (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* postal_field;
	const gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* postal_addresses;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** addresses_a;
	gint addresses_a_length1;
	gint _addresses_a_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeHashSet* _tmp48_;
	GeeHashSet* _tmp49_;
	GeeHashSet* _tmp50_;
	GeeSet* _tmp51_;
	GeeSet* _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_POSTAL_ADDRESS, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	postal_field = _tmp2_;
	_tmp3_ = postal_field;
	if (_tmp3_ == NULL) {
		_g_free0 (postal_field);
		return;
	}
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	postal_addresses = _tmp4_;
	_tmp5_ = postal_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	addresses_a = _tmp7_;
	addresses_a_length1 = _vala_array_length (_tmp6_);
	_addresses_a_size_ = addresses_a_length1;
	_tmp8_ = addresses_a;
	_tmp8__length1 = addresses_a_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp8_;
		a_collection_length1 = _tmp8__length1;
		for (a_it = 0; a_it < _tmp8__length1; a_it = a_it + 1) {
			gchar* _tmp9_;
			gchar* a = NULL;
			_tmp9_ = g_strdup (a_collection[a_it]);
			a = _tmp9_;
			{
				gboolean address_empty;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_ = NULL;
				gchar** a_info;
				gint a_info_length1;
				gint _a_info_size_;
				gboolean _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				const gchar* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				FolksPostalAddress* _tmp43_;
				FolksPostalAddress* pa;
				FolksPostalAddress* _tmp44_;
				FolksPostalAddressFieldDetails* _tmp45_;
				FolksPostalAddressFieldDetails* pafd;
				GeeHashSet* _tmp46_;
				FolksPostalAddressFieldDetails* _tmp47_;
				address_empty = TRUE;
				_tmp10_ = a;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				a_info = _tmp12_;
				a_info_length1 = _vala_array_length (_tmp11_);
				_a_info_size_ = a_info_length1;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_;
							gint _tmp16_;
							gchar** _tmp17_;
							gint _tmp17__length1;
							gboolean _tmp18_ = FALSE;
							gchar** _tmp19_;
							gint _tmp19__length1;
							gint _tmp20_;
							const gchar* _tmp21_;
							gboolean _tmp25_;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = i;
								i = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = i;
							_tmp17_ = a_info;
							_tmp17__length1 = a_info_length1;
							if (!(_tmp16_ < _tmp17__length1)) {
								break;
							}
							_tmp19_ = a_info;
							_tmp19__length1 = a_info_length1;
							_tmp20_ = i;
							_tmp21_ = _tmp19_[_tmp20_];
							if (_tmp21_ != NULL) {
								gchar** _tmp22_;
								gint _tmp22__length1;
								gint _tmp23_;
								const gchar* _tmp24_;
								_tmp22_ = a_info;
								_tmp22__length1 = a_info_length1;
								_tmp23_ = i;
								_tmp24_ = _tmp22_[_tmp23_];
								_tmp18_ = g_strcmp0 (_tmp24_, "") != 0;
							} else {
								_tmp18_ = FALSE;
							}
							_tmp25_ = _tmp18_;
							if (_tmp25_) {
								address_empty = FALSE;
								break;
							}
						}
					}
				}
				_tmp26_ = address_empty;
				if (_tmp26_) {
					a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (a);
					continue;
				}
				_tmp27_ = a_info;
				_tmp27__length1 = a_info_length1;
				_tmp28_ = _tmp27_[TRF_POSTAL_ADDRESS_FIELDS_POBOX];
				_tmp29_ = a_info;
				_tmp29__length1 = a_info_length1;
				_tmp30_ = _tmp29_[TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS];
				_tmp31_ = a_info;
				_tmp31__length1 = a_info_length1;
				_tmp32_ = _tmp31_[TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS];
				_tmp33_ = a_info;
				_tmp33__length1 = a_info_length1;
				_tmp34_ = _tmp33_[TRF_POSTAL_ADDRESS_FIELDS_LOCALITY];
				_tmp35_ = a_info;
				_tmp35__length1 = a_info_length1;
				_tmp36_ = _tmp35_[TRF_POSTAL_ADDRESS_FIELDS_REGION];
				_tmp37_ = a_info;
				_tmp37__length1 = a_info_length1;
				_tmp38_ = _tmp37_[TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE];
				_tmp39_ = a_info;
				_tmp39__length1 = a_info_length1;
				_tmp40_ = _tmp39_[TRF_POSTAL_ADDRESS_FIELDS_COUNTRY];
				_tmp41_ = a_info;
				_tmp41__length1 = a_info_length1;
				_tmp42_ = _tmp41_[TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID];
				_tmp43_ = folks_postal_address_new (_tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp36_, _tmp38_, _tmp40_, NULL, _tmp42_);
				pa = _tmp43_;
				_tmp44_ = pa;
				_tmp45_ = folks_postal_address_field_details_new (_tmp44_, NULL);
				pafd = _tmp45_;
				_tmp46_ = postal_addresses;
				_tmp47_ = pafd;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
				_g_object_unref0 (pafd);
				_g_object_unref0 (pa);
				a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	_tmp48_ = postal_addresses;
	_tmp49_ = _g_object_ref0 (_tmp48_);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp49_;
	_tmp50_ = self->priv->_postal_addresses;
	_tmp51_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp50_);
	_tmp52_ = _tmp51_;
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp52_;
	g_object_notify ((GObject*) self, "postal-addresses");
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (postal_addresses);
	_g_free0 (postal_field);
}


static void _trf_persona_update_local_ids (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* local_ids;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_LOCAL_IDS_PROPERTY, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	local_ids = _tmp2_;
	_tmp3_ = local_ids;
	if (_tmp3_ == NULL) {
		_g_free0 (local_ids);
		return;
	}
	_tmp4_ = local_ids;
	_trf_persona_set_local_ids (self, _tmp4_);
	_g_free0 (local_ids);
}


gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddressFieldDetails* postal_address_fd) {
	gboolean result = FALSE;
	GeeHashSet* _tmp13_;
	FolksPostalAddressFieldDetails* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (postal_address_fd != NULL, FALSE);
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _pafd_cur_it;
		_tmp0_ = self->priv->_postal_addresses;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_pafd_cur_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPostalAddressFieldDetails* pafd_cur;
			FolksPostalAddressFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			FolksPostalAddress* _tmp8_;
			FolksPostalAddressFieldDetails* _tmp9_;
			gconstpointer _tmp10_;
			FolksPostalAddress* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp2_ = _pafd_cur_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _pafd_cur_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			pafd_cur = (FolksPostalAddressFieldDetails*) _tmp5_;
			_tmp6_ = postal_address_fd;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = pafd_cur;
			_tmp10_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = folks_postal_address_equal ((FolksPostalAddress*) _tmp8_, (FolksPostalAddress*) _tmp11_);
			if (_tmp12_) {
				result = FALSE;
				_g_object_unref0 (pafd_cur);
				_g_object_unref0 (_pafd_cur_it);
				return result;
			}
			_g_object_unref0 (pafd_cur);
		}
		_g_object_unref0 (_pafd_cur_it);
	}
	_tmp13_ = self->priv->_postal_addresses;
	_tmp14_ = postal_address_fd;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	g_object_notify ((GObject*) self, "postal-addresses");
	result = TRUE;
	return result;
}


gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _pafd_it;
		_tmp0_ = self->priv->_postal_addresses;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_pafd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPostalAddressFieldDetails* pafd;
			FolksPostalAddressFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			FolksPostalAddress* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp2_ = _pafd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _pafd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			pafd = (FolksPostalAddressFieldDetails*) _tmp5_;
			_tmp6_ = pafd;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_postal_address_get_uid ((FolksPostalAddress*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = tracker_id;
			if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
				GeeHashSet* _tmp12_;
				FolksPostalAddressFieldDetails* _tmp13_;
				_tmp12_ = self->priv->_postal_addresses;
				_tmp13_ = pafd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				g_object_notify ((GObject*) self, "postal-addresses");
				result = TRUE;
				_g_object_unref0 (pafd);
				_g_object_unref0 (_pafd_it);
				return result;
			}
			_g_object_unref0 (pafd);
		}
		_g_object_unref0 (_pafd_it);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_gender (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* gender;
	gint gender_id;
	const gchar* _tmp3_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_GENDER, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	gender = _tmp2_;
	gender_id = 0;
	_tmp3_ = gender;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		_tmp4_ = gender;
		_tmp5_ = atoi (_tmp4_);
		gender_id = _tmp5_;
	}
	_tmp6_ = gender_id;
	_trf_persona_set_gender (self, _tmp6_);
	_g_free0 (gender);
}


void _trf_persona_set_gender (TrfPersona* self, gint gender_id) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gender_id;
	if (_tmp0_ == 0) {
		self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	} else {
		FolksPersonaStore* _tmp1_;
		FolksPersonaStore* _tmp2_;
		TrfPersonaStore* _tmp3_;
		TrfPersonaStore* trf_store;
		gint _tmp4_;
		TrfPersonaStore* _tmp5_;
		gint _tmp6_ = 0;
		_tmp1_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (TRF_PERSONA_STORE (_tmp2_));
		trf_store = _tmp3_;
		_tmp4_ = gender_id;
		_tmp5_ = trf_store;
		_tmp6_ = trf_persona_store_get_gender_male_id (_tmp5_);
		if (_tmp4_ == _tmp6_) {
			self->priv->_gender = FOLKS_GENDER_MALE;
		} else {
			gint _tmp7_;
			TrfPersonaStore* _tmp8_;
			gint _tmp9_ = 0;
			_tmp7_ = gender_id;
			_tmp8_ = trf_store;
			_tmp9_ = trf_persona_store_get_gender_female_id (_tmp8_);
			if (_tmp7_ == _tmp9_) {
				self->priv->_gender = FOLKS_GENDER_FEMALE;
			}
		}
		_g_object_unref0 (trf_store);
	}
	g_object_notify ((GObject*) self, "gender");
}


static void _trf_persona_update_note (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* note;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_NOTE, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	note = _tmp2_;
	_trf_persona_set_note (self, note);
	_g_free0 (note);
}


void _trf_persona_set_note (TrfPersona* self, const gchar* note_content) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = note_content;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		FolksNoteFieldDetails* _tmp2_;
		FolksNoteFieldDetails* note;
		GeeHashSet* _tmp3_;
		FolksNoteFieldDetails* _tmp4_;
		FolksNoteFieldDetails* _tmp5_;
		_tmp1_ = note_content;
		_tmp2_ = folks_note_field_details_new (_tmp1_, NULL, NULL);
		note = _tmp2_;
		_tmp3_ = self->priv->_notes;
		_tmp4_ = note;
		note = NULL;
		_tmp5_ = _tmp4_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (note);
	} else {
		GeeHashSet* _tmp6_;
		_tmp6_ = self->priv->_notes;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	}
	g_object_notify ((GObject*) self, "notes");
}


static void _trf_persona_update_bday (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* bday;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_BIRTHDAY, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	bday = _tmp2_;
	_trf_persona_set_birthday (self, bday);
	_g_free0 (bday);
}


void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = birthday;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = birthday;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GTimeVal t = {0};
		const gchar* _tmp4_;
		GTimeVal _tmp5_;
		GDateTime* _tmp6_;
		g_get_current_time (&t);
		_tmp4_ = birthday;
		g_time_val_from_iso8601 (_tmp4_, &t);
		_tmp5_ = t;
		_tmp6_ = g_date_time_new_from_timeval_utc (&_tmp5_);
		_g_date_time_unref0 (self->priv->_birthday);
		self->priv->_birthday = _tmp6_;
		g_object_notify ((GObject*) self, "birthday");
	} else {
		GDateTime* _tmp7_;
		_tmp7_ = self->priv->_birthday;
		if (_tmp7_ != NULL) {
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			g_object_notify ((GObject*) self, "birthday");
		}
	}
}


static void _trf_persona_update_roles (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* roles_field;
	const gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* role_fds;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** roles_a;
	gint roles_a_length1;
	gint _roles_a_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeHashSet* _tmp35_;
	GeeHashSet* _tmp36_;
	GeeHashSet* _tmp37_;
	GeeSet* _tmp38_;
	GeeSet* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_ROLES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	roles_field = _tmp2_;
	_tmp3_ = roles_field;
	if (_tmp3_ == NULL) {
		_g_free0 (roles_field);
		return;
	}
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	role_fds = _tmp4_;
	_tmp5_ = roles_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	roles_a = _tmp7_;
	roles_a_length1 = _vala_array_length (_tmp6_);
	_roles_a_size_ = roles_a_length1;
	_tmp8_ = roles_a;
	_tmp8__length1 = roles_a_length1;
	{
		gchar** r_collection = NULL;
		gint r_collection_length1 = 0;
		gint _r_collection_size_ = 0;
		gint r_it = 0;
		r_collection = _tmp8_;
		r_collection_length1 = _tmp8__length1;
		for (r_it = 0; r_it < _tmp8__length1; r_it = r_it + 1) {
			gchar* _tmp9_;
			gchar* r = NULL;
			_tmp9_ = g_strdup (r_collection[r_it]);
			r = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_ = NULL;
				gchar** r_info;
				gint r_info_length1;
				gint _r_info_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* tracker_id;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* role;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* title;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* organisation;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				FolksRole* _tmp28_;
				FolksRole* new_role;
				FolksRole* _tmp29_;
				const gchar* _tmp30_;
				FolksRole* _tmp31_;
				FolksRoleFieldDetails* _tmp32_;
				FolksRoleFieldDetails* role_fd;
				GeeHashSet* _tmp33_;
				FolksRoleFieldDetails* _tmp34_;
				_tmp10_ = r;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				r_info = _tmp12_;
				r_info_length1 = _vala_array_length (_tmp11_);
				_r_info_size_ = r_info_length1;
				_tmp13_ = r_info;
				_tmp13__length1 = r_info_length1;
				_tmp14_ = _tmp13_[TRF_ROLE_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				_tmp16_ = r_info;
				_tmp16__length1 = r_info_length1;
				_tmp17_ = _tmp16_[TRF_ROLE_FIELDS_ROLE];
				_tmp18_ = g_strdup (_tmp17_);
				role = _tmp18_;
				_tmp19_ = r_info;
				_tmp19__length1 = r_info_length1;
				_tmp20_ = _tmp19_[TRF_ROLE_FIELDS_TITLE];
				_tmp21_ = g_strdup (_tmp20_);
				title = _tmp21_;
				_tmp22_ = r_info;
				_tmp22__length1 = r_info_length1;
				_tmp23_ = _tmp22_[TRF_ROLE_FIELDS_DEPARTMENT];
				_tmp24_ = g_strdup (_tmp23_);
				organisation = _tmp24_;
				_tmp25_ = title;
				_tmp26_ = organisation;
				_tmp27_ = tracker_id;
				_tmp28_ = folks_role_new (_tmp25_, _tmp26_, _tmp27_);
				new_role = _tmp28_;
				_tmp29_ = new_role;
				_tmp30_ = role;
				folks_role_set_role (_tmp29_, _tmp30_);
				_tmp31_ = new_role;
				_tmp32_ = folks_role_field_details_new (_tmp31_, NULL);
				role_fd = _tmp32_;
				_tmp33_ = role_fds;
				_tmp34_ = role_fd;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
				_g_object_unref0 (role_fd);
				_g_object_unref0 (new_role);
				_g_free0 (organisation);
				_g_free0 (title);
				_g_free0 (role);
				_g_free0 (tracker_id);
				r_info = (_vala_array_free (r_info, r_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (r);
			}
		}
	}
	_tmp35_ = role_fds;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp36_;
	_tmp37_ = self->priv->_roles;
	_tmp38_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp37_);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp39_;
	g_object_notify ((GObject*) self, "roles");
	roles_a = (_vala_array_free (roles_a, roles_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (role_fds);
	_g_free0 (roles_field);
}


gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* role, const gchar* title, const gchar* org) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksRole* _tmp3_;
	FolksRole* new_role;
	FolksRole* _tmp4_;
	const gchar* _tmp5_;
	FolksRole* _tmp6_;
	FolksRoleFieldDetails* _tmp7_;
	FolksRoleFieldDetails* role_fd;
	GeeHashSet* _tmp8_;
	FolksRoleFieldDetails* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = title;
	_tmp1_ = org;
	_tmp2_ = tracker_id;
	_tmp3_ = folks_role_new (_tmp0_, _tmp1_, _tmp2_);
	new_role = _tmp3_;
	_tmp4_ = new_role;
	_tmp5_ = role;
	folks_role_set_role (_tmp4_, _tmp5_);
	_tmp6_ = new_role;
	_tmp7_ = folks_role_field_details_new (_tmp6_, NULL);
	role_fd = _tmp7_;
	_tmp8_ = self->priv->_roles;
	_tmp9_ = role_fd;
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	if (_tmp10_) {
		g_object_notify ((GObject*) self, "roles");
		result = TRUE;
		_g_object_unref0 (role_fd);
		_g_object_unref0 (new_role);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (role_fd);
	_g_object_unref0 (new_role);
	return result;
}


gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _role_fd_it;
		_tmp0_ = self->priv->_roles;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_role_fd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksRoleFieldDetails* role_fd;
			FolksRoleFieldDetails* _tmp6_;
			gconstpointer _tmp7_;
			FolksRole* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp2_ = _role_fd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _role_fd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			role_fd = (FolksRoleFieldDetails*) _tmp5_;
			_tmp6_ = role_fd;
			_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_role_get_uid ((FolksRole*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = tracker_id;
			if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
				GeeHashSet* _tmp12_;
				FolksRoleFieldDetails* _tmp13_;
				_tmp12_ = self->priv->_roles;
				_tmp13_ = role_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				g_object_notify ((GObject*) self, "roles");
				result = TRUE;
				_g_object_unref0 (role_fd);
				_g_object_unref0 (_role_fd_it);
				return result;
			}
			_g_object_unref0 (role_fd);
		}
		_g_object_unref0 (_role_fd_it);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_names (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* fullname;
	TrackerSparqlCursor* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* nickname;
	TrackerSparqlCursor* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* family_name;
	TrackerSparqlCursor* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* given_name;
	TrackerSparqlCursor* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* additional_names;
	TrackerSparqlCursor* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* prefixes;
	TrackerSparqlCursor* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* suffixes;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_FULL_NAME, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	fullname = _tmp2_;
	_trf_persona_update_full_name (self, fullname);
	_tmp3_ = self->priv->_cursor;
	_tmp4_ = tracker_sparql_cursor_get_string (_tmp3_, (gint) TRF_FIELDS_NICKNAME, NULL);
	_tmp5_ = g_strdup (_tmp4_);
	nickname = _tmp5_;
	_trf_persona_update_nickname (self, nickname);
	_tmp6_ = self->priv->_cursor;
	_tmp7_ = tracker_sparql_cursor_get_string (_tmp6_, (gint) TRF_FIELDS_FAMILY_NAME, NULL);
	_tmp8_ = g_strdup (_tmp7_);
	family_name = _tmp8_;
	_trf_persona_update_family_name (self, family_name);
	_tmp9_ = self->priv->_cursor;
	_tmp10_ = tracker_sparql_cursor_get_string (_tmp9_, (gint) TRF_FIELDS_GIVEN_NAME, NULL);
	_tmp11_ = g_strdup (_tmp10_);
	given_name = _tmp11_;
	_trf_persona_update_given_name (self, given_name);
	_tmp12_ = self->priv->_cursor;
	_tmp13_ = tracker_sparql_cursor_get_string (_tmp12_, (gint) TRF_FIELDS_ADDITIONAL_NAMES, NULL);
	_tmp14_ = g_strdup (_tmp13_);
	additional_names = _tmp14_;
	_trf_persona_update_additional_names (self, additional_names);
	_tmp15_ = self->priv->_cursor;
	_tmp16_ = tracker_sparql_cursor_get_string (_tmp15_, (gint) TRF_FIELDS_PREFIXES, NULL);
	_tmp17_ = g_strdup (_tmp16_);
	prefixes = _tmp17_;
	_trf_persona_update_prefixes (self, prefixes);
	_tmp18_ = self->priv->_cursor;
	_tmp19_ = tracker_sparql_cursor_get_string (_tmp18_, (gint) TRF_FIELDS_SUFFIXES, NULL);
	_tmp20_ = g_strdup (_tmp19_);
	suffixes = _tmp20_;
	_trf_persona_update_suffixes (self, suffixes);
	_g_free0 (suffixes);
	_g_free0 (prefixes);
	_g_free0 (additional_names);
	_g_free0 (given_name);
	_g_free0 (family_name);
	_g_free0 (nickname);
	_g_free0 (fullname);
}


static void _trf_persona_update_avatar (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* avatar_url;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_AVATAR_URL, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	avatar_url = _tmp2_;
	_trf_persona_set_avatar_from_uri (self, avatar_url);
	_g_free0 (avatar_url);
}


gboolean _trf_persona_set_avatar_from_uri (TrfPersona* self, const gchar* avatar_url) {
	gboolean result = FALSE;
	GLoadableIcon* _avatar;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GLoadableIcon* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_avatar = NULL;
	_tmp1_ = avatar_url;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = avatar_url;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileIcon* _tmp7_;
		_tmp4_ = avatar_url;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = (GFileIcon*) g_file_icon_new (_tmp6_);
		_g_object_unref0 (_avatar);
		_avatar = (GLoadableIcon*) _tmp7_;
		_g_object_unref0 (_tmp6_);
	}
	_tmp8_ = _avatar;
	_trf_persona_set_avatar (self, _tmp8_);
	result = TRUE;
	_g_object_unref0 (_avatar);
	return result;
}


gboolean _trf_persona_set_avatar (TrfPersona* self, GLoadableIcon* avatar) {
	gboolean result = FALSE;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = avatar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject*) self, "avatar");
	result = TRUE;
	return result;
}


gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GeeSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (local_ids != NULL, FALSE);
	_tmp0_ = local_ids;
	_tmp1_ = trf_persona_store_unserialize_local_ids (_tmp0_);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = GEE_HASH_SET (_tmp1_);
	_tmp2_ = self->priv->_local_ids;
	_tmp3_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp4_;
	g_object_notify ((GObject*) self, "local-ids");
	result = TRUE;
	return result;
}


gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GeeMultiMap* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ws_addrs != NULL, FALSE);
	_tmp0_ = ws_addrs;
	_tmp1_ = trf_persona_store_unserialize_web_services (_tmp0_);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = GEE_HASH_MULTI_MAP (_tmp1_);
	g_object_notify ((GObject*) self, "web-service-addresses");
	result = TRUE;
	return result;
}


static void _trf_persona_update_im_addresses (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* addresses;
	const gchar* _tmp3_;
	GeeHashMultiMap* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** addresses_a;
	gint addresses_a_length1;
	gint _addresses_a_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_IM_ADDRESSES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	addresses = _tmp2_;
	_tmp3_ = addresses;
	if (_tmp3_ == NULL) {
		_g_free0 (addresses);
		return;
	}
	_tmp4_ = self->priv->_im_addresses;
	gee_multi_map_clear ((GeeMultiMap*) _tmp4_);
	_tmp5_ = addresses;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	addresses_a = _tmp7_;
	addresses_a_length1 = _vala_array_length (_tmp6_);
	_addresses_a_size_ = addresses_a_length1;
	_tmp8_ = addresses_a;
	_tmp8__length1 = addresses_a_length1;
	{
		gchar** addr_collection = NULL;
		gint addr_collection_length1 = 0;
		gint _addr_collection_size_ = 0;
		gint addr_it = 0;
		addr_collection = _tmp8_;
		addr_collection_length1 = _tmp8__length1;
		for (addr_it = 0; addr_it < _tmp8__length1; addr_it = addr_it + 1) {
			gchar* _tmp9_;
			gchar* addr = NULL;
			_tmp9_ = g_strdup (addr_collection[addr_it]);
			addr = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_ = NULL;
				gchar** addr_info;
				gint addr_info_length1;
				gint _addr_info_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* tracker_id;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* proto;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* account_id;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* nickname;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				_tmp10_ = addr;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				addr_info = _tmp12_;
				addr_info_length1 = _vala_array_length (_tmp11_);
				_addr_info_size_ = addr_info_length1;
				_tmp13_ = addr_info;
				_tmp13__length1 = addr_info_length1;
				_tmp14_ = _tmp13_[TRF_IM_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				_tmp16_ = addr_info;
				_tmp16__length1 = addr_info_length1;
				_tmp17_ = _tmp16_[TRF_IM_FIELDS_PROTO];
				_tmp18_ = g_strdup (_tmp17_);
				proto = _tmp18_;
				_tmp19_ = addr_info;
				_tmp19__length1 = addr_info_length1;
				_tmp20_ = _tmp19_[TRF_IM_FIELDS_ID];
				_tmp21_ = g_strdup (_tmp20_);
				account_id = _tmp21_;
				_tmp22_ = addr_info;
				_tmp22__length1 = addr_info_length1;
				_tmp23_ = _tmp22_[TRF_IM_FIELDS_IM_NICKNAME];
				_tmp24_ = g_strdup (_tmp23_);
				nickname = _tmp24_;
				_tmp25_ = nickname;
				_trf_persona_update_nickname (self, _tmp25_);
				_tmp26_ = tracker_id;
				_tmp27_ = proto;
				_tmp28_ = account_id;
				_trf_persona_add_im_address (self, _tmp26_, _tmp27_, _tmp28_, FALSE);
				_g_free0 (nickname);
				_g_free0 (account_id);
				_g_free0 (proto);
				_g_free0 (tracker_id);
				addr_info = (_vala_array_free (addr_info, addr_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (addr);
			}
		}
	}
	g_object_notify ((GObject*) self, "im-addresses");
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (addresses);
}


gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	g_return_val_if_fail (im_proto != NULL, FALSE);
	g_return_val_if_fail (account_id != NULL, FALSE);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* account_id_copy;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* normalised_addr;
		const gchar* _tmp11_;
		FolksImFieldDetails* _tmp12_;
		FolksImFieldDetails* im_fd;
		GeeHashMultiMap* _tmp13_;
		const gchar* _tmp14_;
		FolksImFieldDetails* _tmp15_;
		GeeHashMap* _tmp16_;
		GeeHashMap* im_proto_map;
		GeeHashMap* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		GeeHashMap* _tmp22_;
		gboolean _tmp23_;
		_tmp0_ = account_id;
		_tmp1_ = g_strdup (_tmp0_);
		account_id_copy = _tmp1_;
		_tmp2_ = account_id_copy;
		account_id_copy = NULL;
		_tmp3_ = _tmp2_;
		_tmp4_ = im_proto;
		_tmp5_ = folks_im_details_normalise_im_address (_tmp3_, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp3_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_free0 (account_id_copy);
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch0_folks_im_details_error;
			}
			_g_free0 (account_id_copy);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp8_ = NULL;
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		normalised_addr = _tmp10_;
		_tmp11_ = normalised_addr;
		_tmp12_ = folks_im_field_details_new (_tmp11_, NULL);
		im_fd = _tmp12_;
		_tmp13_ = self->priv->_im_addresses;
		_tmp14_ = im_proto;
		_tmp15_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp13_, _tmp14_, _tmp15_);
		_tmp16_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		im_proto_map = _tmp16_;
		_tmp17_ = im_proto_map;
		_tmp18_ = im_proto;
		_tmp19_ = account_id;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp18_, _tmp19_);
		_tmp20_ = self->priv->_tracker_ids_ims;
		_tmp21_ = tracker_id;
		_tmp22_ = im_proto_map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp21_, _tmp22_);
		_tmp23_ = notify;
		if (_tmp23_) {
			g_object_notify ((GObject*) self, "im-addresses");
		}
		_g_object_unref0 (im_proto_map);
		_g_object_unref0 (im_fd);
		_g_free0 (normalised_addr);
		_g_free0 (account_id_copy);
	}
	goto __finally0;
	__catch0_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("trf-persona.vala:1133: Problem when trying to normalise address: %s\n", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	GeeHashMap* proto_im;
	GeeHashMap* _tmp3_;
	gchar* proto;
	gchar* im_addr;
	const gchar* _tmp19_;
	FolksImFieldDetails* _tmp20_;
	FolksImFieldDetails* im_fd;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gboolean _tmp25_;
	gboolean _tmp30_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = self->priv->_tracker_ids_ims;
	_tmp1_ = tracker_id;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	proto_im = (GeeHashMap*) _tmp2_;
	_tmp3_ = proto_im;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (proto_im);
		return result;
	}
	proto = NULL;
	im_addr = NULL;
	{
		GeeHashMap* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _tmp9_;
		GeeIterator* _pr_it;
		_tmp4_ = proto_im;
		_tmp5_ = gee_map_get_keys ((GeeMap*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_pr_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* pr;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GeeHashMap* _tmp16_;
			const gchar* _tmp17_;
			gpointer _tmp18_ = NULL;
			_tmp10_ = _pr_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _pr_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			pr = (gchar*) _tmp13_;
			_tmp14_ = pr;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (proto);
			proto = _tmp15_;
			_tmp16_ = proto_im;
			_tmp17_ = proto;
			_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
			_g_free0 (im_addr);
			im_addr = (gchar*) _tmp18_;
			_g_free0 (pr);
			break;
		}
		_g_object_unref0 (_pr_it);
	}
	_tmp19_ = im_addr;
	_tmp20_ = folks_im_field_details_new (_tmp19_, NULL);
	im_fd = _tmp20_;
	_tmp23_ = proto;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		_tmp24_ = im_addr;
		_tmp22_ = _tmp24_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp25_ = _tmp22_;
	if (_tmp25_) {
		GeeHashMultiMap* _tmp26_;
		const gchar* _tmp27_;
		FolksImFieldDetails* _tmp28_;
		gboolean _tmp29_ = FALSE;
		_tmp26_ = self->priv->_im_addresses;
		_tmp27_ = proto;
		_tmp28_ = im_fd;
		_tmp29_ = gee_multi_map_remove ((GeeMultiMap*) _tmp26_, _tmp27_, _tmp28_);
		_tmp21_ = _tmp29_;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp30_ = _tmp21_;
	if (_tmp30_) {
		GeeHashMap* _tmp31_;
		const gchar* _tmp32_;
		gboolean _tmp33_;
		_tmp31_ = self->priv->_tracker_ids_ims;
		_tmp32_ = tracker_id;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, NULL);
		_tmp33_ = notify;
		if (_tmp33_) {
			g_object_notify ((GObject*) self, "im-addresses");
		}
		result = TRUE;
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
		_g_free0 (proto);
		_g_object_unref0 (proto_im);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (im_fd);
	_g_free0 (im_addr);
	_g_free0 (proto);
	_g_object_unref0 (proto_im);
	return result;
}


static void _trf_persona_update_phones (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* phones_field;
	const gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* phones;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** phones_a;
	gint phones_a_length1;
	gint _phones_a_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeHashSet* _tmp25_;
	GeeHashSet* _tmp26_;
	GeeHashSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeSet* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_PHONES, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	phones_field = _tmp2_;
	_tmp3_ = phones_field;
	if (_tmp3_ == NULL) {
		_g_free0 (phones_field);
		return;
	}
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	phones = _tmp4_;
	_tmp5_ = phones_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	phones_a = _tmp7_;
	phones_a_length1 = _vala_array_length (_tmp6_);
	_phones_a_size_ = phones_a_length1;
	_tmp8_ = phones_a;
	_tmp8__length1 = phones_a_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp8_;
		p_collection_length1 = _tmp8__length1;
		for (p_it = 0; p_it < _tmp8__length1; p_it = p_it + 1) {
			gchar* _tmp9_;
			gchar* p = NULL;
			_tmp9_ = g_strdup (p_collection[p_it]);
			p = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				gboolean _tmp13_;
				_tmp11_ = p;
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					_tmp12_ = p;
					_tmp10_ = g_strcmp0 (_tmp12_, "") != 0;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp13_ = _tmp10_;
				if (_tmp13_) {
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gchar** _tmp16_ = NULL;
					gchar** p_info;
					gint p_info_length1;
					gint _p_info_size_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					FolksPhoneFieldDetails* _tmp19_;
					FolksPhoneFieldDetails* phone_fd;
					FolksPhoneFieldDetails* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					GeeHashSet* _tmp23_;
					FolksPhoneFieldDetails* _tmp24_;
					_tmp14_ = p;
					_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "\t", 0);
					p_info = _tmp16_;
					p_info_length1 = _vala_array_length (_tmp15_);
					_p_info_size_ = p_info_length1;
					_tmp17_ = p_info;
					_tmp17__length1 = p_info_length1;
					_tmp18_ = _tmp17_[TRF_PHONE_FIELDS_PHONE];
					_tmp19_ = folks_phone_field_details_new (_tmp18_, NULL);
					phone_fd = _tmp19_;
					_tmp20_ = phone_fd;
					_tmp21_ = p_info;
					_tmp21__length1 = p_info_length1;
					_tmp22_ = _tmp21_[TRF_PHONE_FIELDS_TRACKER_ID];
					folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp20_, "tracker_id", _tmp22_);
					_tmp23_ = phones;
					_tmp24_ = phone_fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
					_g_object_unref0 (phone_fd);
					p_info = (_vala_array_free (p_info, p_info_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (p);
			}
		}
	}
	_tmp25_ = phones;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp26_;
	_tmp27_ = self->priv->_phone_numbers;
	_tmp28_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp29_;
	g_object_notify ((GObject*) self, "phone-numbers");
	phones_a = (_vala_array_free (phones_a, phones_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (phones);
	_g_free0 (phones_field);
}


gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp12_;
	gboolean _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (phone != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->priv->_phone_numbers;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPhoneFieldDetails* p;
			FolksPhoneFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _p_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPhoneFieldDetails*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp12_ = found;
	if (!_tmp12_) {
		const gchar* _tmp13_;
		FolksPhoneFieldDetails* _tmp14_;
		FolksPhoneFieldDetails* phone_fd;
		FolksPhoneFieldDetails* _tmp15_;
		const gchar* _tmp16_;
		GeeHashSet* _tmp17_;
		FolksPhoneFieldDetails* _tmp18_;
		_tmp13_ = phone;
		_tmp14_ = folks_phone_field_details_new (_tmp13_, NULL);
		phone_fd = _tmp14_;
		_tmp15_ = phone_fd;
		_tmp16_ = tracker_id;
		folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp15_, "tracker_id", _tmp16_);
		_tmp17_ = self->priv->_phone_numbers;
		_tmp18_ = phone_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		g_object_notify ((GObject*) self, "phone-numbers");
		_g_object_unref0 (phone_fd);
	}
	_tmp19_ = found;
	result = !_tmp19_;
	return result;
}


gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = self->priv->_phone_numbers;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksPhoneFieldDetails* p;
			FolksPhoneFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _p_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPhoneFieldDetails*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				GeeHashSet* _tmp12_;
				FolksPhoneFieldDetails* _tmp13_;
				_tmp12_ = self->priv->_phone_numbers;
				_tmp13_ = p;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp14_ = found;
	if (_tmp14_) {
		g_object_notify ((GObject*) self, "phone-numbers");
	}
	result = found;
	return result;
}


gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp12_;
	gboolean _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (addr != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _email_fd_it;
		_tmp0_ = self->priv->_email_addresses;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_email_fd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksEmailFieldDetails* email_fd;
			FolksEmailFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _email_fd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _email_fd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			email_fd = (FolksEmailFieldDetails*) _tmp5_;
			_tmp6_ = email_fd;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				found = TRUE;
				_g_object_unref0 (email_fd);
				break;
			}
			_g_object_unref0 (email_fd);
		}
		_g_object_unref0 (_email_fd_it);
	}
	_tmp12_ = found;
	if (!_tmp12_) {
		const gchar* _tmp13_;
		FolksEmailFieldDetails* _tmp14_;
		FolksEmailFieldDetails* email_fd;
		FolksEmailFieldDetails* _tmp15_;
		const gchar* _tmp16_;
		GeeHashSet* _tmp17_;
		FolksEmailFieldDetails* _tmp18_;
		_tmp13_ = addr;
		_tmp14_ = folks_email_field_details_new (_tmp13_, NULL);
		email_fd = _tmp14_;
		_tmp15_ = email_fd;
		_tmp16_ = tracker_id;
		folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp15_, "tracker_id", _tmp16_);
		_tmp17_ = self->priv->_email_addresses;
		_tmp18_ = email_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		g_object_notify ((GObject*) self, "email-addresses");
		_g_object_unref0 (email_fd);
	}
	_tmp19_ = found;
	result = !_tmp19_;
	return result;
}


gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _email_fd_it;
		_tmp0_ = self->priv->_email_addresses;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_email_fd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksEmailFieldDetails* email_fd;
			FolksEmailFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _email_fd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _email_fd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			email_fd = (FolksEmailFieldDetails*) _tmp5_;
			_tmp6_ = email_fd;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				GeeHashSet* _tmp12_;
				FolksEmailFieldDetails* _tmp13_;
				_tmp12_ = self->priv->_email_addresses;
				_tmp13_ = email_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				found = TRUE;
				_g_object_unref0 (email_fd);
				break;
			}
			_g_object_unref0 (email_fd);
		}
		_g_object_unref0 (_email_fd_it);
	}
	_tmp14_ = found;
	if (_tmp14_) {
		g_object_notify ((GObject*) self, "email-addresses");
	}
	result = found;
	return result;
}


static void _trf_persona_update_email_addresses (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* emails_field;
	const gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* email_addresses;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** emails_a;
	gint emails_a_length1;
	gint _emails_a_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeHashSet* _tmp25_;
	GeeHashSet* _tmp26_;
	GeeHashSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeSet* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_EMAILS, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	emails_field = _tmp2_;
	_tmp3_ = emails_field;
	if (_tmp3_ == NULL) {
		_g_free0 (emails_field);
		return;
	}
	_tmp4_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	email_addresses = _tmp4_;
	_tmp5_ = emails_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	emails_a = _tmp7_;
	emails_a_length1 = _vala_array_length (_tmp6_);
	_emails_a_size_ = emails_a_length1;
	_tmp8_ = emails_a;
	_tmp8__length1 = emails_a_length1;
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp8_;
		e_collection_length1 = _tmp8__length1;
		for (e_it = 0; e_it < _tmp8__length1; e_it = e_it + 1) {
			gchar* _tmp9_;
			gchar* e = NULL;
			_tmp9_ = g_strdup (e_collection[e_it]);
			e = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				gboolean _tmp13_;
				_tmp11_ = e;
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					_tmp12_ = e;
					_tmp10_ = g_strcmp0 (_tmp12_, "") != 0;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp13_ = _tmp10_;
				if (_tmp13_) {
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gchar** _tmp16_ = NULL;
					gchar** id_addr;
					gint id_addr_length1;
					gint _id_addr_size_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					FolksEmailFieldDetails* _tmp19_;
					FolksEmailFieldDetails* fd;
					FolksEmailFieldDetails* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					GeeHashSet* _tmp23_;
					FolksEmailFieldDetails* _tmp24_;
					_tmp14_ = e;
					_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "\t", 0);
					id_addr = _tmp16_;
					id_addr_length1 = _vala_array_length (_tmp15_);
					_id_addr_size_ = id_addr_length1;
					_tmp17_ = id_addr;
					_tmp17__length1 = id_addr_length1;
					_tmp18_ = _tmp17_[TRF_EMAIL_FIELDS_EMAIL];
					_tmp19_ = folks_email_field_details_new (_tmp18_, NULL);
					fd = _tmp19_;
					_tmp20_ = fd;
					_tmp21_ = id_addr;
					_tmp21__length1 = id_addr_length1;
					_tmp22_ = _tmp21_[TRF_EMAIL_FIELDS_TRACKER_ID];
					folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp20_, "tracker_id", _tmp22_);
					_tmp23_ = email_addresses;
					_tmp24_ = fd;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
					_g_object_unref0 (fd);
					id_addr = (_vala_array_free (id_addr, id_addr_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp25_ = email_addresses;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp26_;
	_tmp27_ = self->priv->_email_addresses;
	_tmp28_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp29_;
	g_object_notify ((GObject*) self, "email-addresses");
	emails_a = (_vala_array_free (emails_a, emails_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (email_addresses);
	_g_free0 (emails_field);
}


static void _trf_persona_update_urls (TrfPersona* self) {
	GeeHashSet* _tmp0_;
	GeeHashSet* url_fds;
	TrackerSparqlCursor* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _urls_field;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** urls_table;
	gint urls_table_length1;
	gint _urls_table_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeHashSet* _tmp44_;
	GeeHashSet* _tmp45_;
	GeeHashSet* _tmp46_;
	GeeSet* _tmp47_;
	GeeSet* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	url_fds = _tmp0_;
	_tmp1_ = self->priv->_cursor;
	_tmp2_ = tracker_sparql_cursor_get_string (_tmp1_, (gint) TRF_FIELDS_URLS, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_urls_field = _tmp3_;
	_tmp4_ = _urls_field;
	if (_tmp4_ == NULL) {
		_g_free0 (_urls_field);
		_g_object_unref0 (url_fds);
		return;
	}
	_tmp5_ = _urls_field;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	urls_table = _tmp7_;
	urls_table_length1 = _vala_array_length (_tmp6_);
	_urls_table_size_ = urls_table_length1;
	_tmp8_ = urls_table;
	_tmp8__length1 = urls_table_length1;
	{
		gchar** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
		row_collection = _tmp8_;
		row_collection_length1 = _tmp8__length1;
		for (row_it = 0; row_it < _tmp8__length1; row_it = row_it + 1) {
			gchar* _tmp9_;
			gchar* row = NULL;
			_tmp9_ = g_strdup (row_collection[row_it]);
			row = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_ = NULL;
				gchar** u;
				gint u_length1;
				gint _u_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* tracker_id;
				_tmp10_ = row;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\t", 0);
				u = _tmp12_;
				u_length1 = _vala_array_length (_tmp11_);
				_u_size_ = u_length1;
				_tmp13_ = u;
				_tmp13__length1 = u_length1;
				_tmp14_ = _tmp13_[TRF_URLS_FIELDS_TRACKER_ID];
				_tmp15_ = g_strdup (_tmp14_);
				tracker_id = _tmp15_;
				{
					gint i;
					i = 1;
					{
						gboolean _tmp16_;
						_tmp16_ = TRUE;
						while (TRUE) {
							gboolean _tmp17_;
							gint _tmp19_;
							gchar** _tmp20_;
							gint _tmp20__length1;
							gboolean _tmp21_ = FALSE;
							gchar** _tmp22_;
							gint _tmp22__length1;
							gint _tmp23_;
							const gchar* _tmp24_;
							gboolean _tmp28_;
							gchar* type;
							gint _tmp29_;
							gchar** _tmp32_;
							gint _tmp32__length1;
							gint _tmp33_;
							const gchar* _tmp34_;
							FolksUrlFieldDetails* _tmp35_;
							FolksUrlFieldDetails* url_fd;
							FolksUrlFieldDetails* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							GeeHashSet* _tmp42_;
							FolksUrlFieldDetails* _tmp43_;
							_tmp17_ = _tmp16_;
							if (!_tmp17_) {
								gint _tmp18_;
								_tmp18_ = i;
								i = _tmp18_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp19_ = i;
							_tmp20_ = u;
							_tmp20__length1 = u_length1;
							if (!(_tmp19_ < _tmp20__length1)) {
								break;
							}
							_tmp22_ = u;
							_tmp22__length1 = u_length1;
							_tmp23_ = i;
							_tmp24_ = _tmp22_[_tmp23_];
							if (_tmp24_ == NULL) {
								_tmp21_ = TRUE;
							} else {
								gchar** _tmp25_;
								gint _tmp25__length1;
								gint _tmp26_;
								const gchar* _tmp27_;
								_tmp25_ = u;
								_tmp25__length1 = u_length1;
								_tmp26_ = i;
								_tmp27_ = _tmp25_[_tmp26_];
								_tmp21_ = g_strcmp0 (_tmp27_, "") == 0;
							}
							_tmp28_ = _tmp21_;
							if (_tmp28_) {
								continue;
							}
							type = NULL;
							_tmp29_ = i;
							switch (_tmp29_) {
								case TRF_URLS_FIELDS_BLOG:
								{
									gchar* _tmp30_;
									_tmp30_ = g_strdup (FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_BLOG);
									_g_free0 (type);
									type = _tmp30_;
									break;
								}
								case TRF_URLS_FIELDS_WEBSITE:
								{
									gchar* _tmp31_;
									_tmp31_ = g_strdup (FOLKS_URL_FIELD_DETAILS_PARAM_TYPE_HOME_PAGE);
									_g_free0 (type);
									type = _tmp31_;
									break;
								}
								case TRF_URLS_FIELDS_URL:
								{
									break;
								}
								default:
								break;
							}
							_tmp32_ = u;
							_tmp32__length1 = u_length1;
							_tmp33_ = i;
							_tmp34_ = _tmp32_[_tmp33_];
							_tmp35_ = folks_url_field_details_new (_tmp34_, NULL);
							url_fd = _tmp35_;
							_tmp36_ = url_fd;
							_tmp37_ = tracker_id;
							folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp36_, "tracker_id", _tmp37_);
							_tmp38_ = type;
							if (_tmp38_ != NULL) {
								FolksUrlFieldDetails* _tmp39_;
								FolksUrlFieldDetails* _tmp40_;
								const gchar* _tmp41_;
								_tmp39_ = url_fd;
								_tmp40_ = url_fd;
								_tmp41_ = type;
								folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp39_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE, _tmp41_);
							}
							_tmp42_ = url_fds;
							_tmp43_ = url_fd;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
							_g_object_unref0 (url_fd);
							_g_free0 (type);
						}
					}
				}
				_g_free0 (tracker_id);
				u = (_vala_array_free (u, u_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (row);
			}
		}
	}
	_tmp44_ = url_fds;
	_tmp45_ = _g_object_ref0 (_tmp44_);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp45_;
	_tmp46_ = self->priv->_urls;
	_tmp47_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp46_);
	_tmp48_ = _tmp47_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp48_;
	g_object_notify ((GObject*) self, "urls");
	urls_table = (_vala_array_free (urls_table, urls_table_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_urls_field);
	_g_object_unref0 (url_fds);
}


gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp12_;
	gboolean _tmp23_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _url_fd_it;
		_tmp0_ = self->priv->_urls;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_url_fd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksUrlFieldDetails* url_fd;
			FolksUrlFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _url_fd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _url_fd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			url_fd = (FolksUrlFieldDetails*) _tmp5_;
			_tmp6_ = url_fd;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				found = TRUE;
				_g_object_unref0 (url_fd);
				break;
			}
			_g_object_unref0 (url_fd);
		}
		_g_object_unref0 (_url_fd_it);
	}
	_tmp12_ = found;
	if (!_tmp12_) {
		const gchar* _tmp13_;
		FolksUrlFieldDetails* _tmp14_;
		FolksUrlFieldDetails* url_fd;
		FolksUrlFieldDetails* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GeeHashSet* _tmp21_;
		FolksUrlFieldDetails* _tmp22_;
		_tmp13_ = url;
		_tmp14_ = folks_url_field_details_new (_tmp13_, NULL);
		url_fd = _tmp14_;
		_tmp15_ = url_fd;
		_tmp16_ = tracker_id;
		folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp15_, "tracker_id", _tmp16_);
		_tmp17_ = type;
		if (_tmp17_ != NULL) {
			FolksUrlFieldDetails* _tmp18_;
			FolksUrlFieldDetails* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = url_fd;
			_tmp19_ = url_fd;
			_tmp20_ = type;
			folks_abstract_field_details_set_parameter ((FolksAbstractFieldDetails*) _tmp18_, FOLKS_ABSTRACT_FIELD_DETAILS_PARAM_TYPE, _tmp20_);
		}
		_tmp21_ = self->priv->_urls;
		_tmp22_ = url_fd;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
		g_object_notify ((GObject*) self, "urls");
		_g_object_unref0 (url_fd);
	}
	_tmp23_ = found;
	result = !_tmp23_;
	return result;
}


gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _url_fd_it;
		_tmp0_ = self->priv->_urls;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_url_fd_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksUrlFieldDetails* url_fd;
			FolksUrlFieldDetails* _tmp6_;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_;
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp2_ = _url_fd_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _url_fd_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			url_fd = (FolksUrlFieldDetails*) _tmp5_;
			_tmp6_ = url_fd;
			_tmp7_ = folks_abstract_field_details_get_parameter_values ((FolksAbstractFieldDetails*) _tmp6_, "tracker_id");
			_tmp8_ = _tmp7_;
			_tmp9_ = tracker_id;
			_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				GeeHashSet* _tmp12_;
				FolksUrlFieldDetails* _tmp13_;
				_tmp12_ = self->priv->_urls;
				_tmp13_ = url_fd;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				found = TRUE;
			}
			_g_object_unref0 (url_fd);
		}
		_g_object_unref0 (_url_fd_it);
	}
	_tmp14_ = found;
	if (_tmp14_) {
		g_object_notify ((GObject*) self, "urls");
	}
	result = found;
	return result;
}


static void _trf_persona_update_favourite (TrfPersona* self) {
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* favourite;
	gboolean is_favourite;
	const gchar* _tmp3_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, (gint) TRF_FIELDS_FAVOURITE, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	favourite = _tmp2_;
	is_favourite = FALSE;
	_tmp3_ = favourite;
	if (_tmp3_ != NULL) {
		FolksPersonaStore* _tmp4_;
		FolksPersonaStore* _tmp5_;
		TrfPersonaStore* _tmp6_;
		TrfPersonaStore* trf_store;
		TrfPersonaStore* _tmp7_;
		gint _tmp8_ = 0;
		gint favorite_tracker_id;
		const gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp4_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (TRF_PERSONA_STORE (_tmp5_));
		trf_store = _tmp6_;
		_tmp7_ = trf_store;
		_tmp8_ = trf_persona_store_get_favorite_id (_tmp7_);
		favorite_tracker_id = _tmp8_;
		_tmp9_ = favourite;
		_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ",", 0);
		{
			gchar** tag_collection = NULL;
			gint tag_collection_length1 = 0;
			gint _tag_collection_size_ = 0;
			gint tag_it = 0;
			tag_collection = _tmp11_;
			tag_collection_length1 = _vala_array_length (_tmp10_);
			for (tag_it = 0; tag_it < _vala_array_length (_tmp10_); tag_it = tag_it + 1) {
				gchar* _tmp12_;
				gchar* tag = NULL;
				_tmp12_ = g_strdup (tag_collection[tag_it]);
				tag = _tmp12_;
				{
					const gchar* _tmp13_;
					gint _tmp14_ = 0;
					gint _tmp15_;
					_tmp13_ = tag;
					_tmp14_ = atoi (_tmp13_);
					_tmp15_ = favorite_tracker_id;
					if (_tmp14_ == _tmp15_) {
						is_favourite = TRUE;
					}
					_g_free0 (tag);
				}
			}
			tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (trf_store);
	}
	_tmp16_ = is_favourite;
	_tmp17_ = self->priv->_is_favourite;
	if (_tmp16_ != _tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = is_favourite;
		self->priv->_is_favourite = _tmp18_;
		g_object_notify ((GObject*) self, "is-favourite");
	}
	_g_free0 (favourite);
}


/**
   * This method sets the is_favourite attribute internally.
   * That is, it should be used as a result of an event fired by
   * Tracker since this method doesn't propagate changes back
   * to Tracker again.
   */
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_fav;
	self->priv->_is_favourite = _tmp0_;
	g_object_notify ((GObject*) self, "is-favourite");
}


static const gchar* trf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static gchar** trf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TrfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TrfPersona*) base;
	_tmp0_ = TRF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TRF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** trf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TrfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TrfPersona*) base;
	_tmp0_ = TRF_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TRF_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GLoadableIcon* trf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TrfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TrfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* trf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TrfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TrfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* trf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static FolksGender trf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	TrfPersona* self;
	FolksGender _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_gender;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	TrfPersona* self;
	FolksGender _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_gender_details_change_gender ((FolksGenderDetails*) self, _tmp0_, NULL, NULL);
}


static GDateTime* trf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TrfPersona* self;
	GDateTime* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TrfPersona* self;
	GDateTime* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_birthday ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* trf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = NULL;
	return result;
}


static void trf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TrfPersona* self;
	const gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_calendar_event_id ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_roles (FolksRoleDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_roles_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_roles (FolksRoleDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_role_details_change_roles ((FolksRoleDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_notes (FolksNoteDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_notes_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_notes (FolksNoteDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_note_details_change_notes ((FolksNoteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_postal_addresses (FolksPostalAddressDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_postal_addresses_ro;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_postal_addresses (FolksPostalAddressDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_postal_address_details_change_postal_addresses ((FolksPostalAddressDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* trf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void trf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static gboolean trf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TrfPersona* self;
	gboolean _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void trf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TrfPersona* self;
	gboolean _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_favourite_details_change_is_favourite ((FolksFavouriteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* trf_persona_real_get_local_ids (FolksLocalIdDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSet* _tmp7_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_local_ids;
	_tmp1_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp2_);
	if (_tmp3_ == FALSE) {
		GeeHashSet* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_local_ids;
		_tmp5_ = folks_persona_get_iid ((FolksPersona*) self);
		_tmp6_ = _tmp5_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	}
	_tmp7_ = self->priv->_local_ids_ro;
	result = _tmp7_;
	return result;
}


static void trf_persona_real_set_local_ids (FolksLocalIdDetails* base, GeeSet* value) {
	TrfPersona* self;
	GeeSet* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_local_id_details_change_local_ids ((FolksLocalIdDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* trf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void trf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = value;
	folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) self, _tmp0_, NULL, NULL);
}


static void trf_persona_class_init (TrfPersonaClass * klass) {
	trf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = trf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = trf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = trf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_trf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_trf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = trf_persona_finalize;
	/**
	   * A nickname for the Persona.
	   *
	   * See {@link Folks.NameDetails.nickname}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_PHONE_NUMBERS, "phone-numbers");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_EMAIL_ADDRESSES, "email-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_BIRTHDAY, "birthday");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_CALENDAR_EVENT_ID, "calendar-event-id");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_ROLES, "roles");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NOTES, "notes");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_POSTAL_ADDRESSES, "postal-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * Whether this contact is a user-defined favourite.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IS_FAVOURITE, "is-favourite");
	/**
	   * IDs used to link {@link Trf.Persona}s.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LOCAL_IDS, "local-ids");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
}


static void trf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	trf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_avatar = (void (*)(FolksAvatarDetails*, GLoadableIcon*, GError**)) trf_persona_real_change_avatar;
	iface->change_avatar_finish = trf_persona_real_change_avatar_finish;
	iface->get_avatar = trf_persona_real_get_avatar;
	iface->set_avatar = trf_persona_real_set_avatar;
}


static void trf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	trf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_birthday = (void (*)(FolksBirthdayDetails*, GDateTime*, GError**)) trf_persona_real_change_birthday;
	iface->change_birthday_finish = trf_persona_real_change_birthday_finish;
	iface->get_birthday = trf_persona_real_get_birthday;
	iface->set_birthday = trf_persona_real_set_birthday;
	iface->get_calendar_event_id = trf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = trf_persona_real_set_calendar_event_id;
}


static void trf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	trf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_email_addresses = (void (*)(FolksEmailDetails*, GeeSet*, GError**)) trf_persona_real_change_email_addresses;
	iface->change_email_addresses_finish = trf_persona_real_change_email_addresses_finish;
	iface->get_email_addresses = trf_persona_real_get_email_addresses;
	iface->set_email_addresses = trf_persona_real_set_email_addresses;
}


static void trf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	trf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_is_favourite = (void (*)(FolksFavouriteDetails*, gboolean, GError**)) trf_persona_real_change_is_favourite;
	iface->change_is_favourite_finish = trf_persona_real_change_is_favourite_finish;
	iface->get_is_favourite = trf_persona_real_get_is_favourite;
	iface->set_is_favourite = trf_persona_real_set_is_favourite;
}


static void trf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	trf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_gender = (void (*)(FolksGenderDetails*, FolksGender, GError**)) trf_persona_real_change_gender;
	iface->change_gender_finish = trf_persona_real_change_gender_finish;
	iface->get_gender = trf_persona_real_get_gender;
	iface->set_gender = trf_persona_real_set_gender;
}


static void trf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	trf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_im_addresses = (void (*)(FolksImDetails*, GeeMultiMap*, GError**)) trf_persona_real_change_im_addresses;
	iface->change_im_addresses_finish = trf_persona_real_change_im_addresses_finish;
	iface->get_im_addresses = trf_persona_real_get_im_addresses;
	iface->set_im_addresses = trf_persona_real_set_im_addresses;
}


static void trf_persona_folks_local_id_details_interface_init (FolksLocalIdDetailsIface * iface) {
	trf_persona_folks_local_id_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_local_ids = (void (*)(FolksLocalIdDetails*, GeeSet*, GError**)) trf_persona_real_change_local_ids;
	iface->change_local_ids_finish = trf_persona_real_change_local_ids_finish;
	iface->get_local_ids = trf_persona_real_get_local_ids;
	iface->set_local_ids = trf_persona_real_set_local_ids;
}


static void trf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	trf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_nickname = (void (*)(FolksNameDetails*, const gchar*, GError**)) trf_persona_real_change_nickname;
	iface->change_nickname_finish = trf_persona_real_change_nickname_finish;
	iface->change_structured_name = (void (*)(FolksNameDetails*, FolksStructuredName*, GError**)) trf_persona_real_change_structured_name;
	iface->change_structured_name_finish = trf_persona_real_change_structured_name_finish;
	iface->change_full_name = (void (*)(FolksNameDetails*, const gchar*, GError**)) trf_persona_real_change_full_name;
	iface->change_full_name_finish = trf_persona_real_change_full_name_finish;
	iface->get_nickname = trf_persona_real_get_nickname;
	iface->set_nickname = trf_persona_real_set_nickname;
	iface->get_structured_name = trf_persona_real_get_structured_name;
	iface->set_structured_name = trf_persona_real_set_structured_name;
	iface->get_full_name = trf_persona_real_get_full_name;
	iface->set_full_name = trf_persona_real_set_full_name;
}


static void trf_persona_folks_note_details_interface_init (FolksNoteDetailsIface * iface) {
	trf_persona_folks_note_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_notes = (void (*)(FolksNoteDetails*, GeeSet*, GError**)) trf_persona_real_change_notes;
	iface->change_notes_finish = trf_persona_real_change_notes_finish;
	iface->get_notes = trf_persona_real_get_notes;
	iface->set_notes = trf_persona_real_set_notes;
}


static void trf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	trf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_phone_numbers = (void (*)(FolksPhoneDetails*, GeeSet*, GError**)) trf_persona_real_change_phone_numbers;
	iface->change_phone_numbers_finish = trf_persona_real_change_phone_numbers_finish;
	iface->get_phone_numbers = trf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = trf_persona_real_set_phone_numbers;
}


static void trf_persona_folks_postal_address_details_interface_init (FolksPostalAddressDetailsIface * iface) {
	trf_persona_folks_postal_address_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_postal_addresses = (void (*)(FolksPostalAddressDetails*, GeeSet*, GError**)) trf_persona_real_change_postal_addresses;
	iface->change_postal_addresses_finish = trf_persona_real_change_postal_addresses_finish;
	iface->get_postal_addresses = trf_persona_real_get_postal_addresses;
	iface->set_postal_addresses = trf_persona_real_set_postal_addresses;
}


static void trf_persona_folks_role_details_interface_init (FolksRoleDetailsIface * iface) {
	trf_persona_folks_role_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_roles = (void (*)(FolksRoleDetails*, GeeSet*, GError**)) trf_persona_real_change_roles;
	iface->change_roles_finish = trf_persona_real_change_roles_finish;
	iface->get_roles = trf_persona_real_get_roles;
	iface->set_roles = trf_persona_real_set_roles;
}


static void trf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	trf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_urls = (void (*)(FolksUrlDetails*, GeeSet*, GError**)) trf_persona_real_change_urls;
	iface->change_urls_finish = trf_persona_real_change_urls_finish;
	iface->get_urls = trf_persona_real_get_urls;
	iface->set_urls = trf_persona_real_set_urls;
}


static void trf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	trf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_web_service_addresses = (void (*)(FolksWebServiceDetails*, GeeMultiMap*, GError**)) trf_persona_real_change_web_service_addresses;
	iface->change_web_service_addresses_finish = trf_persona_real_change_web_service_addresses_finish;
	iface->get_web_service_addresses = trf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = trf_persona_real_set_web_service_addresses;
}


static void trf_persona_instance_init (TrfPersona * self) {
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	self->priv = TRF_PERSONA_GET_PRIVATE (self);
	self->priv->_avatar = NULL;
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	self->priv->_birthday = NULL;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->_tracker_ids_ims = _tmp1_;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_web_service_addresses = _tmp3_;
}


static void trf_persona_finalize (GObject* obj) {
	TrfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = TRF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("trf-persona.vala:648: Destroying Trf.Persona '%s': %p", _tmp1_, self);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_free0 (self->priv->_tracker_id);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_object_unref0 (self->priv->_roles);
	_g_object_unref0 (self->priv->_roles_ro);
	_g_object_unref0 (self->priv->_notes);
	_g_object_unref0 (self->priv->_notes_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	_g_object_unref0 (self->priv->_tracker_ids_ims);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	_g_object_unref0 (self->priv->_web_service_addresses);
	G_OBJECT_CLASS (trf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single nco:Contact.
 */
GType trf_persona_get_type (void) {
	static volatile gsize trf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&trf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrfPersona), 0, (GInstanceInitFunc) trf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) trf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) trf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) trf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) trf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) trf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) trf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_local_id_details_info = { (GInterfaceInitFunc) trf_persona_folks_local_id_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) trf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_note_details_info = { (GInterfaceInitFunc) trf_persona_folks_note_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) trf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_postal_address_details_info = { (GInterfaceInitFunc) trf_persona_folks_postal_address_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_role_details_info = { (GInterfaceInitFunc) trf_persona_folks_role_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) trf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) trf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType trf_persona_type_id;
		trf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TrfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_LOCAL_ID_DETAILS, &folks_local_id_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NOTE_DETAILS, &folks_note_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, &folks_postal_address_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_ROLE_DETAILS, &folks_role_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&trf_persona_type_id__volatile, trf_persona_type_id);
	}
	return trf_persona_type_id__volatile;
}


static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	self = TRF_PERSONA (object);
	switch (property_id) {
		case TRF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TRF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TRF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TRF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case TRF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_ROLES:
		g_value_set_object (value, folks_role_details_get_roles ((FolksRoleDetails*) self));
		break;
		case TRF_PERSONA_NOTES:
		g_value_set_object (value, folks_note_details_get_notes ((FolksNoteDetails*) self));
		break;
		case TRF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		g_value_set_object (value, folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) self));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		g_value_set_object (value, folks_local_id_details_get_local_ids ((FolksLocalIdDetails*) self));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	self = TRF_PERSONA (object);
	switch (property_id) {
		case TRF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case TRF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_ROLES:
		folks_role_details_set_roles ((FolksRoleDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_NOTES:
		folks_note_details_set_notes ((FolksNoteDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		folks_postal_address_details_set_postal_addresses ((FolksPostalAddressDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		folks_local_id_details_set_local_ids ((FolksLocalIdDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



