/* signal-manager.c generated by valac 0.14.0.3-1a311, the Vala compiler
 * generated from signal-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
typedef struct _FolksInspectSignalManagerPrivate FolksInspectSignalManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_closure_unref0(var) ((var == NULL) ? NULL : (var = (g_closure_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _FolksInspectSignalManager {
	GObject parent_instance;
	FolksInspectSignalManagerPrivate * priv;
};

struct _FolksInspectSignalManagerClass {
	GObjectClass parent_class;
};

struct _FolksInspectSignalManagerPrivate {
	GeeHashMap* signals_by_class_type;
	GeeHashMap* signals_by_class_instance;
};


static gpointer folks_inspect_signal_manager_parent_class = NULL;

GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerPrivate))
enum  {
	FOLKS_INSPECT_SIGNAL_MANAGER_DUMMY_PROPERTY
};
FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_indent (void);
static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map);
void folks_inspect_utils_unindent (void);
void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string);
static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags);
guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string);
static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string);
guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id);
static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id);
static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue** return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data);
static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data);
static void _vala_GValue_free (GValue* self);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1);
static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self);
static void folks_inspect_signal_manager_finalize (GObject* obj);


FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type) {
	FolksInspectSignalManager * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (FolksInspectSignalManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_type);
	self->priv->signals_by_class_type = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	self->priv->signals_by_class_instance = _tmp1_;
	return self;
}


FolksInspectSignalManager* folks_inspect_signal_manager_new (void) {
	return folks_inspect_signal_manager_construct (FOLKS_INSPECT_TYPE_SIGNAL_MANAGER);
}


void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance) {
	GType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = class_type;
	if (_tmp0_ != G_TYPE_INVALID) {
		GeeHashMap* _tmp1_;
		GType _tmp2_;
		gpointer _tmp3_ = NULL;
		GeeHashMap* hook_ids;
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		GType _tmp6_;
		GeeHashMap* _tmp7_;
		_tmp1_ = self->priv->signals_by_class_type;
		_tmp2_ = class_type;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, GINT_TO_POINTER (_tmp2_));
		hook_ids = (GeeHashMap*) _tmp3_;
		_tmp4_ = class_type;
		_tmp5_ = g_type_name (_tmp4_);
		folks_inspect_utils_print_line ("Signals on all instances of class type '%s':", _tmp5_);
		folks_inspect_utils_indent ();
		_tmp6_ = class_type;
		_tmp7_ = hook_ids;
		folks_inspect_signal_manager_list_signals_for_type (self, _tmp6_, _tmp7_);
		folks_inspect_utils_unindent ();
		_g_object_unref0 (hook_ids);
	} else {
		GObject* _tmp8_;
		_tmp8_ = class_instance;
		if (_tmp8_ != NULL) {
			GeeHashMap* _tmp9_;
			GObject* _tmp10_;
			gpointer _tmp11_ = NULL;
			GeeHashMap* signal_handler_ids;
			GObject* _tmp12_;
			GObject* _tmp13_;
			GType _tmp14_ = 0UL;
			const gchar* _tmp15_ = NULL;
			GObject* _tmp16_;
			GType _tmp17_ = 0UL;
			GeeHashMap* _tmp18_;
			_tmp9_ = self->priv->signals_by_class_instance;
			_tmp10_ = class_instance;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
			signal_handler_ids = (GeeHashMap*) _tmp11_;
			_tmp12_ = class_instance;
			_tmp13_ = class_instance;
			_tmp14_ = G_TYPE_FROM_INSTANCE (_tmp13_);
			_tmp15_ = g_type_name (_tmp14_);
			folks_inspect_utils_print_line ("Signals on instance %p of class type '%s':", _tmp12_, _tmp15_);
			folks_inspect_utils_indent ();
			_tmp16_ = class_instance;
			_tmp17_ = G_TYPE_FROM_INSTANCE (_tmp16_);
			_tmp18_ = signal_handler_ids;
			folks_inspect_signal_manager_list_signals_for_type (self, _tmp17_, _tmp18_);
			folks_inspect_utils_unindent ();
			_g_object_unref0 (signal_handler_ids);
		} else {
			GeeHashMap* _tmp19_;
			GeeMapIterator* _tmp20_ = NULL;
			GeeMapIterator* class_type_iter;
			GeeHashMap* _tmp37_;
			GeeMapIterator* _tmp38_ = NULL;
			GeeMapIterator* class_instance_iter;
			_tmp19_ = self->priv->signals_by_class_type;
			_tmp20_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp19_);
			class_type_iter = _tmp20_;
			folks_inspect_utils_print_line ("Connected signals on all instances of classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp21_;
				gboolean _tmp22_ = FALSE;
				GeeMapIterator* _tmp23_;
				gpointer _tmp24_ = NULL;
				GeeHashMap* hook_ids;
				GeeHashMap* _tmp25_;
				GeeMapIterator* _tmp26_ = NULL;
				GeeMapIterator* hook_iter;
				GeeMapIterator* _tmp27_;
				gpointer _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* class_name;
				_tmp21_ = class_type_iter;
				_tmp22_ = gee_map_iterator_next (_tmp21_);
				if (!(_tmp22_ == TRUE)) {
					break;
				}
				_tmp23_ = class_type_iter;
				_tmp24_ = gee_map_iterator_get_value (_tmp23_);
				hook_ids = (GeeHashMap*) _tmp24_;
				_tmp25_ = hook_ids;
				_tmp26_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp25_);
				hook_iter = _tmp26_;
				_tmp27_ = class_type_iter;
				_tmp28_ = gee_map_iterator_get_key (_tmp27_);
				_tmp29_ = g_type_name (GPOINTER_TO_INT (_tmp28_));
				_tmp30_ = g_strdup (_tmp29_);
				class_name = _tmp30_;
				while (TRUE) {
					GeeMapIterator* _tmp31_;
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
					GeeMapIterator* _tmp34_;
					gpointer _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					_tmp31_ = hook_iter;
					_tmp32_ = gee_map_iterator_next (_tmp31_);
					if (!(_tmp32_ == TRUE)) {
						break;
					}
					_tmp33_ = class_name;
					_tmp34_ = hook_iter;
					_tmp35_ = gee_map_iterator_get_key (_tmp34_);
					_tmp36_ = g_signal_name (GPOINTER_TO_UINT (_tmp35_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp33_, _tmp36_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (hook_iter);
				_g_object_unref0 (hook_ids);
			}
			folks_inspect_utils_unindent ();
			_tmp37_ = self->priv->signals_by_class_instance;
			_tmp38_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp37_);
			class_instance_iter = _tmp38_;
			folks_inspect_utils_print_line ("%s", "Connected signals on specific instances of " "classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp39_;
				gboolean _tmp40_ = FALSE;
				GeeMapIterator* _tmp41_;
				gpointer _tmp42_ = NULL;
				GeeHashMap* signal_handler_ids;
				GeeHashMap* _tmp43_;
				GeeMapIterator* _tmp44_ = NULL;
				GeeMapIterator* signal_handler_iter;
				GeeMapIterator* _tmp45_;
				gpointer _tmp46_ = NULL;
				GObject* _tmp47_;
				GType _tmp48_ = 0UL;
				const gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* class_name;
				_tmp39_ = class_instance_iter;
				_tmp40_ = gee_map_iterator_next (_tmp39_);
				if (!(_tmp40_ == TRUE)) {
					break;
				}
				_tmp41_ = class_instance_iter;
				_tmp42_ = gee_map_iterator_get_value (_tmp41_);
				signal_handler_ids = (GeeHashMap*) _tmp42_;
				_tmp43_ = signal_handler_ids;
				_tmp44_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp43_);
				signal_handler_iter = _tmp44_;
				_tmp45_ = class_instance_iter;
				_tmp46_ = gee_map_iterator_get_key (_tmp45_);
				_tmp47_ = (GObject*) _tmp46_;
				_tmp48_ = G_TYPE_FROM_INSTANCE (_tmp47_);
				_tmp49_ = g_type_name (_tmp48_);
				_tmp50_ = g_strdup (_tmp49_);
				_tmp51_ = _tmp50_;
				_g_object_unref0 (_tmp47_);
				class_name = _tmp51_;
				while (TRUE) {
					GeeMapIterator* _tmp52_;
					gboolean _tmp53_ = FALSE;
					const gchar* _tmp54_;
					GeeMapIterator* _tmp55_;
					gpointer _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					_tmp52_ = signal_handler_iter;
					_tmp53_ = gee_map_iterator_next (_tmp52_);
					if (!(_tmp53_ == TRUE)) {
						break;
					}
					_tmp54_ = class_name;
					_tmp55_ = signal_handler_iter;
					_tmp56_ = gee_map_iterator_get_key (_tmp55_);
					_tmp57_ = g_signal_name (GPOINTER_TO_UINT (_tmp56_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp54_, _tmp57_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (signal_handler_iter);
				_g_object_unref0 (signal_handler_ids);
			}
			folks_inspect_utils_unindent ();
			_g_object_unref0 (class_instance_iter);
			_g_object_unref0 (class_type_iter);
		}
	}
}


void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string) {
	const gchar* _tmp0_;
	GType _tmp1_;
	guint _tmp2_ = 0U;
	guint signal_id;
	guint _tmp3_;
	GSignalQuery query_info = {0};
	guint _tmp7_;
	GSignalQuery _tmp8_ = {0};
	GSignalQuery _tmp9_;
	guint _tmp10_;
	GSignalQuery _tmp11_;
	const gchar* _tmp12_;
	GSignalQuery _tmp13_;
	GType _tmp14_;
	const gchar* _tmp15_ = NULL;
	GSignalQuery _tmp16_;
	GSignalFlags _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GSignalQuery _tmp20_;
	GType _tmp21_;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = signal_name;
	_tmp1_ = class_type;
	_tmp2_ = g_signal_lookup (_tmp0_, _tmp1_);
	signal_id = _tmp2_;
	_tmp3_ = signal_id;
	if (_tmp3_ == ((guint) 0)) {
		const gchar* _tmp4_;
		GType _tmp5_;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = signal_name;
		_tmp5_ = class_type;
		_tmp6_ = g_type_name (_tmp5_);
		folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp4_, _tmp6_);
		return;
	}
	_tmp7_ = signal_id;
	g_signal_query (_tmp7_, &_tmp8_);
	query_info = _tmp8_;
	_tmp9_ = query_info;
	_tmp10_ = _tmp9_.signal_id;
	folks_inspect_utils_print_line ("Signal ID        %u", _tmp10_);
	_tmp11_ = query_info;
	_tmp12_ = _tmp11_.signal_name;
	folks_inspect_utils_print_line ("Signal name      %s", _tmp12_);
	_tmp13_ = query_info;
	_tmp14_ = _tmp13_.itype;
	_tmp15_ = g_type_name (_tmp14_);
	folks_inspect_utils_print_line ("Emitting type    %s", _tmp15_);
	_tmp16_ = query_info;
	_tmp17_ = _tmp16_.signal_flags;
	_tmp18_ = folks_inspect_signal_manager_signal_flags_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	folks_inspect_utils_print_line ("Signal flags     %s", _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = query_info;
	_tmp21_ = _tmp20_.return_type;
	_tmp22_ = g_type_name (_tmp21_);
	folks_inspect_utils_print_line ("Return type      %s", _tmp22_);
	folks_inspect_utils_print_line ("Parameter types:");
	folks_inspect_utils_indent ();
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				guint _tmp26_;
				GSignalQuery _tmp27_;
				guint _tmp28_;
				guint _tmp29_;
				GSignalQuery _tmp30_;
				GType* _tmp31_;
				gint _tmp31__length1;
				guint _tmp32_;
				GType _tmp33_;
				const gchar* _tmp34_ = NULL;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					guint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = i;
				_tmp27_ = query_info;
				_tmp28_ = _tmp27_.n_params;
				if (!(_tmp26_ < _tmp28_)) {
					break;
				}
				_tmp29_ = i;
				_tmp30_ = query_info;
				_tmp31_ = _tmp30_.param_types;
				_tmp31__length1 = -1;
				_tmp32_ = i;
				_tmp33_ = _tmp31_[_tmp32_];
				_tmp34_ = g_type_name (_tmp33_);
				folks_inspect_utils_print_line ("%-4u  %s", _tmp29_, _tmp34_);
			}
		}
	}
	folks_inspect_utils_unindent ();
}


guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = class_type;
	if (_tmp1_ != G_TYPE_INVALID) {
		const gchar* _tmp2_;
		_tmp2_ = signal_name;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		GType _tmp5_;
		guint _tmp6_ = 0U;
		guint signal_id;
		guint _tmp7_;
		GType _tmp11_;
		guint _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp4_ = signal_name;
		_tmp5_ = class_type;
		_tmp6_ = g_signal_lookup (_tmp4_, _tmp5_);
		signal_id = _tmp6_;
		_tmp7_ = signal_id;
		if (_tmp7_ == ((guint) 0)) {
			const gchar* _tmp8_;
			GType _tmp9_;
			const gchar* _tmp10_ = NULL;
			_tmp8_ = signal_name;
			_tmp9_ = class_type;
			_tmp10_ = g_type_name (_tmp9_);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp8_, _tmp10_);
			result = (guint) 0;
			return result;
		}
		_tmp11_ = class_type;
		_tmp12_ = signal_id;
		_tmp13_ = detail_string;
		_tmp14_ = folks_inspect_signal_manager_add_emission_hook (self, _tmp11_, _tmp12_, _tmp13_);
		if (_tmp14_ == FALSE) {
			const gchar* _tmp15_;
			GType _tmp16_;
			const gchar* _tmp17_ = NULL;
			_tmp15_ = signal_name;
			_tmp16_ = class_type;
			_tmp17_ = g_type_name (_tmp16_);
			folks_inspect_utils_print_line ("Not allowed to connect to signal '%s' on " "class '%s'.", _tmp15_, _tmp17_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp18_ = FALSE;
		GType _tmp19_;
		gboolean _tmp21_;
		_tmp19_ = class_type;
		if (_tmp19_ != G_TYPE_INVALID) {
			const gchar* _tmp20_;
			_tmp20_ = signal_name;
			_tmp18_ = _tmp20_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp21_ = _tmp18_;
		if (_tmp21_) {
			GType _tmp22_;
			gint _tmp23_ = 0;
			guint* _tmp24_ = NULL;
			guint* signal_ids;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count;
			guint* _tmp25_;
			gint _tmp25__length1;
			_tmp22_ = class_type;
			_tmp24_ = g_signal_list_ids (_tmp22_, &_tmp23_);
			signal_ids = _tmp24_;
			signal_ids_length1 = _tmp23_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp25_ = signal_ids;
			_tmp25__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp25_;
				signal_id_collection_length1 = _tmp25__length1;
				for (signal_id_it = 0; signal_id_it < _tmp25__length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						GType _tmp26_;
						guint _tmp27_;
						gboolean _tmp28_ = FALSE;
						_tmp26_ = class_type;
						_tmp27_ = signal_id;
						_tmp28_ = folks_inspect_signal_manager_add_emission_hook (self, _tmp26_, _tmp27_, NULL);
						if (_tmp28_ == TRUE) {
							guint _tmp29_;
							_tmp29_ = signal_count;
							signal_count = _tmp29_ + 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp30_ = FALSE;
			GObject* _tmp31_;
			gboolean _tmp33_;
			_tmp31_ = class_instance;
			if (_tmp31_ != NULL) {
				const gchar* _tmp32_;
				_tmp32_ = signal_name;
				_tmp30_ = _tmp32_ != NULL;
			} else {
				_tmp30_ = FALSE;
			}
			_tmp33_ = _tmp30_;
			if (_tmp33_) {
				const gchar* _tmp34_;
				GObject* _tmp35_;
				GType _tmp36_ = 0UL;
				guint _tmp37_ = 0U;
				guint signal_id;
				guint _tmp38_;
				GObject* _tmp44_;
				guint _tmp45_;
				const gchar* _tmp46_;
				_tmp34_ = signal_name;
				_tmp35_ = class_instance;
				_tmp36_ = G_TYPE_FROM_INSTANCE (_tmp35_);
				_tmp37_ = g_signal_lookup (_tmp34_, _tmp36_);
				signal_id = _tmp37_;
				_tmp38_ = signal_id;
				if (_tmp38_ == ((guint) 0)) {
					const gchar* _tmp39_;
					GObject* _tmp40_;
					GObject* _tmp41_;
					GType _tmp42_ = 0UL;
					const gchar* _tmp43_ = NULL;
					_tmp39_ = signal_name;
					_tmp40_ = class_instance;
					_tmp41_ = class_instance;
					_tmp42_ = G_TYPE_FROM_INSTANCE (_tmp41_);
					_tmp43_ = g_type_name (_tmp42_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", _tmp39_, _tmp40_, _tmp43_);
					result = (guint) 0;
					return result;
				}
				_tmp44_ = class_instance;
				_tmp45_ = signal_id;
				_tmp46_ = detail_string;
				folks_inspect_signal_manager_add_signal_handler (self, _tmp44_, _tmp45_, _tmp46_);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp47_ = FALSE;
				GObject* _tmp48_;
				gboolean _tmp50_;
				_tmp48_ = class_instance;
				if (_tmp48_ != NULL) {
					const gchar* _tmp49_;
					_tmp49_ = signal_name;
					_tmp47_ = _tmp49_ == NULL;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp50_ = _tmp47_;
				if (_tmp50_) {
					GObject* _tmp51_;
					GType _tmp52_ = 0UL;
					gint _tmp53_ = 0;
					guint* _tmp54_ = NULL;
					guint* signal_ids;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count;
					guint* _tmp55_;
					gint _tmp55__length1;
					_tmp51_ = class_instance;
					_tmp52_ = G_TYPE_FROM_INSTANCE (_tmp51_);
					_tmp54_ = g_signal_list_ids (_tmp52_, &_tmp53_);
					signal_ids = _tmp54_;
					signal_ids_length1 = _tmp53_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp55_ = signal_ids;
					_tmp55__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp55_;
						signal_id_collection_length1 = _tmp55__length1;
						for (signal_id_it = 0; signal_id_it < _tmp55__length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								guint _tmp56_;
								GObject* _tmp57_;
								guint _tmp58_;
								_tmp56_ = signal_count;
								signal_count = _tmp56_ + 1;
								_tmp57_ = class_instance;
								_tmp58_ = signal_id;
								folks_inspect_signal_manager_add_signal_handler (self, _tmp57_, _tmp58_, NULL);
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = class_type;
	if (_tmp1_ != G_TYPE_INVALID) {
		const gchar* _tmp2_;
		_tmp2_ = signal_name;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		GType _tmp5_;
		guint _tmp6_ = 0U;
		guint signal_id;
		guint _tmp7_;
		GType _tmp11_;
		guint _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp4_ = signal_name;
		_tmp5_ = class_type;
		_tmp6_ = g_signal_lookup (_tmp4_, _tmp5_);
		signal_id = _tmp6_;
		_tmp7_ = signal_id;
		if (_tmp7_ == ((guint) 0)) {
			const gchar* _tmp8_;
			GType _tmp9_;
			const gchar* _tmp10_ = NULL;
			_tmp8_ = signal_name;
			_tmp9_ = class_type;
			_tmp10_ = g_type_name (_tmp9_);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp8_, _tmp10_);
			result = (guint) 0;
			return result;
		}
		_tmp11_ = class_type;
		_tmp12_ = signal_id;
		_tmp13_ = folks_inspect_signal_manager_remove_emission_hook (self, _tmp11_, _tmp12_);
		if (_tmp13_ == FALSE) {
			const gchar* _tmp14_;
			GType _tmp15_;
			const gchar* _tmp16_ = NULL;
			_tmp14_ = signal_name;
			_tmp15_ = class_type;
			_tmp16_ = g_type_name (_tmp15_);
			folks_inspect_utils_print_line ("Could not remove hook for signal '%s' on " "class '%s'.", _tmp14_, _tmp16_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp17_ = FALSE;
		GType _tmp18_;
		gboolean _tmp20_;
		_tmp18_ = class_type;
		if (_tmp18_ != G_TYPE_INVALID) {
			const gchar* _tmp19_;
			_tmp19_ = signal_name;
			_tmp17_ = _tmp19_ == NULL;
		} else {
			_tmp17_ = FALSE;
		}
		_tmp20_ = _tmp17_;
		if (_tmp20_) {
			GType _tmp21_;
			gint _tmp22_ = 0;
			guint* _tmp23_ = NULL;
			guint* signal_ids;
			gint signal_ids_length1;
			gint _signal_ids_size_;
			guint signal_count;
			guint* _tmp24_;
			gint _tmp24__length1;
			_tmp21_ = class_type;
			_tmp23_ = g_signal_list_ids (_tmp21_, &_tmp22_);
			signal_ids = _tmp23_;
			signal_ids_length1 = _tmp22_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp24_ = signal_ids;
			_tmp24__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp24_;
				signal_id_collection_length1 = _tmp24__length1;
				for (signal_id_it = 0; signal_id_it < _tmp24__length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						GType _tmp25_;
						guint _tmp26_;
						gboolean _tmp27_ = FALSE;
						_tmp25_ = class_type;
						_tmp26_ = signal_id;
						_tmp27_ = folks_inspect_signal_manager_remove_emission_hook (self, _tmp25_, _tmp26_);
						if (_tmp27_ == TRUE) {
							guint _tmp28_;
							_tmp28_ = signal_count;
							signal_count = _tmp28_ - 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp29_ = FALSE;
			GObject* _tmp30_;
			gboolean _tmp32_;
			_tmp30_ = class_instance;
			if (_tmp30_ != NULL) {
				const gchar* _tmp31_;
				_tmp31_ = signal_name;
				_tmp29_ = _tmp31_ != NULL;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp32_ = _tmp29_;
			if (_tmp32_) {
				const gchar* _tmp33_;
				GObject* _tmp34_;
				GType _tmp35_ = 0UL;
				guint _tmp36_ = 0U;
				guint signal_id;
				guint _tmp37_;
				GObject* _tmp43_;
				guint _tmp44_;
				_tmp33_ = signal_name;
				_tmp34_ = class_instance;
				_tmp35_ = G_TYPE_FROM_INSTANCE (_tmp34_);
				_tmp36_ = g_signal_lookup (_tmp33_, _tmp35_);
				signal_id = _tmp36_;
				_tmp37_ = signal_id;
				if (_tmp37_ == ((guint) 0)) {
					const gchar* _tmp38_;
					GObject* _tmp39_;
					GObject* _tmp40_;
					GType _tmp41_ = 0UL;
					const gchar* _tmp42_ = NULL;
					_tmp38_ = signal_name;
					_tmp39_ = class_instance;
					_tmp40_ = class_instance;
					_tmp41_ = G_TYPE_FROM_INSTANCE (_tmp40_);
					_tmp42_ = g_type_name (_tmp41_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", _tmp38_, _tmp39_, _tmp42_);
					result = (guint) 0;
					return result;
				}
				_tmp43_ = class_instance;
				_tmp44_ = signal_id;
				folks_inspect_signal_manager_remove_signal_handler (self, _tmp43_, _tmp44_);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp45_ = FALSE;
				GObject* _tmp46_;
				gboolean _tmp48_;
				_tmp46_ = class_instance;
				if (_tmp46_ != NULL) {
					const gchar* _tmp47_;
					_tmp47_ = signal_name;
					_tmp45_ = _tmp47_ == NULL;
				} else {
					_tmp45_ = FALSE;
				}
				_tmp48_ = _tmp45_;
				if (_tmp48_) {
					GObject* _tmp49_;
					GType _tmp50_ = 0UL;
					gint _tmp51_ = 0;
					guint* _tmp52_ = NULL;
					guint* signal_ids;
					gint signal_ids_length1;
					gint _signal_ids_size_;
					guint signal_count;
					guint* _tmp53_;
					gint _tmp53__length1;
					_tmp49_ = class_instance;
					_tmp50_ = G_TYPE_FROM_INSTANCE (_tmp49_);
					_tmp52_ = g_signal_list_ids (_tmp50_, &_tmp51_);
					signal_ids = _tmp52_;
					signal_ids_length1 = _tmp51_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp53_ = signal_ids;
					_tmp53__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp53_;
						signal_id_collection_length1 = _tmp53__length1;
						for (signal_id_it = 0; signal_id_it < _tmp53__length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								GObject* _tmp54_;
								guint _tmp55_;
								gboolean _tmp56_ = FALSE;
								_tmp54_ = class_instance;
								_tmp55_ = signal_id;
								_tmp56_ = folks_inspect_signal_manager_remove_signal_handler (self, _tmp54_, _tmp55_);
								if (_tmp56_) {
									guint _tmp57_;
									_tmp57_ = signal_count;
									signal_count = _tmp57_ - 1;
								}
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map) {
	GType _tmp0_;
	gint _tmp1_ = 0;
	guint* _tmp2_ = NULL;
	guint* signal_ids;
	gint signal_ids_length1;
	gint _signal_ids_size_;
	guint* _tmp3_;
	gint _tmp3__length1;
	GType _tmp20_;
	guint _tmp21_;
	GType* _tmp22_ = NULL;
	GType* interfaces;
	gint interfaces_length1;
	gint _interfaces_size_;
	GType* _tmp23_;
	gint _tmp23__length1;
	GType _tmp26_;
	GType _tmp27_ = 0UL;
	GType parent_type;
	GType _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = type;
	_tmp2_ = g_signal_list_ids (_tmp0_, &_tmp1_);
	signal_ids = _tmp2_;
	signal_ids_length1 = _tmp1_;
	_signal_ids_size_ = signal_ids_length1;
	_tmp3_ = signal_ids;
	_tmp3__length1 = signal_ids_length1;
	if (_tmp3_ != NULL) {
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* type_name;
		guint* _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = type;
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		type_name = _tmp6_;
		_tmp7_ = signal_ids;
		_tmp7__length1 = signal_ids_length1;
		{
			guint* signal_id_collection = NULL;
			gint signal_id_collection_length1 = 0;
			gint _signal_id_collection_size_ = 0;
			gint signal_id_it = 0;
			signal_id_collection = _tmp7_;
			signal_id_collection_length1 = _tmp7__length1;
			for (signal_id_it = 0; signal_id_it < _tmp7__length1; signal_id_it = signal_id_it + 1) {
				guint signal_id = 0U;
				signal_id = signal_id_collection[signal_id_it];
				{
					guint _tmp8_;
					const gchar* _tmp9_ = NULL;
					const gchar* signal_name;
					gboolean _tmp10_ = FALSE;
					GeeHashMap* _tmp11_;
					gboolean _tmp15_;
					_tmp8_ = signal_id;
					_tmp9_ = g_signal_name (_tmp8_);
					signal_name = _tmp9_;
					_tmp11_ = signal_id_map;
					if (_tmp11_ != NULL) {
						GeeHashMap* _tmp12_;
						guint _tmp13_;
						gboolean _tmp14_ = FALSE;
						_tmp12_ = signal_id_map;
						_tmp13_ = signal_id;
						_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, GUINT_TO_POINTER (_tmp13_));
						_tmp10_ = _tmp14_ == TRUE;
					} else {
						_tmp10_ = FALSE;
					}
					_tmp15_ = _tmp10_;
					if (_tmp15_) {
						const gchar* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = type_name;
						_tmp17_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s — connected", _tmp16_, _tmp17_);
					} else {
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						_tmp18_ = type_name;
						_tmp19_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s", _tmp18_, _tmp19_);
					}
				}
			}
		}
		_g_free0 (type_name);
	}
	_tmp20_ = type;
	_tmp22_ = g_type_interfaces (_tmp20_, &_tmp21_);
	interfaces = _tmp22_;
	interfaces_length1 = _tmp21_;
	_interfaces_size_ = interfaces_length1;
	_tmp23_ = interfaces;
	_tmp23__length1 = interfaces_length1;
	{
		GType* interface_type_collection = NULL;
		gint interface_type_collection_length1 = 0;
		gint _interface_type_collection_size_ = 0;
		gint interface_type_it = 0;
		interface_type_collection = _tmp23_;
		interface_type_collection_length1 = _tmp23__length1;
		for (interface_type_it = 0; interface_type_it < _tmp23__length1; interface_type_it = interface_type_it + 1) {
			GType interface_type = 0UL;
			interface_type = interface_type_collection[interface_type_it];
			{
				GType _tmp24_;
				GeeHashMap* _tmp25_;
				_tmp24_ = interface_type;
				_tmp25_ = signal_id_map;
				folks_inspect_signal_manager_list_signals_for_type (self, _tmp24_, _tmp25_);
			}
		}
	}
	_tmp26_ = type;
	_tmp27_ = g_type_parent (_tmp26_);
	parent_type = _tmp27_;
	_tmp28_ = parent_type;
	if (_tmp28_ != G_TYPE_INVALID) {
		GType _tmp29_;
		GeeHashMap* _tmp30_;
		_tmp29_ = parent_type;
		_tmp30_ = signal_id_map;
		folks_inspect_signal_manager_list_signals_for_type (self, _tmp29_, _tmp30_);
	}
	interfaces = (g_free (interfaces), NULL);
	signal_ids = (g_free (signal_ids), NULL);
}


static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data) {
	folks_inspect_signal_manager_signal_meta_marshaller (closure, return_value, param_values, param_values_length1, invocation_hint, marshal_data);
}


static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string) {
	GClosure* _tmp0_;
	GClosure* closure;
	GClosure* _tmp1_;
	GQuark detail_quark;
	const gchar* _tmp2_;
	GObject* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	GClosure* _tmp8_;
	gulong _tmp9_ = 0UL;
	gulong signal_handler_id;
	GeeHashMap* _tmp10_;
	GObject* _tmp11_;
	gpointer _tmp12_ = NULL;
	GeeHashMap* signal_handler_ids;
	GeeHashMap* _tmp13_;
	GeeHashMap* _tmp18_;
	guint _tmp19_;
	gulong _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_instance != NULL);
	_tmp0_ = g_closure_new_object ((gulong) sizeof (GClosure), (GObject*) self);
	closure = _tmp0_;
	_tmp1_ = closure;
	g_closure_set_meta_marshal (_tmp1_, NULL, _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal);
	detail_quark = (GQuark) 0;
	_tmp2_ = detail_string;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GQuark _tmp4_ = 0U;
		_tmp3_ = detail_string;
		_tmp4_ = g_quark_try_string (_tmp3_);
		detail_quark = _tmp4_;
	}
	_tmp5_ = class_instance;
	_tmp6_ = signal_id;
	_tmp7_ = detail_quark;
	_tmp8_ = closure;
	_tmp9_ = g_signal_connect_closure_by_id (_tmp5_, _tmp6_, _tmp7_, _tmp8_, FALSE);
	signal_handler_id = _tmp9_;
	_tmp10_ = self->priv->signals_by_class_instance;
	_tmp11_ = class_instance;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
	signal_handler_ids = (GeeHashMap*) _tmp12_;
	_tmp13_ = signal_handler_ids;
	if (_tmp13_ == NULL) {
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		GObject* _tmp16_;
		GeeHashMap* _tmp17_;
		_tmp14_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (signal_handler_ids);
		signal_handler_ids = _tmp14_;
		_tmp15_ = self->priv->signals_by_class_instance;
		_tmp16_ = class_instance;
		_tmp17_ = signal_handler_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, _tmp17_);
	}
	_tmp18_ = signal_handler_ids;
	_tmp19_ = signal_id;
	_tmp20_ = signal_handler_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, GUINT_TO_POINTER (_tmp19_), GUINT_TO_POINTER (_tmp20_));
	_g_object_unref0 (signal_handler_ids);
	_g_closure_unref0 (closure);
}


static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GObject* _tmp1_;
	gpointer _tmp2_ = NULL;
	GeeHashMap* signal_handler_ids;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_;
	gboolean _tmp8_;
	GeeHashMap* _tmp9_;
	guint _tmp10_;
	gpointer _tmp11_ = NULL;
	gulong signal_handler_id;
	GObject* _tmp12_;
	gulong _tmp13_;
	GeeHashMap* _tmp14_;
	guint _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class_instance != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_instance;
	_tmp1_ = class_instance;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	signal_handler_ids = (GeeHashMap*) _tmp2_;
	_tmp4_ = signal_handler_ids;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeHashMap* _tmp5_;
		guint _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = signal_handler_ids;
		_tmp6_ = signal_id;
		_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, GUINT_TO_POINTER (_tmp6_));
		_tmp3_ = _tmp7_ == FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		result = FALSE;
		_g_object_unref0 (signal_handler_ids);
		return result;
	}
	_tmp9_ = signal_handler_ids;
	_tmp10_ = signal_id;
	_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, GUINT_TO_POINTER (_tmp10_));
	signal_handler_id = GPOINTER_TO_UINT (_tmp11_);
	_tmp12_ = class_instance;
	_tmp13_ = signal_handler_id;
	g_signal_handler_disconnect (_tmp12_, _tmp13_);
	_tmp14_ = signal_handler_ids;
	_tmp15_ = signal_id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp14_, GUINT_TO_POINTER (_tmp15_), NULL);
	result = TRUE;
	_g_object_unref0 (signal_handler_ids);
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue** return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data) {
	GValue* _vala_return_value = NULL;
	void* _tmp0_;
	GSignalInvocationHint* hint;
	GSignalQuery query_info = {0};
	GSignalInvocationHint* _tmp1_;
	guint _tmp2_;
	GSignalQuery _tmp3_ = {0};
	GSignalQuery _tmp4_;
	GType _tmp5_;
	const gchar* _tmp6_ = NULL;
	GSignalQuery _tmp7_;
	const gchar* _tmp8_;
	guint i;
	GValue* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (closure != NULL);
	_tmp0_ = invocation_hint;
	hint = (GSignalInvocationHint*) _tmp0_;
	__vala_GValue_free0 (_vala_return_value);
	_vala_return_value = NULL;
	_tmp1_ = hint;
	_tmp2_ = (*_tmp1_).signal_id;
	g_signal_query (_tmp2_, &_tmp3_);
	query_info = _tmp3_;
	_tmp4_ = query_info;
	_tmp5_ = _tmp4_.itype;
	_tmp6_ = g_type_name (_tmp5_);
	_tmp7_ = query_info;
	_tmp8_ = _tmp7_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp6_, _tmp8_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	_tmp9_ = param_values;
	_tmp9__length1 = param_values_length1;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = _tmp9_;
		param_value_collection_length1 = _tmp9__length1;
		for (param_value_it = 0; param_value_it < _tmp9__length1; param_value_it = param_value_it + 1) {
			GValue _tmp10_ = {0};
			GValue param_value = {0};
			if (G_IS_VALUE (&param_value_collection[param_value_it])) {
				g_value_init (&_tmp10_, G_VALUE_TYPE (&param_value_collection[param_value_it]));
				g_value_copy (&param_value_collection[param_value_it], &_tmp10_);
			} else {
				_tmp10_ = param_value_collection[param_value_it];
			}
			param_value = _tmp10_;
			{
				guint _tmp11_;
				GType _tmp12_ = 0UL;
				const gchar* _tmp13_ = NULL;
				GValue _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp11_ = i;
				i = _tmp11_ + 1;
				_tmp12_ = G_VALUE_TYPE (&param_value);
				_tmp13_ = g_type_name (_tmp12_);
				_tmp14_ = param_value;
				_tmp15_ = folks_inspect_utils_transform_value_to_string (&_tmp14_);
				_tmp16_ = _tmp15_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp11_, _tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	if (return_value) {
		*return_value = _vala_return_value;
	} else {
		__vala_GValue_free0 (_vala_return_value);
	}
}


static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self) {
	gboolean result;
	result = folks_inspect_signal_manager_emission_hook_cb (self, ihint, param_values, param_values_length1);
	return result;
}


static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string) {
	gboolean result = FALSE;
	GQuark detail_quark;
	const gchar* _tmp0_;
	GSignalQuery query = {0};
	guint _tmp3_;
	GSignalQuery _tmp4_ = {0};
	GSignalQuery _tmp5_;
	GSignalFlags _tmp6_;
	guint _tmp7_;
	GQuark _tmp8_;
	gulong _tmp9_ = 0UL;
	gulong hook_id;
	GeeHashMap* _tmp10_;
	GType _tmp11_;
	gpointer _tmp12_ = NULL;
	GeeHashMap* hook_ids;
	GeeHashMap* _tmp13_;
	GeeHashMap* _tmp18_;
	guint _tmp19_;
	gulong _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	detail_quark = (GQuark) 0;
	_tmp0_ = detail_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		GQuark _tmp2_ = 0U;
		_tmp1_ = detail_string;
		_tmp2_ = g_quark_try_string (_tmp1_);
		detail_quark = _tmp2_;
	}
	_tmp3_ = signal_id;
	g_signal_query (_tmp3_, &_tmp4_);
	query = _tmp4_;
	_tmp5_ = query;
	_tmp6_ = _tmp5_.signal_flags;
	if ((_tmp6_ & G_SIGNAL_NO_HOOKS) != 0) {
		result = FALSE;
		return result;
	}
	_tmp7_ = signal_id;
	_tmp8_ = detail_quark;
	_tmp9_ = g_signal_add_emission_hook (_tmp7_, _tmp8_, _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook, self, NULL);
	hook_id = _tmp9_;
	_tmp10_ = self->priv->signals_by_class_type;
	_tmp11_ = class_type;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, GINT_TO_POINTER (_tmp11_));
	hook_ids = (GeeHashMap*) _tmp12_;
	_tmp13_ = hook_ids;
	if (_tmp13_ == NULL) {
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		GType _tmp16_;
		GeeHashMap* _tmp17_;
		_tmp14_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (hook_ids);
		hook_ids = _tmp14_;
		_tmp15_ = self->priv->signals_by_class_type;
		_tmp16_ = class_type;
		_tmp17_ = hook_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, GINT_TO_POINTER (_tmp16_), _tmp17_);
	}
	_tmp18_ = hook_ids;
	_tmp19_ = signal_id;
	_tmp20_ = hook_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, GUINT_TO_POINTER (_tmp19_), GUINT_TO_POINTER (_tmp20_));
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GType _tmp1_;
	gpointer _tmp2_ = NULL;
	GeeHashMap* hook_ids;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_;
	gboolean _tmp8_;
	GeeHashMap* _tmp9_;
	guint _tmp10_;
	gpointer _tmp11_ = NULL;
	gulong hook_id;
	guint _tmp12_;
	gulong _tmp13_;
	GeeHashMap* _tmp14_;
	guint _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_type;
	_tmp1_ = class_type;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, GINT_TO_POINTER (_tmp1_));
	hook_ids = (GeeHashMap*) _tmp2_;
	_tmp4_ = hook_ids;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeHashMap* _tmp5_;
		guint _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = hook_ids;
		_tmp6_ = signal_id;
		_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, GUINT_TO_POINTER (_tmp6_));
		_tmp3_ = _tmp7_ == FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		result = FALSE;
		_g_object_unref0 (hook_ids);
		return result;
	}
	_tmp9_ = hook_ids;
	_tmp10_ = signal_id;
	_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, GUINT_TO_POINTER (_tmp10_));
	hook_id = GPOINTER_TO_UINT (_tmp11_);
	_tmp12_ = signal_id;
	_tmp13_ = hook_id;
	g_signal_remove_emission_hook (_tmp12_, _tmp13_);
	_tmp14_ = hook_ids;
	_tmp15_ = signal_id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp14_, GUINT_TO_POINTER (_tmp15_), NULL);
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1) {
	gboolean result = FALSE;
	GSignalQuery query_info = {0};
	GSignalInvocationHint _tmp0_;
	guint _tmp1_;
	GSignalQuery _tmp2_ = {0};
	GSignalQuery _tmp3_;
	GType _tmp4_;
	const gchar* _tmp5_ = NULL;
	GSignalQuery _tmp6_;
	const gchar* _tmp7_;
	guint i;
	GValue* _tmp8_;
	gint _tmp8__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hint != NULL, FALSE);
	_tmp0_ = *hint;
	_tmp1_ = _tmp0_.signal_id;
	g_signal_query (_tmp1_, &_tmp2_);
	query_info = _tmp2_;
	_tmp3_ = query_info;
	_tmp4_ = _tmp3_.itype;
	_tmp5_ = g_type_name (_tmp4_);
	_tmp6_ = query_info;
	_tmp7_ = _tmp6_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp5_, _tmp7_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	_tmp8_ = param_values;
	_tmp8__length1 = param_values_length1;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = _tmp8_;
		param_value_collection_length1 = _tmp8__length1;
		for (param_value_it = 0; param_value_it < _tmp8__length1; param_value_it = param_value_it + 1) {
			GValue _tmp9_ = {0};
			GValue param_value = {0};
			if (G_IS_VALUE (&param_value_collection[param_value_it])) {
				g_value_init (&_tmp9_, G_VALUE_TYPE (&param_value_collection[param_value_it]));
				g_value_copy (&param_value_collection[param_value_it], &_tmp9_);
			} else {
				_tmp9_ = param_value_collection[param_value_it];
			}
			param_value = _tmp9_;
			{
				guint _tmp10_;
				GType _tmp11_ = 0UL;
				const gchar* _tmp12_ = NULL;
				GValue _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				_tmp10_ = i;
				i = _tmp10_ + 1;
				_tmp11_ = G_VALUE_TYPE (&param_value);
				_tmp12_ = g_type_name (_tmp11_);
				_tmp13_ = param_value;
				_tmp14_ = folks_inspect_utils_transform_value_to_string (&_tmp13_);
				_tmp15_ = _tmp14_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp10_, _tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = TRUE;
	return result;
}


static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* output;
	GSignalFlags _tmp1_;
	GSignalFlags _tmp4_;
	GSignalFlags _tmp12_;
	GSignalFlags _tmp20_;
	GSignalFlags _tmp28_;
	GSignalFlags _tmp36_;
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = flags;
	if ((_tmp1_ & G_SIGNAL_RUN_FIRST) != 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = output;
		_tmp3_ = g_strconcat (_tmp2_, "G_SIGNAL_RUN_FIRST", NULL);
		_g_free0 (output);
		output = _tmp3_;
	}
	_tmp4_ = flags;
	if ((_tmp4_ & G_SIGNAL_RUN_LAST) != 0) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = output;
		if (g_strcmp0 (_tmp6_, "") != 0) {
			_tmp5_ = " | ";
		} else {
			_tmp5_ = "";
		}
		_tmp7_ = output;
		_tmp8_ = _tmp5_;
		_tmp9_ = g_strconcat (_tmp8_, "G_SIGNAL_RUN_LAST", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
		_g_free0 (output);
		output = _tmp11_;
		_g_free0 (_tmp10_);
	}
	_tmp12_ = flags;
	if ((_tmp12_ & G_SIGNAL_RUN_CLEANUP) != 0) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp14_ = output;
		if (g_strcmp0 (_tmp14_, "") != 0) {
			_tmp13_ = " | ";
		} else {
			_tmp13_ = "";
		}
		_tmp15_ = output;
		_tmp16_ = _tmp13_;
		_tmp17_ = g_strconcat (_tmp16_, "G_SIGNAL_RUN_CLEANUP", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
		_g_free0 (output);
		output = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = flags;
	if ((_tmp20_ & G_SIGNAL_DETAILED) != 0) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp22_ = output;
		if (g_strcmp0 (_tmp22_, "") != 0) {
			_tmp21_ = " | ";
		} else {
			_tmp21_ = "";
		}
		_tmp23_ = output;
		_tmp24_ = _tmp21_;
		_tmp25_ = g_strconcat (_tmp24_, "G_SIGNAL_DETAILED", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
		_g_free0 (output);
		output = _tmp27_;
		_g_free0 (_tmp26_);
	}
	_tmp28_ = flags;
	if ((_tmp28_ & G_SIGNAL_ACTION) != 0) {
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp30_ = output;
		if (g_strcmp0 (_tmp30_, "") != 0) {
			_tmp29_ = " | ";
		} else {
			_tmp29_ = "";
		}
		_tmp31_ = output;
		_tmp32_ = _tmp29_;
		_tmp33_ = g_strconcat (_tmp32_, "G_SIGNAL_ACTION", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
		_g_free0 (output);
		output = _tmp35_;
		_g_free0 (_tmp34_);
	}
	_tmp36_ = flags;
	if ((_tmp36_ & G_SIGNAL_NO_HOOKS) != 0) {
		const gchar* _tmp37_ = NULL;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp38_ = output;
		if (g_strcmp0 (_tmp38_, "") != 0) {
			_tmp37_ = " | ";
		} else {
			_tmp37_ = "";
		}
		_tmp39_ = output;
		_tmp40_ = _tmp37_;
		_tmp41_ = g_strconcat (_tmp40_, "G_SIGNAL_NO_HOOKS", NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
		_g_free0 (output);
		output = _tmp43_;
		_g_free0 (_tmp42_);
	}
	result = output;
	return result;
}


static void folks_inspect_signal_manager_class_init (FolksInspectSignalManagerClass * klass) {
	folks_inspect_signal_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksInspectSignalManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_signal_manager_finalize;
}


static void folks_inspect_signal_manager_instance_init (FolksInspectSignalManager * self) {
	self->priv = FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE (self);
}


static void folks_inspect_signal_manager_finalize (GObject* obj) {
	FolksInspectSignalManager * self;
	self = FOLKS_INSPECT_SIGNAL_MANAGER (obj);
	_g_object_unref0 (self->priv->signals_by_class_type);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	G_OBJECT_CLASS (folks_inspect_signal_manager_parent_class)->finalize (obj);
}


GType folks_inspect_signal_manager_get_type (void) {
	static volatile gsize folks_inspect_signal_manager_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_signal_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectSignalManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_signal_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectSignalManager), 0, (GInstanceInitFunc) folks_inspect_signal_manager_instance_init, NULL };
		GType folks_inspect_signal_manager_type_id;
		folks_inspect_signal_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectSignalManager", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_signal_manager_type_id__volatile, folks_inspect_signal_manager_type_id);
	}
	return folks_inspect_signal_manager_type_id__volatile;
}



