/* avatar-cache.c generated by valac 0.14.0.3-1a311, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_AVATAR_CACHE_TESTS (avatar_cache_tests_get_type ())
#define AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests))
#define AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))
#define IS_AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_CACHE_TESTS))
#define IS_AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_CACHE_TESTS))
#define AVATAR_CACHE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))

typedef struct _AvatarCacheTests AvatarCacheTests;
typedef struct _AvatarCacheTestsClass AvatarCacheTestsClass;
typedef struct _AvatarCacheTestsPrivate AvatarCacheTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _AvatarCacheTests {
	FolksTestCase parent_instance;
	AvatarCacheTestsPrivate * priv;
};

struct _AvatarCacheTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarCacheTestsPrivate {
	FolksAvatarCache* _cache;
	GFile* _cache_dir;
	GLoadableIcon* _avatar;
	GMainLoop* _main_loop;
};

struct _Block1Data {
	int _ref_count_;
	AvatarCacheTests * self;
	GLoadableIcon* avatar;
};


static gpointer avatar_cache_tests_parent_class = NULL;

GType avatar_cache_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_CACHE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsPrivate))
enum  {
	AVATAR_CACHE_TESTS_DUMMY_PROPERTY
};
AvatarCacheTests* avatar_cache_tests_new (void);
AvatarCacheTests* avatar_cache_tests_construct (GType object_type);
void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self);
static void avatar_cache_tests_real_set_up (FolksTestCase* base);
void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self);
static void avatar_cache_tests_real_tear_down (FolksTestCase* base);
void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error);
void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar);
static void __lambda0_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda1_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id);
static void __lambda3_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b);
static void __lambda2_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void avatar_cache_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self) {
#line 41 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_and_load_avatar (self);
#line 119 "avatar-cache.c"
}


static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self) {
#line 42 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_avatar_overwrite (self);
#line 126 "avatar-cache.c"
}


static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 44 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_load_avatar_non_existent (self);
#line 133 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self) {
#line 46 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar (self);
#line 140 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 47 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar_non_existent (self);
#line 147 "avatar-cache.c"
}


static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self) {
#line 49 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_build_uri_for_avatar (self);
#line 154 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_construct (GType object_type) {
	AvatarCacheTests * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
#line 34 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) folks_test_case_construct (object_type, "AvatarCache");
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = g_get_tmp_dir ();
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _tmp1_;
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "folks-avatar-cache-tests");
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache_dir = _tmp3_;
#line 37 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (_tmp2_);
#line 41 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-and-load-avatar", _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method, self);
#line 42 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-avatar-overwrite", _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method, self);
#line 44 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "load-avatar-non-existent", _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method, self);
#line 46 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar", _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method, self);
#line 47 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar-non-existent", _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method, self);
#line 49 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "build-uri-for-avatar", _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method, self);
#line 32 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return self;
#line 194 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_new (void) {
#line 32 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return avatar_cache_tests_construct (TYPE_AVATAR_CACHE_TESTS);
#line 201 "avatar-cache.c"
}


static void avatar_cache_tests_real_set_up (FolksTestCase* base) {
	AvatarCacheTests * self;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	FolksAvatarCache* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	GFileIcon* _tmp7_;
	GMainLoop* _tmp8_;
#line 52 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 54 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 55 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache_dir;
#line 55 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 55 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_setenv ("XDG_CACHE_HOME", _tmp2_, TRUE);
#line 55 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp2_);
#line 58 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = folks_avatar_cache_dup ();
#line 58 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 58 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = _tmp3_;
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = g_getenv ("AVATAR_FILE_PATH");
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = g_file_new_for_path (_tmp4_);
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp6_ = _tmp5_;
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp7_ = (GFileIcon*) g_file_icon_new (_tmp6_);
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = (GLoadableIcon*) _tmp7_;
#line 59 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (_tmp6_);
#line 63 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp8_ = g_main_loop_new (NULL, FALSE);
#line 63 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 63 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = _tmp8_;
#line 256 "avatar-cache.c"
}


static void avatar_cache_tests_real_tear_down (FolksTestCase* base) {
	AvatarCacheTests * self;
#line 66 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 68 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 68 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = NULL;
#line 69 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 69 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = NULL;
#line 70 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 70 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = NULL;
#line 71 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 278 "avatar-cache.c"
}


void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error) {
	GFile* _tmp0_;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* file_info;
	GFileEnumerator* _tmp16_;
	GFile* _tmp17_;
	GError * _inner_error_ = NULL;
#line 74 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (dir != NULL);
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = dir;
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_file_enumerate_children (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	enumerator = _tmp1_;
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 77 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 308 "avatar-cache.c"
	}
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = enumerator;
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	file_info = _tmp3_;
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 81 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 324 "avatar-cache.c"
	}
#line 82 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	while (TRUE) {
#line 328 "avatar-cache.c"
		GFileInfo* _tmp4_;
		GFile* _tmp5_;
		GFileInfo* _tmp6_;
		const gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* child_file;
		GFile* _tmp9_;
		GFileType _tmp10_ = 0;
		GFileEnumerator* _tmp13_;
		GFileInfo* _tmp14_ = NULL;
		GFileInfo* _tmp15_;
#line 82 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = file_info;
#line 82 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (!(_tmp4_ != NULL)) {
#line 82 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			break;
#line 346 "avatar-cache.c"
		}
#line 84 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp5_ = dir;
#line 84 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp6_ = file_info;
#line 84 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp7_ = g_file_info_get_name (_tmp6_);
#line 84 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp8_ = g_file_get_child (_tmp5_, _tmp7_);
#line 84 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		child_file = _tmp8_;
#line 86 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp9_ = child_file;
#line 86 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp10_ = g_file_query_file_type (_tmp9_, G_FILE_QUERY_INFO_NONE, NULL);
#line 86 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_tmp10_ == G_FILE_TYPE_DIRECTORY) {
#line 364 "avatar-cache.c"
			GFile* _tmp11_;
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_tmp11_ = child_file;
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_avatar_cache_tests_delete_directory (self, _tmp11_, &_inner_error_);
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			if (_inner_error_ != NULL) {
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 89 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				return;
#line 382 "avatar-cache.c"
			}
		} else {
			GFile* _tmp12_;
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_tmp12_ = child_file;
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			g_file_delete (_tmp12_, NULL, &_inner_error_);
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			if (_inner_error_ != NULL) {
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 93 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
				return;
#line 402 "avatar-cache.c"
			}
		}
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp13_ = enumerator;
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp14_ = g_file_enumerator_next_file (_tmp13_, NULL, &_inner_error_);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp15_ = _tmp14_;
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (child_file);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (file_info);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (enumerator);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
			return;
#line 423 "avatar-cache.c"
		}
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 96 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		file_info = _tmp15_;
#line 82 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (child_file);
#line 431 "avatar-cache.c"
	}
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp16_ = enumerator;
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_file_enumerator_close (_tmp16_, NULL, &_inner_error_);
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 98 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 447 "avatar-cache.c"
	}
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp17_ = dir;
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_file_delete (_tmp17_, NULL, &_inner_error_);
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 101 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 463 "avatar-cache.c"
	}
#line 74 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (file_info);
#line 74 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (enumerator);
#line 469 "avatar-cache.c"
}


void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self) {
	GError * _inner_error_ = NULL;
#line 104 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 477 "avatar-cache.c"
	{
		GFile* _tmp0_;
#line 108 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache_dir;
#line 108 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_avatar_cache_tests_delete_directory (self, _tmp0_, &_inner_error_);
#line 108 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 486 "avatar-cache.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 500 "avatar-cache.c"
	}
	__finally0:
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 511 "avatar-cache.c"
	}
}


static void __lambda0_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 521 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = _tmp2_;
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_free0 (_tmp3_);
#line 122 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 539 "avatar-cache.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 126 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = e->message;
#line 126 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:126: Error storing avatar: %s", _tmp4_);
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 558 "avatar-cache.c"
	}
	__finally1:
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 569 "avatar-cache.c"
	}
#line 129 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = self->priv->_main_loop;
#line 129 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp5_);
#line 575 "avatar-cache.c"
}


static void ___lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	__lambda0_ (self, source_object, res);
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 584 "avatar-cache.c"
}


void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GLoadableIcon* _tmp2_;
	GMainLoop* _tmp3_;
#line 116 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 116 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (avatar != NULL);
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 118 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_store_avatar (_tmp0_, _tmp1_, _tmp2_, ___lambda0__gasync_ready_callback, g_object_ref (self));
#line 132 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 132 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp3_);
#line 611 "avatar-cache.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return _data1_;
#line 620 "avatar-cache.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->self);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_slice_free (Block1Data, _data1_);
#line 633 "avatar-cache.c"
	}
}


static void __lambda1_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	AvatarCacheTests * self;
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self = _data1_->self;
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 646 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		GLoadableIcon* _tmp2_ = NULL;
		GLoadableIcon* _tmp3_;
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = folks_avatar_cache_load_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = _tmp2_;
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 662 "avatar-cache.c"
			goto __catch2_g_error;
		}
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 143 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_data1_->avatar = _tmp3_;
#line 669 "avatar-cache.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 147 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = e->message;
#line 147 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:147: Error loading avatar: %s", _tmp4_);
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 686 "avatar-cache.c"
	}
	__finally2:
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 141 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 697 "avatar-cache.c"
	}
#line 150 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = self->priv->_main_loop;
#line 150 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp5_);
#line 703 "avatar-cache.c"
}


static void ___lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	__lambda1_ (self, source_object, res);
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (self);
#line 712 "avatar-cache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 719 "avatar-cache.c"
}


GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id) {
	GLoadableIcon* result = NULL;
	Block1Data* _data1_;
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
	GLoadableIcon* _tmp3_;
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_data1_->_ref_count_ = 1;
#line 135 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_data1_->self = g_object_ref (self);
#line 137 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_data1_->avatar = NULL;
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 139 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_load_avatar (_tmp0_, _tmp1_, ___lambda1__gasync_ready_callback, block1_data_ref (_data1_));
#line 153 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 153 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _g_object_ref0 (_data1_->avatar);
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	result = _tmp3_;
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (_data1_);
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_data1_ = NULL;
#line 155 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return result;
#line 762 "avatar-cache.c"
}


static void __lambda3_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp3_;
	GError * _inner_error_ = NULL;
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 771 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
#line 164 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 164 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 164 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		folks_avatar_cache_remove_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 164 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		if (_inner_error_ != NULL) {
#line 783 "avatar-cache.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 168 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = e->message;
#line 168 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:168: Error removing avatar: %s", _tmp2_);
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 802 "avatar-cache.c"
	}
	__finally3:
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	if (_inner_error_ != NULL) {
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
		return;
#line 813 "avatar-cache.c"
	}
#line 171 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 171 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp3_);
#line 819 "avatar-cache.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	__lambda3_ (self, source_object, res);
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 828 "avatar-cache.c"
}


void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
#line 158 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 158 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 160 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_remove_avatar (_tmp0_, _tmp1_, ___lambda3__gasync_ready_callback, g_object_ref (self));
#line 174 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 174 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 850 "avatar-cache.c"
}


static void __lambda2_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_) {
	GAsyncResult* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GMainLoop* _tmp2_;
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (_result_ != NULL);
#line 181 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _result_;
#line 181 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_test_utils_loadable_icons_content_equal_finish (_tmp0_);
#line 181 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (_tmp1_);
#line 182 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 182 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp2_);
#line 870 "avatar-cache.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	__lambda2_ (self, source_object, res);
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 879 "avatar-cache.c"
}


void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GMainLoop* _tmp2_;
#line 177 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 177 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (a != NULL);
#line 177 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (b != NULL);
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = a;
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = b;
#line 179 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	folks_test_utils_loadable_icons_content_equal (_tmp0_, _tmp1_, -1, ___lambda2__gasync_ready_callback, g_object_ref (self));
#line 185 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 185 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 903 "avatar-cache.c"
}


void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp2_;
#line 188 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 191 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-id", _tmp0_);
#line 194 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-id");
#line 194 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 197 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (avatar != NULL);
#line 198 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (G_IS_LOADABLE_ICON (avatar));
#line 199 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_avatar;
#line 199 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp2_, avatar);
#line 188 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 932 "avatar-cache.c"
}


void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_ = NULL;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp3_;
#line 202 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 205 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp0_);
#line 206 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = self->priv->_avatar;
#line 206 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp1_);
#line 209 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-ow-id");
#line 209 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp2_;
#line 212 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (avatar != NULL);
#line 213 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (G_IS_LOADABLE_ICON (avatar));
#line 214 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_avatar;
#line 214 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp3_, avatar);
#line 202 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 966 "avatar-cache.c"
}


void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* avatar;
#line 217 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-load-avatar-non-existent");
#line 220 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 221 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (avatar == NULL);
#line 217 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 983 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self) {
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_ = NULL;
	GLoadableIcon* _tmp4_;
#line 224 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = NULL;
#line 229 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 229 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-remove-avatar", _tmp0_);
#line 232 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 232 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 232 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 233 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 233 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (_tmp2_ != NULL);
#line 236 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar");
#line 239 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 239 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 239 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp3_;
#line 240 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = avatar;
#line 240 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (_tmp4_ == NULL);
#line 224 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1026 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_ = NULL;
	GLoadableIcon* avatar;
#line 243 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 246 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar-non-existent");
#line 246 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 247 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (avatar == NULL);
#line 250 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar-non-existent");
#line 243 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1045 "avatar-cache.c"
}


void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self) {
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
#line 253 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 256 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 256 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_avatar_cache_build_uri_for_avatar (_tmp0_, "test-id");
#line 256 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	uri = _tmp1_;
#line 257 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (uri != NULL);
#line 258 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = g_uri_parse_scheme (uri);
#line 258 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _tmp2_;
#line 258 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_assert (_tmp3_ != NULL);
#line 258 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp3_);
#line 253 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_free0 (uri);
#line 1075 "avatar-cache.c"
}


static void avatar_cache_tests_class_init (AvatarCacheTestsClass * klass) {
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_type_class_add_private (klass, sizeof (AvatarCacheTestsPrivate));
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (klass)->set_up = avatar_cache_tests_real_set_up;
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = avatar_cache_tests_real_tear_down;
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = avatar_cache_tests_finalize;
#line 1090 "avatar-cache.c"
}


static void avatar_cache_tests_instance_init (AvatarCacheTests * self) {
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self->priv = AVATAR_CACHE_TESTS_GET_PRIVATE (self);
#line 1097 "avatar-cache.c"
}


static void avatar_cache_tests_finalize (GObject* obj) {
	AvatarCacheTests * self;
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	self = AVATAR_CACHE_TESTS (obj);
#line 27 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 28 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 29 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 30 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 25 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (avatar_cache_tests_parent_class)->finalize (obj);
#line 1115 "avatar-cache.c"
}


GType avatar_cache_tests_get_type (void) {
	static volatile gsize avatar_cache_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_cache_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarCacheTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_cache_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarCacheTests), 0, (GInstanceInitFunc) avatar_cache_tests_instance_init, NULL };
		GType avatar_cache_tests_type_id;
		avatar_cache_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarCacheTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_cache_tests_type_id__volatile, avatar_cache_tests_type_id);
	}
	return avatar_cache_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AvatarCacheTests* _tmp1_;
	AvatarCacheTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
#line 264 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_test_init (&args_length1, &args, NULL);
#line 266 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = g_test_get_root ();
#line 266 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	root = _tmp0_;
#line 267 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = avatar_cache_tests_new ();
#line 267 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _tmp1_;
#line 267 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
#line 267 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_test_suite_add_suite (root, _tmp3_);
#line 267 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (_tmp2_);
#line 269 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_test_run ();
#line 271 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	result = 0;
#line 271 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return result;
#line 1160 "avatar-cache.c"
}


int main (int argc, char ** argv) {
#line 262 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	g_type_init ();
#line 262 "/home/treitter/collabora/folks/tests/folks/avatar-cache.vala"
	return _vala_main (argv, argc);
#line 1169 "avatar-cache.c"
}



