/* import.c generated by valac 0.13.3, the Vala compiler
 * generated from import.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <gee.h>


#define FOLKS_TYPE_IMPORT_TOOL (folks_import_tool_get_type ())
#define FOLKS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportTool))
#define FOLKS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))
#define FOLKS_IS_IMPORT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IS_IMPORT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORT_TOOL))
#define FOLKS_IMPORT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORT_TOOL, FolksImportToolClass))

typedef struct _FolksImportTool FolksImportTool;
typedef struct _FolksImportToolClass FolksImportToolClass;
typedef struct _FolksImportToolPrivate FolksImportToolPrivate;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;
typedef struct _FolksImportToolImportData FolksImportToolImportData;
typedef struct _FolksImporterPrivate FolksImporterPrivate;

struct _FolksImportTool {
	GObject parent_instance;
	FolksImportToolPrivate * priv;
};

struct _FolksImportToolClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* main_loop;
	gboolean success;
};

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()
struct _FolksImportToolImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean result;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* backend_store;
	FolksBackendStore* _tmp1_;
	GError* e1;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	FolksBackendStore* _tmp6_;
	FolksBackend* _tmp7_;
	FolksBackend* kf_backend;
	FolksBackend* _tmp8_;
	FILE* _tmp9_;
	const gchar* _tmp10_;
	FolksBackend* _tmp11_;
	GError* e2;
	FILE* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	FolksPersonaStore* destination_store;
	FolksBackend* _tmp16_;
	GeeMap* _tmp17_;
	GeeMap* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* stores;
	GeeCollection* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	FILE* _tmp24_;
	const gchar* _tmp25_;
	GeeCollection* _tmp26_;
	GeeIterator* _tmp27_;
	GeeIterator* _persona_store_it;
	GeeIterator* _tmp28_;
	gboolean _tmp29_;
	GeeIterator* _tmp30_;
	gpointer _tmp31_;
	FolksPersonaStore* persona_store;
	FolksPersonaStore* _tmp32_;
	FolksPersonaStore* _tmp33_;
	FolksPersonaStore* _tmp34_;
	GError* e3;
	FILE* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	FolksImportersPidgin* _tmp40_;
	FolksImporter* importer;
	FolksImporter* _tmp41_;
	FolksPersonaStore* _tmp42_;
	const gchar* _tmp43_;
	GError* e;
	FILE* _tmp44_;
	const gchar* _tmp45_;
	GError* _tmp46_;
	const gchar* _tmp47_;
	FolksPersonaStore* _tmp48_;
	FILE* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	GError * _inner_error_;
};

struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};


static gpointer folks_import_tool_parent_class = NULL;
static gchar* folks_import_tool_source;
static gchar* folks_import_tool_source = NULL;
static gchar* folks_import_tool_source_filename;
static gchar* folks_import_tool_source_filename = NULL;
static gpointer folks_importer_parent_class = NULL;

GType folks_import_tool_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_IMPORT_TOOL_DUMMY_PROPERTY
};
gint folks_import_tool_main (gchar** args, int args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void folks_import_tool_import (GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_import_tool_import_finish (GAsyncResult* _res_);
static void __lambda0_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void folks_import_tool_import_data_free (gpointer _data);
static gboolean folks_import_tool_import_co (FolksImportToolImportData* _data_);
static void folks_import_tool_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksImportersPidgin* folks_importers_pidgin_new (void);
FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
GType folks_importer_get_type (void) G_GNUC_CONST;
GType folks_importers_pidgin_get_type (void) G_GNUC_CONST;
void folks_importer_import (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_import_error_quark (void);
guint folks_importer_import_finish (FolksImporter* self, GAsyncResult* _res_, GError** error);
FolksImportTool* folks_import_tool_new (void);
FolksImportTool* folks_import_tool_construct (GType object_type);
static void folks_import_tool_finalize (GObject* obj);
enum  {
	FOLKS_IMPORTER_DUMMY_PROPERTY
};
FolksImporter* folks_importer_construct (GType object_type);

static const GOptionEntry FOLKS_IMPORT_TOOL_options[3] = {{"source", 's', 0, G_OPTION_ARG_STRING, &folks_import_tool_source, "Source backend name (default: 'pidgin')", "name"}, {"source-filename", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &folks_import_tool_source_filename, "Source filename (default: specific to source backend)", NULL}, {NULL}};

static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda0_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GMainLoop* _tmp2_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tmp1_ = folks_import_tool_import_finish (_tmp0_);
	_data1_->success = _tmp1_;
	_tmp2_ = _data1_->main_loop;
	g_main_loop_quit (_tmp2_);
}


static void ___lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda0_ (self, source_object, res);
	block1_data_unref (self);
}


gint folks_import_tool_main (gchar** args, int args_length1) {
	gint result = 0;
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* context;
	GOptionContext* _tmp2_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp13_;
	FolksIndividualAggregator* _tmp15_;
	FolksIndividualAggregator* aggregator;
	GMainLoop* _tmp16_;
	GMainLoop* _tmp17_;
	gint _tmp18_ = 0;
	gboolean _tmp19_;
	gint _tmp20_;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("— import meta-contact information to libfolks");
	_tmp1_ = g_option_context_new (_tmp0_);
	context = _tmp1_;
	_tmp2_ = context;
	g_option_context_add_main_entries (_tmp2_, FOLKS_IMPORT_TOOL_options, "folks");
	{
		GOptionContext* _tmp3_;
		_tmp3_ = context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = _ ("Couldn't parse command line options: %s\n");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp4_, _tmp5_, _tmp7_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = folks_import_tool_source;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = folks_import_tool_source;
		_tmp11_ = string_strip (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = g_strcmp0 (_tmp12_, "") == 0;
		_g_free0 (_tmp12_);
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("pidgin");
		_g_free0 (folks_import_tool_source);
		folks_import_tool_source = _tmp14_;
	}
	_tmp15_ = folks_individual_aggregator_new ();
	aggregator = _tmp15_;
	_g_object_unref0 (aggregator);
	aggregator = NULL;
	_tmp16_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp16_;
	_data1_->success = FALSE;
	folks_import_tool_import (___lambda0__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp17_ = _data1_->main_loop;
	g_main_loop_run (_tmp17_);
	_tmp19_ = _data1_->success;
	if (_tmp19_) {
		_tmp18_ = 0;
	} else {
		_tmp18_ = 1;
	}
	_tmp20_ = _tmp18_;
	result = _tmp20_;
	_g_object_unref0 (aggregator);
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return folks_import_tool_main (argv, argc);
}


static void folks_import_tool_import_data_free (gpointer _data) {
	FolksImportToolImportData* _data_;
	_data_ = _data;
	g_slice_free (FolksImportToolImportData, _data_);
}


static void folks_import_tool_import (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportToolImportData* _data_;
	_data_ = g_slice_new0 (FolksImportToolImportData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, folks_import_tool_import);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_import_tool_import_data_free);
	folks_import_tool_import_co (_data_);
}


static gboolean folks_import_tool_import_finish (GAsyncResult* _res_) {
	gboolean result;
	FolksImportToolImportData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void folks_import_tool_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportToolImportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_import_tool_import_co (_data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_import_tool_import_co (FolksImportToolImportData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_backend_store_dup ();
	_data_->backend_store = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->backend_store;
		_data_->_state_ = 1;
		folks_backend_store_load_backends (_data_->_tmp1_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_1:
		folks_backend_store_load_backends_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = stderr;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Couldn't load the backends: %s\n");
		_data_->_tmp4_ = _data_->e1;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		fprintf (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp5_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e1);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->backend_store;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = folks_backend_store_dup_backend_by_name (_data_->_tmp6_, "key-file");
	_data_->kf_backend = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->kf_backend;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp9_ = stderr;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("Couldn't load the 'key-file' backend.\n");
		fprintf (_data_->_tmp9_, "%s", _data_->_tmp10_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp11_ = _data_->kf_backend;
		_data_->_state_ = 2;
		folks_backend_prepare (_data_->_tmp11_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_2:
		folks_backend_prepare_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e2 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp12_ = stderr;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _ ("Couldn't prepare the 'key-file' backend: %s\n");
		_data_->_tmp14_ = _data_->e2;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		fprintf (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e2);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->destination_store = NULL;
	_data_->_tmp16_ = _data_->kf_backend;
	_data_->_tmp17_ = folks_backend_get_persona_stores (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = gee_map_get_values (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->stores = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->stores;
	_data_->_tmp22_ = gee_collection_get_size (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	if (_data_->_tmp23_ == 0) {
		_data_->_tmp24_ = stderr;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _ ("Couldn't load the 'key-file' backend's persona store.\n");
		fprintf (_data_->_tmp24_, "%s", _data_->_tmp25_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		{
			_data_->_tmp26_ = _data_->stores;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp26_);
			_data_->_persona_store_it = _data_->_tmp27_;
			while (TRUE) {
				_data_->_tmp28_ = _data_->_persona_store_it;
				_data_->_tmp29_ = FALSE;
				_data_->_tmp29_ = gee_iterator_next (_data_->_tmp28_);
				if (!_data_->_tmp29_) {
					break;
				}
				_data_->_tmp30_ = _data_->_persona_store_it;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = gee_iterator_get (_data_->_tmp30_);
				_data_->persona_store = (FolksPersonaStore*) _data_->_tmp31_;
				_data_->_tmp32_ = _data_->persona_store;
				_data_->_tmp33_ = _g_object_ref0 (_data_->_tmp32_);
				_g_object_unref0 (_data_->destination_store);
				_data_->destination_store = _data_->_tmp33_;
				_g_object_unref0 (_data_->persona_store);
				break;
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp34_ = _data_->destination_store;
		_data_->_state_ = 3;
		folks_persona_store_prepare (_data_->_tmp34_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_3:
		folks_persona_store_prepare_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e3 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = stderr;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _ ("Couldn't prepare the 'key-file' backend's persona store: %s\n");
		_data_->_tmp37_ = _data_->e3;
		_data_->_tmp38_ = _data_->_tmp37_->message;
		fprintf (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp38_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e3);
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp39_ = folks_import_tool_source;
	if (g_strcmp0 (_data_->_tmp39_, "pidgin") == 0) {
		_data_->_tmp40_ = folks_importers_pidgin_new ();
		_data_->importer = (FolksImporter*) _data_->_tmp40_;
		{
			_data_->_tmp41_ = _data_->importer;
			_data_->_tmp42_ = _data_->destination_store;
			_data_->_tmp43_ = folks_import_tool_source_filename;
			_data_->_state_ = 4;
			folks_importer_import (_data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_, folks_import_tool_import_ready, _data_);
			return FALSE;
			_state_4:
			folks_importer_import_finish (_data_->_tmp41_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
					goto __catch4_folks_import_error;
				}
				_g_object_unref0 (_data_->importer);
				_g_object_unref0 (_data_->stores);
				_g_object_unref0 (_data_->destination_store);
				_g_object_unref0 (_data_->kf_backend);
				_g_object_unref0 (_data_->backend_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally4;
		__catch4_folks_import_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp44_ = stderr;
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = _ ("Error importing personas: %s\n");
			_data_->_tmp46_ = _data_->e;
			_data_->_tmp47_ = _data_->_tmp46_->message;
			fprintf (_data_->_tmp44_, _data_->_tmp45_, _data_->_tmp47_);
			_data_->result = FALSE;
			_g_error_free0 (_data_->e);
			_g_object_unref0 (_data_->importer);
			_g_object_unref0 (_data_->stores);
			_g_object_unref0 (_data_->destination_store);
			_g_object_unref0 (_data_->kf_backend);
			_g_object_unref0 (_data_->backend_store);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally4:
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->importer);
			_g_object_unref0 (_data_->stores);
			_g_object_unref0 (_data_->destination_store);
			_g_object_unref0 (_data_->kf_backend);
			_g_object_unref0 (_data_->backend_store);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp48_ = _data_->destination_store;
		_data_->_state_ = 5;
		folks_persona_store_flush (_data_->_tmp48_, folks_import_tool_import_ready, _data_);
		return FALSE;
		_state_5:
		folks_persona_store_flush_finish (_data_->_tmp48_, _data_->_res_);
		_data_->result = TRUE;
		_g_object_unref0 (_data_->importer);
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp49_ = stderr;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = _ ("Unrecognised source backend name '%s'. 'pidgin' is currently the only " \
"supported source backend.\n");
		_data_->_tmp51_ = folks_import_tool_source;
		fprintf (_data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_);
		_data_->result = FALSE;
		_g_object_unref0 (_data_->stores);
		_g_object_unref0 (_data_->destination_store);
		_g_object_unref0 (_data_->kf_backend);
		_g_object_unref0 (_data_->backend_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->stores);
	_g_object_unref0 (_data_->destination_store);
	_g_object_unref0 (_data_->kf_backend);
	_g_object_unref0 (_data_->backend_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


FolksImportTool* folks_import_tool_construct (GType object_type) {
	FolksImportTool * self = NULL;
	self = (FolksImportTool*) g_object_new (object_type, NULL);
	return self;
}


FolksImportTool* folks_import_tool_new (void) {
	return folks_import_tool_construct (FOLKS_TYPE_IMPORT_TOOL);
}


static void folks_import_tool_class_init (FolksImportToolClass * klass) {
	folks_import_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = folks_import_tool_finalize;
}


static void folks_import_tool_instance_init (FolksImportTool * self) {
}


static void folks_import_tool_finalize (GObject* obj) {
	FolksImportTool * self;
	self = FOLKS_IMPORT_TOOL (obj);
	G_OBJECT_CLASS (folks_import_tool_parent_class)->finalize (obj);
}


GType folks_import_tool_get_type (void) {
	static volatile gsize folks_import_tool_type_id__volatile = 0;
	if (g_once_init_enter (&folks_import_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImportToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_import_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportTool), 0, (GInstanceInitFunc) folks_import_tool_instance_init, NULL };
		GType folks_import_tool_type_id;
		folks_import_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImportTool", &g_define_type_info, 0);
		g_once_init_leave (&folks_import_tool_type_id__volatile, folks_import_tool_type_id);
	}
	return folks_import_tool_type_id__volatile;
}


GQuark folks_import_error_quark (void) {
	return g_quark_from_static_string ("folks_import_error-quark");
}


void folks_importer_import (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_IMPORTER_GET_CLASS (self)->import (self, destination_store, source_filename, _callback_, _user_data_);
}


guint folks_importer_import_finish (FolksImporter* self, GAsyncResult* _res_, GError** error) {
	return FOLKS_IMPORTER_GET_CLASS (self)->import_finish (self, _res_, error);
}


FolksImporter* folks_importer_construct (GType object_type) {
	FolksImporter * self = NULL;
	self = (FolksImporter*) g_object_new (object_type, NULL);
	return self;
}


static void folks_importer_class_init (FolksImporterClass * klass) {
	folks_importer_parent_class = g_type_class_peek_parent (klass);
}


static void folks_importer_instance_init (FolksImporter * self) {
}


GType folks_importer_get_type (void) {
	static volatile gsize folks_importer_type_id__volatile = 0;
	if (g_once_init_enter (&folks_importer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImporter), 0, (GInstanceInitFunc) folks_importer_instance_init, NULL };
		GType folks_importer_type_id;
		folks_importer_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksImporter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_importer_type_id__volatile, folks_importer_type_id);
	}
	return folks_importer_type_id__volatile;
}



