/* persona.c generated by valac 0.11.2.25-30b2-dirty, the Vala compiler
 * generated from persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksPersonaPrivate FolksPersonaPrivate;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
struct _FolksPersona {
	GObject parent_instance;
	FolksPersonaPrivate * priv;
};

struct _FolksPersonaClass {
	GObjectClass parent_class;
	void (*linkable_property_to_links) (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
	gchar** (*get_linkable_properties) (FolksPersona* self, int* result_length1);
};

struct _FolksPersonaPrivate {
	gchar* _iid;
	gchar* _uid;
	gchar* _display_id;
	gboolean _is_user;
	FolksPersonaStore* _store;
};


static gpointer folks_persona_parent_class = NULL;

GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_PERSONA, FolksPersonaPrivate))
enum  {
	FOLKS_PERSONA_DUMMY_PROPERTY,
	FOLKS_PERSONA_IID,
	FOLKS_PERSONA_UID,
	FOLKS_PERSONA_DISPLAY_ID,
	FOLKS_PERSONA_IS_USER,
	FOLKS_PERSONA_STORE,
	FOLKS_PERSONA_LINKABLE_PROPERTIES
};
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void folks_persona_real_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static gchar* folks_persona_escape_uid_component (const gchar* component);
static gchar* folks_persona_unescape_uid_component (const gchar* component);
gchar* folks_persona_build_uid (const gchar* backend_name, const gchar* persona_store_id, const gchar* persona_id);
void folks_persona_split_uid (const gchar* uid, gchar** backend_name, gchar** persona_store_id, gchar** persona_id);
FolksPersona* folks_persona_construct (GType object_type);
const gchar* folks_persona_get_iid (FolksPersona* self);
static void folks_persona_set_iid (FolksPersona* self, const gchar* value);
const gchar* folks_persona_get_uid (FolksPersona* self);
static void folks_persona_set_uid (FolksPersona* self, const gchar* value);
const gchar* folks_persona_get_display_id (FolksPersona* self);
static void folks_persona_set_display_id (FolksPersona* self, const gchar* value);
gboolean folks_persona_get_is_user (FolksPersona* self);
static void folks_persona_set_is_user (FolksPersona* self, gboolean value);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
static void folks_persona_set_store (FolksPersona* self, FolksPersonaStore* value);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static void folks_persona_finalize (GObject* obj);
static void _vala_folks_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
   * Produce one or more mapping strings for the given property's value.
   *
   * This is a virtual method, to be overridden by subclasses of {@link Persona}
   * who have linkable properties. Each of their linkable properties should be
   * handled by their implementation of this function, examining the current
   * value of the property and calling `callback` with one or more mapping
   * strings for the property's value. Each of these mapping strings will be
   * added to the {@link IndividualAggregator}'s link map, related to the
   * {@link Individual} instance which contains this {@link Persona}.
   *
   * @param prop_name the name of the linkable property to use, which must be
   * listed in {@link Persona.linkable_properties}
   * @param callback a callback to execute for each of the mapping strings
   * generated by this property
   * @see Persona.linkable_properties
   * @since 0.1.13
   */
static void folks_persona_real_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	g_assert_not_reached ();
}


void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FOLKS_PERSONA_GET_CLASS (self)->linkable_property_to_links (self, prop_name, callback, callback_target);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch11_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch11_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* folks_persona_escape_uid_component (const gchar* component) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* escaped;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (component != NULL, NULL);
	_tmp0_ = string_replace (component, "\\", "\\\\");
	escaped = _tmp0_;
	_tmp1_ = string_replace (escaped, ":", "\\:");
	result = _tmp1_;
	_g_free0 (escaped);
	return result;
}


static gchar* folks_persona_unescape_uid_component (const gchar* component) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* unescaped;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (component != NULL, NULL);
	_tmp0_ = string_replace (component, "\\:", ":");
	unescaped = _tmp0_;
	_tmp1_ = string_replace (unescaped, "\\", "\\\\");
	result = _tmp1_;
	_g_free0 (unescaped);
	return result;
}


/**
   * Build a UID from the given components.
   *
   * Each component is escaped before the UID is built.
   *
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @return a valid UID
   * @see Persona.split_uid
   * @since 0.1.13
   */
gchar* folks_persona_build_uid (const gchar* backend_name, const gchar* persona_store_id, const gchar* persona_id) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_val_if_fail (backend_name != NULL, NULL);
	g_return_val_if_fail (persona_store_id != NULL, NULL);
	g_return_val_if_fail (persona_id != NULL, NULL);
	_tmp0_ = folks_persona_escape_uid_component (backend_name);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_escape_uid_component (persona_store_id);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_escape_uid_component (persona_id);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s:%s:%s", _tmp1_, _tmp3_, _tmp5_);
	result = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _g_free0 (_tmp3_), _g_free0 (_tmp1_), _tmp7_);
	return result;
}


/**
   * Split a UID into its component parts.
   *
   * Each component is unescaped before being returned. The UID //must// be
   * correctly formed.
   *
   * @param uid a valid UID
   * @param backend_name the {@link Backend.name}
   * @param persona_store_id the {@link PersonaStore.id}
   * @param persona_id the Persona identifier (backend-specific)
   * @see Persona.build_uid
   * @since 0.1.13
   */
static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


void folks_persona_split_uid (const gchar* uid, gchar** backend_name, gchar** persona_store_id, gchar** persona_id) {
	gchar* _backend_name = NULL;
	gchar* _persona_store_id = NULL;
	gchar* _persona_id = NULL;
	gboolean _tmp0_;
	gsize backend_name_length;
	gsize persona_store_id_length;
	gboolean escaped;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	g_return_if_fail (uid != NULL);
	_tmp0_ = g_utf8_validate (uid, (gssize) (-1), NULL);
	g_assert (_tmp0_);
	backend_name_length = (gsize) 0;
	persona_store_id_length = (gsize) 0;
	escaped = FALSE;
	{
		const gchar* i;
		i = uid;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gunichar _tmp3_;
				gunichar _tmp4_;
				if (!_tmp1_) {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = g_utf8_next_char (i);
					i = _tmp2_;
				}
				_tmp1_ = FALSE;
				_tmp3_ = string_get_char (i, 0);
				if (!(_tmp3_ != '\0')) {
					break;
				}
				_tmp4_ = string_get_char (i, 0);
				if (_tmp4_ == '\\') {
					escaped = !escaped;
				} else {
					gboolean _tmp5_ = FALSE;
					if (escaped == FALSE) {
						gunichar _tmp6_;
						_tmp6_ = string_get_char (i, 0);
						_tmp5_ = _tmp6_ == ':';
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						if (backend_name_length == 0) {
							backend_name_length = ((gchar*) i) - ((gchar*) uid);
						} else {
							persona_store_id_length = ((((gchar*) i) - ((gchar*) uid)) - backend_name_length) - 1;
						}
					}
				}
			}
		}
	}
	if (backend_name_length != 0) {
		_tmp7_ = persona_store_id_length != 0;
	} else {
		_tmp7_ = FALSE;
	}
	g_assert (_tmp7_);
	_tmp8_ = g_strndup (uid, backend_name_length);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_persona_unescape_uid_component (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_backend_name);
	_backend_name = _tmp11_;
	_g_free0 (_tmp9_);
	_tmp12_ = g_strndup ((const gchar*) ((((gchar*) uid) + backend_name_length) + 1), persona_store_id_length);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_persona_unescape_uid_component (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_persona_store_id);
	_persona_store_id = _tmp15_;
	_g_free0 (_tmp13_);
	_tmp16_ = folks_persona_unescape_uid_component ((const gchar*) (((((gchar*) uid) + backend_name_length) + persona_store_id_length) + 2));
	_tmp17_ = _tmp16_;
	_g_free0 (_persona_id);
	_persona_id = _tmp17_;
	if (backend_name) {
		*backend_name = _backend_name;
	} else {
		_g_free0 (_backend_name);
	}
	if (persona_store_id) {
		*persona_store_id = _persona_store_id;
	} else {
		_g_free0 (_persona_store_id);
	}
	if (persona_id) {
		*persona_id = _persona_id;
	} else {
		_g_free0 (_persona_id);
	}
}


FolksPersona* folks_persona_construct (GType object_type) {
	FolksPersona * self = NULL;
	self = (FolksPersona*) g_object_new (object_type, NULL);
	return self;
}


const gchar* folks_persona_get_iid (FolksPersona* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_iid;
	return result;
}


static void folks_persona_set_iid (FolksPersona* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_iid);
	self->priv->_iid = _tmp1_;
	g_object_notify ((GObject *) self, "iid");
}


const gchar* folks_persona_get_uid (FolksPersona* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uid;
	return result;
}


static void folks_persona_set_uid (FolksPersona* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp1_;
	g_object_notify ((GObject *) self, "uid");
}


const gchar* folks_persona_get_display_id (FolksPersona* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_id;
	return result;
}


static void folks_persona_set_display_id (FolksPersona* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_display_id);
	self->priv->_display_id = _tmp1_;
	g_object_notify ((GObject *) self, "display-id");
}


gboolean folks_persona_get_is_user (FolksPersona* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_user;
	return result;
}


static void folks_persona_set_is_user (FolksPersona* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_user = value;
	g_object_notify ((GObject *) self, "is-user");
}


FolksPersonaStore* folks_persona_get_store (FolksPersona* self) {
	FolksPersonaStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_store;
	return result;
}


static void folks_persona_set_store (FolksPersona* self, FolksPersonaStore* value) {
	g_return_if_fail (self != NULL);
	self->priv->_store = value;
	g_object_notify ((GObject *) self, "store");
}


gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1) {
	return FOLKS_PERSONA_GET_CLASS (self)->get_linkable_properties (self, result_length1);
}


static void folks_persona_class_init (FolksPersonaClass * klass) {
	folks_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_persona_real_linkable_property_to_links;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_finalize;
	/**
	   * The internal ID used to represent the Persona for linking.
	   *
	   * This is opaque, and shouldn't be parsed or considered meaningful by
	   * clients.
	   *
	   * The internal ID should be unique within a backend, but may not be unique
	   * across backends, so that links can be made between Personas with similar
	   * internal IDs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_IID, g_param_spec_string ("iid", "iid", "iid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The universal ID used to represent the Persona outside its {@link Backend}.
	   *
	   * This is opaque, and should only be parsed by clients using
	   * {@link Persona.split_uid}.
	   *
	   * This is the canonical way to refer to any Persona. It is guaranteed to be
	   * unique within the Persona's {@link PersonaStore}.
	   *
	   * @see Persona.build_uid
	   * @see Persona.split_uid
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The human-readable, service-specific universal ID used to represent the
	   * Persona.
	   *
	   * For example: `foo@@xmpp.example.org`.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific ID. For instance, in a prompt for the user to
	   * select a specific IM contact within an {@link Individual} to begin a chat
	   * with.
	   *
	   * This is not guaranteed to be unique outside of the Persona's
	   * {@link PersonaStore}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_DISPLAY_ID, g_param_spec_string ("display-id", "display-id", "display-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * Whether the Persona is the user.
	   *
	   * Iff the Persona represents the user (the person who owns the account in
	   * the respective backend) this is `true`.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_IS_USER, g_param_spec_boolean ("is-user", "is-user", "is-user", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link PersonaStore} which contains this Persona.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE, g_param_spec_object ("store", "store", "store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The names of the properties of this Persona which are linkable.
	   *
	   * If a property name is in this list, and the Persona is from a
	   * {@link PersonaStore} whose trust level is {@link PersonaStoreTrust.FULL},
	   * the {@link IndividualAggregator} should be able to reliably use the value
	   * of the property from a given Persona instance to link the Persona with
	   * other Personas and form {@link Individual}s.
	   *
	   * Note that {@link Persona.uid} is always implicitly a member of this list,
	   * and doesn't need to be added explicitly.
	   *
	   * This list will have no effect if the Persona's {@link PersonaStore} trust
	   * level is not {@link PersonaStoreTrust.FULL}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_persona_instance_init (FolksPersona * self) {
	self->priv = FOLKS_PERSONA_GET_PRIVATE (self);
}


static void folks_persona_finalize (GObject* obj) {
	FolksPersona * self;
	self = FOLKS_PERSONA (obj);
	_g_free0 (self->priv->_iid);
	_g_free0 (self->priv->_uid);
	_g_free0 (self->priv->_display_id);
	G_OBJECT_CLASS (folks_persona_parent_class)->finalize (obj);
}


/**
 * Represents a "shard" of a person from a single source (a single
 * {@link Backend}), such as an XMPP contact from Telepathy or a vCard contact
 * from evolution-data-server.
 *
 * All the personas belonging to one physical person are aggregated to form a
 * single {@link Individual} representing that person.
 */
GType folks_persona_get_type (void) {
	static volatile gsize folks_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersona), 0, (GInstanceInitFunc) folks_persona_instance_init, NULL };
		GType folks_persona_type_id;
		folks_persona_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersona", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_persona_type_id__volatile, folks_persona_type_id);
	}
	return folks_persona_type_id__volatile;
}


static void _vala_folks_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPersona * self;
	self = FOLKS_PERSONA (object);
	switch (property_id) {
		case FOLKS_PERSONA_IID:
		g_value_set_string (value, folks_persona_get_iid (self));
		break;
		case FOLKS_PERSONA_UID:
		g_value_set_string (value, folks_persona_get_uid (self));
		break;
		case FOLKS_PERSONA_DISPLAY_ID:
		g_value_set_string (value, folks_persona_get_display_id (self));
		break;
		case FOLKS_PERSONA_IS_USER:
		g_value_set_boolean (value, folks_persona_get_is_user (self));
		break;
		case FOLKS_PERSONA_STORE:
		g_value_set_object (value, folks_persona_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPersona * self;
	self = FOLKS_PERSONA (object);
	switch (property_id) {
		case FOLKS_PERSONA_IID:
		folks_persona_set_iid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_UID:
		folks_persona_set_uid (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_DISPLAY_ID:
		folks_persona_set_display_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_IS_USER:
		folks_persona_set_is_user (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE:
		folks_persona_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



