/* individual.c generated by valac 0.11.2.11-bbde6, the Vala compiler
 * generated from individual.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_ALIASABLE (folks_aliasable_get_type ())
#define FOLKS_ALIASABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIASABLE, FolksAliasable))
#define FOLKS_IS_ALIASABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIASABLE))
#define FOLKS_ALIASABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIASABLE, FolksAliasableIface))

typedef struct _FolksAliasable FolksAliasable;
typedef struct _FolksAliasableIface FolksAliasableIface;

#define FOLKS_TYPE_AVATAR (folks_avatar_get_type ())
#define FOLKS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_AVATAR, FolksAvatar))
#define FOLKS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_AVATAR))
#define FOLKS_AVATAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_AVATAR, FolksAvatarIface))

typedef struct _FolksAvatar FolksAvatar;
typedef struct _FolksAvatarIface FolksAvatarIface;

#define FOLKS_TYPE_FAVOURITE (folks_favourite_get_type ())
#define FOLKS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FAVOURITE, FolksFavourite))
#define FOLKS_IS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FAVOURITE))
#define FOLKS_FAVOURITE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_FAVOURITE, FolksFavouriteIface))

typedef struct _FolksFavourite FolksFavourite;
typedef struct _FolksFavouriteIface FolksFavouriteIface;

#define FOLKS_TYPE_GROUPABLE (folks_groupable_get_type ())
#define FOLKS_GROUPABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GROUPABLE, FolksGroupable))
#define FOLKS_IS_GROUPABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GROUPABLE))
#define FOLKS_GROUPABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GROUPABLE, FolksGroupableIface))

typedef struct _FolksGroupable FolksGroupable;
typedef struct _FolksGroupableIface FolksGroupableIface;

#define FOLKS_TYPE_IMABLE (folks_imable_get_type ())
#define FOLKS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMABLE, FolksIMable))
#define FOLKS_IS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMABLE))
#define FOLKS_IMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IMABLE, FolksIMableIface))

typedef struct _FolksIMable FolksIMable;
typedef struct _FolksIMableIface FolksIMableIface;

#define FOLKS_TYPE_PRESENCE (folks_presence_get_type ())
#define FOLKS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PRESENCE, FolksPresence))
#define FOLKS_IS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PRESENCE))
#define FOLKS_PRESENCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PRESENCE, FolksPresenceIface))

typedef struct _FolksPresence FolksPresence;
typedef struct _FolksPresenceIface FolksPresenceIface;

#define FOLKS_TYPE_PRESENCE_TYPE (folks_presence_type_get_type ())

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
typedef struct _FolksIndividualPrivate FolksIndividualPrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _FolksIndividualChangeGroupData FolksIndividualChangeGroupData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define FOLKS_GROUPABLE_TYPE_CHANGE_REASON (folks_groupable_change_reason_get_type ())
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())
typedef struct _Block7Data Block7Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _FolksAliasableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_alias) (FolksAliasable* self);
	void (*set_alias) (FolksAliasable* self, const gchar* value);
};

struct _FolksAvatarIface {
	GTypeInterface parent_iface;
	GFile* (*get_avatar) (FolksAvatar* self);
	void (*set_avatar) (FolksAvatar* self, GFile* value);
};

struct _FolksFavouriteIface {
	GTypeInterface parent_iface;
	gboolean (*get_is_favourite) (FolksFavourite* self);
	void (*set_is_favourite) (FolksFavourite* self, gboolean value);
};

struct _FolksGroupableIface {
	GTypeInterface parent_iface;
	void (*change_group) (FolksGroupable* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_group_finish) (FolksGroupable* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_groups) (FolksGroupable* self);
	void (*set_groups) (FolksGroupable* self, GHashTable* value);
};

struct _FolksIMableIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksIMable* self);
	void (*set_im_addresses) (FolksIMable* self, GHashTable* value);
};

typedef enum  {
	FOLKS_PRESENCE_TYPE_UNSET,
	FOLKS_PRESENCE_TYPE_OFFLINE,
	FOLKS_PRESENCE_TYPE_AVAILABLE,
	FOLKS_PRESENCE_TYPE_AWAY,
	FOLKS_PRESENCE_TYPE_EXTENDED_AWAY,
	FOLKS_PRESENCE_TYPE_HIDDEN,
	FOLKS_PRESENCE_TYPE_BUSY,
	FOLKS_PRESENCE_TYPE_UNKNOWN,
	FOLKS_PRESENCE_TYPE_ERROR
} FolksPresenceType;

struct _FolksPresenceIface {
	GTypeInterface parent_iface;
	FolksPresenceType (*get_presence_type) (FolksPresence* self);
	void (*set_presence_type) (FolksPresence* self, FolksPresenceType value);
	const gchar* (*get_presence_message) (FolksPresence* self);
	void (*set_presence_message) (FolksPresence* self, const gchar* value);
};

struct _FolksIndividual {
	GObject parent_instance;
	FolksIndividualPrivate * priv;
};

struct _FolksIndividualClass {
	GObjectClass parent_class;
};

struct _FolksIndividualPrivate {
	gboolean _is_favourite;
	gchar* _alias;
	GHashTable* _groups;
	GList* _persona_list;
	GeeHashSet* _persona_set;
	GeeHashMap* stores;
	guint persona_user_count;
	GHashTable* _im_addresses;
	FolksTrustLevel _trust_level;
	GFile* _avatar;
	FolksPresenceType _presence_type;
	gchar* _presence_message;
	gboolean _is_user;
	gchar* _id;
};

struct _Block1Data {
	int _ref_count_;
	FolksIndividual * self;
	gchar* group;
	gboolean is_member;
	gpointer _async_data_;
};

struct _FolksIndividualChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividual* self;
	gchar* group;
	gboolean is_member;
	Block1Data* _data1_;
};

typedef enum  {
	FOLKS_GROUPABLE_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPABLE_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPABLE_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPABLE_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPABLE_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPABLE_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPABLE_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED = 11
} FolksGroupableChangeReason;

struct _Block2Data {
	int _ref_count_;
	FolksIndividual * self;
	GList* removed_personas;
};

struct _Block3Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* new_groups;
	GList* removes;
};

struct _Block4Data {
	int _ref_count_;
	FolksIndividual * self;
	gchar* presence_message;
	FolksPresenceType presence_type;
};

struct _Block5Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean favourite;
};

struct _Block6Data {
	int _ref_count_;
	FolksIndividual * self;
	GFile* avatar;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

struct _Block7Data {
	int _ref_count_;
	FolksIndividual * self;
	GeeHashSet* address_set;
};

struct _Block8Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean alias_changed;
	gchar* value;
};

struct _Block9Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean value;
};

struct _Block10Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* value;
};


static gpointer folks_individual_parent_class = NULL;
static FolksAliasableIface* folks_individual_folks_aliasable_parent_iface = NULL;
static FolksAvatarIface* folks_individual_folks_avatar_parent_iface = NULL;
static FolksFavouriteIface* folks_individual_folks_favourite_parent_iface = NULL;
static FolksGroupableIface* folks_individual_folks_groupable_parent_iface = NULL;
static FolksIMableIface* folks_individual_folks_imable_parent_iface = NULL;
static FolksPresenceIface* folks_individual_folks_presence_parent_iface = NULL;

GType folks_trust_level_get_type (void) G_GNUC_CONST;
GType folks_aliasable_get_type (void) G_GNUC_CONST;
GType folks_avatar_get_type (void) G_GNUC_CONST;
GType folks_favourite_get_type (void) G_GNUC_CONST;
GType folks_groupable_get_type (void) G_GNUC_CONST;
GType folks_imable_get_type (void) G_GNUC_CONST;
GType folks_presence_type_get_type (void) G_GNUC_CONST;
GType folks_presence_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL, FolksIndividualPrivate))
enum  {
	FOLKS_INDIVIDUAL_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_TRUST_LEVEL,
	FOLKS_INDIVIDUAL_AVATAR,
	FOLKS_INDIVIDUAL_PRESENCE_TYPE,
	FOLKS_INDIVIDUAL_PRESENCE_MESSAGE,
	FOLKS_INDIVIDUAL_IS_USER,
	FOLKS_INDIVIDUAL_ID,
	FOLKS_INDIVIDUAL_ALIAS,
	FOLKS_INDIVIDUAL_IS_FAVOURITE,
	FOLKS_INDIVIDUAL_GROUPS,
	FOLKS_INDIVIDUAL_IM_ADDRESSES,
	FOLKS_INDIVIDUAL_PERSONAS
};
static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_alias (FolksIndividual* self);
static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_avatar (FolksIndividual* self);
static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const gchar* group, gboolean is_member);
static void folks_individual_update_groups (FolksIndividual* self);
static void folks_individual_real_change_group_data_free (gpointer _data);
static void folks_individual_real_change_group (FolksGroupable* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_individual_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean folks_individual_real_change_group_co (FolksIndividualChangeGroupData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda8_ (FolksPersona* p, Block1Data* _data1_);
void folks_groupable_change_group (FolksGroupable* self, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_groupable_change_group_finish (FolksGroupable* self, GAsyncResult* _res_, GError** error);
static void __lambda8__gfunc (gconstpointer data, gpointer self);
static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_presence (FolksIndividual* self);
static void folks_individual_notify_im_addresses_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_im_addresses (FolksIndividual* self);
static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_is_favourite (FolksIndividual* self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
static void _g_free0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void folks_individual_update_fields (FolksIndividual* self);
GType folks_groupable_change_reason_get_type (void) G_GNUC_CONST;
static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda11_ (FolksPersona* data, Block2Data* _data2_);
static void __lambda11__gfunc (gconstpointer data, gpointer self);
static void folks_individual_update_trust_level (FolksIndividual* self);
static void _g_list_free__g_free0_ (GList* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda2_ (FolksPersona* p, Block3Data* _data3_);
GHashTable* folks_groupable_get_groups (FolksGroupable* self);
static void _lambda3_ (const gchar* k, gboolean v, Block3Data* _data3_);
static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __lambda2__gfunc (gconstpointer data, gpointer self);
static void _lambda4_ (const gchar* k, gboolean v, FolksIndividual* self);
static void _lambda5_ (const gchar* k, gboolean v, FolksIndividual* self);
static void __lambda5__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void _lambda6_ (const gchar* k, gboolean v, Block3Data* _data3_);
static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void _lambda7_ (const gchar* l, FolksIndividual* self);
static void __lambda7__gfunc (gconstpointer data, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda9_ (FolksPersona* p, Block4Data* _data4_);
gint folks_presence_typecmp (FolksPresenceType type_a, FolksPresenceType type_b);
FolksPresenceType folks_presence_get_presence_type (FolksPresence* self);
const gchar* folks_presence_get_presence_message (FolksPresence* self);
static void __lambda9__gfunc (gconstpointer data, gpointer self);
void folks_presence_set_presence_message (FolksPresence* self, const gchar* value);
void folks_presence_set_presence_type (FolksPresence* self, FolksPresenceType value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
const gchar* folks_individual_get_id (FolksIndividual* self);
static void _lambda10_ (FolksPersona* p, Block5Data* _data5_);
gboolean folks_favourite_get_is_favourite (FolksFavourite* self);
static void __lambda10__gfunc (gconstpointer data, gpointer self);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
const gchar* folks_aliasable_get_alias (FolksAliasable* self);
const gchar* folks_persona_get_display_id (FolksPersona* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda1_ (FolksPersona* p, Block6Data* _data6_);
GFile* folks_avatar_get_avatar (FolksAvatar* self);
static void __lambda1__gfunc (gconstpointer data, gpointer self);
void folks_avatar_set_avatar (FolksAvatar* self, GFile* value);
gboolean folks_persona_get_is_user (FolksPersona* self);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
static void folks_individual_set_trust_level (FolksIndividual* self, FolksTrustLevel value);
GList* folks_individual_get_personas (FolksIndividual* self);
GHashTable* folks_imable_get_im_addresses (FolksIMable* self);
static void _lambda12_ (const gchar* k, GPtrArray* v, FolksIndividual* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda13_ (const gchar* old_address, Block7Data* _data7_);
static void __lambda13__gfunc (gconstpointer data, gpointer self);
static void _lambda14_ (const gchar* cur_address, Block7Data* _data7_);
static void __lambda14__gfunc (gconstpointer data, gpointer self);
static void __lambda12__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_connect_to_persona (FolksIndividual* self, FolksPersona* persona);
static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_im_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_persona_group_changed_cb_folks_groupable_group_changed (FolksGroupable* _sender, const gchar* group, gboolean is_member, gpointer self);
static void folks_individual_disconnect_from_persona (FolksIndividual* self, FolksPersona* persona);
static void _folks_individual_set_personas (FolksIndividual* self, GList* persona_list, FolksIndividual* replacement_individual);
static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason, gpointer self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
static void folks_individual_set_is_user (FolksIndividual* self, gboolean value);
const gchar* folks_persona_get_uid (FolksPersona* self);
static void folks_individual_set_id (FolksIndividual* self, const gchar* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda15_ (FolksPersona* p, Block8Data* _data8_);
void folks_aliasable_set_alias (FolksAliasable* self, const gchar* value);
static void __lambda15__gfunc (gconstpointer data, gpointer self);
static void _lambda16_ (FolksPersona* p, Block8Data* _data8_);
static void __lambda16__gfunc (gconstpointer data, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void _lambda17_ (FolksPersona* p, Block9Data* _data9_);
void folks_favourite_set_is_favourite (FolksFavourite* self, gboolean value);
static void __lambda17__gfunc (gconstpointer data, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda18_ (FolksPersona* p, Block10Data* _data10_);
void folks_groupable_set_groups (FolksGroupable* self, GHashTable* value);
static void __lambda18__gfunc (gconstpointer data, gpointer self);
static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_individual_finalize (GObject* obj);
static void _vala_folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void folks_imable_set_im_addresses (FolksIMable* self, GHashTable* value);
static void _vala_folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Trust level for an {@link Individual} for use in the UI.
 *
 * @since 0.1.15
 */
GType folks_trust_level_get_type (void) {
	static volatile gsize folks_trust_level_type_id__volatile = 0;
	if (g_once_init_enter (&folks_trust_level_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_TRUST_LEVEL_NONE, "FOLKS_TRUST_LEVEL_NONE", "none"}, {FOLKS_TRUST_LEVEL_PERSONAS, "FOLKS_TRUST_LEVEL_PERSONAS", "personas"}, {0, NULL, NULL}};
		GType folks_trust_level_type_id;
		folks_trust_level_type_id = g_enum_register_static ("FolksTrustLevel", values);
		g_once_init_leave (&folks_trust_level_type_id__volatile, folks_trust_level_type_id);
	}
	return folks_trust_level_type_id__volatile;
}


static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_alias (self);
}


static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_avatar (self);
}


static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const gchar* group, gboolean is_member) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	folks_individual_update_groups (self);
}


static void folks_individual_real_change_group_data_free (gpointer _data) {
	FolksIndividualChangeGroupData* data;
	data = _data;
	_g_free0 (data->group);
	_g_object_unref0 (data->self);
	g_slice_free (FolksIndividualChangeGroupData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_individual_real_change_group (FolksGroupable* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividual * self;
	FolksIndividualChangeGroupData* _data_;
	self = (FolksIndividual*) base;
	_data_ = g_slice_new0 (FolksIndividualChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_real_change_group_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->group = g_strdup (group);
	_data_->is_member = is_member;
	folks_individual_real_change_group_co (_data_);
}


static void folks_individual_real_change_group_finish (FolksGroupable* base, GAsyncResult* _res_, GError** error) {
	FolksIndividualChangeGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_individual_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualChangeGroupData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_individual_real_change_group_co (data);
}


/**
   * Add or remove the Individual from the specified group.
   *
   * If `is_member` is `true`, the Individual will be added to the `group`. If
   * it is `false`, they will be removed from the `group`.
   *
   * The group membership change will propagate to every {@link Persona} in
   * the Individual.
   *
   * @param group a freeform group identifier
   * @param is_member whether the Individual should be a member of the group
   * @since 0.1.11
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->group);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda8_ (FolksPersona* p, Block1Data* _data1_) {
	FolksIndividual * self;
	self = _data1_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_GROUPABLE (p)) {
		folks_groupable_change_group (FOLKS_GROUPABLE (p), _data1_->group, _data1_->is_member, NULL, NULL);
	}
}


static void __lambda8__gfunc (gconstpointer data, gpointer self) {
	_lambda8_ (data, self);
}


static gboolean folks_individual_real_change_group_co (FolksIndividualChangeGroupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->group = g_strdup (data->group);
	data->_data1_->is_member = data->is_member;
	data->_data1_->_async_data_ = data;
	g_list_foreach (data->self->priv->_persona_list, __lambda8__gfunc, data->_data1_);
	block1_data_unref (data->_data1_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_presence (self);
}


static void folks_individual_notify_im_addresses_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_im_addresses (self);
}


static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_is_favourite (self);
}


/**
   * Create a new Individual.
   *
   * The Individual can optionally be seeded with the {@link Persona}s in
   * `personas`. Otherwise, it will have to have personas added using the
   * {@link Folks.Individual.personas} property after construction.
   *
   * @param personas a list of {@link Persona}s to initialise the
   * {@link Individual} with, or `null`
   * @return a new Individual
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


FolksIndividual* folks_individual_construct (GType object_type, GList* personas) {
	FolksIndividual * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* _tmp3_;
	GeeHashMap* _tmp4_ = NULL;
	GeeHashMap* _tmp5_;
	self = (FolksIndividual*) g_object_new (object_type, NULL);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_ptr_array_unref0_);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_set);
	self->priv->_persona_set = _tmp3_;
	_tmp4_ = gee_hash_map_new (FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->stores);
	self->priv->stores = _tmp5_;
	folks_individual_set_personas (self, personas);
	return self;
}


FolksIndividual* folks_individual_new (GList* personas) {
	return folks_individual_construct (FOLKS_TYPE_INDIVIDUAL, personas);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store) {
	GList* removed_personas;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* iter;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	removed_personas = NULL;
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_persona_set);
	iter = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		FolksPersona* persona;
		FolksPersona* _tmp3_;
		_tmp1_ = gee_iterator_next (iter);
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = gee_iterator_get (iter);
		persona = (FolksPersona*) _tmp2_;
		_tmp3_ = _g_object_ref0 (persona);
		removed_personas = g_list_prepend (removed_personas, _tmp3_);
		self->priv->_persona_list = g_list_remove (self->priv->_persona_list, persona);
		gee_iterator_remove (iter);
		_g_object_unref0 (persona);
	}
	if (removed_personas != NULL) {
		g_signal_emit_by_name (self, "personas-changed", NULL, removed_personas);
	}
	if (store != NULL) {
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, store, NULL);
	}
	_tmp4_ = gee_collection_get_size ((GeeCollection*) self->priv->_persona_set);
	if (_tmp4_ < 1) {
		g_signal_emit_by_name (self, "removed", NULL);
		_g_object_unref0 (iter);
		__g_list_free__g_object_unref0_0 (removed_personas);
		return;
	}
	folks_individual_update_fields (self);
	_g_object_unref0 (iter);
	__g_list_free__g_object_unref0_0 (removed_personas);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		__g_list_free__g_object_unref0_0 (_data2_->removed_personas);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda11_ (FolksPersona* data, Block2Data* _data2_) {
	FolksIndividual * self;
	FolksPersona* p;
	gboolean _tmp0_;
	self = _data2_->self;
	g_return_if_fail (data != NULL);
	p = FOLKS_PERSONA (data);
	_tmp0_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_persona_set, p);
	if (_tmp0_) {
		FolksPersona* _tmp1_;
		_tmp1_ = _g_object_ref0 (p);
		_data2_->removed_personas = g_list_prepend (_data2_->removed_personas, _tmp1_);
		self->priv->_persona_list = g_list_remove (self->priv->_persona_list, p);
	}
}


static void __lambda11__gfunc (gconstpointer data, gpointer self) {
	_lambda11_ (data, self);
}


static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason) {
	Block2Data* _data2_;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->removed_personas = NULL;
	g_list_foreach (removed, __lambda11__gfunc, _data2_);
	if (_data2_->removed_personas != NULL) {
		g_signal_emit_by_name (self, "personas-changed", NULL, _data2_->removed_personas);
	}
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_persona_set);
	if (_tmp0_ < 1) {
		g_signal_emit_by_name (self, "removed", NULL);
		block2_data_unref (_data2_);
		return;
	}
	folks_individual_update_fields (self);
	block2_data_unref (_data2_);
}


static void folks_individual_update_fields (FolksIndividual* self) {
	g_return_if_fail (self != NULL);
	folks_individual_update_groups (self);
	folks_individual_update_presence (self);
	folks_individual_update_is_favourite (self);
	folks_individual_update_avatar (self);
	folks_individual_update_alias (self);
	folks_individual_update_trust_level (self);
	folks_individual_update_im_addresses (self);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		__g_list_free__g_free0_0 (_data3_->removes);
		_g_hash_table_unref0 (_data3_->new_groups);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda3_ (const gchar* k, gboolean v, Block3Data* _data3_) {
	FolksIndividual * self;
	gchar* _tmp0_;
	self = _data3_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	g_hash_table_insert (_data3_->new_groups, _tmp0_, GINT_TO_POINTER (TRUE));
}


static void __lambda3__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda3_ (key, value, self);
}


static void _lambda2_ (FolksPersona* p, Block3Data* _data3_) {
	FolksIndividual * self;
	self = _data3_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_GROUPABLE (p)) {
		FolksGroupable* persona;
		GHashTable* _tmp0_ = NULL;
		persona = FOLKS_GROUPABLE (p);
		_tmp0_ = folks_groupable_get_groups (persona);
		g_hash_table_foreach (_tmp0_, __lambda3__gh_func, _data3_);
	}
}


static void __lambda2__gfunc (gconstpointer data, gpointer self) {
	_lambda2_ (data, self);
}


static void _lambda5_ (const gchar* k, gboolean v, FolksIndividual* self) {
	gchar* _tmp0_;
	gchar* g;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	g = _tmp0_;
	g_debug ("individual.vala:486:    %s", g);
	_g_free0 (g);
}


static void __lambda5__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda5_ (key, value, self);
}


static void _lambda4_ (const gchar* k, gboolean v, FolksIndividual* self) {
	gchar* _tmp0_;
	gchar* group;
	gconstpointer _tmp1_ = NULL;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	group = _tmp0_;
	_tmp1_ = g_hash_table_lookup (self->priv->_groups, group);
	if (GPOINTER_TO_INT (_tmp1_) != TRUE) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (group);
		g_hash_table_insert (self->priv->_groups, _tmp2_, GINT_TO_POINTER (TRUE));
		g_hash_table_foreach (self->priv->_groups, __lambda5__gh_func, self);
		g_signal_emit_by_name ((FolksGroupable*) self, "group-changed", group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda4_ (key, value, self);
}


static void _lambda6_ (const gchar* k, gboolean v, Block3Data* _data3_) {
	FolksIndividual * self;
	gchar* _tmp0_;
	gchar* group;
	gconstpointer _tmp1_ = NULL;
	self = _data3_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	group = _tmp0_;
	_tmp1_ = g_hash_table_lookup (_data3_->new_groups, group);
	if (GPOINTER_TO_INT (_tmp1_) != TRUE) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (group);
		_data3_->removes = g_list_prepend (_data3_->removes, _tmp2_);
	}
	_g_free0 (group);
}


static void __lambda6__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda6_ (key, value, self);
}


static void _lambda7_ (const gchar* l, FolksIndividual* self) {
	gchar* _tmp0_;
	gchar* group;
	g_return_if_fail (l != NULL);
	_tmp0_ = g_strdup ((const gchar*) l);
	group = _tmp0_;
	g_hash_table_remove (self->priv->_groups, group);
	g_signal_emit_by_name ((FolksGroupable*) self, "group-changed", group, FALSE);
	_g_free0 (group);
}


static void __lambda7__gfunc (gconstpointer data, gpointer self) {
	_lambda7_ (data, self);
}


static void folks_individual_update_groups (FolksIndividual* self) {
	Block3Data* _data3_;
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, NULL);
	_data3_->new_groups = _tmp0_;
	if (self->priv->_groups == NULL) {
		GHashTable* _tmp1_ = NULL;
		GHashTable* _tmp2_;
		_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, NULL);
		_tmp2_ = _tmp1_;
		_g_hash_table_unref0 (self->priv->_groups);
		self->priv->_groups = _tmp2_;
	}
	g_list_foreach (self->priv->_persona_list, __lambda2__gfunc, _data3_);
	g_hash_table_foreach (_data3_->new_groups, __lambda4__gh_func, self);
	_data3_->removes = NULL;
	g_hash_table_foreach (self->priv->_groups, __lambda6__gh_func, _data3_);
	g_list_foreach (_data3_->removes, __lambda7__gfunc, self);
	block3_data_unref (_data3_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_free0 (_data4_->presence_message);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda9_ (FolksPersona* p, Block4Data* _data4_) {
	FolksIndividual * self;
	self = _data4_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_PRESENCE (p)) {
		FolksPresence* presence;
		FolksPresenceType _tmp0_;
		gint _tmp1_;
		presence = FOLKS_PRESENCE (p);
		_tmp0_ = folks_presence_get_presence_type (presence);
		_tmp1_ = folks_presence_typecmp (_tmp0_, _data4_->presence_type);
		if (_tmp1_ > 0) {
			FolksPresenceType _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = folks_presence_get_presence_type (presence);
			_data4_->presence_type = _tmp2_;
			_tmp3_ = folks_presence_get_presence_message (presence);
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_free0 (_data4_->presence_message);
			_data4_->presence_message = _tmp5_;
		}
	}
}


static void __lambda9__gfunc (gconstpointer data, gpointer self) {
	_lambda9_ (data, self);
}


static void folks_individual_update_presence (FolksIndividual* self) {
	Block4Data* _data4_;
	gchar* _tmp0_;
	const gchar* _tmp3_ = NULL;
	FolksPresenceType _tmp4_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data4_->presence_message = _tmp0_;
	_data4_->presence_type = FOLKS_PRESENCE_TYPE_UNSET;
	g_list_foreach (self->priv->_persona_list, __lambda9__gfunc, _data4_);
	if (_data4_->presence_message == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strdup ("");
		_tmp2_ = _tmp1_;
		_g_free0 (_data4_->presence_message);
		_data4_->presence_message = _tmp2_;
	}
	_tmp3_ = folks_presence_get_presence_message ((FolksPresence*) self);
	if (g_strcmp0 (_tmp3_, _data4_->presence_message) != 0) {
		folks_presence_set_presence_message ((FolksPresence*) self, _data4_->presence_message);
	}
	_tmp4_ = folks_presence_get_presence_type ((FolksPresence*) self);
	if (_tmp4_ != _data4_->presence_type) {
		folks_presence_set_presence_type ((FolksPresence*) self, _data4_->presence_type);
	}
	block4_data_unref (_data4_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda10_ (FolksPersona* p, Block5Data* _data5_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data5_->self;
	g_return_if_fail (p != NULL);
	if (_data5_->favourite == FALSE) {
		_tmp0_ = FOLKS_IS_FAVOURITE (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = folks_favourite_get_is_favourite (FOLKS_FAVOURITE (p));
		_data5_->favourite = _tmp1_;
		if (_data5_->favourite == TRUE) {
			return;
		}
	}
}


static void __lambda10__gfunc (gconstpointer data, gpointer self) {
	_lambda10_ (data, self);
}


static void folks_individual_update_is_favourite (FolksIndividual* self) {
	Block5Data* _data5_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->favourite = FALSE;
	g_debug ("individual.vala:545: Running update_is_favourite() on '%s'", self->priv->_id);
	g_list_foreach (self->priv->_persona_list, __lambda10__gfunc, _data5_);
	if (self->priv->_is_favourite != _data5_->favourite) {
		self->priv->_is_favourite = _data5_->favourite;
		g_object_notify ((GObject*) self, "is-favourite");
	}
	block5_data_unref (_data5_);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void folks_individual_update_alias (FolksIndividual* self) {
	gchar* alias;
	gboolean alias_is_display_id;
	g_return_if_fail (self != NULL);
	alias = NULL;
	alias_is_display_id = FALSE;
	g_debug ("individual.vala:572: Updating alias for individual '%s'", self->priv->_id);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp0_;
			FolksPersona* p;
			_tmp0_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				if (FOLKS_IS_ALIASABLE (p)) {
					FolksPersonaStore* _tmp2_ = NULL;
					gboolean _tmp3_;
					_tmp2_ = folks_persona_get_store (p);
					_tmp3_ = folks_persona_store_get_is_writeable (_tmp2_);
					_tmp1_ = _tmp3_ == TRUE;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					FolksAliasable* a;
					gboolean _tmp4_ = FALSE;
					const gchar* _tmp5_ = NULL;
					a = FOLKS_ALIASABLE (p);
					_tmp5_ = folks_aliasable_get_alias (a);
					if (_tmp5_ != NULL) {
						const gchar* _tmp6_ = NULL;
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						_tmp6_ = folks_aliasable_get_alias (a);
						_tmp7_ = string_strip (_tmp6_);
						_tmp8_ = _tmp7_;
						_tmp4_ = g_strcmp0 (_tmp8_, "") != 0;
						_g_free0 (_tmp8_);
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						const gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						gchar* _tmp11_;
						_tmp9_ = folks_aliasable_get_alias (a);
						_tmp10_ = g_strdup (_tmp9_);
						_tmp11_ = _tmp10_;
						_g_free0 (alias);
						alias = _tmp11_;
						_g_object_unref0 (p);
						break;
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	g_debug ("individual.vala:591:     got alias '%s' from writeable personas", alias);
	if (alias == NULL) {
		{
			GList* p_collection;
			GList* p_it;
			p_collection = self->priv->_persona_list;
			for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
				FolksPersona* _tmp12_;
				FolksPersona* p;
				_tmp12_ = _g_object_ref0 ((FolksPersona*) p_it->data);
				p = _tmp12_;
				{
					if (FOLKS_IS_ALIASABLE (p)) {
						FolksAliasable* a;
						gboolean _tmp13_ = FALSE;
						const gchar* _tmp14_ = NULL;
						gboolean _tmp18_ = FALSE;
						a = FOLKS_ALIASABLE (p);
						_tmp14_ = folks_aliasable_get_alias (a);
						if (_tmp14_ == NULL) {
							_tmp13_ = TRUE;
						} else {
							const gchar* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							_tmp15_ = folks_aliasable_get_alias (a);
							_tmp16_ = string_strip (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp13_ = g_strcmp0 (_tmp17_, "") == 0;
							_g_free0 (_tmp17_);
						}
						if (_tmp13_) {
							_g_object_unref0 (p);
							continue;
						}
						if (alias == NULL) {
							_tmp18_ = TRUE;
						} else {
							_tmp18_ = alias_is_display_id == TRUE;
						}
						if (_tmp18_) {
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_;
							const gchar* _tmp22_ = NULL;
							const gchar* _tmp23_ = NULL;
							_tmp19_ = folks_aliasable_get_alias (a);
							_tmp20_ = g_strdup (_tmp19_);
							_tmp21_ = _tmp20_;
							_g_free0 (alias);
							alias = _tmp21_;
							_tmp22_ = folks_aliasable_get_alias (a);
							_tmp23_ = folks_persona_get_display_id (p);
							if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
								alias_is_display_id = TRUE;
							} else {
								if (alias != NULL) {
									_g_object_unref0 (p);
									break;
								}
							}
						}
					}
					_g_object_unref0 (p);
				}
			}
		}
	}
	g_debug ("individual.vala:626:     got alias '%s' from non-writeable personas", alias);
	if (alias == NULL) {
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp24_ = folks_persona_get_display_id ((FolksPersona*) self->priv->_persona_list->data);
		_tmp25_ = g_strdup (_tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (alias);
		alias = _tmp26_;
		g_debug ("No aliases available for individual; using display ID " "instead: %s", alias);
	}
	if (g_strcmp0 (self->priv->_alias, alias) != 0) {
		gchar* _tmp27_;
		gchar* _tmp28_;
		g_debug ("individual.vala:644: Changing alias of individual '%s' from '%s' to '%" \
"s'.", self->priv->_id, self->priv->_alias, alias);
		_tmp27_ = g_strdup (alias);
		_tmp28_ = _tmp27_;
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp28_;
		g_object_notify ((GObject*) self, "alias");
	}
	_g_free0 (alias);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->avatar);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda1_ (FolksPersona* p, Block6Data* _data6_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data6_->self;
	g_return_if_fail (p != NULL);
	if (_data6_->avatar == NULL) {
		_tmp0_ = FOLKS_IS_AVATAR (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp1_ = folks_avatar_get_avatar (FOLKS_AVATAR (p));
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_data6_->avatar);
		_data6_->avatar = _tmp3_;
		return;
	}
}


static void __lambda1__gfunc (gconstpointer data, gpointer self) {
	_lambda1_ (data, self);
}


static void folks_individual_update_avatar (FolksIndividual* self) {
	Block6Data* _data6_;
	GFile* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->avatar = NULL;
	g_list_foreach (self->priv->_persona_list, __lambda1__gfunc, _data6_);
	_tmp0_ = folks_avatar_get_avatar ((FolksAvatar*) self);
	if (_tmp0_ != _data6_->avatar) {
		folks_avatar_set_avatar ((FolksAvatar*) self, _data6_->avatar);
	}
	block6_data_unref (_data6_);
}


static void folks_individual_update_trust_level (FolksIndividual* self) {
	FolksTrustLevel trust_level;
	g_return_if_fail (self != NULL);
	trust_level = FOLKS_TRUST_LEVEL_PERSONAS;
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp0_;
			FolksPersona* p;
			_tmp0_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_;
				_tmp2_ = folks_persona_get_is_user (p);
				if (_tmp2_ == FALSE) {
					FolksPersonaStore* _tmp3_ = NULL;
					FolksPersonaStoreTrust _tmp4_;
					_tmp3_ = folks_persona_get_store (p);
					_tmp4_ = folks_persona_store_get_trust_level (_tmp3_);
					_tmp1_ = _tmp4_ == FOLKS_PERSONA_STORE_TRUST_NONE;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					trust_level = FOLKS_TRUST_LEVEL_NONE;
				}
				_g_object_unref0 (p);
			}
		}
	}
	if (self->priv->_trust_level != trust_level) {
		folks_individual_set_trust_level (self, trust_level);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->address_set);
		g_slice_free (Block7Data, _data7_);
	}
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _lambda13_ (const gchar* old_address, Block7Data* _data7_) {
	FolksIndividual * self;
	self = _data7_->self;
	g_return_if_fail (old_address != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->address_set, (const gchar*) old_address);
}


static void __lambda13__gfunc (gconstpointer data, gpointer self) {
	_lambda13_ (data, self);
}


static void _lambda14_ (const gchar* cur_address, Block7Data* _data7_) {
	FolksIndividual * self;
	self = _data7_->self;
	g_return_if_fail (cur_address != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->address_set, (const gchar*) cur_address);
}


static void __lambda14__gfunc (gconstpointer data, gpointer self) {
	_lambda14_ (data, self);
}


static void _lambda12_ (const gchar* k, GPtrArray* v, FolksIndividual* self) {
	Block7Data* _data7_;
	gchar* _tmp0_;
	gchar* cur_protocol;
	GPtrArray* _tmp1_;
	GPtrArray* cur_addresses;
	gconstpointer _tmp2_ = NULL;
	GPtrArray* _tmp3_;
	GPtrArray* old_im_array;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* im_array;
	GeeHashSet* _tmp5_ = NULL;
	gchar* _tmp10_;
	GPtrArray* _tmp11_;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup ((const gchar*) k);
	cur_protocol = _tmp0_;
	_tmp1_ = _g_ptr_array_ref0 ((GPtrArray*) v);
	cur_addresses = _tmp1_;
	_tmp2_ = g_hash_table_lookup (self->priv->_im_addresses, cur_protocol);
	_tmp3_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp2_);
	old_im_array = _tmp3_;
	_tmp4_ = g_ptr_array_new_with_free_func (_g_free0_);
	im_array = _tmp4_;
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_data7_->address_set = _tmp5_;
	if (old_im_array != NULL) {
		g_ptr_array_foreach (old_im_array, __lambda13__gfunc, _data7_);
	}
	g_ptr_array_foreach (cur_addresses, __lambda14__gfunc, _data7_);
	{
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _addr_it;
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data7_->address_set);
		_addr_it = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			gchar* addr;
			gchar* _tmp9_;
			_tmp7_ = gee_iterator_next (_addr_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_addr_it);
			addr = (gchar*) _tmp8_;
			_tmp9_ = g_strdup (addr);
			g_ptr_array_add (im_array, _tmp9_);
			_g_free0 (addr);
		}
		_g_object_unref0 (_addr_it);
	}
	_tmp10_ = g_strdup (cur_protocol);
	_tmp11_ = _g_ptr_array_ref0 (im_array);
	g_hash_table_insert (self->priv->_im_addresses, _tmp10_, _tmp11_);
	_g_ptr_array_unref0 (im_array);
	_g_ptr_array_unref0 (old_im_array);
	_g_ptr_array_unref0 (cur_addresses);
	_g_free0 (cur_protocol);
	block7_data_unref (_data7_);
}


static void __lambda12__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda12_ (key, value, self);
}


static void folks_individual_update_im_addresses (FolksIndividual* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_individual_get_personas (self);
	{
		GList* persona_collection;
		GList* persona_it;
		persona_collection = _tmp0_;
		for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
			FolksPersona* _tmp1_;
			FolksPersona* persona;
			_tmp1_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
			persona = _tmp1_;
			{
				if (FOLKS_IS_IMABLE (persona)) {
					FolksIMable* _tmp2_;
					FolksIMable* imable;
					GHashTable* _tmp3_ = NULL;
					_tmp2_ = _g_object_ref0 (FOLKS_IMABLE (persona));
					imable = _tmp2_;
					_tmp3_ = folks_imable_get_im_addresses (imable);
					g_hash_table_foreach (_tmp3_, __lambda12__gh_func, self);
					_g_object_unref0 (imable);
				}
				_g_object_unref0 (persona);
			}
		}
	}
	g_object_notify ((GObject*) self, "im-addresses");
}


static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_alias_cb (self, _sender, pspec);
}


static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_avatar_cb (self, _sender, pspec);
}


static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_presence_cb (self, _sender, pspec);
}


static void _folks_individual_notify_im_addresses_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_im_addresses_cb (self, _sender, pspec);
}


static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_is_favourite_cb (self, _sender, pspec);
}


static void _folks_individual_persona_group_changed_cb_folks_groupable_group_changed (FolksGroupable* _sender, const gchar* group, gboolean is_member, gpointer self) {
	folks_individual_persona_group_changed_cb (self, group, is_member);
}


static void folks_individual_connect_to_persona (FolksIndividual* self, FolksPersona* persona) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_signal_connect_object ((GObject*) persona, "notify::alias", (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::avatar", (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-message", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-type", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::im-addresses", (GCallback) _folks_individual_notify_im_addresses_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::is-favourite", (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self, 0);
	if (FOLKS_IS_GROUPABLE (persona)) {
		g_signal_connect_object (FOLKS_GROUPABLE (persona), "group-changed", (GCallback) _folks_individual_persona_group_changed_cb_folks_groupable_group_changed, self, 0);
	}
}


static void folks_individual_disconnect_from_persona (FolksIndividual* self, FolksPersona* persona) {
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	guint _tmp8_;
	GQuark _tmp9_;
	guint _tmp10_;
	GQuark _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_signal_parse_name ("notify::alias", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self);
	g_signal_parse_name ("notify::avatar", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-message", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-type", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::im-addresses", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _folks_individual_notify_im_addresses_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-favourite", G_TYPE_OBJECT, &_tmp10_, &_tmp11_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, _tmp11_, NULL, (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self);
	if (FOLKS_IS_GROUPABLE (persona)) {
		guint _tmp12_;
		g_signal_parse_name ("group-changed", FOLKS_TYPE_GROUPABLE, &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (FOLKS_GROUPABLE (persona), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _folks_individual_persona_group_changed_cb_folks_groupable_group_changed, self);
	}
}


static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_individual_store_removed_cb (self, _sender);
}


static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupableChangeReason reason, gpointer self) {
	folks_individual_store_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void _folks_individual_set_personas (FolksIndividual* self, GList* persona_list, FolksIndividual* replacement_individual) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* persona_set;
	GList* added;
	GList* removed;
	GList* _tmp15_ = NULL;
	GList* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean new_is_user;
	gint _tmp18_;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	persona_set = _tmp0_;
	added = NULL;
	removed = NULL;
	{
		GList* p_collection;
		GList* p_it;
		p_collection = persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp1_;
			FolksPersona* p;
			_tmp1_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp1_;
			{
				gboolean _tmp2_;
				_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_persona_set, p);
				if (!_tmp2_) {
					gboolean _tmp3_;
					FolksPersona* _tmp4_;
					FolksPersonaStore* _tmp5_ = NULL;
					FolksPersonaStore* store;
					gpointer _tmp6_ = NULL;
					guint num_from_store;
					_tmp3_ = folks_persona_get_is_user (p);
					if (_tmp3_) {
						self->priv->persona_user_count++;
					}
					_tmp4_ = _g_object_ref0 (p);
					added = g_list_prepend (added, _tmp4_);
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_persona_set, p);
					folks_individual_connect_to_persona (self, p);
					_tmp5_ = folks_persona_get_store (p);
					store = _tmp5_;
					_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->stores, store);
					num_from_store = GPOINTER_TO_UINT (_tmp6_);
					if (num_from_store == 0) {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER (num_from_store + 1));
					} else {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER ((guint) 1));
						g_signal_connect_object (store, "removed", (GCallback) _folks_individual_store_removed_cb_folks_persona_store_removed, self, 0);
						g_signal_connect_object (store, "personas-changed", (GCallback) _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, p);
				_g_object_unref0 (p);
			}
		}
	}
	{
		GList* p_collection;
		GList* p_it;
		p_collection = self->priv->_persona_list;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			FolksPersona* _tmp7_;
			FolksPersona* p;
			_tmp7_ = _g_object_ref0 ((FolksPersona*) p_it->data);
			p = _tmp7_;
			{
				gboolean _tmp8_;
				_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) persona_set, p);
				if (!_tmp8_) {
					gboolean _tmp9_;
					FolksPersona* _tmp10_;
					FolksPersonaStore* _tmp11_ = NULL;
					FolksPersonaStore* store;
					gpointer _tmp12_ = NULL;
					guint num_from_store;
					_tmp9_ = folks_persona_get_is_user (p);
					if (_tmp9_) {
						self->priv->persona_user_count--;
					}
					_tmp10_ = _g_object_ref0 (p);
					removed = g_list_prepend (removed, _tmp10_);
					_tmp11_ = folks_persona_get_store (p);
					store = _tmp11_;
					_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->stores, store);
					num_from_store = GPOINTER_TO_UINT (_tmp12_);
					if (num_from_store > 1) {
						gee_abstract_map_set ((GeeAbstractMap*) self->priv->stores, store, GUINT_TO_POINTER (num_from_store - 1));
					} else {
						guint _tmp13_;
						guint _tmp14_;
						g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp13_, NULL, FALSE);
						g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _folks_individual_store_removed_cb_folks_persona_store_removed, self);
						g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp14_, NULL, FALSE);
						g_signal_handlers_disconnect_matched (store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed, self);
						gee_abstract_map_unset ((GeeAbstractMap*) self->priv->stores, store, NULL);
					}
					folks_individual_disconnect_from_persona (self, p);
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_persona_set, p);
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp15_ = g_list_copy (persona_list);
	_tmp16_ = _tmp15_;
	_g_list_free0 (self->priv->_persona_list);
	self->priv->_persona_list = _tmp16_;
	g_signal_emit_by_name (self, "personas-changed", added, removed);
	if (self->priv->persona_user_count > 0) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = FALSE;
	}
	new_is_user = _tmp17_;
	if (new_is_user != self->priv->_is_user) {
		folks_individual_set_is_user (self, new_is_user);
	}
	_tmp18_ = gee_collection_get_size ((GeeCollection*) self->priv->_persona_set);
	if (_tmp18_ < 1) {
		g_signal_emit_by_name (self, "removed", replacement_individual);
		__g_list_free__g_object_unref0_0 (removed);
		__g_list_free__g_object_unref0_0 (added);
		_g_object_unref0 (persona_set);
		return;
	}
	if (self->priv->_id == NULL) {
		_tmp19_ = ((FolksPersona*) self->priv->_persona_list->data) != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = folks_persona_get_uid ((FolksPersona*) self->priv->_persona_list->data);
		folks_individual_set_id (self, _tmp20_);
	}
	folks_individual_update_fields (self);
	__g_list_free__g_object_unref0_0 (removed);
	__g_list_free__g_object_unref0_0 (added);
	_g_object_unref0 (persona_set);
}


void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (replacement_individual != NULL);
	_folks_individual_set_personas (self, NULL, replacement_individual);
}


FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self) {
	FolksTrustLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_trust_level;
	return result;
}


static void folks_individual_set_trust_level (FolksIndividual* self, FolksTrustLevel value) {
	g_return_if_fail (self != NULL);
	self->priv->_trust_level = value;
	g_object_notify ((GObject *) self, "trust-level");
}


static GFile* folks_individual_real_get_avatar (FolksAvatar* base) {
	GFile* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_avatar;
	return result;
}


static void folks_individual_real_set_avatar (FolksAvatar* base, GFile* value) {
	FolksIndividual* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = (FolksIndividual*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType folks_individual_real_get_presence_type (FolksPresence* base) {
	FolksPresenceType result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_type;
	return result;
}


static void folks_individual_real_set_presence_type (FolksPresence* base, FolksPresenceType value) {
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	self->priv->_presence_type = value;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* folks_individual_real_get_presence_message (FolksPresence* base) {
	const gchar* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_message;
	return result;
}


static void folks_individual_real_set_presence_message (FolksPresence* base, const gchar* value) {
	FolksIndividual* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FolksIndividual*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


gboolean folks_individual_get_is_user (FolksIndividual* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_user;
	return result;
}


static void folks_individual_set_is_user (FolksIndividual* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_user = value;
	g_object_notify ((GObject *) self, "is-user");
}


const gchar* folks_individual_get_id (FolksIndividual* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void folks_individual_set_id (FolksIndividual* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


static const gchar* folks_individual_real_get_alias (FolksAliasable* base) {
	const gchar* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_alias;
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_free0 (_data8_->value);
		g_slice_free (Block8Data, _data8_);
	}
}


static void _lambda15_ (FolksPersona* p, Block8Data* _data8_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data8_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_ALIASABLE (p)) {
		FolksPersonaStore* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = folks_persona_get_store (FOLKS_PERSONA (p));
		_tmp2_ = folks_persona_store_get_is_writeable (_tmp1_);
		_tmp0_ = _tmp2_ == TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = folks_persona_get_uid (FOLKS_PERSONA (p));
		g_debug ("individual.vala:192:     written to writeable persona '%s'", _tmp3_);
		folks_aliasable_set_alias (FOLKS_ALIASABLE (p), _data8_->value);
		_data8_->alias_changed = TRUE;
	}
}


static void __lambda15__gfunc (gconstpointer data, gpointer self) {
	_lambda15_ (data, self);
}


static void _lambda16_ (FolksPersona* p, Block8Data* _data8_) {
	FolksIndividual * self;
	self = _data8_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_ALIASABLE (p)) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = folks_persona_get_uid (FOLKS_PERSONA (p));
		g_debug ("individual.vala:207:     written to non-writeable persona '%s'", _tmp0_);
		folks_aliasable_set_alias (FOLKS_ALIASABLE (p), _data8_->value);
	}
}


static void __lambda16__gfunc (gconstpointer data, gpointer self) {
	_lambda16_ (data, self);
}


static void folks_individual_real_set_alias (FolksAliasable* base, const gchar* value) {
	FolksIndividual* self;
	Block8Data* _data8_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FolksIndividual*) base;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->value = g_strdup (value);
	if (g_strcmp0 (self->priv->_alias, _data8_->value) == 0) {
		block8_data_unref (_data8_);
		return;
	}
	_tmp0_ = g_strdup (_data8_->value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp1_;
	g_debug ("individual.vala:184: Setting alias of individual '%s' to '%s'…", self->priv->_id, _data8_->value);
	_data8_->alias_changed = FALSE;
	g_list_foreach (self->priv->_persona_list, __lambda15__gfunc, _data8_);
	if (_data8_->alias_changed == FALSE) {
		g_list_foreach (self->priv->_persona_list, __lambda16__gfunc, _data8_);
	}
	block8_data_unref (_data8_);
	g_object_notify ((GObject *) self, "alias");
}


static gboolean folks_individual_real_get_is_favourite (FolksFavourite* base) {
	gboolean result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_is_favourite;
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void _lambda17_ (FolksPersona* p, Block9Data* _data9_) {
	FolksIndividual * self;
	self = _data9_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_FAVOURITE (p)) {
		g_signal_handlers_block_by_func (p, (void*) folks_individual_notify_is_favourite_cb, self);
		folks_favourite_set_is_favourite (FOLKS_FAVOURITE (p), _data9_->value);
		g_signal_handlers_unblock_by_func (p, (void*) folks_individual_notify_is_favourite_cb, self);
	}
}


static void __lambda17__gfunc (gconstpointer data, gpointer self) {
	_lambda17_ (data, self);
}


static void folks_individual_real_set_is_favourite (FolksFavourite* base, gboolean value) {
	FolksIndividual* self;
	Block9Data* _data9_;
	const gchar* _tmp0_;
	self = (FolksIndividual*) base;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->value = value;
	if (self->priv->_is_favourite == _data9_->value) {
		block9_data_unref (_data9_);
		return;
	}
	_tmp0_ = NULL;
	if (_data9_->value) {
		_tmp0_ = "TRUE";
	} else {
		_tmp0_ = "FALSE";
	}
	g_debug ("individual.vala:231: Setting '%s' favourite status to %s", self->priv->_id, _tmp0_);
	self->priv->_is_favourite = _data9_->value;
	g_list_foreach (self->priv->_persona_list, __lambda17__gfunc, _data9_);
	block9_data_unref (_data9_);
	g_object_notify ((GObject *) self, "is-favourite");
}


static GHashTable* folks_individual_real_get_groups (FolksGroupable* base) {
	GHashTable* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_groups;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_hash_table_unref0 (_data10_->value);
		g_slice_free (Block10Data, _data10_);
	}
}


static void _lambda18_ (FolksPersona* p, Block10Data* _data10_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data10_->self;
	g_return_if_fail (p != NULL);
	if (FOLKS_IS_GROUPABLE (p)) {
		FolksPersonaStore* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = folks_persona_get_store (FOLKS_PERSONA (p));
		_tmp2_ = folks_persona_store_get_is_writeable (_tmp1_);
		_tmp0_ = _tmp2_ == TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		folks_groupable_set_groups (FOLKS_GROUPABLE (p), _data10_->value);
	}
}


static void __lambda18__gfunc (gconstpointer data, gpointer self) {
	_lambda18_ (data, self);
}


static void folks_individual_real_set_groups (FolksGroupable* base, GHashTable* value) {
	FolksIndividual* self;
	Block10Data* _data10_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	self = (FolksIndividual*) base;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->value = _g_hash_table_ref0 (value);
	_tmp0_ = _g_hash_table_ref0 (_data10_->value);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp1_;
	g_list_foreach (self->priv->_persona_list, __lambda18__gfunc, _data10_);
	block10_data_unref (_data10_);
	g_object_notify ((GObject *) self, "groups");
}


static GHashTable* folks_individual_real_get_im_addresses (FolksIMable* base) {
	GHashTable* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_im_addresses;
	return result;
}


static void folks_individual_real_set_im_addresses (FolksIMable* base, GHashTable* value) {
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	g_object_notify ((GObject *) self, "im-addresses");
}


GList* folks_individual_get_personas (FolksIndividual* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_persona_list;
	return result;
}


void folks_individual_set_personas (FolksIndividual* self, GList* value) {
	g_return_if_fail (self != NULL);
	_folks_individual_set_personas (self, value, NULL);
	g_object_notify ((GObject *) self, "personas");
}


static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void folks_individual_class_init (FolksIndividualClass * klass) {
	folks_individual_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_finalize;
	/**
	   * The trust level of the Individual.
	   *
	   * This specifies how far the Individual can be trusted to be who it claims
	   * to be. See the descriptions for the elements of {@link TrustLevel}.
	   *
	   * Clients should ''not'' allow linking of Individuals who have a trust level
	   * of {@link TrustLevel.NONE}.
	   *
	   * @since 0.1.15
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_TRUST_LEVEL, g_param_spec_enum ("trust-level", "trust-level", "trust-level", FOLKS_TYPE_TRUST_LEVEL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_TYPE, "presence-type");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_MESSAGE, "presence-message");
	/**
	   * Whether the Individual is the user.
	   *
	   * Iff the Individual represents the user – the person who owns the
	   * account in the backend for each {@link Persona} in the Individual –
	   * this is `true`.
	   *
	   * It is //not// guaranteed that every {@link Persona} in the Individual has
	   * its {@link Persona.is_user} set to the same value as the Individual. For
	   * example, the user could own two Telepathy accounts, and have added the
	   * other account as a contact in each account. The accounts will expose a
	   * {@link Persona} for the user (which will have {@link Persona.is_user} set
	   * to `true`) //and// a {@link Persona} for the contact for the other account
	   * (which will have {@link Persona.is_user} set to `false`).
	   *
	   * It is guaranteed that iff this property is set to `true` on an Individual,
	   * there will be at least one {@link Persona} in the Individual with its
	   * {@link Persona.is_user} set to `true`.
	   *
	   * It is guaranteed that there will only ever be one Individual with this
	   * property set to `true`.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_IS_USER, g_param_spec_boolean ("is-user", "is-user", "is-user", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A unique identifier for the Individual.
	   *
	   * This uniquely identifies the Individual, and persists across
	   * {@link IndividualAggregator} instances.
	   *
	   * FIXME: Will this.id actually be the persistent ID for storage?
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ALIAS, "alias");
	/**
	   * Whether this Individual is a user-defined favourite.
	   *
	   * This property is `true` if any of this Individual's {@link Persona}s are
	   * favourites).
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_IS_FAVOURITE, "is-favourite");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_GROUPS, "groups");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_IM_ADDRESSES, "im-addresses");
	/**
	   * The set of {@link Persona}s encapsulated by this Individual.
	   *
	   * Changing the set of personas may cause updates to the aggregated properties
	   * provided by the Individual, resulting in property notifications for them.
	   *
	   * Changing the set of personas will not cause permanent linking/unlinking of
	   * the added/removed personas to/from this Individual. To do that, call
	   * {@link IndividualAggregator.link_personas} or
	   * {@link IndividualAggregator.unlink_individual}, which will ensure the link
	   * changes are written to the appropriate backend.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PERSONAS, g_param_spec_pointer ("personas", "personas", "personas", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Emitted when the last of the Individual's {@link Persona}s has been
	   * removed.
	   *
	   * At this point, the Individual is invalid, so any client referencing it
	   * should unreference it and remove it from their UI.
	   *
	   * @param replacement_individual the individual which has replaced this one
	   * due to linking, or `null` if this individual was removed for another reason
	   * @since 0.1.13
	   */
	g_signal_new ("removed", FOLKS_TYPE_INDIVIDUAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the Individual.
	   *
	   * @param added a list of {@link Persona}s which have been added
	   * @param removed a list of {@link Persona}s which have been removed
	   *
	   * @since 0.1.15
	   */
	g_signal_new ("personas_changed", FOLKS_TYPE_INDIVIDUAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_POINTER);
}


static void folks_individual_folks_aliasable_interface_init (FolksAliasableIface * iface) {
	folks_individual_folks_aliasable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = folks_individual_real_get_alias;
	iface->set_alias = folks_individual_real_set_alias;
}


static void folks_individual_folks_avatar_interface_init (FolksAvatarIface * iface) {
	folks_individual_folks_avatar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_individual_real_get_avatar;
	iface->set_avatar = folks_individual_real_set_avatar;
}


static void folks_individual_folks_favourite_interface_init (FolksFavouriteIface * iface) {
	folks_individual_folks_favourite_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = folks_individual_real_get_is_favourite;
	iface->set_is_favourite = folks_individual_real_set_is_favourite;
}


static void folks_individual_folks_groupable_interface_init (FolksGroupableIface * iface) {
	folks_individual_folks_groupable_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupable* ,const gchar* ,gboolean ,GError**)) folks_individual_real_change_group;
	iface->change_group_finish = folks_individual_real_change_group_finish;
	iface->get_groups = folks_individual_real_get_groups;
	iface->set_groups = folks_individual_real_set_groups;
}


static void folks_individual_folks_imable_interface_init (FolksIMableIface * iface) {
	folks_individual_folks_imable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = folks_individual_real_get_im_addresses;
	iface->set_im_addresses = folks_individual_real_set_im_addresses;
}


static void folks_individual_folks_presence_interface_init (FolksPresenceIface * iface) {
	folks_individual_folks_presence_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = folks_individual_real_get_presence_type;
	iface->set_presence_type = folks_individual_real_set_presence_type;
	iface->get_presence_message = folks_individual_real_get_presence_message;
	iface->set_presence_message = folks_individual_real_set_presence_message;
}


static void folks_individual_instance_init (FolksIndividual * self) {
	self->priv = FOLKS_INDIVIDUAL_GET_PRIVATE (self);
	self->priv->persona_user_count = (guint) 0;
}


static void folks_individual_finalize (GObject* obj) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (obj);
	_g_free0 (self->priv->_alias);
	_g_hash_table_unref0 (self->priv->_groups);
	_g_list_free0 (self->priv->_persona_list);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->stores);
	_g_hash_table_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_message);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_individual_parent_class)->finalize (obj);
}


/**
 * A physical person, aggregated from the various {@link Persona}s the person
 * might have, such as their different IM addresses or vCard entries.
 */
GType folks_individual_get_type (void) {
	static volatile gsize folks_individual_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividual), 0, (GInstanceInitFunc) folks_individual_instance_init, NULL };
		static const GInterfaceInfo folks_aliasable_info = { (GInterfaceInitFunc) folks_individual_folks_aliasable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_info = { (GInterfaceInitFunc) folks_individual_folks_avatar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_info = { (GInterfaceInitFunc) folks_individual_folks_favourite_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_groupable_info = { (GInterfaceInitFunc) folks_individual_folks_groupable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_imable_info = { (GInterfaceInitFunc) folks_individual_folks_imable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_info = { (GInterfaceInitFunc) folks_individual_folks_presence_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_individual_type_id;
		folks_individual_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividual", &g_define_type_info, 0);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_ALIASABLE, &folks_aliasable_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_AVATAR, &folks_avatar_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_FAVOURITE, &folks_favourite_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_GROUPABLE, &folks_groupable_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_IMABLE, &folks_imable_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_PRESENCE, &folks_presence_info);
		g_once_init_leave (&folks_individual_type_id__volatile, folks_individual_type_id);
	}
	return folks_individual_type_id__volatile;
}


static void _vala_folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_TRUST_LEVEL:
		g_value_set_enum (value, folks_individual_get_trust_level (self));
		break;
		case FOLKS_INDIVIDUAL_AVATAR:
		g_value_set_object (value, folks_avatar_get_avatar ((FolksAvatar*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_get_presence_type ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_get_presence_message ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_IS_USER:
		g_value_set_boolean (value, folks_individual_get_is_user (self));
		break;
		case FOLKS_INDIVIDUAL_ID:
		g_value_set_string (value, folks_individual_get_id (self));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		g_value_set_string (value, folks_aliasable_get_alias ((FolksAliasable*) self));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_get_is_favourite ((FolksFavourite*) self));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		g_value_set_boxed (value, folks_groupable_get_groups ((FolksGroupable*) self));
		break;
		case FOLKS_INDIVIDUAL_IM_ADDRESSES:
		g_value_set_boxed (value, folks_imable_get_im_addresses ((FolksIMable*) self));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		g_value_set_pointer (value, folks_individual_get_personas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_TRUST_LEVEL:
		folks_individual_set_trust_level (self, g_value_get_enum (value));
		break;
		case FOLKS_INDIVIDUAL_AVATAR:
		folks_avatar_set_avatar ((FolksAvatar*) self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		folks_presence_set_presence_type ((FolksPresence*) self, g_value_get_enum (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		folks_presence_set_presence_message ((FolksPresence*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_IS_USER:
		folks_individual_set_is_user (self, g_value_get_boolean (value));
		break;
		case FOLKS_INDIVIDUAL_ID:
		folks_individual_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		folks_aliasable_set_alias ((FolksAliasable*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		folks_favourite_set_is_favourite ((FolksFavourite*) self, g_value_get_boolean (value));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		folks_groupable_set_groups ((FolksGroupable*) self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_IM_ADDRESSES:
		folks_imable_set_im_addresses ((FolksIMable*) self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		folks_individual_set_personas (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



