/* imable.c generated by valac 0.10.0, the Vala compiler
 * generated from imable.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_IMABLE (folks_imable_get_type ())
#define FOLKS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMABLE, FolksIMable))
#define FOLKS_IS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMABLE))
#define FOLKS_IMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IMABLE, FolksIMableIface))

typedef struct _FolksIMable FolksIMable;
typedef struct _FolksIMableIface FolksIMableIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FolksIMableIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksIMable* self);
	void (*set_im_addresses) (FolksIMable* self, GHashTable* value);
};



GType folks_imable_get_type (void) G_GNUC_CONST;
char* folks_imable_normalise_im_address (const char* im_address, const char* protocol);
GHashTable* folks_imable_get_im_addresses (FolksIMable* self);
void folks_imable_set_im_addresses (FolksIMable* self, GHashTable* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * @since 0.2.0
   */
static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


char* folks_imable_normalise_im_address (const char* im_address, const char* protocol) {
	char* result = NULL;
	char* normalised;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	normalised = NULL;
	if (_vala_strcmp0 (protocol, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (protocol, "myspace") == 0;
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		normalised = (_tmp2_ = g_utf8_strdown (_tmp1_ = string_replace (im_address, " ", ""), -1), _g_free0 (normalised), _tmp2_);
		_g_free0 (_tmp1_);
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		if (_vala_strcmp0 (protocol, "irc") == 0) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = _vala_strcmp0 (protocol, "yahoo") == 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = _vala_strcmp0 (protocol, "yahoojp") == 0;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = _vala_strcmp0 (protocol, "groupwise") == 0;
		}
		if (_tmp3_) {
			char* _tmp6_;
			normalised = (_tmp6_ = g_utf8_strdown (im_address, -1), _g_free0 (normalised), _tmp6_);
		} else {
			if (_vala_strcmp0 (protocol, "jabber") == 0) {
				gint parts_length1;
				gint _parts_size_;
				char** _tmp8_;
				char** _tmp7_;
				char** parts;
				char* resource;
				char** _tmp10_;
				char** _tmp11_;
				char* node;
				char* domain;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				char* _tmp19_;
				gboolean _tmp21_ = FALSE;
				parts = (_tmp8_ = _tmp7_ = g_strsplit (im_address, "/", 2), parts_length1 = _vala_array_length (_tmp7_), _parts_size_ = parts_length1, _tmp8_);
				g_return_val_if_fail (parts_length1 >= 1, NULL);
				resource = NULL;
				if (parts_length1 == 2) {
					char* _tmp9_;
					resource = (_tmp9_ = g_strdup (parts[1]), _g_free0 (resource), _tmp9_);
				}
				parts = (_tmp11_ = _tmp10_ = g_strsplit (parts[0], "@", 2), parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL), parts_length1 = _vala_array_length (_tmp10_), _parts_size_ = parts_length1, _tmp11_);
				g_return_val_if_fail (parts_length1 >= 1, NULL);
				node = NULL;
				domain = NULL;
				if (parts_length1 == 2) {
					char* _tmp12_;
					char* _tmp13_;
					node = (_tmp12_ = g_strdup (parts[0]), _g_free0 (node), _tmp12_);
					domain = (_tmp13_ = g_strdup (parts[1]), _g_free0 (domain), _tmp13_);
				} else {
					char* _tmp14_;
					char* _tmp15_;
					node = (_tmp14_ = NULL, _g_free0 (node), _tmp14_);
					domain = (_tmp15_ = g_strdup (parts[0]), _g_free0 (domain), _tmp15_);
				}
				if (node == NULL) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = _vala_strcmp0 (node, "") != 0;
				}
				g_return_val_if_fail (_tmp16_, NULL);
				if (domain != NULL) {
					_tmp17_ = _vala_strcmp0 (domain, "") != 0;
				} else {
					_tmp17_ = FALSE;
				}
				g_return_val_if_fail (_tmp17_, NULL);
				if (resource == NULL) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = _vala_strcmp0 (resource, "") != 0;
				}
				g_return_val_if_fail (_tmp18_, NULL);
				domain = (_tmp19_ = g_utf8_strdown (domain, -1), _g_free0 (domain), _tmp19_);
				if (node != NULL) {
					char* _tmp20_;
					node = (_tmp20_ = g_utf8_strdown (node, -1), _g_free0 (node), _tmp20_);
				}
				if (node != NULL) {
					_tmp21_ = resource != NULL;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					char* _tmp22_;
					normalised = (_tmp22_ = g_strdup_printf ("%s@%s/%s", node, domain, resource), _g_free0 (normalised), _tmp22_);
				} else {
					if (node != NULL) {
						char* _tmp23_;
						normalised = (_tmp23_ = g_strdup_printf ("%s@%s", node, domain), _g_free0 (normalised), _tmp23_);
					} else {
						if (resource != NULL) {
							char* _tmp24_;
							normalised = (_tmp24_ = g_strdup_printf ("%s/%s", domain, resource), _g_free0 (normalised), _tmp24_);
						} else {
							g_assert_not_reached ();
						}
					}
				}
				_g_free0 (domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			} else {
				char* _tmp25_;
				normalised = (_tmp25_ = g_strdup (im_address), _g_free0 (normalised), _tmp25_);
			}
		}
	}
	result = g_utf8_normalize (normalised, -1, G_NORMALIZE_DEFAULT);
	_g_free0 (normalised);
	return result;
}


GHashTable* folks_imable_get_im_addresses (FolksIMable* self) {
	return FOLKS_IMABLE_GET_INTERFACE (self)->get_im_addresses (self);
}


void folks_imable_set_im_addresses (FolksIMable* self, GHashTable* value) {
	FOLKS_IMABLE_GET_INTERFACE (self)->set_im_addresses (self, value);
}


static void folks_imable_base_init (FolksIMableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of IM protocol to an ordered set of IM addresses.
		   *
		   * Each mapping is from an arbitrary protocol identifier to a set of IM
		   * addresses on that protocol for the contact, listed in preference order.
		   * The most-preferred IM address for each protocol comes first in that
		   * protocol's list.
		   *
		   * There must be no duplicate IM addresses in each ordered set, though a given
		   * IM address may be present in the sets for different protocols.
		   *
		   * All the IM addresses must be normalised using
		   * {@link IMable.normalise_im_address} before being added to this property.
		   *
		   * @since 0.1.13
		   */
		g_object_interface_install_property (iface, g_param_spec_boxed ("im-addresses", "im-addresses", "im-addresses", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * IM addresses exposed by an object implementing {@link Presence}.
 *
 * @since 0.1.13
 */
GType folks_imable_get_type (void) {
	static volatile gsize folks_imable_type_id__volatile = 0;
	if (g_once_init_enter (&folks_imable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIMableIface), (GBaseInitFunc) folks_imable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_imable_type_id;
		folks_imable_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksIMable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_imable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_imable_type_id__volatile, folks_imable_type_id);
	}
	return folks_imable_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




