/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <libsoup/soup-session-async.h>
#include <json-glib/json-parser.h>

struct _CouchDB {
	GObject parent;

	char *hostname;
	SoupSession *http_session;
};

struct _CouchDBDocument {
	GObject parent;

	CouchDB *couchdb;
	char *dbname;
	JsonNode *root_node;
};

struct _CouchDBDatabaseInfo {
	gint ref_count;

	char *dbname;
	gint doc_count;
	gint doc_del_count;
	gint update_seq;
	gboolean compact_running;
	gint disk_size;
};

CouchDBDatabaseInfo *couchdb_database_info_new (const char *dbname,
						gint doc_count,
						gint doc_del_count,
						gint update_seq,
						gboolean compact_running,
						gint disk_size);

struct _CouchDBDocumentInfo {
	gint ref_count;

	char *docid;
	char *revision;
};

CouchDBDocumentInfo *couchdb_document_info_new (const char *docid, const char *revision);

struct _CouchDBStructField {
	gint ref_count;

	JsonObject *json_object;
};

CouchDBStructField *couchdb_struct_field_new_from_json_object (JsonObject *json_object);

/*
 * Utility functions
 */

JsonParser *send_message_and_parse (CouchDB *couchdb,
				    const char *method,
				    const char *url,
				    GError **error);

#endif
